/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic.uuid;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.command.internal.ApplyEChangeSwitch;
import tools.vitruv.change.atomic.eobject.CreateEObject;
import tools.vitruv.change.atomic.eobject.DeleteEObject;
import tools.vitruv.change.atomic.resolve.AtomicEChangeResolverHelper;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolver;

public class AtomicEChangeUuidResolver {
    private UuidResolver uuidResolver;

    public AtomicEChangeUuidResolver(UuidResolver uuidResolver) {
        this.uuidResolver = uuidResolver;
    }

    public EChange<EObject> resolveAndApplyForward(EChange<Uuid> unresolvedEChange) {
        EChange<EObject> resolvedEChange = this.resolve(unresolvedEChange);
        ApplyEChangeSwitch.applyEChange(resolvedEChange, true);
        this.updateUuidResolver(resolvedEChange, unresolvedEChange);
        return resolvedEChange;
    }

    private EChange<EObject> resolve(EChange<Uuid> unresolvedChange) {
        return AtomicEChangeResolverHelper.resolveChange(unresolvedChange, uuid -> {
            if (unresolvedChange instanceof CreateEObject) {
                CreateEObject createChange = (CreateEObject)unresolvedChange;
                return EcoreUtil.create((EClass)createChange.getAffectedEObjectType());
            }
            return this.uuidResolver.getEObject((Uuid)uuid);
        }, this::resourceResolver);
    }

    public EChange<Uuid> assignIds(EChange<EObject> resolvedEChange) {
        EChange<Uuid> unresolvedEChange = AtomicEChangeResolverHelper.resolveChange(resolvedEChange, eObject -> {
            CreateEObject createChange;
            if (this.uuidResolver.hasUuid((EObject)eObject)) {
                return this.uuidResolver.getUuid((EObject)eObject);
            }
            if (resolvedEChange instanceof CreateEObject && (createChange = (CreateEObject)resolvedEChange).getAffectedElement() == eObject) {
                return this.uuidResolver.registerEObject((EObject)eObject);
            }
            throw new IllegalStateException("trying to assign UUID for unknown element %s of change %s".formatted(eObject, resolvedEChange));
        }, this::resourceResolver);
        this.updateUuidResolver(resolvedEChange, unresolvedEChange);
        return unresolvedEChange;
    }

    public void endTransaction() {
        this.uuidResolver.endTransaction();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateUuidResolver(EChange<EObject> resolvedChange, EChange<Uuid> unresolvedChange) {
        if (resolvedChange instanceof CreateEObject) {
            CreateEObject createResolvedChange = (CreateEObject)resolvedChange;
            if (unresolvedChange instanceof CreateEObject) {
                CreateEObject createUnresolvedChange = (CreateEObject)unresolvedChange;
                this.uuidResolver.registerEObject((Uuid)createUnresolvedChange.getAffectedElement(), (EObject)createResolvedChange.getAffectedElement());
                return;
            }
        }
        if (!(resolvedChange instanceof DeleteEObject)) return;
        DeleteEObject deleteResolvedChange = (DeleteEObject)resolvedChange;
        if (!(unresolvedChange instanceof DeleteEObject)) return;
        DeleteEObject deleteUnresolvedChange = (DeleteEObject)unresolvedChange;
        this.uuidResolver.unregisterEObject((Uuid)deleteUnresolvedChange.getAffectedElement(), (EObject)deleteResolvedChange.getAffectedElement());
    }

    private Resource resourceResolver(Resource sourceResource) {
        return this.uuidResolver.getResource(sourceResource.getURI());
    }
}

