/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic.uuid;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolverImpl;

public interface UuidResolver {
    default public boolean hasUuid(EObject eObject) {
        try {
            Uuid uuid = this.getUuid(eObject);
            return uuid != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    default public boolean hasEObject(Uuid uuid) {
        try {
            EObject eObject = this.getEObject(uuid);
            return eObject != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public Uuid getUuid(EObject var1) throws IllegalStateException;

    public EObject getEObject(Uuid var1) throws IllegalStateException;

    public Uuid generateUuid(EObject var1);

    public void registerEObject(Uuid var1, EObject var2) throws IllegalStateException;

    default public Uuid registerEObject(EObject eObject) throws IllegalStateException {
        Uuid uuid = this.generateUuid(eObject);
        this.registerEObject(uuid, eObject);
        return uuid;
    }

    public void unregisterEObject(Uuid var1, EObject var2) throws IllegalStateException;

    public Resource getResource(URI var1);

    public void endTransaction() throws IllegalStateException;

    public void resolveResources(Map<Resource, Resource> var1, UuidResolver var2) throws IllegalStateException;

    default public void resolveResource(Resource sourceResource, Resource targetResource, UuidResolver targetUuidResolver) throws IllegalStateException {
        Preconditions.checkState((sourceResource != null ? 1 : 0) != 0, (Object)"source resource must not be null");
        Preconditions.checkState((targetResource != null ? 1 : 0) != 0, (Object)"target resource must not be null");
        this.resolveResources(Map.of(sourceResource, targetResource), targetUuidResolver);
    }

    public static UuidResolver create(ResourceSet resourceSet) {
        return new UuidResolverImpl(resourceSet);
    }

    public void storeAtUri(URI var1) throws IOException, IllegalStateException;

    public void loadFromUri(URI var1) throws IOException, IllegalStateException;
}

