/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic.uuid;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.atomic.hid.ObjectResolutionUtil;
import tools.vitruv.change.atomic.hid.internal.HierarchicalIdResolver;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolver;

class UuidResolverImpl
implements UuidResolver {
    private static final Logger LOGGER = LogManager.getLogger(UuidResolverImpl.class);
    private static final String NON_READONLY_PREFIX = "ord_";
    private static final String SERIALIZATION_SEPARATOR = "|";
    private final ResourceSet resourceSet;
    private final BiMap<EObject, Uuid> eObjectToUuid = HashBiMap.create();

    public UuidResolverImpl(ResourceSet resourceSet) {
        Preconditions.checkArgument((resourceSet != null ? 1 : 0) != 0, (Object)"Resource set may not be null");
        this.resourceSet = resourceSet;
    }

    @Override
    public Uuid getUuid(EObject eObject) throws IllegalStateException {
        Uuid uuid = this.getUuidOrNull(eObject);
        Preconditions.checkState((uuid != null ? 1 : 0) != 0, (String)"no UUID could be found for EObject: %s", (Object)eObject);
        return uuid;
    }

    @Override
    public EObject getEObject(Uuid uuid) throws IllegalStateException {
        EObject eObject = this.getEObjectOrNull(uuid);
        Preconditions.checkState((eObject != null ? 1 : 0) != 0, (String)"no EObject could be found for UUID: %s", (Object)uuid);
        return eObject;
    }

    @Override
    public void registerEObject(Uuid uuid, EObject eObject) throws IllegalStateException {
        Preconditions.checkState((uuid != null ? 1 : 0) != 0, (Object)"uuid must not be null");
        Preconditions.checkState((eObject != null ? 1 : 0) != 0, (Object)"object must not be null");
        if (eObject.eResource() != null && eObject.eResource().getResourceSet() != null) {
            Preconditions.checkState((eObject.eResource().getResourceSet() == this.resourceSet ? 1 : 0) != 0, (String)"element %s is contained in wrong resource set", (Object)eObject);
        }
        Preconditions.checkState((boolean)((Uuid)this.eObjectToUuid.getOrDefault((Object)eObject, (Object)uuid)).equals(uuid), (String)"element %s is already registered for UUID %s", (Object)eObject, (Object)this.eObjectToUuid.get((Object)eObject));
        Preconditions.checkState((boolean)((EObject)this.eObjectToUuid.inverse().getOrDefault((Object)uuid, (Object)eObject)).equals(eObject), (String)"UUID %s is already registered for element %s, was trying to register %s", (Object)uuid, (Object)this.eObjectToUuid.inverse().get((Object)uuid), (Object)eObject);
        if (this.isReadOnlyEObject(eObject)) {
            Uuid expectedUuid = this.getUuidForReadOnlyEObject(eObject);
            Preconditions.checkState((boolean)uuid.equals(expectedUuid), (String)"read-only object %s must be registered for UUID %s but was %s", (Object)eObject, (Object)expectedUuid, (Object)uuid);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding UUID " + String.valueOf(uuid) + " for EObject: " + String.valueOf(eObject));
        }
        this.eObjectToUuid.put((Object)eObject, (Object)uuid);
    }

    @Override
    public void unregisterEObject(Uuid uuid, EObject eObject) throws IllegalStateException {
        Preconditions.checkState((uuid != null ? 1 : 0) != 0, (Object)"uuid must not be null");
        Preconditions.checkState((eObject != null ? 1 : 0) != 0, (Object)"object must not be null");
        Preconditions.checkState((boolean)uuid.equals(this.eObjectToUuid.get((Object)eObject)), (String)"trying to unregister element %s but is not registered for uuid %s", (Object)eObject, (Object)uuid);
        this.eObjectToUuid.remove((Object)eObject);
    }

    @Override
    public Uuid generateUuid(EObject eObject) {
        Preconditions.checkState((!eObject.eIsProxy() ? 1 : 0) != 0, (String)"Cannot generate UUID for proxy object %s", (Object)eObject);
        if (this.isReadOnlyEObject(eObject)) {
            return this.getUuidForReadOnlyEObject(eObject);
        }
        return new Uuid(NON_READONLY_PREFIX + EcoreUtil.generateUUID());
    }

    @Override
    public Resource getResource(URI uri) {
        return ResourceSetUtil.getOrCreateResource((ResourceSet)this.resourceSet, (URI)uri);
    }

    @Override
    public void endTransaction() {
        for (EObject object : this.eObjectToUuid.keySet()) {
            Preconditions.checkState((object.eResource() != null ? 1 : 0) != 0, (String)"dangling object %s detected", (Object)object);
            Preconditions.checkState((object.eResource().getResourceSet() == this.resourceSet ? 1 : 0) != 0, (String)"object %s is contained in wrong resource set", (Object)object);
        }
    }

    @Override
    public void resolveResources(Map<Resource, Resource> sourceToTargetResourceMapping, UuidResolver targetUuidResolver) {
        Preconditions.checkState((sourceToTargetResourceMapping != null ? 1 : 0) != 0, (Object)"source to target resource mapping must not be null");
        Preconditions.checkState((targetUuidResolver != null ? 1 : 0) != 0, (Object)"target UUID resolver must not be null");
        if (sourceToTargetResourceMapping.isEmpty()) {
            return;
        }
        sourceToTargetResourceMapping.keySet().forEach(resource -> Preconditions.checkState((resource.getResourceSet() == this.resourceSet ? 1 : 0) != 0, (String)"trying to unresolve resource %s from different resource set", (Object)resource));
        ResourceSet targetResourceSet = sourceToTargetResourceMapping.values().iterator().next().getResourceSet();
        sourceToTargetResourceMapping.values().forEach(resource -> Preconditions.checkState((resource.getResourceSet() == targetResourceSet ? 1 : 0) != 0, (String)"trying to resolve resource %s from different resource set", (Object)resource));
        Map<Uuid, HierarchicalId> uuidToIdMapping = this.generateUuidToIdMapping(sourceToTargetResourceMapping.keySet());
        this.applyUuidToIdMapping(uuidToIdMapping, targetUuidResolver, targetResourceSet, sourceToTargetResourceMapping);
    }

    @Override
    public void loadFromUri(URI uri) throws IOException {
        Preconditions.checkState((boolean)this.eObjectToUuid.isEmpty(), (Object)"trying to load stored UUID resolver configuration but contained already some UUIDs");
        Preconditions.checkState((boolean)uri.isFile(), (String)"Loading UUID resolver requires a file uri but was %s", (Object)uri);
        File file = new File(uri.toFileString());
        if (!file.exists()) {
            return;
        }
        HashMap<Uuid, HierarchicalId> uuidToIdMapping = new HashMap<Uuid, HierarchicalId>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                String[] components = line.split("\\|");
                Preconditions.checkState((components.length == 2 ? 1 : 0) != 0, (String)"invalid UUID resolver serialization (line %s) found at %s", (Object)line, (Object)uri);
                uuidToIdMapping.put(new Uuid(components[0]), new HierarchicalId(components[1]));
                line = reader.readLine();
            }
        }
        this.applyUuidToIdMapping(uuidToIdMapping, this, this.resourceSet, null);
    }

    @Override
    public void storeAtUri(URI uri) throws IOException {
        Preconditions.checkState((boolean)uri.isFile(), (String)"Storing UUID resolver requires a file uri but was %s", (Object)uri);
        Map<Uuid, HierarchicalId> uuidToIdMapping = this.generateUuidToIdMapping(null);
        File file = new File(uri.toFileString());
        try (FileWriter writer = new FileWriter(file);){
            for (Map.Entry<Uuid, HierarchicalId> entry : uuidToIdMapping.entrySet()) {
                String uuid = entry.getKey().getRawValue();
                String id = entry.getValue().getId();
                writer.write(uuid + SERIALIZATION_SEPARATOR + id);
                writer.write(System.lineSeparator());
            }
        }
    }

    private Uuid getUuidOrNull(EObject eObject) {
        if (this.isReadOnlyEObject(eObject)) {
            return this.getUuidForReadOnlyEObject(eObject);
        }
        Uuid uuid = (Uuid)this.eObjectToUuid.get((Object)eObject);
        return uuid;
    }

    private Uuid getUuidForReadOnlyEObject(EObject eObject) {
        URI proxyURI = ((InternalEObject)eObject).eProxyURI();
        Resource resource = eObject.eResource();
        if (proxyURI == null && resource != null) {
            URI uri = resource.getURI();
            String uriFragment = ObjectResolutionUtil.getHierarchicUriFragment(eObject);
            uri = uri == null ? URI.createURI((String)("#" + uriFragment)) : uri.appendFragment(uriFragment);
            return new Uuid(uri.toString());
        }
        return new Uuid(EcoreUtil.getURI((EObject)eObject).toString());
    }

    private EObject getEObjectOrNull(Uuid uuid) {
        if (this.isReadOnlyUuid(uuid)) {
            return this.getEObjectForReadOnlyUuid(uuid);
        }
        return (EObject)this.eObjectToUuid.inverse().get((Object)uuid);
    }

    private EObject getEObjectForReadOnlyUuid(Uuid uuid) {
        URI uri = URI.createURI((String)uuid.getRawValue());
        return uri.hasFragment() ? this.resourceSet.getEObject(uri, true) : null;
    }

    private boolean isReadOnlyEObject(EObject eObject) {
        return eObject.eResource() != null && eObject.eResource().getURI() != null && this.isReadOnlyUri(eObject.eResource().getURI());
    }

    private boolean isReadOnlyUri(URI uri) {
        return URIUtil.isPathmap((URI)uri) || uri.isArchive();
    }

    private boolean isReadOnlyUuid(Uuid uuid) {
        return !uuid.getRawValue().startsWith(NON_READONLY_PREFIX);
    }

    private Map<Uuid, HierarchicalId> generateUuidToIdMapping(Collection<Resource> resourcesFilter) {
        HierarchicalIdResolver idUnresolver = HierarchicalIdResolver.create(this.resourceSet);
        HashMap<Uuid, HierarchicalId> uuidToIdMapping = new HashMap<Uuid, HierarchicalId>();
        for (Map.Entry entry : this.eObjectToUuid.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            Preconditions.checkState((eObject.eResource() != null && eObject.eResource().getResourceSet() != null ? 1 : 0) != 0, (String)"trying to unresolve dangling EObject %s", (Object)eObject);
            if (resourcesFilter != null && !resourcesFilter.contains(eObject.eResource())) continue;
            HierarchicalId id = idUnresolver.getAndUpdateId(eObject);
            Uuid uuid = (Uuid)entry.getValue();
            uuidToIdMapping.put(uuid, id);
        }
        return uuidToIdMapping;
    }

    private void applyUuidToIdMapping(Map<Uuid, HierarchicalId> uuidToIdMapping, UuidResolver targetUuidResolver, ResourceSet targetResourceSet, Map<Resource, Resource> sourceToTargetResourceMapping) throws IllegalStateException {
        HierarchicalIdResolver idResolver = HierarchicalIdResolver.create(targetResourceSet);
        for (Map.Entry<Uuid, HierarchicalId> entry : uuidToIdMapping.entrySet()) {
            Uuid uuid = entry.getKey();
            HierarchicalId id = entry.getValue();
            EObject targetEObject = idResolver.getEObject(id);
            Preconditions.checkState((targetEObject != null ? 1 : 0) != 0, (String)"could not find object corresponding to %s in resource set %s", (Object)uuid, (Object)targetResourceSet);
            if (sourceToTargetResourceMapping != null) {
                EObject sourceEObject = (EObject)this.eObjectToUuid.inverse().get((Object)uuid);
                Preconditions.checkState((targetEObject.eResource() == sourceToTargetResourceMapping.get(sourceEObject.eResource()) ? 1 : 0) != 0, (String)"resolved object %s to element %s which is contained in wrong resource", (Object)targetEObject, (Object)sourceEObject);
            }
            targetUuidResolver.registerEObject(uuid, targetEObject);
        }
    }
}

