/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.composite;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public final class MetamodelDescriptor {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final Set<String> nsUris;

    private MetamodelDescriptor(Set<String> nsUris) {
        Consumer<String> _function = it -> Preconditions.checkArgument((it != null ? 1 : 0) != 0, (String)"metamodel descriptor to be instantiated for namespace URIs %s must not contain a null URI", (Object)nsUris);
        nsUris.forEach(_function);
        HashSet<String> _hashSet = new HashSet<String>(nsUris);
        this.nsUris = _hashSet;
    }

    public boolean contains(MetamodelDescriptor descriptorForPotentiallyContainedMetamodel) {
        boolean _xblockexpression = false;
        Preconditions.checkArgument((descriptorForPotentiallyContainedMetamodel != null ? 1 : 0) != 0, (String)"metamodel descriptor to check for containment in %s must not be null", (Object)this);
        _xblockexpression = this.nsUris.containsAll(descriptorForPotentiallyContainedMetamodel.nsUris);
        return _xblockexpression;
    }

    public boolean equals(Object obj) {
        boolean _xblockexpression = false;
        if (obj instanceof MetamodelDescriptor) {
            return Objects.equals(this.nsUris, ((MetamodelDescriptor)obj).nsUris);
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public int hashCode() {
        return this.nsUris.hashCode();
    }

    public String toString() {
        return this.nsUris.toString();
    }

    public static MetamodelDescriptor of(EPackage rootPackage) {
        String _nsURI = rootPackage.getNsURI();
        return MetamodelDescriptor.with(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{_nsURI})));
    }

    public static MetamodelDescriptor of(Set<EPackage> rootPackages) {
        Functions.Function1 _function = it -> it.getNsURI();
        return MetamodelDescriptor.with(IterableExtensions.toSet((Iterable)IterableExtensions.map(rootPackages, (Functions.Function1)_function)));
    }

    public static MetamodelDescriptor with(String nsUri) {
        return MetamodelDescriptor.with(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{nsUri})));
    }

    public static MetamodelDescriptor with(Set<String> nsUris) {
        return new MetamodelDescriptor(nsUris);
    }

    @Pure
    public Set<String> getNsUris() {
        return this.nsUris;
    }
}

