/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.composite.description.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.eobject.CreateEObject;
import tools.vitruv.change.atomic.eobject.DeleteEObject;
import tools.vitruv.change.atomic.eobject.EObjectExistenceEChange;
import tools.vitruv.change.atomic.feature.FeatureEChange;
import tools.vitruv.change.atomic.feature.UnsetFeature;
import tools.vitruv.change.atomic.feature.attribute.InsertEAttributeValue;
import tools.vitruv.change.atomic.feature.attribute.RemoveEAttributeValue;
import tools.vitruv.change.atomic.feature.attribute.ReplaceSingleValuedEAttribute;
import tools.vitruv.change.atomic.feature.attribute.UpdateAttributeEChange;
import tools.vitruv.change.atomic.feature.reference.InsertEReference;
import tools.vitruv.change.atomic.feature.reference.RemoveEReference;
import tools.vitruv.change.atomic.feature.reference.ReplaceSingleValuedEReference;
import tools.vitruv.change.atomic.root.InsertRootEObject;
import tools.vitruv.change.atomic.root.RemoveRootEObject;
import tools.vitruv.change.atomic.root.RootEChange;
import tools.vitruv.change.composite.MetamodelDescriptor;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.interaction.UserInteractionBase;

public class TransactionalChangeImpl<Element>
implements TransactionalChange<Element> {
    private List<? extends EChange<Element>> eChanges;
    private final List<UserInteractionBase> userInteractions = new ArrayList<UserInteractionBase>();

    public TransactionalChangeImpl(Iterable<? extends EChange<Element>> eChanges) {
        this.eChanges = IterableExtensions.toList((Iterable)((Iterable)Preconditions.checkNotNull(eChanges, (Object)"eChanges")));
    }

    @Override
    public List<EChange<Element>> getEChanges() {
        return Collections.unmodifiableList(this.eChanges);
    }

    @Override
    public boolean containsConcreteChange() {
        boolean _isEmpty = this.eChanges.isEmpty();
        return !_isEmpty;
    }

    private static URI getChangedURI(EChange<?> eChange) {
        URI _objectUri;
        EObject _affectedElement;
        URI _switchResult = null;
        boolean _matched = false;
        if (eChange instanceof FeatureEChange) {
            _matched = true;
            _affectedElement = (EObject)((FeatureEChange)eChange).getAffectedElement();
            _objectUri = null;
            if (_affectedElement != null) {
                _objectUri = TransactionalChangeImpl.getObjectUri(_affectedElement);
            }
            _switchResult = _objectUri;
        }
        if (!_matched && eChange instanceof EObjectExistenceEChange) {
            _matched = true;
            _affectedElement = (EObject)((EObjectExistenceEChange)eChange).getAffectedElement();
            _objectUri = null;
            if (_affectedElement != null) {
                _objectUri = TransactionalChangeImpl.getObjectUri(_affectedElement);
            }
            _switchResult = _objectUri;
        }
        if (!_matched && eChange instanceof RootEChange) {
            _matched = true;
            _switchResult = URI.createURI((String)((RootEChange)eChange).getUri());
        }
        return _switchResult;
    }

    @Override
    public Set<URI> getChangedURIs() {
        Functions.Function1 _function = it -> TransactionalChangeImpl.getChangedURI(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(this.eChanges, (Functions.Function1)_function)));
    }

    @Override
    public MetamodelDescriptor getAffectedEObjectsMetamodelDescriptor() {
        Functions.Function2 _function;
        HashSet _hashSet;
        Set<EObject> _affectedEObjects = this.getAffectedEObjects();
        HashSet changedPackages = (HashSet)IterableExtensions.fold(_affectedEObjects, _hashSet = new HashSet(), (Functions.Function2)(_function = (affectedPackages, changedObject) -> {
            HashSet _xblockexpression = null;
            EPackage currentPackage = changedObject.eClass().getEPackage();
            while (currentPackage.getESuperPackage() != null) {
                currentPackage = currentPackage.getESuperPackage();
            }
            if (currentPackage != null) {
                affectedPackages.add(currentPackage);
            }
            _xblockexpression = affectedPackages;
            return _xblockexpression;
        }));
        boolean _isEmpty = changedPackages.isEmpty();
        boolean _not = !_isEmpty;
        Preconditions.checkState((boolean)_not, (String)"Cannot identify the packages of this change:%s%s", (Object)System.lineSeparator(), (Object)this);
        return MetamodelDescriptor.of(changedPackages);
    }

    @Override
    public Set<EObject> getAffectedEObjects() {
        Functions.Function1 _function = it -> TransactionalChangeImpl.getAffectedEObjects(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(this.eChanges, (Functions.Function1)_function));
    }

    @Override
    public Set<EObject> getAffectedAndReferencedEObjects() {
        Functions.Function1 _function = it -> TransactionalChangeImpl.getAffectedAndReferencedEObjects(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(this.eChanges, (Functions.Function1)_function));
    }

    private static Set<EObject> getAffectedEObjects(EChange<?> eChange) {
        Set<EObject> _switchResult = null;
        boolean _matched = false;
        if (eChange instanceof FeatureEChange) {
            _matched = true;
            _switchResult = Set.of((EObject)((FeatureEChange)eChange).getAffectedElement());
        }
        if (!_matched && eChange instanceof EObjectExistenceEChange) {
            _matched = true;
            _switchResult = Set.of((EObject)((EObjectExistenceEChange)eChange).getAffectedElement());
        }
        if (!_matched && eChange instanceof InsertRootEObject) {
            _matched = true;
            _switchResult = Set.of((EObject)((InsertRootEObject)eChange).getNewValue());
        }
        if (!_matched && eChange instanceof RemoveRootEObject) {
            _matched = true;
            _switchResult = Set.of((EObject)((RemoveRootEObject)eChange).getOldValue());
        }
        return _switchResult;
    }

    private static Set<EObject> getAffectedAndReferencedEObjects(EChange<?> eChange) {
        Set<EObject> _switchResult = null;
        boolean _matched = false;
        if (eChange instanceof UpdateAttributeEChange) {
            _matched = true;
            _switchResult = Set.of((EObject)((UpdateAttributeEChange)eChange).getAffectedElement());
        }
        if (!_matched && eChange instanceof ReplaceSingleValuedEReference) {
            _matched = true;
            _switchResult = TransactionalChangeImpl.setOfNotNull((EObject)((ReplaceSingleValuedEReference)eChange).getAffectedElement(), (EObject)((ReplaceSingleValuedEReference)eChange).getOldValue(), (EObject)((ReplaceSingleValuedEReference)eChange).getNewValue());
        }
        if (!_matched && eChange instanceof InsertEReference) {
            _matched = true;
            _switchResult = Set.of((EObject)((InsertEReference)eChange).getAffectedElement(), (EObject)((InsertEReference)eChange).getNewValue());
        }
        if (!_matched && eChange instanceof RemoveEReference) {
            _matched = true;
            _switchResult = Set.of((EObject)((RemoveEReference)eChange).getAffectedElement(), (EObject)((RemoveEReference)eChange).getOldValue());
        }
        if (!_matched && eChange instanceof EObjectExistenceEChange) {
            _matched = true;
            _switchResult = Set.of((EObject)((EObjectExistenceEChange)eChange).getAffectedElement());
        }
        if (!_matched && eChange instanceof InsertRootEObject) {
            _matched = true;
            _switchResult = Set.of((EObject)((InsertRootEObject)eChange).getNewValue());
        }
        if (!_matched && eChange instanceof RemoveRootEObject) {
            _matched = true;
            _switchResult = Set.of((EObject)((RemoveRootEObject)eChange).getOldValue());
        }
        return _switchResult;
    }

    @Override
    public Iterable<UserInteractionBase> getUserInteractions() {
        return this.userInteractions;
    }

    @Override
    public void setUserInteractions(Iterable<UserInteractionBase> userInteractions) {
        Preconditions.checkNotNull(userInteractions, (Object)"Interactions must not be null");
        this.userInteractions.clear();
        Iterables.addAll(this.userInteractions, userInteractions);
    }

    protected List<EChange<Element>> getClonedEChanges() {
        Functions.Function1 _function = it -> (EChange)EcoreUtil.copy((EObject)it);
        return IterableUtil.mapFixed(this.eChanges, (Functions.Function1)_function);
    }

    @Override
    public TransactionalChangeImpl<Element> copy() {
        List<EChange<Element>> _clonedEChanges = this.getClonedEChanges();
        return new TransactionalChangeImpl<Element>(_clonedEChanges);
    }

    public boolean equals(Object obj) {
        boolean _xifexpression = false;
        if (obj == this) {
            _xifexpression = true;
        } else {
            boolean _xifexpression_1 = false;
            if (obj == null) {
                _xifexpression_1 = false;
            } else {
                boolean _xifexpression_2 = false;
                if (obj instanceof TransactionalChange) {
                    List _eChanges = ((TransactionalChange)obj).getEChanges();
                    _xifexpression_2 = Objects.equals(this.eChanges, _eChanges);
                } else {
                    _xifexpression_2 = false;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public int hashCode() {
        return this.eChanges.hashCode();
    }

    private static URI getObjectUri(EObject object) {
        URI _xblockexpression = null;
        Resource objectResource = object.eResource();
        URI _xifexpression = null;
        if (objectResource != null) {
            _xifexpression = objectResource.getURI();
        } else {
            URI _xifexpression_1 = null;
            boolean _eIsProxy = object.eIsProxy();
            if (_eIsProxy) {
                URI _xblockexpression_1 = null;
                URI proxyURI = ((InternalEObject)object).eProxyURI();
                URI _xifexpression_2 = null;
                _xifexpression_2 = proxyURI != null && proxyURI.segmentCount() > 0 ? proxyURI.trimFragment() : null;
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
            } else {
                _xifexpression_1 = null;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static <T> Set<T> setOfNotNull(T element) {
        Set<T> _xifexpression = null;
        _xifexpression = element != null ? Set.of(element) : CollectionLiterals.emptySet();
        return _xifexpression;
    }

    private static <T> Set<T> setOfNotNull(T element1, T element2) {
        Set<T> _xifexpression = null;
        if (element1 == null) {
            _xifexpression = TransactionalChangeImpl.setOfNotNull(element2);
        } else {
            Set<T> _xifexpression_1 = null;
            _xifexpression_1 = element2 == null ? Set.of(element1) : Set.of(element1, element2);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static <T> Set<T> setOfNotNull(T element1, T element2, T element3) {
        Set<T> _xifexpression = null;
        if (element1 == null) {
            _xifexpression = TransactionalChangeImpl.setOfNotNull(element2, element3);
        } else {
            Set<T> _xifexpression_1 = null;
            if (element2 == null) {
                _xifexpression_1 = TransactionalChangeImpl.setOfNotNull(element1, element3);
            } else {
                Set<T> _xifexpression_2 = null;
                _xifexpression_2 = element3 == null ? Set.of(element1, element2) : Set.of(element1, element2, element3);
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String toString() {
        String _xifexpression = null;
        boolean _isEmpty = this.eChanges.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            String _simpleName = this.getClass().getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" (empty)");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _simpleName_1 = this.getClass().getSimpleName();
            _builder_1.append(_simpleName_1);
            _builder_1.append(": [");
            _builder_1.newLineIfNotEmpty();
            for (EChange<Element> eChange : this.eChanges) {
                _builder_1.append("\t");
                CharSequence _stringRepresentation = this.getStringRepresentation(eChange);
                _builder_1.append((Object)_stringRepresentation, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("]");
            _builder_1.newLine();
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    private CharSequence getStringRepresentation(EChange<?> change) {
        Object _oldValue;
        Object _newValue;
        CharSequence _affectedFeatureString;
        Object _affectedElement;
        int _index;
        String _uri;
        StringConcatenation _builder;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (change instanceof InsertRootEObject) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("insert ");
            Object _newValue2 = ((InsertRootEObject)change).getNewValue();
            _builder.append(_newValue2);
            _builder.append(" at ");
            _uri = ((InsertRootEObject)change).getUri();
            _builder.append(_uri);
            _builder.append(" (index ");
            _index = ((InsertRootEObject)change).getIndex();
            _builder.append((Object)_index);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof RemoveRootEObject) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("remove ");
            Object _oldValue2 = ((RemoveRootEObject)change).getOldValue();
            _builder.append(_oldValue2);
            _builder.append(" from ");
            _uri = ((RemoveRootEObject)change).getUri();
            _builder.append(_uri);
            _builder.append(" (index ");
            _index = ((RemoveRootEObject)change).getIndex();
            _builder.append((Object)_index);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof CreateEObject) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("create ");
            _affectedElement = ((CreateEObject)change).getAffectedElement();
            _builder.append(_affectedElement);
            _switchResult = _builder;
        }
        if (!_matched && change instanceof DeleteEObject) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("delete ");
            _affectedElement = ((DeleteEObject)change).getAffectedElement();
            _builder.append(_affectedElement);
            _switchResult = _builder;
        }
        if (!_matched && change instanceof UnsetFeature) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" = ");
            _builder.append("\u2205");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof ReplaceSingleValuedEAttribute) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" = ");
            _newValue = ((ReplaceSingleValuedEAttribute)change).getNewValue();
            _builder.append(_newValue);
            _builder.append(" (was ");
            Object _oldValue3 = ((ReplaceSingleValuedEAttribute)change).getOldValue();
            _builder.append(_oldValue3);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof ReplaceSingleValuedEReference) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" = ");
            _newValue = ((ReplaceSingleValuedEReference)change).getNewValue();
            _builder.append(_newValue);
            _builder.append(" (was ");
            Object _oldValue4 = ((ReplaceSingleValuedEReference)change).getOldValue();
            _builder.append(_oldValue4);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof InsertEAttributeValue) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" += ");
            _newValue = ((InsertEAttributeValue)change).getNewValue();
            _builder.append(_newValue);
            _builder.append(" (index ");
            int _index2 = ((InsertEAttributeValue)change).getIndex();
            _builder.append((Object)_index2);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof InsertEReference) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" += ");
            _newValue = ((InsertEReference)change).getNewValue();
            _builder.append(_newValue);
            _builder.append(" (index ");
            int _index3 = ((InsertEReference)change).getIndex();
            _builder.append((Object)_index3);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof RemoveEAttributeValue) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" -= ");
            _oldValue = ((RemoveEAttributeValue)change).getOldValue();
            _builder.append(_oldValue);
            _builder.append(" (index ");
            int _index4 = ((RemoveEAttributeValue)change).getIndex();
            _builder.append((Object)_index4);
            _builder.append(")");
            _switchResult = _builder;
        }
        if (!_matched && change instanceof RemoveEReference) {
            _matched = true;
            _builder = new StringConcatenation();
            _affectedFeatureString = this.getAffectedFeatureString((FeatureEChange)change);
            _builder.append((Object)_affectedFeatureString);
            _builder.append(" -= ");
            _oldValue = ((RemoveEReference)change).getOldValue();
            _builder.append(_oldValue);
            _builder.append(" (index ");
            int _index5 = ((RemoveEReference)change).getIndex();
            _builder.append((Object)_index5);
            _builder.append(")");
            _switchResult = _builder;
        }
        return _switchResult;
    }

    private CharSequence getAffectedFeatureString(FeatureEChange<?, ?> change) {
        StringConcatenation _builder = new StringConcatenation();
        Object _affectedElement = change.getAffectedElement();
        _builder.append(_affectedElement);
        _builder.append(".");
        String _name = change.getAffectedFeature().getName();
        _builder.append(_name);
        return _builder;
    }
}

