/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.composite.recording;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.EChangeUtil;
import tools.vitruv.change.atomic.eobject.EObjectAddedEChange;
import tools.vitruv.change.atomic.eobject.EObjectSubtractedEChange;
import tools.vitruv.change.atomic.feature.reference.UpdateReferenceEChange;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChangeFactory;
import tools.vitruv.change.composite.recording.NotificationInfo;
import tools.vitruv.change.composite.recording.NotificationToEChangeConverter;

public class ChangeRecorder
implements AutoCloseable {
    private final NotificationRecorder recordingAdapter = new NotificationRecorder(this);
    private final Set<Notifier> rootObjects = new HashSet<Notifier>();
    private boolean isRecording = false;
    private List<EChange<EObject>> resultChanges = CollectionLiterals.emptyList();
    private final NotificationToEChangeConverter converter;
    private final Set<EObject> existingObjects = new HashSet<EObject>();
    private final Set<Notifier> toDesinfect = new HashSet<Notifier>();
    private final ResourceSet resourceSet;

    public ChangeRecorder(ResourceSet resourceSet) {
        NotificationToEChangeConverter _notificationToEChangeConverter;
        this.resourceSet = resourceSet;
        Functions.Function2 _function = (affectedObject, addedObject) -> this.isCreateChange((EObject)affectedObject, (EObject)addedObject);
        this.converter = _notificationToEChangeConverter = new NotificationToEChangeConverter((Functions.Function2<? super EObject, ? super EObject, ? extends Boolean>)_function);
    }

    private boolean isCreateChange(EObject affectedObject, EObject addedObject) {
        boolean create = addedObject != null && !this.existingObjects.contains(addedObject);
        boolean bl = create = create && (addedObject.eResource() == null || affectedObject == null || Objects.equals(addedObject.eResource(), affectedObject.eResource()));
        if (create) {
            this.existingObjects.add(addedObject);
        }
        return create;
    }

    public void addToRecording(Notifier notifier) {
        this.checkNotDisposed();
        Preconditions.checkNotNull((Object)notifier, (Object)"notifier");
        Preconditions.checkArgument((boolean)this.isInOurResourceSet(notifier), (Object)"cannot record changes in a different resource set!");
        boolean _add = this.rootObjects.add(notifier);
        if (_add) {
            Functions.Function1 _function = it -> {
                boolean _xblockexpression = false;
                if (it instanceof EObject) {
                    this.existingObjects.add((EObject)it);
                }
                _xblockexpression = this.addAdapter((Notifier)it);
                return _xblockexpression;
            };
            ChangeRecorder.recursively(notifier, (Functions.Function1<? super Notifier, ? extends Boolean>)_function);
        }
    }

    public void removeFromRecording(Notifier notifier) {
        this.checkNotDisposed();
        Preconditions.checkNotNull((Object)notifier, (Object)"notifier");
        this.rootObjects.remove(notifier);
        Functions.Function1 _function = it -> this.removeAdapter((Notifier)it);
        ChangeRecorder.recursively(notifier, (Functions.Function1<? super Notifier, ? extends Boolean>)_function);
    }

    public List<EChange<EObject>> beginRecording() {
        ArrayList<EChange<EObject>> _xblockexpression = null;
        this.checkNotDisposed();
        Preconditions.checkState((!this.isRecording ? 1 : 0) != 0, (Object)"This recorder is already recording!");
        Consumer<Notifier> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> this.removeAdapter((Notifier)it_1);
            ChangeRecorder.recursively(it, (Functions.Function1<? super Notifier, ? extends Boolean>)_function_1);
        };
        this.toDesinfect.forEach(_function);
        this.toDesinfect.clear();
        this.isRecording = true;
        ArrayList<EChange<EObject>> _arrayList = new ArrayList<EChange<EObject>>();
        this.resultChanges = _arrayList;
        _xblockexpression = this.resultChanges;
        return _xblockexpression;
    }

    @Override
    public void close() {
        this.isRecording = false;
        this.resultChanges = null;
        Set<Notifier> rootCopy = Set.copyOf(this.rootObjects);
        this.rootObjects.clear();
        this.existingObjects.clear();
        Consumer<Notifier> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> this.removeAdapter((Notifier)it_1);
            ChangeRecorder.recursively(it, (Functions.Function1<? super Notifier, ? extends Boolean>)_function_1);
        };
        rootCopy.forEach(_function);
    }

    private void checkNotDisposed() {
        Preconditions.checkState((this.resultChanges != null ? 1 : 0) != 0, (Object)"This recorder has already been disposed!");
    }

    public TransactionalChange<EObject> endRecording() {
        this.checkNotDisposed();
        Preconditions.checkState((boolean)this.isRecording, (Object)"This recorder is not recording");
        this.isRecording = false;
        this.resultChanges = List.copyOf(this.postprocessRemovals(this.resultChanges));
        return this.getChange();
    }

    private List<EChange<EObject>> postprocessRemovals(List<EChange<EObject>> changes) {
        boolean _not;
        boolean _isEmpty = changes.isEmpty();
        if (_isEmpty) {
            return changes;
        }
        HashSet<EObject> removedElements = new HashSet<EObject>();
        for (EChange<EObject> eChange : changes) {
            boolean _matched = false;
            if (eChange instanceof EObjectSubtractedEChange) {
                _matched = true;
                boolean _isContainmentRemoval = EChangeUtil.isContainmentRemoval(eChange);
                if (_isContainmentRemoval) {
                    EObject _oldValue = (EObject)((EObjectSubtractedEChange)eChange).getOldValue();
                    removedElements.add(_oldValue);
                }
            }
            boolean _matched_1 = false;
            if (!(eChange instanceof EObjectAddedEChange)) continue;
            _matched_1 = true;
            boolean _isContainmentInsertion = EChangeUtil.isContainmentInsertion(eChange);
            if (!_isContainmentInsertion) continue;
            EObject _newValue = (EObject)((EObjectAddedEChange)eChange).getNewValue();
            removedElements.remove(_newValue);
        }
        boolean _isEmpty_1 = removedElements.isEmpty();
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            HashMap allElementsToDelete = new HashMap();
            Consumer<EObject> _function = element -> {
                Functions.Function1 _function_1 = it -> IterableExtensions.contains((Iterable)it, (Object)element);
                boolean _exists = IterableExtensions.exists(allElementsToDelete.values(), (Functions.Function1)_function_1);
                if (_exists) {
                    return;
                }
                List elementsToDelete = ListExtensions.reverse((List)IteratorExtensions.toList((Iterator)element.eAllContents()));
                Consumer<EObject> _function_2 = child -> {
                    boolean _containsKey = allElementsToDelete.containsKey(child);
                    if (_containsKey) {
                        allElementsToDelete.remove(child);
                    }
                };
                elementsToDelete.forEach(_function_2);
                elementsToDelete.add(element);
                allElementsToDelete.put(element, elementsToDelete);
            };
            removedElements.forEach(_function);
            Functions.Function1 _function_1 = elementsToDelete -> {
                Functions.Function1 _function_2 = it -> this.converter.createDeleteChange((EObject)it);
                return IterableExtensions.map((Iterable)elementsToDelete, (Functions.Function1)_function_2);
            };
            List _list = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(allElementsToDelete.values(), (Functions.Function1)_function_1));
            Iterables.addAll(changes, (Iterable)_list);
        }
        return changes;
    }

    public TransactionalChange<EObject> getChange() {
        TransactionalChange<EObject> _xblockexpression = null;
        this.checkNotDisposed();
        Preconditions.checkState((!this.isRecording ? 1 : 0) != 0, (Object)"This recorder is still recording!");
        _xblockexpression = VitruviusChangeFactory.getInstance().createTransactionalChange(this.resultChanges);
        return _xblockexpression;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    private static void _recursively(ResourceSet resourceSet, Functions.Function1<? super Notifier, ? extends Boolean> action) {
        Boolean _apply = (Boolean)action.apply((Object)resourceSet);
        if (_apply.booleanValue()) {
            Consumer<Resource> _function = it -> ChangeRecorder.recursively((Notifier)it, action);
            resourceSet.getResources().forEach(_function);
        }
    }

    private static void _recursively(Resource resource, Functions.Function1<? super Notifier, ? extends Boolean> action) {
        Boolean _apply = (Boolean)action.apply((Object)resource);
        if (_apply.booleanValue()) {
            Consumer<EObject> _function = it -> ChangeRecorder.recursively((Notifier)it, action);
            resource.getContents().forEach(_function);
        }
    }

    private static void _recursively(EObject object, Functions.Function1<? super Notifier, ? extends Boolean> action) {
        Boolean _apply = (Boolean)action.apply((Object)object);
        if (_apply.booleanValue()) {
            TreeIterator properContents = EcoreUtil.getAllProperContents((EObject)object, (boolean)true);
            while (properContents.hasNext()) {
                Boolean _apply_1 = (Boolean)action.apply(properContents.next());
                boolean _not = _apply_1 == false;
                if (!_not) continue;
                properContents.prune();
            }
        }
    }

    private boolean removeAdapter(Notifier notifier) {
        return !this.rootObjects.contains(notifier) && notifier.eAdapters().remove((Object)this.recordingAdapter);
    }

    private boolean addAdapter(Notifier notifier) {
        boolean _xblockexpression = false;
        EList eAdapters = notifier.eAdapters();
        _xblockexpression = !eAdapters.contains((Object)this.recordingAdapter) && eAdapters.add((Object)this.recordingAdapter);
        return _xblockexpression;
    }

    private boolean isInOurResourceSet(Notifier notifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (Objects.equals(notifier, null)) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && notifier instanceof EObject) {
            _matched = true;
            Resource _eResource = null;
            if ((EObject)notifier != null) {
                _eResource = ((EObject)notifier).eResource();
            }
            _switchResult = this.isInOurResourceSet((Notifier)_eResource);
        }
        if (!_matched && notifier instanceof Resource) {
            _matched = true;
            ResourceSet _resourceSet = null;
            if ((Resource)notifier != null) {
                _resourceSet = ((Resource)notifier).getResourceSet();
            }
            _switchResult = this.isInOurResourceSet((Notifier)_resourceSet);
        }
        if (!_matched && notifier instanceof ResourceSet) {
            _matched = true;
            _switchResult = Objects.equals(notifier, this.resourceSet);
        }
        if (!_matched) {
            String _simpleName = notifier.getClass().getSimpleName();
            String _plus = "Unexpected notifier type: " + _simpleName;
            throw new IllegalStateException(_plus);
        }
        return _switchResult;
    }

    @XbaseGenerated
    private static void recursively(Notifier object, Functions.Function1<? super Notifier, ? extends Boolean> action) {
        if (object instanceof EObject && action != null) {
            ChangeRecorder._recursively((EObject)object, action);
            return;
        }
        if (object instanceof Resource && action != null) {
            ChangeRecorder._recursively((Resource)object, action);
            return;
        }
        if (object instanceof ResourceSet && action != null) {
            ChangeRecorder._recursively((ResourceSet)object, action);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object, action).toString());
    }

    @FinalFieldsConstructor
    private static class NotificationRecorder
    implements Adapter {
        @Extension
        private final ChangeRecorder outer;
        private final Set<Resource> currentlyLoadingResources = new HashSet<Resource>();

        public void notifyChanged(Notification notification) {
            this.handleAdaptersForResourceAndResourceSetChanges(notification);
            Iterable<? extends EChange<EObject>> newChanges = this.extractRelevantChanges(notification);
            if (this.outer.isRecording) {
                Iterables.addAll(this.outer.resultChanges, newChanges);
            }
        }

        private void handleAdaptersForResourceAndResourceSetChanges(Notification notification) {
            boolean _isContainment;
            Object _feature;
            if (notification.getNotifier() instanceof ResourceSet && notification.getFeatureID(ResourceSet.class) == 0) {
                int _eventType = notification.getEventType();
                switch (_eventType) {
                    case 3: {
                        Object _newValue = notification.getNewValue();
                        this.startLoadingResource((Resource)_newValue);
                        break;
                    }
                    case 5: {
                        Object _newValue_1 = notification.getNewValue();
                        Consumer<Resource> _function = it -> this.startLoadingResource((Resource)it);
                        ((Iterable)_newValue_1).forEach(_function);
                    }
                }
            }
            Object feature = _feature = notification.getFeature();
            boolean _matched = false;
            if (feature instanceof EReference && (_isContainment = ((EReference)feature).isContainment())) {
                _matched = true;
            }
            if (!_matched && notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 2) {
                _matched = true;
            }
            if (!_matched && notification.getNotifier() instanceof ResourceSet && notification.getFeatureID(ResourceSet.class) == 0) {
                _matched = true;
            }
            if (_matched) {
                int _eventType_1 = notification.getEventType();
                switch (_eventType_1) {
                    case 1: 
                    case 4: {
                        this.desinfect(notification.getOldValue());
                        break;
                    }
                    case 6: {
                        Object _oldValue = notification.getOldValue();
                        Consumer<Object> _function_1 = it -> this.desinfect(it);
                        ((Iterable)_oldValue).forEach(_function_1);
                    }
                }
                int _eventType_2 = notification.getEventType();
                switch (_eventType_2) {
                    case 1: 
                    case 3: {
                        this.infect(notification.getNewValue());
                        break;
                    }
                    case 5: {
                        Object _newValue_2 = notification.getNewValue();
                        Consumer<Object> _function_2 = it -> this.infect(it);
                        ((Iterable)_newValue_2).forEach(_function_2);
                    }
                }
            }
            if (!_matched && notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 4) {
                _matched = true;
                Object _notifier = notification.getNotifier();
                this.finishLoadingResource((Resource)_notifier);
            }
        }

        private Iterable<? extends EChange<EObject>> extractRelevantChanges(Notification notification) {
            boolean _not;
            Iterable<Object> _xifexpression = null;
            if (this.affectsLoadingResource(notification) || this.affectsUnloadingResource(notification)) {
                _xifexpression = CollectionLiterals.emptyList();
            } else {
                NotificationInfo _notificationInfo = new NotificationInfo(notification);
                _xifexpression = this.outer.converter.convert(_notificationInfo);
            }
            List changes = _xifexpression;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)changes);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Consumer<EChange> _function = it -> {
                    boolean _matched = false;
                    if (it instanceof EObjectAddedEChange) {
                        _matched = true;
                        EObject _newValue = (EObject)((EObjectAddedEChange)it).getNewValue();
                        this.outer.existingObjects.add(_newValue);
                        boolean _matched_1 = false;
                        if (it instanceof UpdateReferenceEChange) {
                            _matched_1 = true;
                            EObject _affectedElement = (EObject)((UpdateReferenceEChange)it).getAffectedElement();
                            this.outer.existingObjects.add(_affectedElement);
                        }
                    }
                };
                changes.forEach(_function);
            }
            return changes;
        }

        private void startLoadingResource(Resource resource) {
            this.currentlyLoadingResources.add(resource);
        }

        private void finishLoadingResource(Resource resource) {
            this.currentlyLoadingResources.remove(resource);
            Functions.Function1 _function = it -> {
                boolean _xblockexpression = false;
                if (it instanceof EObject) {
                    this.outer.existingObjects.add((EObject)it);
                }
                _xblockexpression = this.outer.addAdapter((Notifier)it);
                return _xblockexpression;
            };
            ChangeRecorder.recursively((Notifier)resource, (Functions.Function1<? super Notifier, ? extends Boolean>)_function);
        }

        private boolean affectsLoadingResource(Notification notification) {
            boolean _contains;
            EObject _xifexpression = null;
            Object _newValue = notification.getNewValue();
            if (_newValue instanceof EObject) {
                Object _newValue_1 = notification.getNewValue();
                _xifexpression = (EObject)_newValue_1;
            } else {
                _xifexpression = null;
            }
            EObject newEObject = _xifexpression;
            boolean _and = false;
            Resource _eResource = null;
            if (newEObject != null) {
                _eResource = newEObject.eResource();
            }
            boolean _tripleNotEquals = _eResource != null;
            _and = !_tripleNotEquals ? false : (_contains = this.currentlyLoadingResources.contains(newEObject.eResource()));
            return _and;
        }

        private boolean affectsUnloadingResource(Notification notification) {
            Object _notifier = notification.getNotifier();
            if (_notifier instanceof Resource) {
                Object _notifier_1 = notification.getNotifier();
                Resource resource = (Resource)_notifier_1;
                ResourceSet resourceSet = resource.getResourceSet();
                return !resource.isLoaded() && resourceSet != null && resourceSet.getURIConverter().exists(resource.getURI(), CollectionLiterals.emptyMap());
            }
            return false;
        }

        private void infect(Object newValue) {
            if ((Notifier)newValue != null) {
                Functions.Function1 _function = it -> {
                    boolean _xblockexpression = false;
                    this.outer.toDesinfect.remove(it);
                    _xblockexpression = this.outer.addAdapter((Notifier)it);
                    return _xblockexpression;
                };
                ChangeRecorder.recursively((Notifier)newValue, (Functions.Function1<? super Notifier, ? extends Boolean>)_function);
            }
        }

        private boolean desinfect(Object oldValue) {
            boolean _xifexpression = false;
            if (oldValue instanceof Notifier) {
                _xifexpression = this.outer.toDesinfect.add((Notifier)oldValue);
            }
            return _xifexpression;
        }

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void setTarget(Notifier newTarget) {
        }

        public NotificationRecorder(ChangeRecorder outer) {
            this.outer = outer;
        }
    }
}

