/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.composite.recording;

import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.TypeInferringAtomicEChangeFactory;
import tools.vitruv.change.atomic.eobject.CreateEObject;
import tools.vitruv.change.atomic.eobject.EObjectAddedEChange;
import tools.vitruv.change.atomic.feature.UnsetFeature;
import tools.vitruv.change.atomic.feature.attribute.AttributeFactory;
import tools.vitruv.change.atomic.feature.attribute.InsertEAttributeValue;
import tools.vitruv.change.atomic.feature.attribute.RemoveEAttributeValue;
import tools.vitruv.change.atomic.feature.attribute.ReplaceSingleValuedEAttribute;
import tools.vitruv.change.atomic.feature.reference.InsertEReference;
import tools.vitruv.change.atomic.feature.reference.RemoveEReference;
import tools.vitruv.change.atomic.feature.reference.ReplaceSingleValuedEReference;
import tools.vitruv.change.atomic.feature.reference.UpdateReferenceEChange;
import tools.vitruv.change.atomic.root.RemoveRootEObject;
import tools.vitruv.change.composite.recording.EChangeCreationUtil;
import tools.vitruv.change.composite.recording.EventType;
import tools.vitruv.change.composite.recording.NotificationInfo;

@FinalFieldsConstructor
final class NotificationToEChangeConverter {
    @Extension
    private final TypeInferringAtomicEChangeFactory changeFactory = TypeInferringAtomicEChangeFactory.getInstance();
    private final Functions.Function2<? super EObject, ? super EObject, ? extends Boolean> isCreateChange;
    private final String ATTRIBUTE_TYPE = "Attribute";
    private final String REFERENCE_TYPE = "Reference";
    private final String RESOURCE_CONTENTS_TYPE = "Resource Contents";

    public EChange<EObject> createDeleteChange(EObject eObject) {
        return this.changeFactory.createDeleteEObjectChange(eObject);
    }

    private String convertExceptionMessage(EventType eventType, String notificationType) {
        return String.format("Event type {} for {} Notifications unexpected.", new Object[0]);
    }

    public Iterable<? extends EChange<EObject>> convert(@Extension NotificationInfo notification) {
        Object _notifier;
        boolean _isReferenceNotification;
        boolean _isAttributeNotification;
        Object _newValue;
        Object _oldValue;
        boolean _equals;
        boolean _isTransient;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        boolean _isTouch = notification.isTouch();
        if (_isTouch) {
            _matched = true;
        }
        if (!_matched && (_isTransient = notification.isTransient())) {
            _matched = true;
        }
        if (!_matched && (_equals = Objects.equals(_oldValue = notification.getOldValue(), _newValue = notification.getNewValue()))) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        if (!_matched && (_isAttributeNotification = notification.isAttributeNotification())) {
            _matched = true;
            Iterable<? extends EChange<EObject>> _switchResult_1 = null;
            EventType _eventTypeEnum = notification.getEventTypeEnum();
            if (_eventTypeEnum != null) {
                switch (_eventTypeEnum) {
                    case SET: {
                        _switchResult_1 = this.handleSetAttribute(notification);
                        break;
                    }
                    case UNSET: {
                        _switchResult_1 = this.handleUnsetAttribute(notification);
                        break;
                    }
                    case ADD: {
                        _switchResult_1 = this.handleInsertAttribute(notification);
                        break;
                    }
                    case ADD_MANY: {
                        _switchResult_1 = this.handleMultiInsertAttribute(notification);
                        break;
                    }
                    case REMOVE: {
                        _switchResult_1 = this.handleRemoveAttribute(notification);
                        break;
                    }
                    case REMOVE_MANY: {
                        _switchResult_1 = this.handleMultiRemoveAttribute(notification);
                        break;
                    }
                    case MOVE: {
                        _switchResult_1 = this.handleMoveAttribute(notification);
                        break;
                    }
                    case RESOLVE: {
                        String _convertExceptionMessage = this.convertExceptionMessage(EventType.RESOLVE, this.ATTRIBUTE_TYPE);
                        throw new IllegalArgumentException(_convertExceptionMessage);
                    }
                    case REMOVING_ADAPTER: {
                        String _convertExceptionMessage_1 = this.convertExceptionMessage(EventType.REMOVING_ADAPTER, this.ATTRIBUTE_TYPE);
                        throw new IllegalArgumentException(_convertExceptionMessage_1);
                    }
                    default: {
                        int _eventType = notification.getEventType();
                        String _plus = "Unexpected event type " + Integer.valueOf(_eventType);
                        throw new IllegalArgumentException(_plus);
                    }
                }
            } else {
                int _eventType = notification.getEventType();
                String _plus = "Unexpected event type " + Integer.valueOf(_eventType);
                throw new IllegalArgumentException(_plus);
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && (_isReferenceNotification = notification.isReferenceNotification())) {
            _matched = true;
            Iterable<? extends EChange<EObject>> _switchResult_2 = null;
            EventType _eventTypeEnum_1 = notification.getEventTypeEnum();
            if (_eventTypeEnum_1 != null) {
                switch (_eventTypeEnum_1) {
                    case SET: {
                        _switchResult_2 = this.handleSetReference(notification);
                        break;
                    }
                    case UNSET: {
                        _switchResult_2 = this.handleUnsetReference(notification);
                        break;
                    }
                    case ADD: {
                        _switchResult_2 = this.handleInsertReference(notification);
                        break;
                    }
                    case ADD_MANY: {
                        _switchResult_2 = this.handleMultiInsertReference(notification);
                        break;
                    }
                    case REMOVE: {
                        _switchResult_2 = this.handleRemoveReference(notification);
                        break;
                    }
                    case REMOVE_MANY: {
                        _switchResult_2 = this.handleMultiRemoveReference(notification);
                        break;
                    }
                    case MOVE: {
                        _switchResult_2 = this.handleMoveReference(notification);
                        break;
                    }
                    case RESOLVE: {
                        String _convertExceptionMessage_2 = this.convertExceptionMessage(EventType.RESOLVE, this.REFERENCE_TYPE);
                        throw new IllegalArgumentException(_convertExceptionMessage_2);
                    }
                    case REMOVING_ADAPTER: {
                        String _convertExceptionMessage_3 = this.convertExceptionMessage(EventType.REMOVING_ADAPTER, this.REFERENCE_TYPE);
                        throw new IllegalArgumentException(_convertExceptionMessage_3);
                    }
                    default: {
                        int _eventType_1 = notification.getEventType();
                        String _plus_1 = "Unexpected event type " + Integer.valueOf(_eventType_1);
                        throw new IllegalArgumentException(_plus_1);
                    }
                }
            } else {
                int _eventType_1 = notification.getEventType();
                String _plus_1 = "Unexpected event type " + Integer.valueOf(_eventType_1);
                throw new IllegalArgumentException(_plus_1);
            }
            _switchResult = _switchResult_2;
        }
        if (!_matched && (_notifier = notification.getNotifier()) instanceof Resource) {
            _matched = true;
            Iterable<Object> _switchResult_3 = null;
            int _featureID = notification.getFeatureID(Resource.class);
            switch (_featureID) {
                case 2: {
                    Iterable<? extends EChange<EObject>> _switchResult_4 = null;
                    EventType _eventTypeEnum_2 = notification.getEventTypeEnum();
                    if (_eventTypeEnum_2 != null) {
                        switch (_eventTypeEnum_2) {
                            case ADD: {
                                _switchResult_4 = this.handleInsertRootChange(notification);
                                break;
                            }
                            case ADD_MANY: {
                                _switchResult_4 = this.handleMultiInsertRootChange(notification);
                                break;
                            }
                            case REMOVE: {
                                _switchResult_4 = this.handleRemoveRootChange(notification);
                                break;
                            }
                            case REMOVE_MANY: {
                                _switchResult_4 = this.handleMultiRemoveRootChange(notification);
                                break;
                            }
                            case SET: {
                                String _convertExceptionMessage_4 = this.convertExceptionMessage(EventType.SET, this.RESOURCE_CONTENTS_TYPE);
                                throw new IllegalArgumentException(_convertExceptionMessage_4);
                            }
                            case UNSET: {
                                String _convertExceptionMessage_5 = this.convertExceptionMessage(EventType.UNSET, this.RESOURCE_CONTENTS_TYPE);
                                throw new IllegalArgumentException(_convertExceptionMessage_5);
                            }
                            case MOVE: {
                                String _convertExceptionMessage_6 = this.convertExceptionMessage(EventType.MOVE, this.RESOURCE_CONTENTS_TYPE);
                                throw new IllegalArgumentException(_convertExceptionMessage_6);
                            }
                            case RESOLVE: {
                                String _convertExceptionMessage_7 = this.convertExceptionMessage(EventType.RESOLVE, this.RESOURCE_CONTENTS_TYPE);
                                throw new IllegalArgumentException(_convertExceptionMessage_7);
                            }
                            case REMOVING_ADAPTER: {
                                String _convertExceptionMessage_8 = this.convertExceptionMessage(EventType.REMOVING_ADAPTER, this.RESOURCE_CONTENTS_TYPE);
                                throw new IllegalArgumentException(_convertExceptionMessage_8);
                            }
                            default: {
                                int _eventType_2 = notification.getEventType();
                                String _plus_2 = "Unexpected event type " + Integer.valueOf(_eventType_2);
                                throw new IllegalArgumentException(_plus_2);
                            }
                        }
                    } else {
                        int _eventType_2 = notification.getEventType();
                        String _plus_2 = "Unexpected event type " + Integer.valueOf(_eventType_2);
                        throw new IllegalArgumentException(_plus_2);
                    }
                    _switchResult_3 = _switchResult_4;
                    break;
                }
                case 1: {
                    Iterable<? extends EChange<EObject>> _switchResult_5 = null;
                    EventType _eventTypeEnum_3 = notification.getEventTypeEnum();
                    if (_eventTypeEnum_3 != null) {
                        switch (_eventTypeEnum_3) {
                            case SET: {
                                _switchResult_5 = this.handleSetUriChange(notification);
                                break;
                            }
                            default: {
                                int _eventType_3 = notification.getEventType();
                                String _plus_3 = "Unexpected event type " + Integer.valueOf(_eventType_3);
                                String _plus_4 = _plus_3 + " for Resource URI Notification.";
                                throw new IllegalArgumentException(_plus_4);
                            }
                        }
                    } else {
                        int _eventType_3 = notification.getEventType();
                        String _plus_3 = "Unexpected event type " + Integer.valueOf(_eventType_3);
                        String _plus_4 = _plus_3 + " for Resource URI Notification.";
                        throw new IllegalArgumentException(_plus_4);
                    }
                    _switchResult_3 = _switchResult_5;
                    break;
                }
                default: {
                    _switchResult_3 = CollectionLiterals.emptyList();
                }
            }
            _switchResult = _switchResult_3;
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        return _switchResult;
    }

    private Iterable<? extends EChange<EObject>> handleMoveAttribute(@Extension NotificationInfo notification) {
        Object _oldValue = notification.getOldValue();
        RemoveEAttributeValue _createRemoveAttributeChange = this.changeFactory.createRemoveAttributeChange((Object)notification.getNotifierModelElement(), notification.getAttribute(), ((Integer)_oldValue).intValue(), notification.getNewValue());
        InsertEAttributeValue _createInsertAttributeChange = this.changeFactory.createInsertAttributeChange((Object)notification.getNotifierModelElement(), notification.getAttribute(), notification.getPosition(), notification.getNewValue());
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EChange[]{_createRemoveAttributeChange, _createInsertAttributeChange}));
    }

    private Iterable<? extends EChange<EObject>> handleMoveReference(@Extension NotificationInfo notification) {
        Object _oldValue = notification.getOldValue();
        RemoveEReference _createRemoveReferenceChange = this.changeFactory.createRemoveReferenceChange((Object)notification.getNotifierModelElement(), notification.getReference(), (Object)notification.getNewModelElementValue(), ((Integer)_oldValue).intValue());
        InsertEReference _createInsertReferenceChange = this.changeFactory.createInsertReferenceChange((Object)notification.getNotifierModelElement(), notification.getReference(), (Object)notification.getNewModelElementValue(), notification.getPosition());
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EChange[]{_createRemoveReferenceChange, _createInsertReferenceChange}));
    }

    private Iterable<? extends EChange<EObject>> handleSetAttribute(@Extension NotificationInfo notification) {
        boolean _not;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        boolean _isMany = notification.getAttribute().isMany();
        boolean bl = _not = !_isMany;
        if (_not) {
            _matched = true;
            _switchResult = this.handleReplaceAttribute(notification);
        }
        if (!_matched && notification.getOldValue() != null && notification.getNewValue() != null) {
            _matched = true;
            List<EChange<EObject>> _handleRemoveAttribute = this.handleRemoveAttribute(notification);
            List<InsertEAttributeValue<EObject, Object>> _handleInsertAttribute = this.handleInsertAttribute(notification);
            _switchResult = Iterables.concat(_handleRemoveAttribute, _handleInsertAttribute);
        }
        if (!_matched) {
            boolean _tripleNotEquals;
            Object _newValue = notification.getNewValue();
            boolean bl2 = _tripleNotEquals = _newValue != null;
            if (_tripleNotEquals) {
                _matched = true;
                _switchResult = this.handleInsertAttribute(notification);
            }
        }
        if (!_matched) {
            boolean _tripleNotEquals_1;
            Object _oldValue = notification.getOldValue();
            boolean bl3 = _tripleNotEquals_1 = _oldValue != null;
            if (_tripleNotEquals_1) {
                _matched = true;
                _switchResult = this.handleRemoveAttribute(notification);
            }
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        return _switchResult;
    }

    private Iterable<? extends EChange<EObject>> handleSetReference(@Extension NotificationInfo notification) {
        boolean _not;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        boolean _isMany = notification.getReference().isMany();
        boolean bl = _not = !_isMany;
        if (_not) {
            _matched = true;
            _switchResult = this.handleReplaceReference(notification);
        }
        if (!_matched && notification.getOldValue() != null && notification.getNewValue() != null) {
            _matched = true;
            Iterable<? extends EChange<EObject>> _handleRemoveReference = this.handleRemoveReference(notification);
            Iterable<? extends EChange<EObject>> _handleInsertReference = this.handleInsertReference(notification);
            _switchResult = Iterables.concat(_handleRemoveReference, _handleInsertReference);
        }
        if (!_matched) {
            boolean _tripleNotEquals;
            Object _newValue = notification.getNewValue();
            boolean bl2 = _tripleNotEquals = _newValue != null;
            if (_tripleNotEquals) {
                _matched = true;
                _switchResult = this.handleInsertReference(notification);
            }
        }
        if (!_matched) {
            boolean _tripleNotEquals_1;
            Object _oldValue = notification.getOldValue();
            boolean bl3 = _tripleNotEquals_1 = _oldValue != null;
            if (_tripleNotEquals_1) {
                _matched = true;
                _switchResult = this.handleRemoveReference(notification);
            }
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        return _switchResult;
    }

    private Iterable<? extends EChange<EObject>> handleUnsetAttribute(@Extension NotificationInfo notification) {
        Iterable<Object> _xifexpression = null;
        boolean _isMany = notification.getAttribute().isMany();
        boolean _not = !_isMany;
        _xifexpression = _not ? this.handleSetAttribute(notification) : List.of(this.changeFactory.createUnsetFeatureChange((Object)notification.getNotifierModelElement(), (EStructuralFeature)notification.getAttribute()));
        return _xifexpression;
    }

    private Iterable<? extends EChange<EObject>> handleUnsetReference(@Extension NotificationInfo notification) {
        Iterable<Object> _xifexpression = null;
        boolean _isMany = notification.getReference().isMany();
        boolean _not = !_isMany;
        _xifexpression = _not ? this.handleSetReference(notification) : List.of(this.changeFactory.createUnsetFeatureChange((Object)notification.getNotifierModelElement(), (EStructuralFeature)notification.getReference()));
        return _xifexpression;
    }

    private Iterable<? extends EChange<EObject>> handleReplaceAttribute(@Extension NotificationInfo notification) {
        ReplaceSingleValuedEAttribute change = AttributeFactory.eINSTANCE.createReplaceSingleValuedEAttribute();
        change.setOldValue(notification.getOldValue());
        change.setNewValue(notification.getNewValue());
        change.setAffectedFeature((EStructuralFeature)notification.getAttribute());
        change.setAffectedElement((Object)notification.getNotifierModelElement());
        change.setIsUnset(notification.wasUnset());
        return List.of(change);
    }

    private Iterable<? extends EChange<EObject>> handleReplaceReference(@Extension NotificationInfo notification) {
        ReplaceSingleValuedEReference change = this.changeFactory.createReplaceSingleReferenceChange((Object)notification.getNotifierModelElement(), notification.getReference(), (Object)notification.getOldModelElementValue(), (Object)notification.getNewModelElementValue());
        change.setIsUnset(notification.wasUnset());
        return this.surroundWithCreateAndFeatureChangesIfNecessary((EObjectAddedEChange<EObject>)change);
    }

    private List<EChange<EObject>> handleRemoveAttribute(@Extension NotificationInfo notification) {
        return this.addUnsetChangeIfNecessary((EChange<EObject>)this.changeFactory.createRemoveAttributeChange((Object)notification.getNotifierModelElement(), notification.getAttribute(), notification.getPosition(), notification.getOldValue()), notification);
    }

    private Iterable<? extends EChange<EObject>> handleMultiRemoveAttribute(@Extension NotificationInfo notification) {
        boolean _tripleEquals;
        Iterable<Object> _xifexpression = null;
        Object _newValue = notification.getNewValue();
        boolean bl = _tripleEquals = _newValue == null;
        if (_tripleEquals) {
            Iterable<EChange<EObject>> _xblockexpression = null;
            Object _oldValue = notification.getOldValue();
            List oldValues = (List)_oldValue;
            Functions.Function2 _function = (index, value) -> {
                RemoveEAttributeValue _xblockexpression_1 = null;
                int _initialIndex = notification.getInitialIndex();
                int _size = oldValues.size();
                int _plus = _initialIndex + _size;
                int _minus = _plus - 1;
                int valueIndex = _minus - index;
                _xblockexpression_1 = this.changeFactory.createRemoveAttributeChange((Object)notification.getNotifierModelElement(), notification.getAttribute(), valueIndex, value);
                return _xblockexpression_1;
            };
            _xblockexpression = this.addUnsetChangeIfNecessary(IterableUtil.mapFixedIndexed((Collection)ListExtensions.reverseView((List)oldValues), (Functions.Function2)_function), notification);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = this.unsetChangeOrEmpty(notification);
        }
        return _xifexpression;
    }

    private Iterable<? extends EChange<EObject>> handleRemoveReference(@Extension NotificationInfo notification) {
        return this.addUnsetChangeIfNecessary((EChange<EObject>)this.changeFactory.createRemoveReferenceChange((Object)notification.getNotifierModelElement(), notification.getReference(), (Object)notification.getOldModelElementValue(), notification.getPosition()), notification);
    }

    private Iterable<? extends EChange<EObject>> handleMultiRemoveReference(@Extension NotificationInfo notification) {
        boolean _tripleEquals;
        Iterable<Object> _xifexpression = null;
        Object _newValue = notification.getNewValue();
        boolean bl = _tripleEquals = _newValue == null;
        if (_tripleEquals) {
            Iterable<EChange<EObject>> _xblockexpression = null;
            Object _oldValue = notification.getOldValue();
            List oldValues = (List)_oldValue;
            Functions.Function2 _function = (index, value) -> {
                RemoveEReference _xblockexpression_1 = null;
                int _initialIndex = notification.getInitialIndex();
                int _size = oldValues.size();
                int _plus = _initialIndex + _size;
                int _minus = _plus - 1;
                int valueIndex = _minus - index;
                _xblockexpression_1 = this.changeFactory.createRemoveReferenceChange((Object)notification.getNotifierModelElement(), notification.getReference(), value, valueIndex);
                return _xblockexpression_1;
            };
            _xblockexpression = this.addUnsetChangeIfNecessary(IterableUtil.mapFixedIndexed((Collection)ListExtensions.reverseView((List)oldValues), (Functions.Function2)_function), notification);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = this.unsetChangeOrEmpty(notification);
        }
        return _xifexpression;
    }

    private List<InsertEAttributeValue<EObject, Object>> handleInsertAttribute(@Extension NotificationInfo notification) {
        return List.of(this.changeFactory.createInsertAttributeChange((Object)notification.getNotifierModelElement(), notification.getAttribute(), notification.getPosition(), notification.getNewValue()));
    }

    private List<InsertEAttributeValue<EObject, Object>> handleMultiInsertAttribute(@Extension NotificationInfo notification) {
        Object _newValue = notification.getNewValue();
        Functions.Function2 _function = (index, value) -> {
            EObject _notifierModelElement = notification.getNotifierModelElement();
            EAttribute _attribute = notification.getAttribute();
            int _initialIndex = notification.getInitialIndex();
            int _plus = _initialIndex + index;
            return this.changeFactory.createInsertAttributeChange((Object)_notifierModelElement, _attribute, _plus, value);
        };
        return IterableUtil.mapFixedIndexed((Collection)((List)_newValue), (Functions.Function2)_function);
    }

    private Iterable<? extends EChange<EObject>> handleInsertReference(@Extension NotificationInfo notification) {
        return this.surroundWithCreateAndFeatureChangesIfNecessary((EObjectAddedEChange<EObject>)this.changeFactory.createInsertReferenceChange((Object)notification.getNotifierModelElement(), notification.getReference(), (Object)notification.getNewModelElementValue(), notification.getPosition()));
    }

    private Iterable<? extends EChange<EObject>> handleMultiInsertReference(@Extension NotificationInfo notification) {
        Object _newValue = notification.getNewValue();
        Functions.Function2 _function = (index, value) -> {
            EObject _notifierModelElement = notification.getNotifierModelElement();
            EReference _reference = notification.getReference();
            int _initialIndex = notification.getInitialIndex();
            int _plus = _initialIndex + index;
            return this.surroundWithCreateAndFeatureChangesIfNecessary((EObjectAddedEChange<EObject>)this.changeFactory.createInsertReferenceChange((Object)_notifierModelElement, _reference, value, _plus));
        };
        return IterableUtil.flatMapFixedIndexed((Iterable)((List)_newValue), (Functions.Function2)_function);
    }

    private Iterable<? extends EChange<EObject>> handleInsertRootChange(@Extension NotificationInfo notification) {
        return this.surroundWithCreateAndFeatureChangesIfNecessary((EObjectAddedEChange<EObject>)this.changeFactory.createInsertRootChange((Object)notification.getNewModelElementValue(), notification.getNotifierResource(), notification.getPosition()));
    }

    private List<EChange<EObject>> handleMultiInsertRootChange(@Extension NotificationInfo notification) {
        Object _newValue = notification.getNewValue();
        Functions.Function2 _function = (index, value) -> {
            Resource _notifierResource = notification.getNotifierResource();
            int _initialIndex = notification.getInitialIndex();
            int _plus = _initialIndex + index;
            return this.surroundWithCreateAndFeatureChangesIfNecessary((EObjectAddedEChange<EObject>)this.changeFactory.createInsertRootChange(value, _notifierResource, _plus));
        };
        return IterableUtil.flatMapFixedIndexed((Iterable)((List)_newValue), (Functions.Function2)_function);
    }

    private List<RemoveRootEObject<EObject>> handleRemoveRootChange(@Extension NotificationInfo notification) {
        return List.of(this.changeFactory.createRemoveRootChange(notification.getOldModelElementValue(), notification.getNotifierResource(), notification.getPosition()));
    }

    private List<RemoveRootEObject<EObject>> handleMultiRemoveRootChange(@Extension NotificationInfo notification) {
        List _xblockexpression = null;
        Object _oldValue = notification.getOldValue();
        List oldValues = (List)_oldValue;
        Functions.Function2 _function = (index, value) -> {
            RemoveRootEObject _xblockexpression_1 = null;
            int _initialIndex = notification.getInitialIndex();
            int _size = oldValues.size();
            int _plus = _initialIndex + _size;
            int _minus = _plus - 1;
            int valueIndex = _minus - index;
            _xblockexpression_1 = this.changeFactory.createRemoveRootChange(value, notification.getNotifierResource(), valueIndex);
            return _xblockexpression_1;
        };
        _xblockexpression = IterableUtil.mapFixedIndexed((Collection)ListExtensions.reverseView((List)oldValues), (Functions.Function2)_function);
        return _xblockexpression;
    }

    private Iterable<? extends EChange<EObject>> handleSetUriChange(@Extension NotificationInfo notification) {
        Iterable _xblockexpression = null;
        Object _oldValue = notification.getOldValue();
        URI oldUri = (URI)_oldValue;
        Functions.Function2 _function = (index, value) -> {
            RemoveRootEObject _xblockexpression_1 = null;
            int _initialIndex = notification.getInitialIndex();
            int _size = notification.getNotifierResource().getContents().size();
            int _plus = _initialIndex + _size;
            int _minus = _plus - 1;
            int valueIndex = _minus - index;
            Resource oldResource = notification.getNotifierResource().getResourceSet().createResource(oldUri);
            _xblockexpression_1 = this.changeFactory.createRemoveRootChange(value, oldResource, oldUri, valueIndex);
            return _xblockexpression_1;
        };
        List _mapFixedIndexed = IterableUtil.mapFixedIndexed((Collection)notification.getNotifierResource().getContents(), (Functions.Function2)_function);
        Functions.Function2 _function_1 = (index, value) -> {
            Resource _notifierResource = notification.getNotifierResource();
            int _initialIndex = notification.getInitialIndex();
            int _plus = _initialIndex + index;
            return this.surroundWithCreateAndFeatureChangesIfNecessary((EObjectAddedEChange<EObject>)this.changeFactory.createInsertRootChange(value, _notifierResource, _plus));
        };
        List _flatMapFixedIndexed = IterableUtil.flatMapFixedIndexed((Iterable)notification.getNotifierResource().getContents(), (Functions.Function2)_function_1);
        _xblockexpression = Iterables.concat((Iterable)_mapFixedIndexed, (Iterable)_flatMapFixedIndexed);
        return _xblockexpression;
    }

    private Iterable<? extends EChange<EObject>> allAdditiveChangesForChangeRelevantFeatures(EObjectAddedEChange<EObject> change, EObject eObject) {
        Functions.Function2 _function = (object, attribute) -> EChangeCreationUtil.createAdditiveEChangeForAttribute(object, attribute);
        Functions.Function2 _function_1 = (object, reference) -> {
            List<? extends EChange<EObject>> _xifexpression = null;
            boolean _isContainment = reference.isContainment();
            if (_isContainment) {
                Functions.Function1 _function_2 = referencedObject -> (Boolean)this.isCreateChange.apply(object, referencedObject);
                _xifexpression = EChangeCreationUtil.createAdditiveEChangeForReferencedObject(object, reference, (Functions.Function1<? super EObject, ? extends Boolean>)_function_2);
            }
            return _xifexpression;
        };
        Iterable<? extends EChange<EObject>> _walkChangeRelevantFeatures = NotificationToEChangeConverter.walkChangeRelevantFeatures((EObject)change.getNewValue(), (Functions.Function2<? super EObject, ? super EAttribute, ? extends Iterable<? extends EChange<EObject>>>)_function, (Functions.Function2<? super EObject, ? super EReference, ? extends Iterable<? extends EChange<EObject>>>)_function_1);
        Functions.Function2 _function_2 = (object, reference) -> {
            boolean _not;
            List<? extends EChange<EObject>> _xifexpression = null;
            boolean _isContainment = reference.isContainment();
            boolean bl = _not = !_isContainment;
            if (_not) {
                Functions.Function1 _function_3 = it -> false;
                _xifexpression = EChangeCreationUtil.createAdditiveEChangeForReferencedObject(object, reference, (Functions.Function1<? super EObject, ? extends Boolean>)_function_3);
            }
            return _xifexpression;
        };
        Iterable<? extends EChange<EObject>> _walkChangeRelevantFeatures_1 = NotificationToEChangeConverter.walkChangeRelevantFeatures((EObject)change.getNewValue(), null, (Functions.Function2<? super EObject, ? super EReference, ? extends Iterable<? extends EChange<EObject>>>)_function_2);
        return Iterables.concat(_walkChangeRelevantFeatures, _walkChangeRelevantFeatures_1);
    }

    private static Iterable<? extends EChange<EObject>> walkChangeRelevantFeatures(EObject eObject, Functions.Function2<? super EObject, ? super EAttribute, ? extends Iterable<? extends EChange<EObject>>> attributeVisitor, Functions.Function2<? super EObject, ? super EReference, ? extends Iterable<? extends EChange<EObject>>> referenceVisitor) {
        Iterable _xblockexpression = null;
        Functions.Function1 _function = it -> EChangeCreationUtil.hasChangeableUnderivedPersistedNotContainingNonDefaultValue(eObject, it);
        Iterable changeRelevantFeatures = IterableExtensions.filter((Iterable)eObject.eClass().getEAllStructuralFeatures(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            Iterable _elvis = null;
            Iterable _apply = null;
            if (attributeVisitor != null) {
                _apply = (Iterable)attributeVisitor.apply((Object)eObject, it);
            }
            if (_apply != null) {
                _elvis = _apply;
            } else {
                List _emptyList = CollectionLiterals.emptyList();
                _elvis = _emptyList;
            }
            return _elvis;
        };
        List thisLayerAttributeResults = IterableUtil.flatMapFixed((Iterable)Iterables.filter((Iterable)changeRelevantFeatures, EAttribute.class), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> {
            Iterable _elvis = null;
            Iterable _apply = null;
            if (referenceVisitor != null) {
                _apply = (Iterable)referenceVisitor.apply((Object)eObject, it);
            }
            if (_apply != null) {
                _elvis = _apply;
            } else {
                List _emptyList = CollectionLiterals.emptyList();
                _elvis = _emptyList;
            }
            return _elvis;
        };
        List thisLayerReferenceResults = IterableUtil.flatMapFixed((Iterable)Iterables.filter((Iterable)changeRelevantFeatures, EReference.class), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> it.isContainment();
        Functions.Function1 _function_4 = it -> NotificationToEChangeConverter.getReferencedElements(eObject, it);
        Functions.Function1 _function_5 = it -> NotificationToEChangeConverter.walkChangeRelevantFeatures(it, attributeVisitor, referenceVisitor);
        List nextLayer = IterableUtil.flatMapFixed((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)changeRelevantFeatures, EReference.class), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
        Iterable _plus = Iterables.concat((Iterable)thisLayerAttributeResults, (Iterable)thisLayerReferenceResults);
        _xblockexpression = Iterables.concat((Iterable)_plus, (Iterable)nextLayer);
        return _xblockexpression;
    }

    private static Iterable<EObject> getReferencedElements(EObject eObject, EReference reference) {
        List<EObject> _xifexpression = null;
        boolean _isMany = reference.isMany();
        if (_isMany) {
            Object _eGet = eObject.eGet((EStructuralFeature)reference);
            _xifexpression = (List<EObject>)_eGet;
        } else {
            Object _eGet_1 = eObject.eGet((EStructuralFeature)reference);
            _xifexpression = List.of((EObject)_eGet_1);
        }
        return _xifexpression;
    }

    private List<UnsetFeature<EObject, EStructuralFeature>> unsetChangeOrEmpty(NotificationInfo notification) {
        List<UnsetFeature> _xifexpression = null;
        boolean _wasUnset = notification.wasUnset();
        _xifexpression = _wasUnset ? List.of(this.changeFactory.createUnsetFeatureChange((Object)notification.getNotifierModelElement(), notification.getStructuralFeature())) : CollectionLiterals.emptyList();
        return _xifexpression;
    }

    private <T extends EChange<EObject>> Iterable<? extends EChange<EObject>> addUnsetChangeIfNecessary(Iterable<T> changes, NotificationInfo notification) {
        Iterable _xifexpression = null;
        boolean _wasUnset = notification.wasUnset();
        if (_wasUnset) {
            List<UnsetFeature> _of = List.of(this.changeFactory.createUnsetFeatureChange((Object)notification.getNotifierModelElement(), notification.getStructuralFeature()));
            _xifexpression = Iterables.concat(changes, _of);
        } else {
            _xifexpression = changes;
        }
        return _xifexpression;
    }

    private List<EChange<EObject>> addUnsetChangeIfNecessary(EChange<EObject> change, NotificationInfo notification) {
        List<Object> _xifexpression = null;
        boolean _wasUnset = notification.wasUnset();
        _xifexpression = _wasUnset ? List.of(change, this.changeFactory.createUnsetFeatureChange((Object)notification.getNotifierModelElement(), notification.getStructuralFeature())) : List.of(change);
        return _xifexpression;
    }

    private Iterable<? extends EChange<EObject>> surroundWithCreateAndFeatureChangesIfNecessary(EObjectAddedEChange<EObject> change) {
        EObject _switchResult = null;
        boolean _matched = false;
        if (change instanceof UpdateReferenceEChange) {
            _matched = true;
            _switchResult = (EObject)((UpdateReferenceEChange)change).getAffectedElement();
        }
        if (!_matched) {
            _switchResult = null;
        }
        EObject affectedElement = _switchResult;
        Iterable<Object> _xifexpression = null;
        Boolean _apply = (Boolean)this.isCreateChange.apply((Object)affectedElement, change.getNewValue());
        if (_apply.booleanValue()) {
            Iterable _xblockexpression = null;
            CreateEObject createChange = this.changeFactory.createCreateEObjectChange((EObject)change.getNewValue());
            List<EObjectAddedEChange<EObject>> _of = List.of(createChange, change);
            Iterable<? extends EChange<EObject>> _allAdditiveChangesForChangeRelevantFeatures = this.allAdditiveChangesForChangeRelevantFeatures(change, (EObject)change.getNewValue());
            _xblockexpression = Iterables.concat(_of, _allAdditiveChangesForChangeRelevantFeatures);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = List.of(change);
        }
        return _xifexpression;
    }

    public NotificationToEChangeConverter(Functions.Function2<? super EObject, ? super EObject, ? extends Boolean> isCreateChange) {
        this.isCreateChange = isCreateChange;
    }
}

