/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.interaction.builder.impl;

import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.change.interaction.UserInteractionBase;
import tools.vitruv.change.interaction.UserInteractionListener;
import tools.vitruv.change.interaction.UserInteractionOptions;
import tools.vitruv.change.interaction.builder.InteractionBuilder;
import tools.vitruv.change.interaction.types.BaseInteraction;
import tools.vitruv.change.interaction.types.InteractionFactory;

@Accessors
public abstract class BaseInteractionBuilder<V, I extends BaseInteraction<?>, T extends InteractionBuilder<V, T>>
implements InteractionBuilder<V, T> {
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final InteractionFactory interactionFactory;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private I interactionToBuild;
    @Accessors(value={AccessorType.NONE})
    private Iterable<UserInteractionListener> userInteractionListener;

    public BaseInteractionBuilder(InteractionFactory interactionFactory, Iterable<UserInteractionListener> userInteractionListener) {
        this.interactionFactory = interactionFactory;
        this.userInteractionListener = userInteractionListener;
        this.interactionToBuild = this.createUserInteraction();
    }

    public abstract I createUserInteraction();

    @Override
    public abstract V startInteraction();

    protected abstract T getSelf();

    public void setMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null!");
        }
        ((BaseInteraction)this.interactionToBuild).setMessage(message);
    }

    @Override
    public T title(String title) {
        if (title != null) {
            ((BaseInteraction)this.interactionToBuild).setTitle(title);
        }
        return this.getSelf();
    }

    @Override
    public T windowModality(UserInteractionOptions.WindowModality windowModality) {
        if (windowModality != null) {
            ((BaseInteraction)this.interactionToBuild).setWindowModality(windowModality);
        }
        return this.getSelf();
    }

    @Override
    public T positiveButtonText(String text) {
        if (text != null) {
            ((BaseInteraction)this.interactionToBuild).setPositiveButtonText(text);
        }
        return this.getSelf();
    }

    @Override
    public T negativeButtonText(String text) {
        if (text != null) {
            ((BaseInteraction)this.interactionToBuild).setNegativeButtonText(text);
        }
        return this.getSelf();
    }

    @Override
    public T cancelButtonText(String text) {
        if (text != null) {
            ((BaseInteraction)this.interactionToBuild).setCancelButtonText(text);
        }
        return this.getSelf();
    }

    public void notifyUserInputReceived(UserInteractionBase input) {
        for (UserInteractionListener listener : this.userInteractionListener) {
            listener.onUserInteractionReceived(input);
        }
    }

    @Pure
    protected InteractionFactory getInteractionFactory() {
        return this.interactionFactory;
    }

    @Pure
    protected I getInteractionToBuild() {
        return this.interactionToBuild;
    }
}

