/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.interaction.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import tools.vitruv.change.interaction.ConfirmationUserInteraction;
import tools.vitruv.change.interaction.FreeTextUserInteraction;
import tools.vitruv.change.interaction.MultipleChoiceMultiSelectionUserInteraction;
import tools.vitruv.change.interaction.MultipleChoiceSelectionInteractionBase;
import tools.vitruv.change.interaction.MultipleChoiceSingleSelectionUserInteraction;
import tools.vitruv.change.interaction.UserInteractionBase;

public class PredefinedInteractionMatcher {
    private List<UserInteractionBase> userInteractions = CollectionLiterals.newArrayList();

    public PredefinedInteractionMatcher() {
        ArrayList<UserInteractionBase> _arrayList = new ArrayList<UserInteractionBase>();
        this.userInteractions = _arrayList;
    }

    public void addInteraction(UserInteractionBase interaction) {
        this.userInteractions.add(interaction);
    }

    protected <T extends UserInteractionBase> Iterable<T> getMatchingInput(String message, Class<T> type) {
        if (this.userInteractions == null) {
            return Collections.emptyList();
        }
        Functions.Function1 _function = input -> !input.isSetMessage() || input.getMessage().equals(message);
        Iterable inputToReuse = IterableExtensions.filter((Iterable)Iterables.filter(this.userInteractions, type), (Functions.Function1)_function);
        return inputToReuse;
    }

    protected <T extends MultipleChoiceSelectionInteractionBase> Iterable<T> getMatchingMutltipleChoiceInput(String message, Iterable<String> choices, Class<T> type) {
        if (this.userInteractions == null) {
            return Collections.emptyList();
        }
        Functions.Function1 _function = input -> !input.isSetMessage() || input.getMessage().equals(message) && input.getChoices().containsAll((Collection)IterableExtensions.toList((Iterable)choices));
        Iterable inputToReuse = IterableExtensions.filter((Iterable)Iterables.filter(this.userInteractions, type), (Functions.Function1)_function);
        return inputToReuse;
    }

    public Boolean getNotificationResult(String message) {
        Iterable<ConfirmationUserInteraction> inputToReuseCandidates = this.getMatchingInput(message, ConfirmationUserInteraction.class);
        boolean _isEmpty = IterableExtensions.isEmpty(inputToReuseCandidates);
        if (_isEmpty) {
            return null;
        }
        ConfirmationUserInteraction inputToReuse = (ConfirmationUserInteraction)IterableExtensions.head(inputToReuseCandidates);
        this.userInteractions.remove(inputToReuse);
        return true;
    }

    public Boolean getConfirmationResult(String message) {
        Iterable<ConfirmationUserInteraction> inputToReuseCandidates = this.getMatchingInput(message, ConfirmationUserInteraction.class);
        boolean _isEmpty = IterableExtensions.isEmpty(inputToReuseCandidates);
        if (_isEmpty) {
            return null;
        }
        ConfirmationUserInteraction inputToReuse = (ConfirmationUserInteraction)IterableExtensions.head(inputToReuseCandidates);
        this.userInteractions.remove(inputToReuse);
        return inputToReuse.isConfirmed();
    }

    public String getTextInputResult(String message) {
        Iterable<FreeTextUserInteraction> inputToReuseCandidates = this.getMatchingInput(message, FreeTextUserInteraction.class);
        boolean _isEmpty = IterableExtensions.isEmpty(inputToReuseCandidates);
        if (_isEmpty) {
            return null;
        }
        FreeTextUserInteraction inputToReuse = (FreeTextUserInteraction)IterableExtensions.head(inputToReuseCandidates);
        this.userInteractions.remove(inputToReuse);
        return inputToReuse.getText();
    }

    public Integer getSingleSelectionResult(String message, Iterable<String> choices) {
        Iterable<MultipleChoiceSingleSelectionUserInteraction> inputToReuseCandidates = this.getMatchingMutltipleChoiceInput(message, choices, MultipleChoiceSingleSelectionUserInteraction.class);
        boolean _isEmpty = IterableExtensions.isEmpty(inputToReuseCandidates);
        if (_isEmpty) {
            return null;
        }
        MultipleChoiceSingleSelectionUserInteraction inputToReuse = (MultipleChoiceSingleSelectionUserInteraction)IterableExtensions.head(inputToReuseCandidates);
        this.userInteractions.remove(inputToReuse);
        return inputToReuse.getSelectedIndex();
    }

    public Iterable<Integer> getMultiSelectionResult(String message, Iterable<String> choices) {
        Iterable<MultipleChoiceMultiSelectionUserInteraction> inputToReuseCandidates = this.getMatchingMutltipleChoiceInput(message, choices, MultipleChoiceMultiSelectionUserInteraction.class);
        boolean _isEmpty = IterableExtensions.isEmpty(inputToReuseCandidates);
        if (_isEmpty) {
            return null;
        }
        MultipleChoiceMultiSelectionUserInteraction inputToReuse = (MultipleChoiceMultiSelectionUserInteraction)IterableExtensions.head(inputToReuseCandidates);
        this.userInteractions.remove(inputToReuse);
        return inputToReuse.getSelectedIndices();
    }
}

