/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.interaction.impl;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import tools.vitruv.change.interaction.InteractionResultProvider;
import tools.vitruv.change.interaction.PredefinedInteractionResultProvider;
import tools.vitruv.change.interaction.UserInteractionBase;
import tools.vitruv.change.interaction.UserInteractionOptions;
import tools.vitruv.change.interaction.impl.PredefinedInteractionMatcher;

public class PredefinedInteractionResultProviderImpl
implements PredefinedInteractionResultProvider {
    private final InteractionResultProvider fallback;
    private final PredefinedInteractionMatcher predefinedInteractionMatcher = new PredefinedInteractionMatcher();

    public PredefinedInteractionResultProviderImpl(InteractionResultProvider fallback) {
        this.fallback = fallback;
    }

    @Override
    public void addUserInteractions(UserInteractionBase ... interactions) {
        Consumer<UserInteractionBase> _function = it -> this.predefinedInteractionMatcher.addInteraction((UserInteractionBase)it);
        ((List)Conversions.doWrapArray((Object)interactions)).forEach(_function);
    }

    @Override
    public boolean getConfirmationInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String negativeDecisionText, String cancelDecisionText) {
        Boolean result = this.predefinedInteractionMatcher.getConfirmationResult(message);
        if (result == null && this.fallback != null) {
            result = this.fallback.getConfirmationInteractionResult(windowModality, title, message, positiveDecisionText, negativeDecisionText, cancelDecisionText);
        }
        Functions.Function0 _function = () -> {
            String _printInteraction = this.printInteraction(title, message);
            return "No input given for confirmation:" + _printInteraction;
        };
        return this.ifNullThrow(result, (Functions.Function0<? extends String>)_function);
    }

    @Override
    public void getNotificationInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, UserInteractionOptions.NotificationType notificationType) {
        Boolean result = this.predefinedInteractionMatcher.getNotificationResult(message);
        if (result == null && this.fallback != null) {
            this.fallback.getNotificationInteractionResult(windowModality, title, message, positiveDecisionText, notificationType);
        }
    }

    @Override
    public String getTextInputInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, UserInteractionOptions.InputValidator inputValidator) {
        String _xblockexpression = null;
        String result = this.predefinedInteractionMatcher.getTextInputResult(message);
        if (result == null && this.fallback != null) {
            this.fallback.getTextInputInteractionResult(windowModality, title, message, positiveDecisionText, cancelDecisionText, inputValidator);
        }
        Functions.Function0 _function = () -> {
            String _printInteraction = this.printInteraction(title, message);
            return "No input given for text input: " + _printInteraction;
        };
        _xblockexpression = this.ifNullThrow(result, (Functions.Function0<? extends String>)_function);
        return _xblockexpression;
    }

    @Override
    public int getMultipleChoiceSingleSelectionInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
        Integer result = this.predefinedInteractionMatcher.getSingleSelectionResult(message, choices);
        if (result == null && this.fallback != null) {
            result = this.fallback.getMultipleChoiceSingleSelectionInteractionResult(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
        }
        Functions.Function0 _function = () -> {
            String _printSelection = this.printSelection(title, message, choices);
            return "No input given for single selection:" + _printSelection;
        };
        return this.ifNullThrow(result, (Functions.Function0<? extends String>)_function);
    }

    @Override
    public Iterable<Integer> getMultipleChoiceMultipleSelectionInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
        Iterable<Integer> _xblockexpression = null;
        Iterable<Integer> result = this.predefinedInteractionMatcher.getMultiSelectionResult(message, choices);
        if (result == null && this.fallback != null) {
            result = this.fallback.getMultipleChoiceMultipleSelectionInteractionResult(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
        }
        Functions.Function0 _function = () -> {
            String _printSelection = this.printSelection(title, message, choices);
            return "No input given for multiple selection:" + _printSelection;
        };
        _xblockexpression = this.ifNullThrow(result, (Functions.Function0<? extends String>)_function);
        return _xblockexpression;
    }

    private String printInteraction(String title, String message) {
        String _lineSeparator = System.lineSeparator();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(title);
        _builder.append(": ");
        _builder.append(message);
        return _lineSeparator + String.valueOf(_builder);
    }

    private String printSelection(String title, String message, Iterable<String> choices) {
        String _printInteraction = this.printInteraction(title, message);
        String _lineSeparator = System.lineSeparator();
        String _plus = _printInteraction + _lineSeparator;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String c : choices) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _lineSeparator_1 = System.lineSeparator();
                _builder.appendImmediate((Object)_lineSeparator_1, "");
            }
            _builder.append("  ");
            _builder.append("\u2219");
            _builder.append(" ");
            _builder.append(c);
        }
        return _plus + String.valueOf(_builder);
    }

    private <T> T ifNullThrow(T value, Functions.Function0<? extends String> messageProducer) {
        if (value == null) {
            String _apply = (String)messageProducer.apply();
            throw new IllegalStateException(_apply);
        }
        return value;
    }
}

