/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.interaction.impl;

import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.xbase.lib.Exceptions;
import tools.vitruv.change.interaction.InteractionResultProvider;
import tools.vitruv.change.interaction.UserInteractionOptions;

public class ThinktimeSimulatingInteractionResultProvider
implements InteractionResultProvider {
    private static final Logger logger = LogManager.getLogger(ThinktimeSimulatingInteractionResultProvider.class);
    private final Random random = new Random();
    private final int minWaittime;
    private final int maxWaittime;
    private final int waitTimeRange;
    private final InteractionResultProvider delegate;

    public ThinktimeSimulatingInteractionResultProvider(InteractionResultProvider delegate, int minWaittime, int maxWaittime) {
        if (minWaittime > maxWaittime) {
            throw new RuntimeException("Configure min and max waittime properly: Min" + Integer.valueOf(minWaittime) + " Max: " + Integer.valueOf(maxWaittime));
        }
        this.delegate = delegate;
        this.minWaittime = minWaittime;
        this.maxWaittime = maxWaittime;
        this.waitTimeRange = maxWaittime - minWaittime;
    }

    private void simulateUserThinktime() {
        if (-1 < this.maxWaittime) {
            int _nextInt = this.random.nextInt(this.waitTimeRange + 1);
            int currentWaittime = _nextInt + this.minWaittime;
            try {
                Thread.sleep(currentWaittime);
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)_t;
                    logger.trace("User think time simulation thread interrupted: " + String.valueOf(e), (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Delegate
    private InteractionResultProvider waitAndAccessDelegate() {
        InteractionResultProvider _xblockexpression = null;
        this.simulateUserThinktime();
        _xblockexpression = this.delegate;
        return _xblockexpression;
    }

    @Override
    public boolean getConfirmationInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String negativeDecisionText, String cancelDecisionText) {
        return this.waitAndAccessDelegate().getConfirmationInteractionResult(windowModality, title, message, positiveDecisionText, negativeDecisionText, cancelDecisionText);
    }

    @Override
    public Iterable<Integer> getMultipleChoiceMultipleSelectionInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
        return this.waitAndAccessDelegate().getMultipleChoiceMultipleSelectionInteractionResult(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
    }

    @Override
    public int getMultipleChoiceSingleSelectionInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
        return this.waitAndAccessDelegate().getMultipleChoiceSingleSelectionInteractionResult(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
    }

    @Override
    public void getNotificationInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, UserInteractionOptions.NotificationType notificationType) {
        this.waitAndAccessDelegate().getNotificationInteractionResult(windowModality, title, message, positiveDecisionText, notificationType);
    }

    @Override
    public String getTextInputInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, UserInteractionOptions.InputValidator inputValidator) {
        return this.waitAndAccessDelegate().getTextInputInteractionResult(windowModality, title, message, positiveDecisionText, cancelDecisionText, inputValidator);
    }
}

