/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.interaction.types;

import tools.vitruv.change.interaction.FreeTextUserInteraction;
import tools.vitruv.change.interaction.InteractionFactory;
import tools.vitruv.change.interaction.InteractionResultProvider;
import tools.vitruv.change.interaction.UserInteractionOptions;
import tools.vitruv.change.interaction.types.BaseInteraction;

public class TextInputInteraction
extends BaseInteraction<FreeTextUserInteraction> {
    private static final String DEFAULT_TITLE = "Input Text";
    private static final String DEFAULT_MESSAGE = "";
    private UserInteractionOptions.InputValidator inputValidator;
    private UserInteractionOptions.InputFieldType inputFieldType;
    public static final UserInteractionOptions.InputValidator NUMBERS_ONLY_INPUT_VALIDATOR = new UserInteractionOptions.InputValidator(){

        @Override
        public String getInvalidInputMessage(String input) {
            return "Only numbers are allowed as input";
        }

        @Override
        public boolean isInputValid(String input) {
            return input.matches("[0-9]*");
        }
    };
    public static final UserInteractionOptions.InputValidator ACCEPT_ALL_INPUT_VALIDATOR = new UserInteractionOptions.InputValidator(){

        @Override
        public String getInvalidInputMessage(String input) {
            return TextInputInteraction.DEFAULT_MESSAGE;
        }

        @Override
        public boolean isInputValid(String input) {
            return true;
        }
    };

    protected TextInputInteraction(InteractionResultProvider interactionResultProvider, UserInteractionOptions.WindowModality windowModality, UserInteractionOptions.InputFieldType fieldType, UserInteractionOptions.InputValidator inputValidator) {
        super(interactionResultProvider, windowModality, DEFAULT_TITLE, DEFAULT_MESSAGE);
        this.inputFieldType = fieldType;
        this.inputValidator = inputValidator;
    }

    protected TextInputInteraction(InteractionResultProvider interactionResultProvider, UserInteractionOptions.WindowModality windowModality) {
        this(interactionResultProvider, windowModality, UserInteractionOptions.InputFieldType.SINGLE_LINE, ACCEPT_ALL_INPUT_VALIDATOR);
    }

    public UserInteractionOptions.InputValidator getInputValidator() {
        return this.inputValidator;
    }

    public void setInputValidator(UserInteractionOptions.InputValidator newInputValidator) {
        this.inputValidator = newInputValidator;
    }

    public UserInteractionOptions.InputFieldType getInputFieldType() {
        return this.inputFieldType;
    }

    public void setInputFieldType(UserInteractionOptions.InputFieldType newInputFieldType) {
        this.inputFieldType = newInputFieldType;
    }

    @Override
    public FreeTextUserInteraction startInteraction() {
        String result = this.getInteractionResultProvider().getTextInputInteractionResult(this.getWindowModality(), this.getTitle(), this.getMessage(), this.getPositiveButtonText(), this.getCancelButtonText(), this.inputValidator);
        FreeTextUserInteraction userInput = InteractionFactory.eINSTANCE.createFreeTextUserInteraction();
        userInput.setMessage(this.getMessage());
        userInput.setText(result);
        return userInput;
    }
}

