/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.commons.util.org.eclipse.core.resources;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.activextendannotations.Utility;
import edu.kit.ipd.sdq.commons.util.org.eclipse.core.resources.IPathUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.core.resources.IResourceUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Utility
public final class IProjectUtil {
    private static final Logger LOGGER = Logger.getLogger(IProjectUtil.class);
    public static final Path JAVA_SOURCE_FOLDER = Path.of("src", new String[0]);
    public static final Path JAVA_BIN_FOLDER = Path.of("bin", new String[0]);
    public static final Path SOURCE_GEN_FOLDER = Path.of("src-gen", new String[0]);

    public static IFolder createFolderInProjectIfNecessary(IProject project, String folderName) {
        Functions.Function2 _function = (lastFolder, newPart) -> IResourceUtil.createIfNotExists(lastFolder.getFolder(IPathUtil.getEclipsePath(newPart)));
        IContainer _fold = (IContainer)IterableExtensions.fold((Iterable)Path.of(folderName, new String[0]), (Object)project, (Functions.Function2)_function);
        return (IFolder)_fold;
    }

    public static IProject getWorkspaceProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IProject createProjectAt(String projectName, Path projectLocation) {
        IProject _workspaceProject = IProjectUtil.getWorkspaceProject(projectName);
        Procedures.Procedure1 _function = it -> {
            try {
                boolean _exists = it.exists();
                boolean _not = !_exists;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The project ");
                _builder.append(projectName);
                _builder.append(" already exists!");
                Preconditions.checkState((boolean)_not, (Object)_builder);
                IProjectDescription _newProjectDescription = it.getWorkspace().newProjectDescription(projectName);
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setLocation(IPathUtil.getEclipsePath(projectLocation));
                IProjectDescription _doubleArrow = (IProjectDescription)ObjectExtensions.operator_doubleArrow((Object)_newProjectDescription, (Procedures.Procedure1)_function_1);
                it.create(_doubleArrow, null);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        return (IProject)ObjectExtensions.operator_doubleArrow((Object)_workspaceProject, (Procedures.Procedure1)_function);
    }

    public static IJavaProject configureAsJavaProject(IProject project) {
        try {
            boolean _not;
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            project.open((IProgressMonitor)_nullProgressMonitor);
            IProjectDescription description = project.getDescription();
            String[] currentNatureIds = description.getNatureIds();
            boolean _contains = ArrayExtensions.contains((Object[])description.getNatureIds(), (Object)"org.eclipse.jdt.core.javanature");
            boolean bl = _not = !_contains;
            if (_not) {
                int _length = currentNatureIds.length;
                int _plus = _length + 1;
                String[] newNatureIds = new String[_plus];
                System.arraycopy(currentNatureIds, 0, newNatureIds, 0, currentNatureIds.length);
                newNatureIds[currentNatureIds.length] = "org.eclipse.jdt.core.javanature";
                description.setNatureIds(newNatureIds);
                project.setDescription(description, null);
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IFolder binFolder = IResourceUtil.createIfNotExists(project.getFolder(IPathUtil.getEclipsePath(JAVA_BIN_FOLDER)));
            javaProject.setOutputLocation(binFolder.getFullPath(), null);
            Functions.Function1 _function = it -> it.getEntryKind() != 3 || !Objects.equal((Object)it.getPath(), (Object)project.getFullPath());
            Set newClasspath = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)javaProject.getRawClasspath())), (Functions.Function1)_function));
            IClasspathEntry[] _defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
            Iterables.addAll((Collection)newClasspath, (Iterable)((Iterable)Conversions.doWrapArray((Object)_defaultJRELibrary)));
            IFolder sourceFolder = IResourceUtil.createIfNotExists(project.getFolder(IPathUtil.getEclipsePath(JAVA_SOURCE_FOLDER)));
            IClasspathEntry _newSourceEntry = JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath());
            newClasspath.add(_newSourceEntry);
            javaProject.setRawClasspath((IClasspathEntry[])Conversions.unwrapArray((Object)newClasspath, IClasspathEntry.class), null);
            return javaProject;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static IJavaProject configureSrcGenFolder(IJavaProject javaProject) {
        try {
            boolean _not;
            IFolder srcGenFolder = IResourceUtil.createIfNotExists(javaProject.getProject().getFolder(IPathUtil.getEclipsePath(SOURCE_GEN_FOLDER)));
            IClasspathEntry[] oldClasspath = javaProject.getRawClasspath();
            Functions.Function1 _function = it -> it.getEntryKind() != 3 || !Objects.equal((Object)it.getPath(), (Object)srcGenFolder.getFullPath());
            boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)oldClasspath)), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                IClasspathEntry srcGenEntry;
                int _length = oldClasspath.length;
                int _plus = _length + 1;
                IClasspathEntry[] newClasspath = new IClasspathEntry[_plus];
                System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
                IClasspathAttribute _newClasspathAttribute = JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)"true");
                newClasspath[oldClasspath.length] = srcGenEntry = JavaCore.newSourceEntry((IPath)srcGenFolder.getFullPath(), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IClasspathAttribute[])new IClasspathAttribute[]{_newClasspathAttribute});
                javaProject.setRawClasspath(newClasspath, null);
            }
            return javaProject;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean createJavaProject(IProject project) {
        boolean _exists = project.exists();
        boolean _not = !_exists;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The project ");
        String _name = project.getName();
        _builder.append(_name);
        _builder.append(" already exists!");
        Preconditions.checkState((boolean)_not, (Object)_builder);
        try {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            project.create((IProgressMonitor)_nullProgressMonitor);
            IProjectUtil.configureAsJavaProject(project);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return true;
    }

    public static boolean createJavaProject(String projectName) {
        return IProjectUtil.createJavaProject(IProjectUtil.getWorkspaceProject(projectName));
    }

    public static void buildAllProjectsIncrementally(String builderId) throws IllegalStateException {
        IProject[] _projects;
        IProject[] iProjectArray = _projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = _projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && IProjectUtil.hasBuilder(project, builderId)) {
                IProjectUtil.buildIncrementally(project, builderId);
            }
            ++n2;
        }
    }

    public static void buildIncrementally(IProject project, String builderId) throws IllegalStateException {
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"project must not be null");
        Preconditions.checkState((boolean)project.isOpen(), (String)"project %s must be open to built", (Object)project.getName());
        boolean _isDebugEnabled = LOGGER.isDebugEnabled();
        if (_isDebugEnabled) {
            String _name = project.getName();
            String _plus = "Run builder " + builderId + " for project " + _name;
            LOGGER.debug((Object)_plus);
        }
        try {
            project.build(10, builderId, null, null);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                String _name_1 = project.getName();
                String message = "Could not run builder " + builderId + " for project " + _name_1;
                LOGGER.error((Object)message, (Throwable)e);
                throw new IllegalStateException(message, (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void refreshAndBuildIncrementally(IProject project) {
        CoreException e;
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"project must not be null");
        Preconditions.checkState((boolean)project.isOpen(), (String)"project %s must be open to be refreshed and built", (Object)project.getName());
        boolean _isDebugEnabled = LOGGER.isDebugEnabled();
        if (_isDebugEnabled) {
            String _name = project.getName();
            String _plus = "Refresh and build project " + _name;
            LOGGER.debug((Object)_plus);
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                e = (CoreException)_t;
                String _name_1 = project.getName();
                String message = "Could not refresh project " + _name_1;
                LOGGER.error((Object)message, (Throwable)e);
                throw new IllegalStateException(message, (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            project.build(10, null);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                e = (CoreException)_t;
                String _name_1 = project.getName();
                String message = "Could not build project " + _name_1;
                LOGGER.error((Object)message, (Throwable)e);
                throw new IllegalStateException(message, (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBuilder(IProject project, String builderId) {
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"project must not be null");
        Preconditions.checkState((boolean)project.isOpen(), (String)"project %s must be open", (Object)project.getName());
        try {
            ICommand[] _buildSpec;
            ICommand[] iCommandArray = _buildSpec = project.getDescription().getBuildSpec();
            int n = _buildSpec.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand buildSpec = iCommandArray[n2];
                String _builderName = buildSpec.getBuilderName();
                boolean _equals = Objects.equal((Object)builderId, (Object)_builderName);
                if (_equals) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable _t) {
            if (!(_t instanceof CoreException)) throw Exceptions.sneakyThrow((Throwable)_t);
            CoreException e = (CoreException)_t;
            String _name = project.getName();
            String message = "Could not read description of project " + _name;
            LOGGER.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, (Throwable)e);
        }
    }

    private IProjectUtil() {
    }
}

