/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore;

import edu.kit.ipd.sdq.activextendannotations.Utility;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Utility
public final class EObjectUtil {
    public static List<?> getFeatureValues(EObject eObject, String featureName) {
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureName);
        return EObjectUtil.getFeatureValues(eObject, feature);
    }

    public static List<?> getFeatureValues(EObject eObject, EStructuralFeature feature) {
        Object newValue;
        Object _eGet = null;
        if (eObject != null) {
            _eGet = eObject.eGet(feature);
        }
        if ((newValue = _eGet) == null || !feature.isMany()) {
            return null;
        }
        if (newValue instanceof List) {
            return (List)newValue;
        }
        throw new IllegalStateException("The value '" + newValue + "' for the multi-valued feature '" + feature + "' of the EObject '" + eObject + "' has to be a list!");
    }

    public static Object getFeatureValue(EObject eObject, EStructuralFeature feature) {
        Object newValue;
        Object _eGet = null;
        if (eObject != null) {
            _eGet = eObject.eGet(feature);
        }
        if ((newValue = _eGet) == null || feature.isMany()) {
            return null;
        }
        if (!(newValue instanceof List)) {
            return newValue;
        }
        throw new IllegalStateException("The value '" + newValue + "' for the not multi-valued feature '" + feature + "' of the EObject '" + eObject + "' has to be a list!");
    }

    public static EList<?> getValueList(EObject eObject, EStructuralFeature feature) {
        Object value = eObject.eGet(feature);
        if (feature.isMany() && value != null) {
            return (EList)value;
        }
        if (value == null) {
            return new BasicEList();
        }
        return new BasicEList(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{value})));
    }

    public static Iterable<EObject> getAllContents(EObject eObject) {
        TreeIterator _eAllContents = null;
        if (eObject != null) {
            _eAllContents = eObject.eAllContents();
        }
        Iterable _iterable = null;
        if (_eAllContents != null) {
            _iterable = IteratorExtensions.toIterable((Iterator)_eAllContents);
        }
        return _iterable;
    }

    @Deprecated
    public static Iterable<EObject> getAllContents(Resource resource) {
        return IteratorExtensions.toIterable((Iterator)resource.getAllContents());
    }

    public static EAttribute getAttributeByName(EObject eObject, String attributeName) {
        Functions.Function1 _function = attribute -> attribute.getName().equals(attributeName);
        return (EAttribute)IterableExtensions.filter((Iterable)eObject.eClass().getEAllAttributes(), (Functions.Function1)_function).iterator().next();
    }

    public static EReference getReferenceByName(EObject eObject, String referenceName) {
        Functions.Function1 _function = reference -> reference.getName().equals(referenceName);
        return (EReference)IterableExtensions.filter((Iterable)eObject.eClass().getEAllReferences(), (Functions.Function1)_function).iterator().next();
    }

    private EObjectUtil() {
    }
}

