/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.activextendannotations.Utility;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Utility
public final class ResourceCopier {
    public static boolean requiresFullCopy(Resource resource) {
        return ResourceCopier.isWritableUmlResource(resource);
    }

    public static Map<Resource, Resource> copyViewSourceResources(Iterable<Resource> originalResources, ResourceSet newResourceSet, Functions.Function1<? super EObject, ? extends Boolean> rootElementPredicate) {
        return ResourceCopier.copyResources(originalResources, newResourceSet, false, rootElementPredicate);
    }

    public static Map<Resource, Resource> copyViewResources(Iterable<Resource> originalResources, ResourceSet newResourceSet) {
        Functions.Function1 _function = it -> true;
        return ResourceCopier.copyResources(originalResources, newResourceSet, true, (Functions.Function1<? super EObject, ? extends Boolean>)_function);
    }

    public static Resource copyViewResource(Resource originalResource, ResourceSet newResourceSet) {
        Map<Resource, Resource> mapping = ResourceCopier.copyViewResources(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Resource[]{originalResource})), newResourceSet);
        return mapping.get(originalResource);
    }

    private static Map<Resource, Resource> copyResources(Iterable<Resource> originalResources, ResourceSet newResourceSet, Boolean copyXmlIds, Functions.Function1<? super EObject, ? extends Boolean> rootElementPredicate) {
        HashMap<Resource, Resource> resourceMapping = new HashMap<Resource, Resource>();
        Functions.Function1 _function = it -> ResourceCopier.isWritableUmlResource(it);
        List _list = IterableExtensions.toList((Iterable)IterableExtensions.filter(originalResources, (Functions.Function1)_function));
        for (Resource umlResource : _list) {
            Resource copy = ResourceCopier.copyUmlResource(umlResource, newResourceSet);
            if (copyXmlIds.booleanValue() && umlResource instanceof XMLResource && copy instanceof XMLResource) {
                ResourceCopier.copyUmlIds((XMLResource)umlResource, (XMLResource)copy);
            }
            resourceMapping.put(umlResource, copy);
        }
        Functions.Function1 _function_1 = it -> {
            boolean _isWritableUmlResource = ResourceCopier.isWritableUmlResource(it);
            return !_isWritableUmlResource;
        };
        Map<Resource, Resource> otherMapping = ResourceCopier.copyResourcesInternal(IterableExtensions.toList((Iterable)IterableExtensions.filter(originalResources, (Functions.Function1)_function_1)), newResourceSet, copyXmlIds, rootElementPredicate);
        Consumer<Resource> _function_2 = it -> resourceMapping.put((Resource)it, (Resource)otherMapping.get(it));
        otherMapping.keySet().forEach(_function_2);
        return resourceMapping;
    }

    private static Resource copyUmlResource(Resource originalResource, ResourceSet newResourceSet) {
        try {
            URI originalURI = originalResource.getURI();
            String _fileExtension = originalURI.fileExtension();
            String _plus = "." + _fileExtension;
            Path tempFilePath = Files.createTempFile(null, _plus, new FileAttribute[0]);
            URI tempURI = URI.createFileURI((String)tempFilePath.toString());
            originalResource.setURI(tempURI);
            originalResource.save(null);
            originalResource.setURI(originalURI);
            Resource copiedResource = newResourceSet.getResource(tempURI, true);
            copiedResource.setURI(originalURI);
            Files.delete(tempFilePath);
            EcoreUtil.resolveAll((Resource)copiedResource);
            return copiedResource;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static Map<Resource, Resource> copyResourcesInternal(Iterable<Resource> originalResources, ResourceSet newResourceSet, Boolean copyXmlIds, Functions.Function1<? super EObject, ? extends Boolean> rootElementPredicate) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true);
        HashMap<Resource, Resource> resourceMapping = new HashMap<Resource, Resource>();
        for (Resource originalResource : originalResources) {
            Functions.Function1 _function = it -> {
                boolean _isContainedInOtherThanOwnResource = ResourceCopier.isContainedInOtherThanOwnResource(it, originalResources);
                return !_isContainedInOtherThanOwnResource;
            };
            List elementsContainedInResource = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)originalResource.getContents(), (Functions.Function1)_function));
            copier.copyAll((Collection)elementsContainedInResource);
        }
        copier.copyReferences();
        for (Resource originalResource_1 : originalResources) {
            Resource.Factory.Registry _resourceFactoryRegistry = newResourceSet.getResourceFactoryRegistry();
            Resource.Factory _factory = null;
            if (_resourceFactoryRegistry != null) {
                _factory = _resourceFactoryRegistry.getFactory(originalResource_1.getURI());
            }
            Resource _createResource = null;
            if (_factory != null) {
                _createResource = _factory.createResource(originalResource_1.getURI());
            }
            Resource copiedResource = (Resource)Preconditions.checkNotNull((Object)_createResource, (String)"Cannot create resource copy: %s", (Object)originalResource_1.getURI());
            Functions.Function1 _function = it -> (Boolean)rootElementPredicate.apply(it);
            Iterable selectedRootElements = IterableExtensions.filter((Iterable)originalResource_1.getContents(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> (EObject)Preconditions.checkNotNull((Object)((EObject)copier.get(it)), (String)"corresponding object for %s is null", (Object)it);
            Iterable mappedRootElements = IterableExtensions.map((Iterable)selectedRootElements, (Functions.Function1)_function_1);
            Iterables.addAll((Collection)copiedResource.getContents(), (Iterable)mappedRootElements);
            EList _resources = newResourceSet.getResources();
            _resources.add((Object)copiedResource);
            resourceMapping.put(originalResource_1, copiedResource);
        }
        if (copyXmlIds.booleanValue()) {
            Set _entrySet = copier.entrySet();
            for (Map.Entry entry : _entrySet) {
                EObject sourceElement = (EObject)entry.getKey();
                EObject targetElement = (EObject)entry.getValue();
                if (!(sourceElement.eResource() instanceof XMLResource) || !(targetElement.eResource() instanceof XMLResource)) continue;
                Resource _eResource = sourceElement.eResource();
                String id = ((XMLResource)_eResource).getID(sourceElement);
                Resource _eResource_1 = targetElement.eResource();
                ((XMLResource)_eResource_1).setID(targetElement, id);
            }
        }
        return resourceMapping;
    }

    private static boolean isContainedInOtherThanOwnResource(EObject eObject, Iterable<Resource> resources) {
        Resource rootContainerResource = EcoreUtil.getRootContainer((EObject)eObject).eResource();
        return rootContainerResource != eObject.eResource() && IterableExtensions.contains(resources, (Object)rootContainerResource);
    }

    private static boolean isWritableUmlResource(Resource resource) {
        return Objects.equal((Object)resource.getURI().fileExtension(), (Object)"uml") && !URIUtil.isPathmap(resource.getURI());
    }

    private static void copyUmlIds(XMLResource source, XMLResource target) {
        TreeIterator sourceIterator = source.getAllContents();
        TreeIterator targetIterator = target.getAllContents();
        while (sourceIterator.hasNext() && targetIterator.hasNext()) {
            EClass _eClass_1;
            EObject sourceObject = (EObject)sourceIterator.next();
            EObject targetObject = (EObject)targetIterator.next();
            EClass _eClass = sourceObject.eClass();
            boolean _tripleEquals = _eClass == (_eClass_1 = targetObject.eClass());
            Preconditions.checkState((boolean)_tripleEquals, (String)"non matching elements %s and %s", (Object)sourceObject, (Object)targetObject);
            target.setID(targetObject, source.getID(sourceObject));
        }
        boolean _hasNext = sourceIterator.hasNext();
        boolean _not = !_hasNext;
        Preconditions.checkState((boolean)_not, (Object)"source uml resource has too many elements");
        boolean _hasNext_1 = targetIterator.hasNext();
        boolean _not_1 = !_hasNext_1;
        Preconditions.checkState((boolean)_not_1, (Object)"target uml resource has too many elements");
    }

    private ResourceCopier() {
    }
}

