/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.commons.util.java.lang;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.activextendannotations.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Utility
public final class IterableUtil {
    public static final <T, R> List<R> mapFixed(Iterable<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        ArrayList _xblockexpression = null;
        ArrayList _xifexpression = null;
        if (original instanceof Collection) {
            int _size = ((Collection)original).size();
            _xifexpression = new ArrayList(_size);
        } else {
            _xifexpression = new ArrayList();
        }
        ArrayList target = _xifexpression;
        _xblockexpression = IterableUtil.mapFixedTo(original, target, transformation);
        return _xblockexpression;
    }

    public static final <T, R> List<R> mapFixed(Collection<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        int _size = original.size();
        ArrayList _arrayList = new ArrayList(_size);
        return IterableUtil.mapFixedTo(original, _arrayList, transformation);
    }

    public static final <T, R, C extends Collection<R>> C mapFixedTo(Iterable<T> original, C target, Functions.Function1<? super T, ? extends R> transformation) {
        for (T o : original) {
            target.add((Object)transformation.apply(o));
        }
        return target;
    }

    public static final <T, R> List<R> flatMapFixed(Iterable<T> original, Functions.Function1<? super T, ? extends Iterable<? extends R>> transformation) {
        ArrayList _arrayList = new ArrayList();
        return IterableUtil.flatMapFixedTo(original, _arrayList, transformation);
    }

    public static final <T, R, C extends Collection<R>> C flatMapFixedTo(Iterable<T> original, C target, Functions.Function1<? super T, ? extends Iterable<? extends R>> transformation) {
        for (T o : original) {
            Iterables.addAll(target, (Iterable)((Iterable)transformation.apply(o)));
        }
        return target;
    }

    public static final <T, R> List<R> mapFixedIndexed(Iterable<T> original, Functions.Function2<? super Integer, ? super T, ? extends R> transformation) {
        ArrayList _xblockexpression = null;
        ArrayList _xifexpression = null;
        if (original instanceof Collection) {
            int _size = ((Collection)original).size();
            _xifexpression = new ArrayList(_size);
        } else {
            _xifexpression = new ArrayList();
        }
        ArrayList target = _xifexpression;
        _xblockexpression = IterableUtil.mapFixedIndexedTo(original, target, transformation);
        return _xblockexpression;
    }

    public static final <T, R> List<R> mapFixedIndexed(Collection<T> original, Functions.Function2<? super Integer, ? super T, ? extends R> transformation) {
        int _size = original.size();
        ArrayList _arrayList = new ArrayList(_size);
        return IterableUtil.mapFixedIndexedTo(original, _arrayList, transformation);
    }

    public static final <T, R, C extends Collection<R>> C mapFixedIndexedTo(Iterable<T> original, C target, Functions.Function2<? super Integer, ? super T, ? extends R> transformation) {
        boolean _hasNext;
        int i = 0;
        Iterator<T> iterator = original.iterator();
        boolean _while = _hasNext = iterator.hasNext();
        while (_while) {
            boolean _hasNext_1;
            target.add((Object)transformation.apply((Object)i, iterator.next()));
            int _i = i;
            i = _i + 1;
            _while = _hasNext_1 = iterator.hasNext();
        }
        return target;
    }

    public static final <T, R> List<R> flatMapFixedIndexed(Iterable<T> original, Functions.Function2<? super Integer, ? super T, ? extends Iterable<? extends R>> transformation) {
        ArrayList _arrayList = new ArrayList();
        return IterableUtil.flatMapFixedIndexedTo(original, _arrayList, transformation);
    }

    public static final <T, R, C extends Collection<R>> C flatMapFixedIndexedTo(Iterable<T> original, C target, Functions.Function2<? super Integer, ? super T, ? extends Iterable<? extends R>> transformation) {
        boolean _hasNext;
        int i = 0;
        Iterator<T> iterator = original.iterator();
        boolean _while = _hasNext = iterator.hasNext();
        while (_while) {
            boolean _hasNext_1;
            Iterables.addAll(target, (Iterable)((Iterable)transformation.apply((Object)i, iterator.next())));
            int _i = i;
            i = _i + 1;
            _while = _hasNext_1 = iterator.hasNext();
        }
        return target;
    }

    public static final String join(Iterable<? extends CharSequence> iterable, CharSequence before, CharSequence separator, CharSequence after) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (CharSequence charSequence : iterable) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append((Object)before);
            } else {
                _builder.appendImmediate((Object)separator, "");
            }
            _builder.append((Object)charSequence);
        }
        if (_hasElements) {
            _builder.append((Object)after);
        }
        return _builder.toString();
    }

    public static <T> int count(Iterable<T> coll, T element) {
        int count = 0;
        for (T pivot : coll) {
            boolean _equals = Objects.equal(pivot, element);
            if (!_equals) continue;
            ++count;
        }
        return count;
    }

    public static final <A extends Iterable<T>, T> T claimOne(A iterable) {
        Iterator<T> iterator = iterable.iterator();
        boolean _hasNext = iterator.hasNext();
        if (_hasNext) {
            boolean _not;
            T one = iterator.next();
            boolean _hasNext_1 = iterator.hasNext();
            boolean bl = _not = !_hasNext_1;
            if (_not) {
                return one;
            }
        }
        throw new IllegalStateException("It was claimed that the collection '" + iterable + "' contains exactly one element!");
    }

    public static final <A extends Iterable<?>> A claimNotEmpty(A iterable) {
        boolean _equals;
        int _size = IterableExtensions.size(iterable);
        boolean bl = _equals = _size == 0;
        if (_equals) {
            throw new IllegalStateException("It was claimed that the collection '" + iterable + "' is not empty!");
        }
        return iterable;
    }

    public static final <A extends Iterable<T>, T> T claimNotMany(A c) {
        int size = IterableExtensions.size(c);
        if (size > 1) {
            throw new IllegalStateException("It was claimed that the collection '" + c + "' contains exactly one element!");
        }
        if (size == 1) {
            return c.iterator().next();
        }
        return null;
    }

    public static <T> boolean containsAny(Iterable<T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            boolean _test = predicate.test(t);
            if (!_test) continue;
            return true;
        }
        return false;
    }

    public static <A, B> Map<A, B> indexedBy(Iterable<B> iterable, Functions.Function1<? super B, ? extends A> indexer) {
        HashMap<Object, B> _xifexpression = null;
        if (iterable instanceof Collection) {
            int _size = ((Collection)iterable).size();
            _xifexpression = new HashMap(_size);
        } else {
            _xifexpression = new HashMap<Object, B>();
        }
        HashMap<Object, B> result = _xifexpression;
        for (B b : iterable) {
            result.put(indexer.apply(b), b);
        }
        return result;
    }

    private IterableUtil() {
    }
}

