/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.commons.util.java.lang;

import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.activextendannotations.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Utility
public final class MapUtil {
    public static final <K, V, C extends Collection<V>> C add(Map<K, C> map, K key, V value, Functions.Function0<? extends C> constructor) {
        Collection newCollection = (Collection)constructor.apply();
        newCollection.add(value);
        return MapUtil.addAll(map, key, newCollection, constructor);
    }

    public static final <K, V, C extends Collection<V>> C addAll(Map<K, C> map, K key, C values, Functions.Function0<? extends C> constructor) {
        Collection mappedValueCollection = (Collection)map.get(key);
        if (mappedValueCollection == null) {
            mappedValueCollection = (Collection)constructor.apply();
            map.put(key, mappedValueCollection);
        }
        mappedValueCollection.addAll(values);
        return (C)mappedValueCollection;
    }

    public static final <K, C extends Collection<?>> boolean onlyEmptyCollectionsMapped(Map<K, C> map) {
        Collection<C> _values = null;
        if (map != null) {
            _values = map.values();
        }
        Iterable _flatten = null;
        if (_values != null) {
            _flatten = Iterables.concat(_values);
        }
        return IterableExtensions.isEmpty(_flatten);
    }

    public static final <K, V, C extends Collection<V>> boolean containsAll(Map<K, C> map1, Map<K, C> map2) {
        List _mapFixed = null;
        if (map2 != null) {
            Functions.Function2 _function = (key, value) -> MapUtil.containsAll(map1, key, value);
            _mapFixed = MapUtil.mapFixed(map2, _function);
        }
        Functions.Function1 _function_1 = it -> (boolean)it;
        return IterableExtensions.forall(_mapFixed, (Functions.Function1)_function_1);
    }

    public static final <K, V, C extends Collection<V>> boolean containsAll(Map<K, C> map, K key, C values) {
        boolean _tripleEquals;
        if (map == null) {
            return false;
        }
        Collection _get = (Collection)map.get(key);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            return false;
        }
        return ((Collection)map.get(key)).containsAll(values);
    }

    public static final <K, V, R> List<R> mapFixed(Map<K, V> map, Functions.Function2<? super K, ? super V, ? extends R> transformation) {
        int _size = map.entrySet().size();
        ArrayList<Object> list = new ArrayList<Object>(_size);
        Set<Map.Entry<K, V>> _entrySet = map.entrySet();
        for (Map.Entry<K, V> mapEntry : _entrySet) {
            list.add(transformation.apply(mapEntry.getKey(), mapEntry.getValue()));
        }
        return list;
    }

    private MapUtil() {
    }
}

