/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.propagation.impl;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import tools.vitruv.change.composite.MetamodelDescriptor;
import tools.vitruv.change.interaction.UserInteractor;
import tools.vitruv.change.propagation.ChangePropagationObserver;
import tools.vitruv.change.propagation.ChangePropagationSpecification;

public abstract class AbstractChangePropagationSpecification
implements ChangePropagationSpecification {
    private final List<ChangePropagationObserver> propagationObservers;
    private UserInteractor userInteractor;
    private MetamodelDescriptor sourceMetamodelDescriptor;
    private MetamodelDescriptor targetMetamodelDescriptor;

    public AbstractChangePropagationSpecification(MetamodelDescriptor sourceMetamodelDescriptor, MetamodelDescriptor targetMetamodelDescriptor) {
        this.sourceMetamodelDescriptor = sourceMetamodelDescriptor;
        this.targetMetamodelDescriptor = targetMetamodelDescriptor;
        this.propagationObservers = CollectionLiterals.newArrayList();
    }

    protected UserInteractor getUserInteractor() {
        return this.userInteractor;
    }

    @Override
    public MetamodelDescriptor getSourceMetamodelDescriptor() {
        return this.sourceMetamodelDescriptor;
    }

    @Override
    public MetamodelDescriptor getTargetMetamodelDescriptor() {
        return this.targetMetamodelDescriptor;
    }

    @Override
    public void setUserInteractor(UserInteractor userInteractor) {
        this.userInteractor = userInteractor;
    }

    @Override
    public void registerObserver(ChangePropagationObserver observer) {
        if (observer != null) {
            this.propagationObservers.add(observer);
        }
    }

    @Override
    public void deregisterObserver(ChangePropagationObserver observer) {
        this.propagationObservers.remove(observer);
    }

    @Override
    public void notifyObjectCreated(EObject createdObject) {
        Consumer<ChangePropagationObserver> _function = it -> it.objectCreated(createdObject);
        this.propagationObservers.forEach(_function);
    }
}

