/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.propagation.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.composite.MetamodelDescriptor;
import tools.vitruv.change.composite.description.CompositeChange;
import tools.vitruv.change.composite.description.CompositeContainerChange;
import tools.vitruv.change.composite.description.PropagatedChange;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeFactory;
import tools.vitruv.change.interaction.InternalUserInteractor;
import tools.vitruv.change.interaction.UserInteractionBase;
import tools.vitruv.change.interaction.UserInteractionFactory;
import tools.vitruv.change.interaction.UserInteractionListener;
import tools.vitruv.change.interaction.UserInteractor;
import tools.vitruv.change.propagation.ChangePropagationMode;
import tools.vitruv.change.propagation.ChangePropagationObserver;
import tools.vitruv.change.propagation.ChangePropagationSpecification;
import tools.vitruv.change.propagation.ChangePropagationSpecificationProvider;
import tools.vitruv.change.propagation.ChangeRecordingModelRepository;

public class ChangePropagator {
    private static final Logger logger = LogManager.getLogger(ChangePropagator.class);
    private final ChangeRecordingModelRepository modelRepository;
    private final ChangePropagationSpecificationProvider changePropagationProvider;
    private final InternalUserInteractor userInteractor;
    private final ChangePropagationMode changePropagationMode;

    public ChangePropagator(ChangeRecordingModelRepository modelRepository, ChangePropagationSpecificationProvider changePropagationProvider, InternalUserInteractor userInteractor) {
        this(modelRepository, changePropagationProvider, userInteractor, ChangePropagationMode.TRANSITIVE_CYCLIC);
    }

    public ChangePropagator(ChangeRecordingModelRepository modelRepository, ChangePropagationSpecificationProvider changePropagationProvider, InternalUserInteractor userInteractor, ChangePropagationMode mode) {
        this.modelRepository = modelRepository;
        this.changePropagationProvider = changePropagationProvider;
        this.userInteractor = userInteractor;
        this.changePropagationMode = mode;
    }

    public List<PropagatedChange> propagateChange(VitruviusChange<Uuid> change) {
        VitruviusChange<EObject> resolvedChange = this.modelRepository.applyChange(change);
        Functions.Function1 _function = it -> it.eResource();
        Consumer<Resource> _function_1 = it -> it.setModified(true);
        IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)resolvedChange.getAffectedEObjects(), (Functions.Function1)_function)).forEach(_function_1);
        boolean _isTraceEnabled = logger.isTraceEnabled();
        if (_isTraceEnabled) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Will now propagate this input change:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(resolvedChange, "\t");
            _builder.newLineIfNotEmpty();
            logger.trace((CharSequence)_builder);
        }
        return new ChangePropagation(this, resolvedChange, null).propagateChanges();
    }

    private Iterable<TransactionalChange<EObject>> getTransactionalChangeSequence(VitruviusChange<EObject> change) {
        boolean _not;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        boolean _containsConcreteChange = change.containsConcreteChange();
        boolean bl = _not = !_containsConcreteChange;
        if (_not) {
            _matched = true;
            _switchResult = CollectionLiterals.emptyList();
        }
        if (!_matched && change instanceof TransactionalChange) {
            _matched = true;
            _switchResult = List.of((TransactionalChange)change);
        }
        if (!_matched && change instanceof CompositeChange) {
            _matched = true;
            Functions.Function1 _function = it -> this.getTransactionalChangeSequence((VitruviusChange<EObject>)it);
            _switchResult = IterableExtensions.flatMap((Iterable)((CompositeChange)change).getChanges(), (Functions.Function1)_function);
        }
        if (!_matched) {
            String _simpleName = change.getClass().getSimpleName();
            String _plus = "Unexpected change type: " + _simpleName;
            throw new IllegalStateException(_plus);
        }
        return _switchResult;
    }

    @FinalFieldsConstructor
    private static class ChangePropagation
    implements ChangePropagationObserver,
    UserInteractionListener {
        @Extension
        private final ChangePropagator outer;
        private final VitruviusChange<EObject> sourceChange;
        private final ChangePropagation previous;
        private final Set<Resource> changedResources = new HashSet<Resource>();
        private final List<EObject> createdObjects = new ArrayList<EObject>();
        private final List<UserInteractionBase> userInteractions = new ArrayList<UserInteractionBase>();

        private List<PropagatedChange> propagateChanges() {
            Functions.Function1 _function = it -> this.propagateSingleChange((TransactionalChange<EObject>)it);
            List result = IterableUtil.flatMapFixed(this.outer.getTransactionalChangeSequence(this.sourceChange), (Functions.Function1)_function);
            this.handleObjectsWithoutResource();
            Consumer<Resource> _function_1 = it -> it.setModified(true);
            this.changedResources.forEach(_function_1);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PropagatedChange> propagateSingleChange(TransactionalChange<EObject> change) {
            try {
                boolean _notEquals;
                boolean _isTraceEnabled;
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)change.getAffectedEObjects());
                boolean _not = !_isNullOrEmpty;
                Preconditions.checkState((boolean)_not, (String)"There are no objects affected by this change:%s%s", (Object)System.lineSeparator(), change);
                AutoCloseable userInteractorChange = this.installUserInteractorForChange((VitruviusChange<EObject>)change);
                Consumer<ChangePropagationSpecification> _function = it -> it.registerObserver(this);
                this.outer.changePropagationProvider.forEach(_function);
                this.outer.userInteractor.registerUserInputListener((UserInteractionListener)this);
                List _xtrycatchfinallyexpression = null;
                try {
                    Functions.Function1 _function_1 = it -> {
                        List<ChangePropagationSpecification> _changePropagationSpecifications = this.outer.changePropagationProvider.getChangePropagationSpecifications((MetamodelDescriptor)it);
                        Procedures.Procedure1 _function_2 = it_1 -> {
                            Consumer<ChangePropagationSpecification> _function_3 = it_2 -> it_2.setUserInteractor((UserInteractor)this.outer.userInteractor);
                            it_1.forEach(_function_3);
                        };
                        return (List)ObjectExtensions.operator_doubleArrow(_changePropagationSpecifications, (Procedures.Procedure1)_function_2);
                    };
                    Functions.Function1 _function_2 = it -> this.propagateChangeForChangePropagationSpecification(change, (ChangePropagationSpecification)it);
                    _xtrycatchfinallyexpression = IterableUtil.flatMapFixed((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)this.sourceChange.getAffectedEObjectsMetamodelDescriptors(), (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
                }
                finally {
                    this.outer.userInteractor.deregisterUserInputListener((UserInteractionListener)this);
                    Consumer<ChangePropagationSpecification> _function_3 = it -> it.deregisterObserver(this);
                    this.outer.changePropagationProvider.forEach(_function_3);
                    userInteractorChange.close();
                }
                List propagationResultChanges = _xtrycatchfinallyexpression;
                boolean _isDebugEnabled = logger.isDebugEnabled();
                if (_isDebugEnabled) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Propagated ");
                    Iterable<String> _propagationPath = this.getPropagationPath();
                    boolean _hasElements = false;
                    for (String p : _propagationPath) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" -> ", "");
                        }
                        _builder.append(p);
                    }
                    _builder.append(" -> {");
                    boolean _hasElements_1 = false;
                    for (TransactionalChange changeInPropagation : propagationResultChanges) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        Set _affectedEObjectsMetamodelDescriptors = changeInPropagation.getAffectedEObjectsMetamodelDescriptors();
                        _builder.append((Object)_affectedEObjectsMetamodelDescriptors);
                    }
                    _builder.append("}");
                    logger.debug((CharSequence)_builder);
                }
                if (_isTraceEnabled = logger.isTraceEnabled()) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Result changes:");
                    _builder_1.newLine();
                    for (TransactionalChange result : propagationResultChanges) {
                        _builder_1.append("\t");
                        Set _affectedEObjectsMetamodelDescriptors_1 = result.getAffectedEObjectsMetamodelDescriptors();
                        _builder_1.append((Object)_affectedEObjectsMetamodelDescriptors_1, "\t");
                        _builder_1.append(": ");
                        _builder_1.append((Object)result, "\t");
                        _builder_1.newLineIfNotEmpty();
                    }
                    logger.trace((CharSequence)_builder_1);
                }
                change.setUserInteractions(this.userInteractions);
                CompositeContainerChange _createCompositeChange = VitruviusChangeFactory.getInstance().createCompositeChange((Iterable)propagationResultChanges);
                PropagatedChange propagatedChange = new PropagatedChange(change, (VitruviusChange)_createCompositeChange);
                ArrayList<PropagatedChange> resultingChanges = new ArrayList<PropagatedChange>();
                resultingChanges.add(propagatedChange);
                boolean bl = _notEquals = !Objects.equals((Object)this.outer.changePropagationMode, (Object)ChangePropagationMode.SINGLE_STEP);
                if (_notEquals) {
                    Functions.Function1 _function_1 = it -> it.containsConcreteChange();
                    Iterable<PropagatedChange> _propagateTransitiveChanges = this.propagateTransitiveChanges(IterableExtensions.filter((Iterable)propagationResultChanges, (Functions.Function1)_function_1));
                    Iterables.addAll(resultingChanges, _propagateTransitiveChanges);
                }
                return resultingChanges;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        private Iterable<PropagatedChange> propagateTransitiveChanges(Iterable<TransactionalChange<EObject>> transitiveChanges) {
            Functions.Function1 _function = it -> it.containsConcreteChange();
            Iterable nonEmptyChanges = IterableExtensions.filter(transitiveChanges, (Functions.Function1)_function);
            Iterable _xifexpression = null;
            boolean _equals = Objects.equals((Object)this.outer.changePropagationMode, (Object)ChangePropagationMode.TRANSITIVE_EXCEPT_LEAVES);
            if (_equals) {
                Functions.Function1 _function_1 = it -> {
                    List<ChangePropagationSpecification> targetSpecifications = this.outer.changePropagationProvider.getChangePropagationSpecifications(it.getAffectedEObjectsMetamodelDescriptor());
                    int _size = targetSpecifications.size();
                    return _size > 1;
                };
                _xifexpression = IterableExtensions.filter((Iterable)nonEmptyChanges, (Functions.Function1)_function_1);
            } else {
                _xifexpression = nonEmptyChanges;
            }
            Iterable nonLeafChanges = _xifexpression;
            Functions.Function1 _function_2 = it -> new ChangePropagation(this.outer, (VitruviusChange<EObject>)it, this);
            List nextPropagations = IterableUtil.mapFixed((Iterable)nonLeafChanges, (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> it.propagateChanges();
            return Iterables.concat((Iterable)IterableUtil.mapFixed((Collection)nextPropagations, (Functions.Function1)_function_3));
        }

        private Iterable<TransactionalChange<EObject>> propagateChangeForChangePropagationSpecification(TransactionalChange<EObject> change, ChangePropagationSpecification propagationSpecification) {
            Runnable _function = () -> {
                List _eChanges = change.getEChanges();
                for (EChange eChange : _eChanges) {
                    propagationSpecification.propagateChange((EChange<EObject>)eChange, this.outer.modelRepository.getCorrespondenceModel(), this.outer.modelRepository);
                }
            };
            Iterable<TransactionalChange<EObject>> transitiveChanges = this.outer.modelRepository.recordChanges(_function);
            Functions.Function1 _function_1 = it -> it.getAffectedEObjects();
            Functions.Function1 _function_2 = it -> it.eResource();
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(transitiveChanges, (Functions.Function1)_function_1), (Functions.Function1)_function_2));
            Iterables.addAll(this.changedResources, (Iterable)_filterNull);
            return transitiveChanges;
        }

        private AutoCloseable installUserInteractorForChange(VitruviusChange<EObject> change) {
            boolean _not;
            AutoCloseable _xblockexpression = null;
            Iterable pastUserInputsFromChange = change.getUserInteractions();
            AutoCloseable _xifexpression = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)pastUserInputsFromChange);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                Functions.Function1 _function = currentProvider -> UserInteractionFactory.instance.createPredefinedInteractionResultProvider(currentProvider, (UserInteractionBase[])Conversions.unwrapArray((Object)pastUserInputsFromChange, UserInteractionBase.class));
                _xifexpression = this.outer.userInteractor.replaceUserInteractionResultProvider(_function);
            } else {
                AutoCloseable _function_1;
                _xifexpression = _function_1 = () -> {};
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private void handleObjectsWithoutResource() {
            Functions.Function1 _function = it -> {
                Resource _eResource = it.eResource();
                return _eResource == null;
            };
            Iterable _filter = IterableExtensions.filter(this.createdObjects, (Functions.Function1)_function);
            for (EObject createdObjectWithoutResource : _filter) {
                boolean _hasCorrespondences = this.outer.modelRepository.getCorrespondenceModel().hasCorrespondences(createdObjectWithoutResource);
                boolean _not = !_hasCorrespondences;
                Preconditions.checkState((boolean)_not, (String)"The object %s is part of a correspondence to %s but not in any resource", (Object)createdObjectWithoutResource, (Object)this.outer.modelRepository.getCorrespondenceModel().getCorrespondingEObjects(createdObjectWithoutResource));
                logger.warn("Object was created but has no correspondence and is thus lost: " + String.valueOf(createdObjectWithoutResource));
            }
        }

        @Override
        public void objectCreated(EObject createdObject) {
            this.createdObjects.add(createdObject);
        }

        public void onUserInteractionReceived(UserInteractionBase interaction) {
            this.userInteractions.add(interaction);
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("propagate ");
            Iterable<String> _propagationPath = this.getPropagationPath();
            boolean _hasElements = false;
            for (String p : _propagationPath) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" -> ", "");
                }
                _builder.append(p);
            }
            _builder.append(": ");
            _builder.append(this.sourceChange);
            return _builder.toString();
        }

        private Iterable<String> getPropagationPath() {
            Iterable<CallSite> _xifexpression = null;
            if (this.previous == null) {
                String _string = this.sourceChange.getAffectedEObjectsMetamodelDescriptors().toString();
                String _plus = "<input change> in " + _string;
                _xifexpression = List.of(_plus);
            } else {
                Iterable<String> _propagationPath = this.previous.getPropagationPath();
                List<String> _of = List.of(this.sourceChange.getAffectedEObjectsMetamodelDescriptors().toString());
                _xifexpression = Iterables.concat(_propagationPath, _of);
            }
            return _xifexpression;
        }

        public ChangePropagation(ChangePropagator outer, VitruviusChange<EObject> sourceChange, ChangePropagation previous) {
            this.outer = outer;
            this.sourceChange = sourceChange;
            this.previous = previous;
        }
    }
}

