/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.propagation.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.composite.MetamodelDescriptor;
import tools.vitruv.change.correspondence.Correspondence;
import tools.vitruv.change.correspondence.view.EditableCorrespondenceModelView;
import tools.vitruv.change.interaction.UserInteractor;
import tools.vitruv.change.propagation.ChangePropagationObserver;
import tools.vitruv.change.propagation.ChangePropagationSpecification;
import tools.vitruv.change.propagation.impl.AbstractChangePropagationSpecification;
import tools.vitruv.change.utils.ResourceAccess;

public class CompositeChangePropagationSpecification
extends AbstractChangePropagationSpecification
implements ChangePropagationObserver {
    private static final Logger logger = LogManager.getLogger(CompositeChangePropagationSpecification.class);
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final List<ChangePropagationSpecification> changePreprocessors;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final List<ChangePropagationSpecification> changeMainprocessors;

    public CompositeChangePropagationSpecification(MetamodelDescriptor sourceMetamodel, MetamodelDescriptor targetMetamodel) {
        super(sourceMetamodel, targetMetamodel);
        ArrayList<ChangePropagationSpecification> _arrayList = new ArrayList<ChangePropagationSpecification>();
        this.changePreprocessors = _arrayList;
        ArrayList<ChangePropagationSpecification> _arrayList_1 = new ArrayList<ChangePropagationSpecification>();
        this.changeMainprocessors = _arrayList_1;
    }

    protected void addChangePreprocessor(ChangePropagationSpecification changePropagationSpecifcation) {
        this.assertMetamodelsCompatible(changePropagationSpecifcation);
        this.changePreprocessors.add(changePropagationSpecifcation);
        changePropagationSpecifcation.setUserInteractor(this.getUserInteractor());
        changePropagationSpecifcation.registerObserver(this);
    }

    protected void addChangeMainprocessor(ChangePropagationSpecification changePropagationSpecifcation) {
        this.assertMetamodelsCompatible(changePropagationSpecifcation);
        this.changeMainprocessors.add(changePropagationSpecifcation);
        changePropagationSpecifcation.setUserInteractor(this.getUserInteractor());
        changePropagationSpecifcation.registerObserver(this);
    }

    private void assertMetamodelsCompatible(ChangePropagationSpecification potentialChangeProcessor) {
        if (!this.getSourceMetamodelDescriptor().equals((Object)potentialChangeProcessor.getSourceMetamodelDescriptor()) || !this.getTargetMetamodelDescriptor().equals((Object)potentialChangeProcessor.getTargetMetamodelDescriptor())) {
            throw new IllegalArgumentException("ChangeProcessor metamodels are not compatible");
        }
    }

    @Override
    public void propagateChange(EChange<EObject> change, EditableCorrespondenceModelView<Correspondence> correspondenceModel, ResourceAccess resourceAccess) {
        this.propagateChangeViaPreprocessors(change, correspondenceModel, resourceAccess);
        this.propagateChangeViaMainprocessors(change, correspondenceModel, resourceAccess);
    }

    protected void propagateChangeViaPreprocessors(EChange<EObject> change, EditableCorrespondenceModelView<Correspondence> correspondenceModel, ResourceAccess resourceAccess) {
        for (ChangePropagationSpecification changeProcessor : this.changePreprocessors) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Calling change preprocessor ");
            _builder.append((Object)changeProcessor);
            _builder.append(" for change event ");
            _builder.append(change);
            logger.trace((CharSequence)_builder);
            changeProcessor.propagateChange(change, correspondenceModel, resourceAccess);
        }
    }

    protected void propagateChangeViaMainprocessors(EChange<EObject> change, EditableCorrespondenceModelView<Correspondence> correspondenceModel, ResourceAccess resourceAccess) {
        for (ChangePropagationSpecification changeProcessor : this.changeMainprocessors) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Calling change mainprocessor ");
            _builder.append((Object)changeProcessor);
            _builder.append(" for change event ");
            _builder.append(change);
            logger.trace((CharSequence)_builder);
            changeProcessor.propagateChange(change, correspondenceModel, resourceAccess);
        }
    }

    @Override
    public boolean doesHandleChange(EChange<EObject> change, EditableCorrespondenceModelView<Correspondence> correspondenceModel) {
        ArrayList<ChangePropagationSpecification> _allProcessors = this.getAllProcessors();
        for (ChangePropagationSpecification changeProcessor : _allProcessors) {
            boolean _doesHandleChange = changeProcessor.doesHandleChange(change, correspondenceModel);
            if (!_doesHandleChange) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUserInteractor(UserInteractor userInteractor) {
        super.setUserInteractor(userInteractor);
        ArrayList<ChangePropagationSpecification> _allProcessors = this.getAllProcessors();
        for (ChangePropagationSpecification changeProcessor : _allProcessors) {
            changeProcessor.setUserInteractor(userInteractor);
        }
    }

    private ArrayList<ChangePropagationSpecification> getAllProcessors() {
        ArrayList<ChangePropagationSpecification> processors = new ArrayList<ChangePropagationSpecification>();
        if (this.changePreprocessors != null) {
            Iterables.addAll(processors, this.changePreprocessors);
        }
        if (this.changeMainprocessors != null) {
            Iterables.addAll(processors, this.changeMainprocessors);
        }
        return processors;
    }

    @Override
    public void objectCreated(EObject createdObject) {
        this.notifyObjectCreated(createdObject);
    }

    @Pure
    protected List<ChangePropagationSpecification> getChangePreprocessors() {
        return this.changePreprocessors;
    }

    @Pure
    protected List<ChangePropagationSpecification> getChangeMainprocessors() {
        return this.changeMainprocessors;
    }
}

