/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.propagation.impl;

import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolver;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeResolver;
import tools.vitruv.change.composite.description.VitruviusChangeResolverFactory;
import tools.vitruv.change.composite.recording.ChangeRecorder;
import tools.vitruv.change.correspondence.Correspondence;
import tools.vitruv.change.correspondence.model.CorrespondenceModel;
import tools.vitruv.change.correspondence.model.CorrespondenceModelFactory;
import tools.vitruv.change.correspondence.model.PersistableCorrespondenceModel;
import tools.vitruv.change.correspondence.view.CorrespondenceModelViewFactory;
import tools.vitruv.change.correspondence.view.EditableCorrespondenceModelView;
import tools.vitruv.change.propagation.PersistableChangeRecordingModelRepository;
import tools.vitruv.change.propagation.impl.ResourceRegistrationAdapter;

public class DefaultChangeRecordingModelRepository
implements PersistableChangeRecordingModelRepository {
    private static final Logger LOGGER = LogManager.getLogger(DefaultChangeRecordingModelRepository.class);
    private static final String METADATA_KEY_FRAGMENT_SEPARATOR = "_";
    private final ResourceSet modelsResourceSet;
    private final PersistableCorrespondenceModel correspondenceModel;
    private final ChangeRecorder changeRecorder;
    private final Path consistencyMetadataFolder;
    private UuidResolver uuidResolver;
    private final VitruviusChangeResolver<Uuid> changeResolver;
    private boolean isLoading = false;

    public DefaultChangeRecordingModelRepository(URI correspondencesURI, Path consistencyMetadataFolder) {
        this.consistencyMetadataFolder = consistencyMetadataFolder;
        this.modelsResourceSet = ResourceSetUtil.withGlobalFactories((ResourceSet)new ResourceSetImpl());
        this.uuidResolver = UuidResolver.create((ResourceSet)this.modelsResourceSet);
        this.changeResolver = VitruviusChangeResolverFactory.forUuids((UuidResolver)this.uuidResolver);
        this.correspondenceModel = CorrespondenceModelFactory.createPersistableCorrespondenceModel((URI)correspondencesURI);
        this.modelsResourceSet.eAdapters().add((Object)new ResourceRegistrationAdapter(resource -> {
            if (!this.isLoading) {
                this.getCreateOrLoadModel(resource.getURI());
            }
        }));
        this.changeRecorder = new ChangeRecorder(this.modelsResourceSet);
    }

    @Override
    public void loadExistingModels() {
        this.isLoading = true;
        this.correspondenceModel.loadSerializedCorrespondences(this.modelsResourceSet);
        this.isLoading = false;
    }

    @Override
    public EditableCorrespondenceModelView<Correspondence> getCorrespondenceModel() {
        return CorrespondenceModelViewFactory.createEditableCorrespondenceModelView((CorrespondenceModel)this.correspondenceModel);
    }

    public URI getMetadataModelURI(String ... metadataKey) {
        Path metadataPath = this.consistencyMetadataFolder.resolve(String.join((CharSequence)METADATA_KEY_FRAGMENT_SEPARATOR, metadataKey));
        return URI.createFileURI((String)metadataPath.toString());
    }

    public Resource getModelResource(URI uri) {
        return this.getCreateOrLoadModel(uri);
    }

    private Resource getCreateOrLoadModel(URI modelResourceURI) {
        Resource resource;
        if (modelResourceURI.isFile() || modelResourceURI.isPlatform()) {
            resource = ResourceSetUtil.getOrCreateResource((ResourceSet)this.modelsResourceSet, (URI)modelResourceURI);
            this.changeRecorder.addToRecording((Notifier)resource);
        } else {
            resource = ResourceSetUtil.loadOrCreateResource((ResourceSet)this.modelsResourceSet, (URI)modelResourceURI);
        }
        return resource;
    }

    public void persistAsRoot(EObject rootEObject, URI uri) {
        this.addRoot(this.getCreateOrLoadModel(uri), rootEObject);
    }

    private void addRoot(Resource resource, EObject root) {
        resource.getContents().add((Object)root);
        resource.setModified(true);
        LOGGER.debug("Add root to resource: {}", (Object)resource);
    }

    @Override
    public void saveOrDeleteModels() {
        HashSet<Resource> resourcesToDelete = new HashSet<Resource>();
        for (Resource modelResource : this.modelsResourceSet.getResources()) {
            if (modelResource.getContents().isEmpty()) {
                resourcesToDelete.add(modelResource);
                continue;
            }
            this.save(modelResource);
        }
        resourcesToDelete.stream().forEach(this::delete);
        this.correspondenceModel.save();
    }

    private void delete(Resource resource) {
        try {
            resource.delete(null);
        }
        catch (IOException e) {
            LOGGER.error("Deletion of resource {} did not work.", (Object)resource, (Object)e);
            throw new IllegalStateException("Could not delete resource with URI " + String.valueOf(resource.getURI()), e);
        }
    }

    private void save(Resource resource) {
        if (!resource.isModified()) {
            return;
        }
        LOGGER.debug("Attempt to save resource: {}", (Object)resource);
        try {
            resource.save(null);
            resource.setModified(false);
        }
        catch (IOException e) {
            LOGGER.error("Model could not be saved: {}", (Object)resource.getURI(), (Object)e);
            throw new IllegalStateException("Could not save resource with URI " + String.valueOf(resource.getURI()), e);
        }
    }

    @Override
    public Iterable<TransactionalChange<EObject>> recordChanges(Runnable changeApplicator) {
        this.changeRecorder.beginRecording();
        LOGGER.debug("Start recording changes");
        changeApplicator.run();
        LOGGER.debug("End recording changes");
        this.changeRecorder.endRecording();
        TransactionalChange recordedChange = this.changeRecorder.getChange();
        this.changeResolver.assignIds((VitruviusChange)recordedChange);
        return List.of(recordedChange);
    }

    @Override
    public VitruviusChange<EObject> applyChange(VitruviusChange<Uuid> change) {
        return this.changeResolver.resolveAndApply(change);
    }

    @Override
    public void close() throws Exception {
        this.changeRecorder.close();
        this.modelsResourceSet.getResources().forEach(Resource::unload);
        this.modelsResourceSet.getResources().clear();
        this.correspondenceModel.close();
        this.uuidResolver = null;
    }

    @Override
    public UuidResolver getUuidResolver() {
        return this.uuidResolver;
    }
}

