/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.propagation.impl;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.composite.description.PropagatedChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.propagation.ChangePropagationListener;
import tools.vitruv.change.composite.propagation.ChangeableModelRepository;
import tools.vitruv.change.interaction.InternalUserInteractor;
import tools.vitruv.change.propagation.ChangePropagationSpecificationProvider;
import tools.vitruv.change.propagation.PersistableChangeRecordingModelRepository;
import tools.vitruv.change.propagation.impl.ChangePropagator;

public class DefaultChangeableModelRepository
implements ChangeableModelRepository {
    private static final Logger LOGGER = LogManager.getLogger(DefaultChangeableModelRepository.class);
    private final Set<ChangePropagationListener> changePropagationListeners = new HashSet<ChangePropagationListener>();
    private final PersistableChangeRecordingModelRepository modelRepository;
    private final ChangePropagator changePropagator;

    public DefaultChangeableModelRepository(PersistableChangeRecordingModelRepository modelRepository, ChangePropagationSpecificationProvider changePropagationSpecificationProvider, InternalUserInteractor userInteractor) {
        this.modelRepository = modelRepository;
        this.changePropagator = new ChangePropagator(modelRepository, changePropagationSpecificationProvider, userInteractor);
    }

    public List<PropagatedChange> propagateChange(VitruviusChange<Uuid> change) {
        Preconditions.checkArgument((change != null ? 1 : 0) != 0, (Object)"change to propagate must not be null");
        Preconditions.checkArgument((boolean)change.containsConcreteChange(), (String)"change to propagate must contain concrete changes:%s%s", (Object)System.lineSeparator(), change);
        LOGGER.info("Start change propagation");
        this.notifyChangePropagationStarted(change);
        List<PropagatedChange> resultChanges = this.changePropagator.propagateChange(change);
        this.modelRepository.saveOrDeleteModels();
        this.notifyChangePropagationFinished(change, resultChanges);
        LOGGER.info("Finished change propagation");
        return resultChanges;
    }

    private void notifyChangePropagationStarted(VitruviusChange<Uuid> change) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Started synchronizing change: " + String.valueOf(change));
        }
        this.changePropagationListeners.stream().forEach(listener -> listener.startedChangePropagation(change));
    }

    private void notifyChangePropagationFinished(VitruviusChange<Uuid> inputChange, Iterable<PropagatedChange> generatedChanges) {
        this.changePropagationListeners.stream().forEach(listener -> listener.finishedChangePropagation(generatedChanges));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished synchronizing change: " + String.valueOf(inputChange));
        }
    }

    public void addChangePropagationListener(ChangePropagationListener propagationListener) {
        Preconditions.checkArgument((propagationListener != null ? 1 : 0) != 0, (Object)"propagation listener must not be null");
        this.changePropagationListeners.add(propagationListener);
    }

    public void removeChangePropagationListener(ChangePropagationListener propagationListener) {
        Preconditions.checkArgument((propagationListener != null ? 1 : 0) != 0, (Object)"propagation listener must not be null");
        this.changePropagationListeners.remove(propagationListener);
    }
}

