/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.testutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.change.interaction.InteractionResultProvider;
import tools.vitruv.change.interaction.UserInteractionOptions;
import tools.vitruv.change.testutils.printing.TestMessages;

public class TestUserInteraction {
    private final List<Response<ConfirmationInteractionDescription, Boolean>> confirmations = new LinkedList<Response<ConfirmationInteractionDescription, Boolean>>();
    private final List<Response<NotificationInteractionDescription, Void>> notificationReactions = new LinkedList<Response<NotificationInteractionDescription, Void>>();
    private final List<Response<TextInputInteractionDescription, String>> textInputs = new LinkedList<Response<TextInputInteractionDescription, String>>();
    private final List<Response<MultipleChoiceInteractionDescription, Functions.Function1<? super MultipleChoiceInteractionDescription, ? extends Integer>>> multipleChoices = new LinkedList<Response<MultipleChoiceInteractionDescription, Functions.Function1<? super MultipleChoiceInteractionDescription, ? extends Integer>>>();
    private final List<Response<MultipleChoiceMultipleSelectionInteractionDescription, Functions.Function1<? super MultipleChoiceMultipleSelectionInteractionDescription, ? extends int[]>>> multipleChoiceMultipleSelections = new LinkedList<Response<MultipleChoiceMultipleSelectionInteractionDescription, Functions.Function1<? super MultipleChoiceMultipleSelectionInteractionDescription, ? extends int[]>>>();

    public void addNextConfirmationInput(boolean nextConfirmation) {
        this.onNextConfirmation().respondWith(nextConfirmation);
    }

    public void addNextTextInput(String nextInput) {
        this.onNextTextInput().respondWith(nextInput);
    }

    public void addNextSingleSelection(int nextSelection) {
        this.onNextMultipleChoiceSingleSelection().respondWithChoiceAt(nextSelection);
    }

    public void addNextMultiSelection(int[] nextSelection) {
        this.onNextMultipleChoiceMultiSelection().respondWithChoicesAt(nextSelection);
    }

    public SimpleResponseBuilder<ConfirmationInteractionDescription, Boolean> onConfirmation(Functions.Function1<? super ConfirmationInteractionDescription, ? extends Boolean> condition) {
        return new SimpleResponseBuilder<ConfirmationInteractionDescription, Boolean>(this, this.confirmations, condition);
    }

    public SimpleResponseBuilder<ConfirmationInteractionDescription, Boolean> onNextConfirmation() {
        Functions.Function1 _function = it -> true;
        return this.onConfirmation((Functions.Function1<? super ConfirmationInteractionDescription, ? extends Boolean>)_function);
    }

    public TestUserInteraction acknowledgeNotification(Functions.Function1<? super NotificationInteractionDescription, ? extends Boolean> check) {
        Response<? super NotificationInteractionDescription, Object> _response = new Response<NotificationInteractionDescription, Object>(check, null, false);
        this.notificationReactions.add(_response);
        return this;
    }

    public SimpleResponseBuilder<TextInputInteractionDescription, String> onTextInput(Functions.Function1<? super TextInputInteractionDescription, ? extends Boolean> condition) {
        return new SimpleResponseBuilder<TextInputInteractionDescription, String>(this, this.textInputs, condition);
    }

    public SimpleResponseBuilder<TextInputInteractionDescription, String> onNextTextInput() {
        Functions.Function1 _function = it -> true;
        return this.onTextInput((Functions.Function1<? super TextInputInteractionDescription, ? extends Boolean>)_function);
    }

    public MultipleChoiceResponseBuilder onMultipleChoiceSingleSelection(Functions.Function1<? super MultipleChoiceInteractionDescription, ? extends Boolean> condition) {
        return new MultipleChoiceResponseBuilder(this, condition);
    }

    public MultipleChoiceResponseBuilder onNextMultipleChoiceSingleSelection() {
        Functions.Function1 _function = it -> true;
        return this.onMultipleChoiceSingleSelection((Functions.Function1<? super MultipleChoiceInteractionDescription, ? extends Boolean>)_function);
    }

    public MultipleChoiceMultipleSelectionResponseBuilder onMultipleChoiceMultiSelection(Functions.Function1<? super MultipleChoiceMultipleSelectionInteractionDescription, ? extends Boolean> condition) {
        return new MultipleChoiceMultipleSelectionResponseBuilder(this, condition);
    }

    public MultipleChoiceMultipleSelectionResponseBuilder onNextMultipleChoiceMultiSelection() {
        Functions.Function1 _function = it -> true;
        return this.onMultipleChoiceMultiSelection((Functions.Function1<? super MultipleChoiceMultipleSelectionInteractionDescription, ? extends Boolean>)_function);
    }

    public void assertAllInteractionsOccurred() {
        int _size_4;
        int _size_3;
        int _size_2;
        int _size_1;
        Functions.Function1 _function = it -> !it.repeatedly;
        Iterable nonRepeatedConfirmations = IterableExtensions.filter(this.confirmations, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> !it.repeatedly;
        Iterable nonRepeatedNotifications = IterableExtensions.filter(this.notificationReactions, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> !it.repeatedly;
        Iterable nonRepeatedTextInputs = IterableExtensions.filter(this.textInputs, (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> !it.repeatedly;
        Iterable nonRepeatedMultipleChoices = IterableExtensions.filter(this.multipleChoices, (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = it -> !it.repeatedly;
        Iterable nonRepeatedMultipleChoiceMultipleSelections = IterableExtensions.filter(this.multipleChoiceMultipleSelections, (Functions.Function1)_function_4);
        int _size = IterableExtensions.size((Iterable)nonRepeatedConfirmations);
        int _plus = _size + (_size_1 = IterableExtensions.size((Iterable)nonRepeatedNotifications));
        int _plus_1 = _plus + (_size_2 = IterableExtensions.size((Iterable)nonRepeatedTextInputs));
        int _plus_2 = _plus_1 + (_size_3 = IterableExtensions.size((Iterable)nonRepeatedMultipleChoices));
        int interactionsLeft = _plus_2 + (_size_4 = IterableExtensions.size((Iterable)nonRepeatedMultipleChoiceMultipleSelections));
        if (interactionsLeft > 0) {
            StringBuilder resultMessage = new StringBuilder();
            List _list = IterableExtensions.toList((Iterable)nonRepeatedConfirmations);
            Pair _mappedTo = Pair.of((Object)"confirmation", (Object)_list);
            List _list_1 = IterableExtensions.toList((Iterable)nonRepeatedNotifications);
            Pair _mappedTo_1 = Pair.of((Object)"notification", (Object)_list_1);
            List _list_2 = IterableExtensions.toList((Iterable)nonRepeatedTextInputs);
            Pair _mappedTo_2 = Pair.of((Object)"text input", (Object)_list_2);
            List _list_3 = IterableExtensions.toList((Iterable)nonRepeatedMultipleChoices);
            Pair _mappedTo_3 = Pair.of((Object)"single selection", (Object)_list_3);
            List _list_4 = IterableExtensions.toList((Iterable)nonRepeatedMultipleChoiceMultipleSelections);
            Pair _mappedTo_4 = Pair.of((Object)"multi selection", (Object)_list_4);
            Functions.Function1 _function_5 = it -> {
                boolean _isEmpty = ((Collection)it.getValue()).isEmpty();
                return !_isEmpty;
            };
            Procedures.Procedure1 _function_6 = it -> resultMessage.append(((Collection)it.getValue()).size()).append(" ").append(TestMessages.plural((Collection)((Collection)it.getValue()), (String)((String)it.getKey())));
            StringBuilder _append = TestMessages.joinSemantic((StringBuilder)resultMessage, (Collection)IterableExtensions.toList((Iterable)IterableExtensions.filter(List.of(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4), (Functions.Function1)_function_5)), (String)"and", (Procedures.Procedure1)_function_6).append(" ");
            String _xifexpression = null;
            _xifexpression = interactionsLeft == 1 ? "was" : "were";
            _append.append(_xifexpression).append(" expected but did not occur!");
            String _string = resultMessage.toString();
            throw new AssertionError((Object)_string);
        }
    }

    public void clearResponses() {
        this.confirmations.clear();
        this.notificationReactions.clear();
        this.textInputs.clear();
        this.multipleChoices.clear();
        this.multipleChoiceMultipleSelections.clear();
    }

    public StringBuilder listSize(StringBuilder result, Collection<?> list, String type) {
        StringBuilder _xifexpression = null;
        boolean _isEmpty = list.isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? result.append(list.size()).append(" ").append(TestMessages.plural(list, (String)type)) : null;
        return _xifexpression;
    }

    @FinalFieldsConstructor
    public static class SimpleResponseBuilder<Description, Result> {
        private final TestUserInteraction owner;
        private final List<Response<Description, Result>> targetQueue;
        private final Functions.Function1<? super Description, ? extends Boolean> condition;
        private boolean repeatedly = false;

        public SimpleResponseBuilder<Description, Result> always() {
            this.repeatedly = true;
            return this;
        }

        public TestUserInteraction respondWith(Result result) {
            Response<? super Description, Result> _response = new Response<Description, Result>(this.condition, result, this.repeatedly);
            this.targetQueue.add(_response);
            return this.owner;
        }

        public SimpleResponseBuilder(TestUserInteraction owner, List<Response<Description, Result>> targetQueue, Functions.Function1<? super Description, ? extends Boolean> condition) {
            this.owner = owner;
            this.targetQueue = targetQueue;
            this.condition = condition;
        }
    }

    @FinalFieldsConstructor
    public static class MultipleChoiceResponseBuilder {
        private final TestUserInteraction owner;
        private final Functions.Function1<? super MultipleChoiceInteractionDescription, ? extends Boolean> condition;
        private boolean repeatedly = false;

        public MultipleChoiceResponseBuilder always() {
            this.repeatedly = true;
            return this;
        }

        public TestUserInteraction respondWith(String result) {
            Functions.Function1 _function = it -> Objects.equals(it, result);
            return this.respondWithChoiceMatching((Functions.Function1<? super String, ? extends Boolean>)_function);
        }

        public TestUserInteraction respondWithChoiceAt(int resultIndex) {
            Functions.Function1 _function = it -> resultIndex;
            Response<? super MultipleChoiceInteractionDescription, Functions.Function1> _response = new Response<MultipleChoiceInteractionDescription, Functions.Function1>(this.condition, _function, this.repeatedly);
            this.owner.multipleChoices.add(_response);
            return this.owner;
        }

        public TestUserInteraction respondWithChoiceMatching(Functions.Function1<? super String, ? extends Boolean> selector) {
            Functions.Function1 _function = it -> MultipleChoiceResponseBuilder.assertedIndexBy(it, selector);
            Response<? super MultipleChoiceInteractionDescription, Functions.Function1> _response = new Response<MultipleChoiceInteractionDescription, Functions.Function1>(this.condition, _function, this.repeatedly);
            this.owner.multipleChoices.add(_response);
            return this.owner;
        }

        private static int assertedIndexBy(MultipleChoiceInteractionDescription interaction, Functions.Function1<? super String, ? extends Boolean> selector) {
            boolean _hasNext;
            int i = 0;
            Iterator<String> choiceIt = interaction.choices.iterator();
            boolean _while = _hasNext = choiceIt.hasNext();
            while (_while) {
                boolean _hasNext_1;
                Boolean _apply = (Boolean)selector.apply((Object)choiceIt.next());
                if (_apply.booleanValue()) {
                    return i;
                }
                int _i = i;
                i = _i + 1;
                _while = _hasNext_1 = choiceIt.hasNext();
            }
            StringConcatenation _builder = new StringConcatenation();
            String _type = interaction.getType();
            _builder.append(_type);
            _builder.append(" without an acceptable choice:");
            String _lineSeparator = System.lineSeparator();
            _builder.append(_lineSeparator);
            _builder.append((Object)interaction);
            throw new AssertionError(_builder);
        }

        public MultipleChoiceResponseBuilder(TestUserInteraction owner, Functions.Function1<? super MultipleChoiceInteractionDescription, ? extends Boolean> condition) {
            this.owner = owner;
            this.condition = condition;
        }
    }

    @FinalFieldsConstructor
    public static class MultipleChoiceMultipleSelectionResponseBuilder {
        private final TestUserInteraction owner;
        private final Functions.Function1<? super MultipleChoiceMultipleSelectionInteractionDescription, ? extends Boolean> condition;
        private boolean repeatedly = false;

        public MultipleChoiceMultipleSelectionResponseBuilder always() {
            this.repeatedly = true;
            return this;
        }

        public TestUserInteraction respondWith(String ... results) {
            return this.respondWith(Set.of(results));
        }

        public TestUserInteraction respondWith(Set<String> results) {
            Functions.Function1 _function = it -> results.contains(it);
            return this.respondWithChoicesMatching((Functions.Function1<? super String, ? extends Boolean>)_function);
        }

        public TestUserInteraction respondWithChoicesAt(int ... resultIndeces) {
            Functions.Function1 _function = it -> resultIndeces;
            Response<? super MultipleChoiceMultipleSelectionInteractionDescription, Functions.Function1> _response = new Response<MultipleChoiceMultipleSelectionInteractionDescription, Functions.Function1>(this.condition, _function, this.repeatedly);
            this.owner.multipleChoiceMultipleSelections.add(_response);
            return this.owner;
        }

        public TestUserInteraction respondWithChoicesMatching(Functions.Function1<? super String, ? extends Boolean> selector) {
            Functions.Function1 _function = it -> MultipleChoiceMultipleSelectionResponseBuilder.assertedIndecesBy(it, selector);
            Response<? super MultipleChoiceMultipleSelectionInteractionDescription, Functions.Function1> _response = new Response<MultipleChoiceMultipleSelectionInteractionDescription, Functions.Function1>(this.condition, _function, this.repeatedly);
            this.owner.multipleChoiceMultipleSelections.add(_response);
            return this.owner;
        }

        private static int[] assertedIndecesBy(MultipleChoiceMultipleSelectionInteractionDescription interaction, Functions.Function1<? super String, ? extends Boolean> selector) {
            boolean _hasNext;
            ArrayList<Integer> result = new ArrayList<Integer>();
            int i = 0;
            Iterator<String> choiceIt = interaction.getChoices().iterator();
            boolean _while = _hasNext = choiceIt.hasNext();
            while (_while) {
                boolean _hasNext_1;
                Boolean _apply = (Boolean)selector.apply((Object)choiceIt.next());
                if (_apply.booleanValue()) {
                    result.add(i);
                }
                int _i = i;
                i = _i + 1;
                _while = _hasNext_1 = choiceIt.hasNext();
            }
            return (int[])Conversions.unwrapArray(result, Integer.TYPE);
        }

        public MultipleChoiceMultipleSelectionResponseBuilder(TestUserInteraction owner, Functions.Function1<? super MultipleChoiceMultipleSelectionInteractionDescription, ? extends Boolean> condition) {
            this.owner = owner;
            this.condition = condition;
        }
    }

    @FinalFieldsConstructor
    public static class Response<Description, Result> {
        private final Functions.Function1<? super Description, ? extends Boolean> matcher;
        private final Result response;
        private final boolean repeatedly;

        public Response(Functions.Function1<? super Description, ? extends Boolean> matcher, Result response, boolean repeatedly) {
            this.matcher = matcher;
            this.response = response;
            this.repeatedly = repeatedly;
        }
    }

    @FinalFieldsConstructor
    public static class ResultProvider
    implements InteractionResultProvider {
        private final TestUserInteraction source;

        public boolean getConfirmationInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String negativeDecisionText, String cancelDecisionText) {
            ConfirmationInteractionDescription _confirmationInteractionDescription = new ConfirmationInteractionDescription(windowModality, title, message, positiveDecisionText, negativeDecisionText, cancelDecisionText);
            return (Boolean)ResultProvider.requireMatchingInteraction(this.source.confirmations, _confirmationInteractionDescription);
        }

        public void getNotificationInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, UserInteractionOptions.NotificationType notificationType) {
            NotificationInteractionDescription _notificationInteractionDescription = new NotificationInteractionDescription(windowModality, title, message, positiveDecisionText, notificationType);
            ResultProvider.requireMatchingInteraction(this.source.notificationReactions, _notificationInteractionDescription);
        }

        public String getTextInputInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, UserInteractionOptions.InputValidator inputValidator) {
            TextInputInteractionDescription _textInputInteractionDescription = new TextInputInteractionDescription(windowModality, title, message, positiveDecisionText, cancelDecisionText, inputValidator);
            return (String)ResultProvider.requireMatchingInteraction(this.source.textInputs, _textInputInteractionDescription);
        }

        public int getMultipleChoiceSingleSelectionInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
            MultipleChoiceInteractionDescription interaction = new MultipleChoiceInteractionDescription(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
            Functions.Function1 resultProvider = (Functions.Function1)ResultProvider.requireMatchingInteraction(this.source.multipleChoices, interaction);
            return (Integer)resultProvider.apply((Object)interaction);
        }

        public Iterable<Integer> getMultipleChoiceMultipleSelectionInteractionResult(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
            MultipleChoiceMultipleSelectionInteractionDescription interaction = new MultipleChoiceMultipleSelectionInteractionDescription(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
            Functions.Function1 resultProvider = (Functions.Function1)ResultProvider.requireMatchingInteraction(this.source.multipleChoiceMultipleSelections, interaction);
            return (Iterable)Conversions.doWrapArray((Object)resultProvider.apply((Object)interaction));
        }

        private static <Description extends InteractionDescription, Result> Result requireMatchingInteraction(Iterable<Response<Description, Result>> options, Description interaction) {
            Iterator<Response<Description, Result>> optionsIt = options.iterator();
            while (optionsIt.hasNext()) {
                Response<Description, Result> option = optionsIt.next();
                Boolean _apply = (Boolean)option.matcher.apply(interaction);
                if (!_apply.booleanValue()) continue;
                if (!option.repeatedly) {
                    optionsIt.remove();
                }
                return option.response;
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("An unexpected ");
            String _type = interaction.getType();
            _builder.append(_type);
            _builder.append(" occurred:");
            String _lineSeparator = System.lineSeparator();
            _builder.append(_lineSeparator);
            _builder.append(interaction);
            throw new AssertionError(_builder);
        }

        public ResultProvider(TestUserInteraction source) {
            this.source = source;
        }
    }

    public static class MultipleChoiceMultipleSelectionInteractionDescription
    extends MultipleChoiceInteractionDescription {
        public MultipleChoiceMultipleSelectionInteractionDescription(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
            super(windowModality, title, message, positiveDecisionText, cancelDecisionText, choices);
        }

        @Override
        public String getType() {
            return "multiple choice interaction with multiple selections";
        }
    }

    @FinalFieldsConstructor
    @Accessors
    public static class MultipleChoiceInteractionDescription
    extends InteractionDescription {
        private final String cancelDecisionText;
        private final Iterable<String> choices;

        @Override
        public String toString() {
            String _string = super.toString();
            Functions.Function1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                String _lineSeparator = System.lineSeparator();
                _builder.append(_lineSeparator);
                _builder.append("  \u2022 ");
                _builder.append(it);
                return _builder.toString();
            };
            String _join = IterableExtensions.join(this.choices, (CharSequence)"", (Functions.Function1)_function);
            return _string + _join;
        }

        @Override
        public String getType() {
            return "multiple choice interaction";
        }

        public MultipleChoiceInteractionDescription(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, Iterable<String> choices) {
            super(windowModality, title, message, positiveDecisionText);
            this.cancelDecisionText = cancelDecisionText;
            this.choices = choices;
        }

        @Pure
        public String getCancelDecisionText() {
            return this.cancelDecisionText;
        }

        @Pure
        public Iterable<String> getChoices() {
            return this.choices;
        }
    }

    @FinalFieldsConstructor
    @Accessors
    public static class NotificationInteractionDescription
    extends InteractionDescription {
        private final UserInteractionOptions.NotificationType notificationType;

        @Override
        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)this.notificationType);
            _builder.append(" ");
            String _string = super.toString();
            _builder.append(_string);
            return _builder.toString();
        }

        @Override
        public String getType() {
            return "notification interaction";
        }

        public NotificationInteractionDescription(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, UserInteractionOptions.NotificationType notificationType) {
            super(windowModality, title, message, positiveDecisionText);
            this.notificationType = notificationType;
        }

        @Pure
        public UserInteractionOptions.NotificationType getNotificationType() {
            return this.notificationType;
        }
    }

    @FinalFieldsConstructor
    @Accessors
    public static class TextInputInteractionDescription
    extends InteractionDescription {
        private final String cancelDecisionText;
        private final UserInteractionOptions.InputValidator inputValidator;

        @Override
        public String getType() {
            return "text input interaction";
        }

        public TextInputInteractionDescription(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String cancelDecisionText, UserInteractionOptions.InputValidator inputValidator) {
            super(windowModality, title, message, positiveDecisionText);
            this.cancelDecisionText = cancelDecisionText;
            this.inputValidator = inputValidator;
        }

        @Pure
        public String getCancelDecisionText() {
            return this.cancelDecisionText;
        }

        @Pure
        public UserInteractionOptions.InputValidator getInputValidator() {
            return this.inputValidator;
        }
    }

    @FinalFieldsConstructor
    @Accessors
    public static class ConfirmationInteractionDescription
    extends InteractionDescription {
        private final String negativeDecisionText;
        private final String cancelDecisionText;

        @Override
        public String getType() {
            return "confirmation interaction";
        }

        public ConfirmationInteractionDescription(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText, String negativeDecisionText, String cancelDecisionText) {
            super(windowModality, title, message, positiveDecisionText);
            this.negativeDecisionText = negativeDecisionText;
            this.cancelDecisionText = cancelDecisionText;
        }

        @Pure
        public String getNegativeDecisionText() {
            return this.negativeDecisionText;
        }

        @Pure
        public String getCancelDecisionText() {
            return this.cancelDecisionText;
        }
    }

    @FinalFieldsConstructor
    @Accessors
    public static abstract class InteractionDescription {
        private final UserInteractionOptions.WindowModality windowModality;
        private final String title;
        private final String message;
        private final String positiveDecisionText;

        public abstract String getType();

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(this.title);
            _builder.append(": ");
            _builder.append(this.message);
            return _builder.toString();
        }

        public InteractionDescription(UserInteractionOptions.WindowModality windowModality, String title, String message, String positiveDecisionText) {
            this.windowModality = windowModality;
            this.title = title;
            this.message = message;
            this.positiveDecisionText = positiveDecisionText;
        }

        @Pure
        public UserInteractionOptions.WindowModality getWindowModality() {
            return this.windowModality;
        }

        @Pure
        public String getTitle() {
            return this.title;
        }

        @Pure
        public String getMessage() {
            return this.message;
        }

        @Pure
        public String getPositiveDecisionText() {
            return this.positiveDecisionText;
        }
    }
}

