/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.testutils.views;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.change.composite.description.PropagatedChange;
import tools.vitruv.change.testutils.TestUserInteraction;
import tools.vitruv.change.testutils.views.TestView;
import tools.vitruv.change.testutils.views.UriMode;

public class BasicTestView
implements TestView {
    private final Path persistenceDirectory;
    private final ResourceSet resourceSet;
    @Accessors
    private final TestUserInteraction userInteraction;
    private final UriMode uriMode;

    public BasicTestView(Path persistenceDirectory, UriMode uriMode) {
        this(persistenceDirectory, new TestUserInteraction(), uriMode);
    }

    public BasicTestView(Path persistenceDirectory, TestUserInteraction userInteraction, UriMode uriMode) {
        this(persistenceDirectory, ResourceSetUtil.withGlobalFactories((ResourceSet)new ResourceSetImpl()), userInteraction, uriMode);
    }

    public BasicTestView(Path persistenceDirectory, ResourceSet resourceSet, TestUserInteraction userInteraction, UriMode uriMode) {
        this.persistenceDirectory = persistenceDirectory;
        this.resourceSet = resourceSet;
        this.userInteraction = userInteraction;
        this.uriMode = uriMode;
    }

    @Override
    public Resource resourceAt(URI modelUri) {
        return ResourceSetUtil.loadOrCreateResource((ResourceSet)this.resourceSet, (URI)modelUri);
    }

    @Override
    public <T extends EObject> T from(Class<T> clazz, URI modelUri) {
        Resource resource = this.resourceSet.getResource(modelUri, true);
        return this.from(clazz, resource);
    }

    @Override
    public <T extends Notifier> T record(T notifier, Consumer<T> consumer) {
        consumer.accept(notifier);
        return notifier;
    }

    @Override
    public <T extends Notifier> List<PropagatedChange> propagate(T notifier, Consumer<T> consumer) {
        Resource _determineResource;
        Resource toSave = this.determineResource(notifier);
        consumer.accept(notifier);
        Resource _elvis = null;
        _elvis = toSave != null ? toSave : (_determineResource = this.determineResource(notifier));
        if (_elvis != null) {
            this.saveOrDelete(_elvis);
        }
        return CollectionLiterals.emptyList();
    }

    @Override
    public void moveTo(Resource resource, Path newViewRelativePath) {
        this.moveSafelyTo(this.getAbsolutePath(resource.getURI()), this.persistenceDirectory.resolve(newViewRelativePath));
        resource.setURI(this.getUri(newViewRelativePath));
    }

    @Override
    public void moveTo(Resource resource, URI newUri) {
        this.moveSafelyTo(this.getAbsolutePath(resource.getURI()), this.getAbsolutePath(newUri));
        resource.setURI(newUri);
    }

    private Path moveSafelyTo(Path source, Path target) {
        try {
            Path _xblockexpression = null;
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            _xblockexpression = Files.move(source, target, new CopyOption[0]);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void saveOrDelete(Resource resource) {
        try {
            boolean _isEmpty = resource.getContents().isEmpty();
            if (_isEmpty) {
                resource.delete(CollectionLiterals.emptyMap());
            } else {
                resource.save(CollectionLiterals.emptyMap());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public URI getUri(Path viewRelativePath) {
        Preconditions.checkArgument((viewRelativePath != null ? 1 : 0) != 0, (Object)"The viewRelativePath must not be null!");
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)viewRelativePath);
        boolean _not = !_isEmpty;
        Preconditions.checkArgument((boolean)_not, (Object)"The viewRelativePath must not be empty!");
        URI _switchResult = null;
        UriMode uriMode = this.uriMode;
        if (uriMode != null) {
            switch (uriMode) {
                case PLATFORM_URIS: {
                    _switchResult = URI.createPlatformResourceURI((String)IterableExtensions.join((Iterable)this.persistenceDirectory.getFileName().resolve(viewRelativePath).normalize(), (CharSequence)"/"), (boolean)true);
                    break;
                }
                case FILE_URIS: {
                    _switchResult = URIUtil.createFileURI((File)this.persistenceDirectory.resolve(viewRelativePath).normalize().toFile());
                    break;
                }
            }
        }
        return _switchResult;
    }

    private Path getAbsolutePath(URI uri) {
        Path _xifexpression = null;
        boolean _isFile = uri.isFile();
        if (_isFile) {
            Path _xblockexpression = null;
            boolean _hasAbsolutePath = uri.hasAbsolutePath();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)uri);
            _builder.append(" is a file URI but does not have an absolute path!");
            Preconditions.checkArgument((boolean)_hasAbsolutePath, (Object)_builder);
            _xifexpression = _xblockexpression = Path.of(URI.decode((String)uri.path()), new String[0]);
        } else {
            Path _xifexpression_1 = null;
            boolean _isPlatformResource = uri.isPlatformResource();
            if (!_isPlatformResource) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("This URI is not supported by this view: ");
                _builder.append((Object)uri);
                throw new IllegalArgumentException(_builder.toString());
            }
            _xifexpression_1 = this.persistenceDirectory.resolveSibling(uri.toPlatformString(true));
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private Resource determineResource(Notifier notifier) {
        Resource _switchResult = null;
        boolean _matched = false;
        if (notifier instanceof Resource) {
            _matched = true;
            _switchResult = (Resource)notifier;
        }
        if (!_matched && notifier instanceof EObject) {
            _matched = true;
            _switchResult = ((EObject)notifier).eResource();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    @Override
    public void close() throws Exception {
        Consumer<Resource> _function = it -> it.unload();
        this.resourceSet.getResources().forEach(_function);
        this.resourceSet.getResources().clear();
    }

    @Override
    @Pure
    public TestUserInteraction getUserInteraction() {
        return this.userInteraction;
    }
}

