/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.testutils.views;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolver;
import tools.vitruv.change.composite.description.PropagatedChange;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeResolver;
import tools.vitruv.change.composite.description.VitruviusChangeResolverFactory;
import tools.vitruv.change.composite.propagation.ChangeableModelRepository;
import tools.vitruv.change.composite.recording.ChangeRecorder;
import tools.vitruv.change.propagation.ChangePropagationSpecification;
import tools.vitruv.change.propagation.ChangePropagationSpecificationProvider;
import tools.vitruv.change.propagation.ChangePropagationSpecificationRepository;
import tools.vitruv.change.propagation.PersistableChangeRecordingModelRepository;
import tools.vitruv.change.propagation.impl.DefaultChangeRecordingModelRepository;
import tools.vitruv.change.testutils.TestModelRepositoryFactory;
import tools.vitruv.change.testutils.TestUserInteraction;
import tools.vitruv.change.testutils.views.BasicTestView;
import tools.vitruv.change.testutils.views.NonTransactionalTestView;
import tools.vitruv.change.testutils.views.TestView;
import tools.vitruv.change.testutils.views.UriMode;

public class ChangePublishingTestView
implements NonTransactionalTestView {
    private final ResourceSet resourceSet = ResourceSetUtil.withGlobalFactories((ResourceSet)new ResourceSetImpl());
    private final UuidResolver uuidResolver = UuidResolver.create((ResourceSet)this.resourceSet);
    private final VitruviusChangeResolver<Uuid> changeResolver;
    @Delegate
    private final TestView delegate;
    private final ChangeRecorder changeRecorder;
    private final ChangeableModelRepository modelRepository;
    private final BiConsumer<Resource, UuidResolver> uuidResolution;
    private boolean disposeViewResourcesAfterPropagation = true;

    public ChangePublishingTestView(Path persistenceDirectory, TestUserInteraction userInteraction, UriMode uriMode, ChangeableModelRepository changeableModelRepository, BiConsumer<Resource, UuidResolver> uuidResolution) {
        ChangeRecorder _changeRecorder;
        this.modelRepository = changeableModelRepository;
        BasicTestView _basicTestView = new BasicTestView(persistenceDirectory, this.resourceSet, userInteraction, uriMode);
        this.delegate = _basicTestView;
        this.changeRecorder = _changeRecorder = new ChangeRecorder(this.resourceSet);
        this.changeResolver = VitruviusChangeResolverFactory.forUuids((UuidResolver)this.uuidResolver);
        this.uuidResolution = uuidResolution;
        this.changeRecorder.beginRecording();
    }

    public ChangePublishingTestView(Path persistenceDirectory, TestUserInteraction userInteraction, UriMode uriMode, ChangeableModelRepository changeableModelRepository, UuidResolver modelUuidResolver, Function<URI, Resource> modelResourceAt) {
        this(persistenceDirectory, userInteraction, uriMode, changeableModelRepository, (viewResource, viewUuidResolver) -> {
            Resource modelResource = (Resource)modelResourceAt.apply(viewResource.getURI());
            if (modelResource != null) {
                modelUuidResolver.resolveResource(modelResource, viewResource, viewUuidResolver);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
            this.changeRecorder.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Notifier> T record(T notifier, Consumer<T> consumer) {
        try {
            this.startRecordingChanges(notifier);
            T t = this.delegate.record(notifier, consumer);
            return t;
        }
        finally {
            this.stopRecordingChanges(notifier);
        }
    }

    @Override
    public <T extends Notifier> List<PropagatedChange> propagate(T notifier, Consumer<T> consumer) {
        Consumer<Notifier> _function = it -> this.record(it, consumer);
        List<PropagatedChange> delegateChanges = this.delegate.propagate(notifier, _function);
        this.changeRecorder.endRecording();
        List<PropagatedChange> ourChanges = this.propagateChanges((TransactionalChange<EObject>)this.changeRecorder.getChange());
        this.changeRecorder.beginRecording();
        return ChangePublishingTestView.operator_plus(delegateChanges, ourChanges);
    }

    @Override
    public List<PropagatedChange> propagate() {
        this.changeRecorder.endRecording();
        TransactionalChange recordedChange = this.changeRecorder.getChange();
        Functions.Function1 _function = it -> this.resourceSet.getResource(it, false);
        Functions.Function1 _function_1 = changedResource -> {
            Consumer<Resource> _function_2 = it -> {};
            return this.delegate.propagate(changedResource, _function_2);
        };
        List delegateChanges = IterableUtil.flatMapFixed((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)recordedChange.getChangedURIs(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        List<PropagatedChange> ourChanges = this.propagateChanges((TransactionalChange<EObject>)recordedChange);
        this.changeRecorder.beginRecording();
        return ChangePublishingTestView.operator_plus(delegateChanges, ourChanges);
    }

    private List<PropagatedChange> propagateChanges(TransactionalChange<EObject> change) {
        VitruviusChange unresolvedChange = this.changeResolver.assignIds(change);
        List propagationResult = this.modelRepository.propagateChange(unresolvedChange);
        if (this.disposeViewResourcesAfterPropagation) {
            this.disposeViewResources();
        }
        return propagationResult;
    }

    @Override
    public Resource resourceAt(URI modelUri) {
        Resource resource = this.delegate.resourceAt(modelUri);
        this.uuidResolution.accept(resource, this.uuidResolver);
        return resource;
    }

    @Override
    public Resource resourceAt(Path viewRelativePath) {
        return this.resourceAt(this.getUri(viewRelativePath));
    }

    @Override
    public <T extends EObject> T from(Class<T> clazz, URI modelUri) {
        Resource resource = this.resourceSet.getResource(modelUri, true);
        this.uuidResolution.accept(resource, this.uuidResolver);
        return this.from(clazz, resource);
    }

    @Override
    public <T extends EObject> T from(Class<T> clazz, Path viewRelativePath) {
        return this.from(clazz, this.getUri(viewRelativePath));
    }

    @Override
    public void disposeViewResources() {
        Consumer<Resource> _function = resource -> {
            if (resource.getURI() == null || !URIUtil.isPathmap((URI)resource.getURI())) {
                Procedures.Procedure1 _function_1 = it -> {
                    boolean _hasUuid = this.uuidResolver.hasUuid(it);
                    if (_hasUuid) {
                        this.uuidResolver.unregisterEObject(this.uuidResolver.getUuid(it), it);
                    }
                };
                IteratorExtensions.forEach((Iterator)resource.getAllContents(), (Procedures.Procedure1)_function_1);
            }
        };
        this.resourceSet.getResources().forEach(_function);
        this.resourceSet.getResources().clear();
    }

    @Override
    public <T extends Notifier> T startRecordingChanges(T notifier) {
        Preconditions.checkState((boolean)this.changeRecorder.isRecording(), (Object)"This test view has already been closed!");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The object to record changes of is null!");
        Preconditions.checkArgument((notifier != null ? 1 : 0) != 0, (Object)_builder);
        this.changeRecorder.addToRecording(notifier);
        return notifier;
    }

    @Override
    public <T extends Notifier> T stopRecordingChanges(T notifier) {
        Preconditions.checkState((boolean)this.changeRecorder.isRecording(), (Object)"This test view has already been closed!");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The object to stop recording changes of is null!");
        Preconditions.checkArgument((notifier != null ? 1 : 0) != 0, (Object)_builder);
        this.changeRecorder.removeFromRecording(notifier);
        return notifier;
    }

    @Override
    public void setDisposeViewResourcesAfterPropagation(boolean enabled) {
        this.disposeViewResourcesAfterPropagation = enabled;
    }

    public static <T> List<T> operator_plus(List<T> a, List<T> b) {
        List<T> _xifexpression = null;
        boolean _isEmpty = a.isEmpty();
        if (_isEmpty) {
            _xifexpression = b;
        } else {
            List<T> _xifexpression_1 = null;
            boolean _isEmpty_1 = b.isEmpty();
            if (_isEmpty_1) {
                _xifexpression_1 = a;
            } else {
                ArrayList<T> _xblockexpression = null;
                int _size = a.size();
                int _size_1 = b.size();
                int _plus = _size + _size_1;
                ArrayList<T> result = new ArrayList<T>(_plus);
                result.addAll(a);
                result.addAll(b);
                _xblockexpression = result;
                _xifexpression_1 = _xblockexpression;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static ChangePublishingTestView createDefaultChangePublishingTestView(Path persistenceDirectory, Iterable<ChangePropagationSpecification> changePropagationSpecifications) {
        try {
            TestUserInteraction userInteraction = new TestUserInteraction();
            ChangePropagationSpecificationRepository changePropagationSpecificationProvider = new ChangePropagationSpecificationRepository(changePropagationSpecifications);
            Path _createTempDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
            DefaultChangeRecordingModelRepository modelRepository = new DefaultChangeRecordingModelRepository(null, _createTempDirectory);
            ChangeableModelRepository changeableModelRepository = TestModelRepositoryFactory.createTestChangeableModelRepository((PersistableChangeRecordingModelRepository)modelRepository, (ChangePropagationSpecificationProvider)changePropagationSpecificationProvider, userInteraction);
            UuidResolver _uuidResolver = modelRepository.getUuidResolver();
            Function<URI, Resource> _function = it -> modelRepository.getModelResource(it);
            return new ChangePublishingTestView(persistenceDirectory, userInteraction, UriMode.FILE_URIS, changeableModelRepository, _uuidResolver, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public <T extends EObject> T from(Class<T> clazz, Resource resource) {
        return this.delegate.from(clazz, resource);
    }

    @Override
    public URI getUri(Path viewRelativePath) {
        return this.delegate.getUri(viewRelativePath);
    }

    @Override
    public TestUserInteraction getUserInteraction() {
        return this.delegate.getUserInteraction();
    }

    @Override
    public void moveTo(Resource resource, Path newViewRelativePath) {
        this.delegate.moveTo(resource, newViewRelativePath);
    }

    @Override
    public void moveTo(Resource resource, URI newUri) {
        this.delegate.moveTo(resource, newUri);
    }
}

