/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ProjectMarker {
    private static final String TEST_PROJECT_MARKER_FILE_NAME = "test_project.marker_vitruv";

    private ProjectMarker() {
    }

    public static void markAsProjectRootFolder(Path projectRootFolder) throws IOException {
        Files.createFile(projectRootFolder.resolve(TEST_PROJECT_MARKER_FILE_NAME), new FileAttribute[0]);
    }

    public static Path getProjectRootFolder(Path containedElementPath) {
        Path potentialProjectPath = containedElementPath;
        while (!Files.exists(potentialProjectPath.resolve(TEST_PROJECT_MARKER_FILE_NAME), new LinkOption[0])) {
            Preconditions.checkState(((potentialProjectPath = potentialProjectPath.getParent()) != null ? 1 : 0) != 0, (String)"No project folder for %s found", (Object)containedElementPath);
        }
        return potentialProjectPath;
    }
}

