/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.utils.activeannotations;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.services.Problem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import tools.vitruv.change.utils.activeannotations.ModelCreators;

public class ModelCreatorsProcessor
extends AbstractClassProcessor {
    private static final String NEW_EOBJECT_ARGUMENT_CONVERTER = "NewEObject";
    private static final String CLASSIFIER_ARGUMENT_CONVERTER = "Classifier";

    private TypeReference checkPreconditions(ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        TypeReference _xblockexpression = null;
        try {
            Preconditions.checkNotNull((Object)context.newTypeReference(Preconditions.class, new TypeReference[0]));
        }
        catch (Throwable _t) {
            if (_t instanceof NullPointerException || _t instanceof ClassNotFoundException || _t instanceof NoClassDefFoundError) {
                context.addError((Element)annotatedClass, "Please add Guava to the classpath!");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            Preconditions.checkNotNull((Object)context.newTypeReference(ParameterContext.class, new TypeReference[0]));
        }
        catch (Throwable _t) {
            if (_t instanceof NullPointerException || _t instanceof ClassNotFoundException || _t instanceof NoClassDefFoundError) {
                context.addError((Element)annotatedClass, "Please add the JUnit Jupiter API to the classpath!");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        TypeReference _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = (TypeReference)Preconditions.checkNotNull((Object)context.newTypeReference(ArgumentConverter.class, new TypeReference[0]));
        }
        catch (Throwable _t) {
            if (_t instanceof NullPointerException || _t instanceof ClassNotFoundException || _t instanceof NoClassDefFoundError) {
                context.addError((Element)annotatedClass, "Please add JUnit 5 Params to the classpath!");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public void doRegisterGlobals(ClassDeclaration annotatedClass, @Extension RegisterGlobalsContext context) {
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedName = annotatedClass.getQualifiedName();
        _builder.append(_qualifiedName);
        _builder.append(".");
        _builder.append(NEW_EOBJECT_ARGUMENT_CONVERTER);
        context.registerClass(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        String _qualifiedName_1 = annotatedClass.getQualifiedName();
        _builder_1.append(_qualifiedName_1);
        _builder_1.append(".");
        _builder_1.append(CLASSIFIER_ARGUMENT_CONVERTER);
        context.registerClass(_builder_1.toString());
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean _lessThan;
        this.checkPreconditions((ClassDeclaration)annotatedClass, context);
        AnnotationReference annotation = annotatedClass.findAnnotation(context.findTypeGlobally(ModelCreators.class));
        if (annotation == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Cannot find ");
            String _simpleName = ModelCreators.class.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" annotation on ");
            String _simpleName_1 = annotatedClass.getSimpleName();
            _builder.append(_simpleName_1);
            context.addError((Element)annotatedClass, _builder.toString());
        }
        Functions.Function1 _function = it -> {
            Problem.Severity _severity = it.getSeverity();
            return Objects.equals(_severity, Problem.Severity.ERROR);
        };
        boolean _exists = IterableExtensions.exists((Iterable)context.getProblems((Element)annotatedClass), (Functions.Function1)_function);
        if (_exists) {
            return;
        }
        final TypeReference factory = annotation.getClassValue("factory");
        boolean createStatic = annotation.getBooleanValue("staticCreators");
        String stripPrefix = annotation.getStringValue("stripPrefix");
        String prefix = annotation.getStringValue("prefix");
        String[] rawReplacements = annotation.getStringArrayValue("replace");
        int _size = ((List)Conversions.doWrapArray((Object)rawReplacements)).size();
        int _modulo = _size % 2;
        boolean _equals = _modulo == 0;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("The replace array must have an even number of elements!");
        Preconditions.checkArgument((boolean)_equals, (Object)_builder_1);
        HashMap<String, String> replacements = new HashMap<String, String>();
        int i = 0;
        int _size_1 = ((List)Conversions.doWrapArray((Object)rawReplacements)).size();
        boolean _while = _lessThan = i < _size_1;
        while (_while) {
            boolean _lessThan_1;
            replacements.put(rawReplacements[i], rawReplacements[i + 1]);
            int _i = i;
            i = _i + 2;
            int _size_2 = ((List)Conversions.doWrapArray((Object)rawReplacements)).size();
            _while = _lessThan_1 = i < _size_2;
        }
        Functions.Function1 _function_1 = it -> it.getDeclaration();
        Functions.Function1 _function_2 = it -> it.getSimpleName().startsWith("create") && IterableExtensions.isEmpty((Iterable)it.getParameters());
        Consumer<MethodDeclaration> _function_3 = createMethod -> {
            String baseName = ModelCreatorsProcessor.removePrefix(ModelCreatorsProcessor.removePrefix(createMethod.getSimpleName(), "create"), stripPrefix);
            String _firstUpper = StringExtensions.toFirstUpper((String)replacements.getOrDefault(baseName, baseName));
            String targetName = prefix + _firstUpper;
            Procedures.Procedure1 _function_4 = it -> {
                it.setStatic(createStatic);
                it.setReturnType(createMethod.getReturnType());
                StringConcatenationClient _client = new StringConcatenationClient((MethodDeclaration)createMethod){
                    final /* synthetic */ MethodDeclaration val$createMethod;
                    {
                        this.val$createMethod = methodDeclaration;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)factory);
                        _builder.append((Object)".eINSTANCE.");
                        String _simpleName = this.val$createMethod.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"();");
                    }
                };
                it.setBody(_client);
                context.setPrimarySourceElement((MutableElement)it, (Element)annotatedClass);
            };
            annotatedClass.addMethod(targetName, _function_4);
        };
        IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)factory.getDeclaredResolvedMethods(), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
        Procedures.Procedure1 _function_4 = it -> {
            it.setReturnType(context.newTypeReference(EClassifier.class, new TypeReference[0]));
            it.setStatic(true);
            it.setVisibility(Visibility.PRIVATE);
            it.addParameter("classifierName", context.newTypeReference(String.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append(Preconditions.class);
                    _builder.append((Object)".checkNotNull(");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)factory, "\t");
                    _builder.append((Object)".eINSTANCE.getEPackage().getEClassifier(classifierName),");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\"There is no classifier called '%s' in '%s'!\", classifierName, ");
                    _builder.append((Object)factory, "\t");
                    _builder.append((Object)".eINSTANCE.getEPackage().getName()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("_getClassifier", _function_4);
        Procedures.Procedure1 _function_5 = it -> {
            it.setReturnType(context.newTypeReference(EClassifier.class, new TypeReference[0]));
            it.addParameter("classifierName", context.newTypeReference(String.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return _getClassifier(classifierName);");
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("classifier", _function_5);
        Procedures.Procedure1 _function_6 = it -> {
            it.setReturnType(context.newTypeReference(EObject.class, new TypeReference[0]));
            it.setStatic(true);
            it.setVisibility(Visibility.PRIVATE);
            it.addParameter("className", context.newTypeReference(String.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(EClassifier.class);
                    _builder.append((Object)" requestedClassifier = _getClassifier(className);");
                    _builder.newLineIfNotEmpty();
                    _builder.append(Preconditions.class);
                    _builder.append((Object)".checkArgument(");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"requestedClassifier instanceof ");
                    _builder.append(EClass.class, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\"%s is not an EClass and can thus not be instantiated!\", className");
                    _builder.newLine();
                    _builder.append((Object)");");
                    _builder.newLine();
                    _builder.append((Object)"return ");
                    _builder.append((Object)factory);
                    _builder.append((Object)".eINSTANCE.create((");
                    _builder.append(EClass.class);
                    _builder.append((Object)") requestedClassifier);");
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("_createInstance", _function_6);
        Procedures.Procedure1 _function_7 = it -> {
            it.setReturnType(context.newTypeReference(EObject.class, new TypeReference[0]));
            it.addParameter("className", context.newTypeReference(String.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return _createInstance(className);");
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("create", _function_7);
        Procedures.Procedure1 _function_8 = it -> {
            MutableTypeParameterDeclaration type = it.addTypeParameter("M", new TypeReference[]{context.newTypeReference(EObject.class, new TypeReference[0])});
            it.setReturnType(context.newSelfTypeReference((Type)type));
            it.addParameter("clazz", context.newTypeReference(Class.class, new TypeReference[]{context.newWildcardTypeReference(context.newSelfTypeReference((Type)type))}));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return clazz.cast(_createInstance(clazz.getSimpleName()));");
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("create", _function_8);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)annotatedClass.getDeclaredConstructors());
        if (_isEmpty) {
            Procedures.Procedure1 _function_9 = it -> it.setVisibility(Visibility.PRIVATE);
            annotatedClass.addConstructor(_function_9);
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        String _qualifiedName = annotatedClass.getQualifiedName();
        _builder_2.append(_qualifiedName);
        _builder_2.append(".");
        _builder_2.append(NEW_EOBJECT_ARGUMENT_CONVERTER);
        MutableClassDeclaration _findClass = context.findClass(_builder_2.toString());
        Procedures.Procedure1 _function_10 = it -> {
            TypeReference _newTypeReference = context.newTypeReference(ArgumentConverter.class, new TypeReference[0]);
            it.setImplementedInterfaces(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
            Procedures.Procedure1 _function_11 = it_1 -> {
                it_1.setReturnType(context.newTypeReference(EObject.class, new TypeReference[0]));
                it_1.addParameter("source", context.newTypeReference(Object.class, new TypeReference[0]));
                it_1.addParameter("context", context.newTypeReference(ParameterContext.class, new TypeReference[0]));
                TypeReference _newTypeReference_1 = context.newTypeReference(ArgumentConversionException.class, new TypeReference[0]);
                it_1.setExceptions(new TypeReference[]{_newTypeReference_1});
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"try {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return _createInstance((String) source);");
                        _builder.newLine();
                        _builder.append((Object)"} catch (IllegalArgumentException | NullPointerException e) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"throw new ");
                        _builder.append(ArgumentConversionException.class, "\t");
                        _builder.append((Object)"(e.getMessage(), e);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                };
                it_1.setBody(_client);
            };
            it.addMethod("convert", _function_11);
        };
        ObjectExtensions.operator_doubleArrow((Object)_findClass, (Procedures.Procedure1)_function_10);
        StringConcatenation _builder_3 = new StringConcatenation();
        String _qualifiedName_1 = annotatedClass.getQualifiedName();
        _builder_3.append(_qualifiedName_1);
        _builder_3.append(".");
        _builder_3.append(CLASSIFIER_ARGUMENT_CONVERTER);
        MutableClassDeclaration _findClass_1 = context.findClass(_builder_3.toString());
        Procedures.Procedure1 _function_11 = it -> {
            TypeReference _newTypeReference = context.newTypeReference(ArgumentConverter.class, new TypeReference[0]);
            it.setImplementedInterfaces(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
            Procedures.Procedure1 _function_12 = it_1 -> {
                it_1.setReturnType(context.newTypeReference(EObject.class, new TypeReference[0]));
                it_1.addParameter("source", context.newTypeReference(Object.class, new TypeReference[0]));
                it_1.addParameter("context", context.newTypeReference(ParameterContext.class, new TypeReference[0]));
                TypeReference _newTypeReference_1 = context.newTypeReference(ArgumentConversionException.class, new TypeReference[0]);
                it_1.setExceptions(new TypeReference[]{_newTypeReference_1});
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"try {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return _getClassifier((String) source);");
                        _builder.newLine();
                        _builder.append((Object)"} catch (NullPointerException e) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"throw new ");
                        _builder.append(ArgumentConversionException.class, "\t");
                        _builder.append((Object)"(e.getMessage(), e);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                };
                it_1.setBody(_client);
            };
            it.addMethod("convert", _function_12);
        };
        ObjectExtensions.operator_doubleArrow((Object)_findClass_1, (Procedures.Procedure1)_function_11);
    }

    private static String removePrefix(String target, String prefix) {
        String _xifexpression = null;
        boolean _startsWith = target.startsWith(prefix);
        _xifexpression = _startsWith ? target.substring(prefix.length()) : target;
        return _xifexpression;
    }
}

