/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.utils.activeannotations;

import java.util.Objects;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.utils.activeannotations.WithGeneratedRandomIds;

public class WithGeneratedIdsProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        TypeReference extendedFactory = annotatedClass.getExtendedClass();
        if (extendedFactory == null || !context.newTypeReference(EFactoryImpl.class, new TypeReference[0]).isAssignableFrom(extendedFactory)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("'A class annotated with ");
            String _simpleName = WithGeneratedRandomIds.class.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" must extend an extension ");
            _builder.append("of");
            String _simpleName_1 = EFactoryImpl.class.getSimpleName();
            _builder.append(_simpleName_1);
            _builder.append(".");
            context.addError((Element)annotatedClass, _builder.toString());
            return;
        }
        AnnotationReference annotation = annotatedClass.findAnnotation(context.findTypeGlobally(WithGeneratedRandomIds.class));
        if (annotation == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Cannot find ");
            String _simpleName_2 = WithGeneratedRandomIds.class.getSimpleName();
            _builder_1.append(_simpleName_2);
            _builder_1.append(" annotation on ");
            String _simpleName_3 = annotatedClass.getSimpleName();
            _builder_1.append(_simpleName_3);
            context.addError((Element)annotatedClass, _builder_1.toString());
            return;
        }
        TypeReference identifierMetaclass = annotation.getClassValue("identifierMetaclass");
        Functions.Function1 _function = it -> it.getDeclaration().getSimpleName().startsWith("create") && IterableExtensions.isEmpty((Iterable)it.getDeclaration().getParameters()) && identifierMetaclass.isAssignableFrom(it.getDeclaration().getReturnType());
        Iterable createMethods = IterableExtensions.filter((Iterable)extendedFactory.getDeclaredResolvedMethods(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)createMethods);
        if (_isEmpty) {
            context.addWarning((Element)annotatedClass, "Could not find a single create method to override. Please check your arguments!");
        }
        for (ResolvedMethod createMethod : createMethods) {
            StringConcatenationClient _client;
            Functions.Function1 _function_1 = it -> Objects.equals(it.getSimpleName(), createMethod.getDeclaration().getSimpleName()) && IterableExtensions.isEmpty((Iterable)it.getParameters()) && !it.isStatic();
            MutableMethodDeclaration existingMethod = (MutableMethodDeclaration)IterableExtensions.findFirst((Iterable)annotatedClass.getDeclaredMethods(), (Functions.Function1)_function_1);
            Object _xifexpression = null;
            if (existingMethod != null) {
                Object _xblockexpression = null;
                Object newName = existingMethod.getSimpleName();
                do {
                    newName = "_" + (String)newName;
                } while (this.existsWithName(annotatedClass.getDeclaredMethods(), (String)newName));
                Procedures.Procedure1 _function_2 = it -> {
                    it.setVisibility(Visibility.PRIVATE);
                    it.setReturnType(existingMethod.getReturnType());
                    it.setBody(existingMethod.getBody());
                    context.setPrimarySourceElement((MutableElement)it, (Element)existingMethod);
                };
                annotatedClass.addMethod((String)newName, _function_2);
                _xifexpression = _xblockexpression = newName;
            } else {
                String _simpleName_4 = createMethod.getDeclaration().getSimpleName();
                _xifexpression = "super." + _simpleName_4;
            }
            final String creatorMethod = _xifexpression;
            final TypeReference createdMetaClass = createMethod.getResolvedReturnType();
            StringConcatenationClient idSetterBody = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"final ");
                    _builder.append((Object)createdMetaClass);
                    _builder.append((Object)" created = ");
                    _builder.append((Object)creatorMethod);
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                    _builder.append(EcoreUtil.class);
                    _builder.append((Object)".setID(created, ");
                    _builder.append(EcoreUtil.class);
                    _builder.append((Object)".generateUUID());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"return created;");
                    _builder.newLine();
                }
            };
            if (existingMethod != null) {
                existingMethod.setBody(idSetterBody);
                continue;
            }
            Procedures.Procedure1 _function_2 = it -> {
                it.setReturnType(createdMetaClass);
                it.setBody(idSetterBody);
                context.setPrimarySourceElement((MutableElement)it, (Element)annotatedClass);
            };
            annotatedClass.addMethod(createMethod.getDeclaration().getSimpleName(), _function_2);
        }
    }

    public String removeFromEnd(String string, String substring) {
        boolean _notEquals;
        int _length_1;
        int _length = string.length();
        int _minus = _length - (_length_1 = substring.length());
        String end = string.substring(_minus, string.length());
        boolean bl = _notEquals = !Objects.equals(end, substring);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(string);
            _builder.append(" does not end with ");
            _builder.append(substring);
            _builder.append("!");
            throw new IllegalArgumentException(_builder.toString());
        }
        int _length_2 = string.length();
        int _length_3 = substring.length();
        int _minus_1 = _length_2 - _length_3;
        return string.substring(0, _minus_1);
    }

    public boolean existsWithName(Iterable<? extends MethodDeclaration> methods, String name) {
        Functions.Function1 _function = it -> {
            String _simpleName = it.getSimpleName();
            return Objects.equals(_simpleName, name);
        };
        return IterableExtensions.exists(methods, (Functions.Function1)_function);
    }
}

