/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.common.elements;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import tools.vitruv.dsls.common.elements.EPackageRegistryScope;
import tools.vitruv.dsls.common.elements.ElementsPackage;
import tools.vitruv.dsls.common.elements.MetaclassEAttributeReference;
import tools.vitruv.dsls.common.elements.MetaclassEReferenceReference;
import tools.vitruv.dsls.common.elements.MetaclassFeatureReference;
import tools.vitruv.dsls.common.elements.MetaclassReference;
import tools.vitruv.dsls.common.elements.MetamodelImport;

public class CommonLanguageElementsScopeProvider {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private Provider<EPackageRegistryScope> packagesScope;

    public <T> IScope createScope(IScope parentScope, Iterator<? extends T> elements, Function<T, IEObjectDescription> descriptionCreation) {
        Functions.Function1 _function = it -> (IEObjectDescription)descriptionCreation.apply(it);
        List _list = IteratorExtensions.toList((Iterator)IteratorExtensions.filterNull((Iterator)IteratorExtensions.map(elements, (Functions.Function1)_function)));
        return new SimpleScope(parentScope, (Iterable)_list);
    }

    public IScope getScope(EObject context, EReference reference) {
        boolean _equals = reference.equals(ElementsPackage.Literals.METAMODEL_IMPORT__PACKAGE);
        if (_equals) {
            return (IScope)this.packagesScope.get();
        }
        boolean _equals_1 = reference.equals(ElementsPackage.Literals.METACLASS_FEATURE_REFERENCE__FEATURE);
        if (_equals_1) {
            EClassifier _metaclass = null;
            if ((MetaclassFeatureReference)context != null) {
                _metaclass = ((MetaclassFeatureReference)context).getMetaclass();
            }
            return this.createEStructuralFeatureScope((EClass)_metaclass);
        }
        boolean _equals_2 = reference.equals(ElementsPackage.Literals.METACLASS_EATTRIBUTE_REFERENCE__FEATURE);
        if (_equals_2) {
            EClassifier _metaclass_1 = null;
            if ((MetaclassEAttributeReference)context != null) {
                _metaclass_1 = ((MetaclassEAttributeReference)context).getMetaclass();
            }
            return this.createEAttributeScope((EClass)_metaclass_1);
        }
        boolean _equals_3 = reference.equals(ElementsPackage.Literals.METACLASS_EREFERENCE_REFERENCE__FEATURE);
        if (_equals_3) {
            EClassifier _metaclass_2 = null;
            if ((MetaclassEReferenceReference)context != null) {
                _metaclass_2 = ((MetaclassEReferenceReference)context).getMetaclass();
            }
            return this.createEReferenceScope((EClass)_metaclass_2);
        }
        boolean _equals_4 = reference.equals(ElementsPackage.Literals.METACLASS_REFERENCE__METAMODEL);
        if (_equals_4) {
            return this.createImportsScope(context.eResource());
        }
        boolean _equals_5 = reference.equals(ElementsPackage.Literals.METACLASS_REFERENCE__METACLASS);
        if (_equals_5) {
            MetaclassReference _xifexpression = null;
            if (context instanceof MetaclassReference) {
                _xifexpression = (MetaclassReference)context;
            }
            MetaclassReference potentialMetaclassReference = _xifexpression;
            MetamodelImport _metamodel = null;
            if (potentialMetaclassReference != null) {
                _metamodel = potentialMetaclassReference.getMetamodel();
            }
            return this.createQualifiedEClassifierScope(_metamodel);
        }
        return null;
    }

    private IScope createImportsScope(Resource resource) {
        IScope _xblockexpression = null;
        if (resource == null) {
            return IScope.NULLSCOPE;
        }
        Function<MetamodelImport, IEObjectDescription> _function = it -> EObjectDescription.create((String)it.getName(), (EObject)it);
        _xblockexpression = this.createScope(IScope.NULLSCOPE, this.getMetamodelImports(resource).iterator(), _function);
        return _xblockexpression;
    }

    private Iterable<MetamodelImport> getMetamodelImports(Resource res) {
        List contents = IterableExtensions.toList(this.getAllContentsOfEClass(res, ElementsPackage.eINSTANCE.getMetamodelImport(), true));
        Functions.Function1 _function = it -> {
            EPackage _package = it.getPackage();
            return _package != null;
        };
        Functions.Function1 _function_1 = it -> {
            String _name_1;
            MetamodelImport _xblockexpression = null;
            String _elvis = null;
            String _name = it.getName();
            _elvis = _name != null ? _name : (_name_1 = it.getPackage().getName());
            it.setName(_elvis);
            _xblockexpression = it;
            return _xblockexpression;
        };
        Iterable validImports = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)contents, MetamodelImport.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
        return validImports;
    }

    private IScope createEStructuralFeatureScope(EClass eClass) {
        EList _eAllStructuralFeatures = null;
        if (eClass != null) {
            _eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        }
        return this.createEStructuralFeatureScope(_eAllStructuralFeatures.iterator());
    }

    private IScope createEAttributeScope(EClass eClass) {
        EList _eAllAttributes = null;
        if (eClass != null) {
            _eAllAttributes = eClass.getEAllAttributes();
        }
        return this.createEStructuralFeatureScope(_eAllAttributes.iterator());
    }

    private IScope createEReferenceScope(EClass eClass) {
        EList _eAllReferences = null;
        if (eClass != null) {
            _eAllReferences = eClass.getEAllReferences();
        }
        return this.createEStructuralFeatureScope(_eAllReferences.iterator());
    }

    private IScope createEStructuralFeatureScope(Iterator<? extends EStructuralFeature> featuresIterator) {
        IScope _xifexpression = null;
        if (featuresIterator == null) {
            return IScope.NULLSCOPE;
        }
        Function<EStructuralFeature, IEObjectDescription> _function = it -> EObjectDescription.create((String)it.getName(), (EObject)it);
        _xifexpression = this.createScope(IScope.NULLSCOPE, featuresIterator, _function);
        return _xifexpression;
    }

    public Iterable<EObject> getAllContentsOfEClass(Resource res, EClass namedParent, boolean allContents) {
        Object _xifexpression = null;
        _xifexpression = allContents ? IteratorExtensions.toList((Iterator)res.getAllContents()) : res.getContents();
        Object contents = _xifexpression;
        Functions.Function1 _function = it -> it.eClass().equals(namedParent);
        return IterableExtensions.filter((Iterable)contents, (Functions.Function1)_function);
    }

    public SimpleScope createQualifiedEClassifierScope(MetamodelImport metamodelImport) {
        return this.createQualifiedEClassifierScope(metamodelImport, false, null, EcorePackage.Literals.EOBJECT);
    }

    public SimpleScope createQualifiedEClassScopeWithEObject(MetamodelImport metamodelImport) {
        return this.createQualifiedEClassifierScope(metamodelImport, true, null, EcorePackage.Literals.EOBJECT);
    }

    public SimpleScope createQualifiedEClassScopeWithoutAbstract(MetamodelImport metamodelImport) {
        Function<EClassifier, Boolean> _function = it -> {
            boolean _isAbstract;
            boolean _xifexpression = false;
            _xifexpression = it instanceof EClass ? !(_isAbstract = ((EClass)it).isAbstract()) : false;
            return _xifexpression;
        };
        return this.createQualifiedEClassifierScope(metamodelImport, false, _function, EcorePackage.Literals.EOBJECT);
    }

    private SimpleScope createQualifiedEClassifierScope(MetamodelImport metamodelImport, boolean includeEObject, Function<EClassifier, Boolean> filter, EClass type) {
        Iterable<Object> _xifexpression = null;
        if (metamodelImport == null || metamodelImport.getPackage() == null) {
            List _xifexpression_1 = null;
            if (includeEObject) {
                IEObjectDescription _createEObjectDescription = this.createEObjectDescription((EClassifier)type, false);
                _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IEObjectDescription[]{_createEObjectDescription}));
            } else {
                _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = this.collectObjectDescriptions(metamodelImport.getPackage(), true, metamodelImport.isUseQualifiedNames(), filter);
        }
        List classifierDescriptions = _xifexpression;
        SimpleScope resultScope = new SimpleScope(IScope.NULLSCOPE, classifierDescriptions);
        return resultScope;
    }

    private IEObjectDescription createEObjectDescription(EClassifier classifier, boolean useQualifiedNames) {
        QualifiedName qualifiedName = null;
        qualifiedName = useQualifiedNames ? this.qualifiedNameProvider.getFullyQualifiedName((EObject)classifier).skipFirst(1) : QualifiedName.create((String)classifier.getName());
        return EObjectDescription.create((QualifiedName)qualifiedName, (EObject)classifier);
    }

    private Iterable<IEObjectDescription> collectObjectDescriptions(EPackage pckg, boolean includeSubpackages, boolean useQualifiedNames, final Function<EClassifier, Boolean> filter) {
        Iterable _xblockexpression = null;
        Iterable classes = this.collectEClasses(pckg, includeSubpackages);
        if (filter != null) {
            classes = IterableExtensions.filter(classes, (Functions.Function1)new Functions.Function1<EClassifier, Boolean>(){

                public Boolean apply(EClassifier arg0) {
                    return (Boolean)filter.apply(arg0);
                }
            });
        }
        Functions.Function1 _function = it -> this.createEObjectDescription((EClassifier)it, useQualifiedNames);
        _xblockexpression = IterableExtensions.map(classes, (Functions.Function1)_function);
        return _xblockexpression;
    }

    private Iterable<EClassifier> collectEClasses(EPackage pckg, boolean includeSubpackages) {
        ArrayList recursiveResult = CollectionLiterals.newArrayList();
        if (includeSubpackages) {
            Functions.Function1 _function = it -> this.collectEClasses((EPackage)it, includeSubpackages);
            Iterable _flatten = Iterables.concat((Iterable)ListExtensions.map((List)pckg.getESubpackages(), (Functions.Function1)_function));
            Iterables.addAll((Collection)recursiveResult, (Iterable)_flatten);
        }
        Functions.Function1 _function_1 = it -> it instanceof EClass || it instanceof EEnum;
        Iterable result = IterableExtensions.filter((Iterable)pckg.getEClassifiers(), (Functions.Function1)_function_1);
        return Iterables.concat((Iterable)recursiveResult, (Iterable)result);
    }
}

