/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.activextendannotations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.activextendannotations.CloseResource;
import edu.kit.ipd.sdq.activextendannotations.TypeCopier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.ValidationContext;
import org.eclipse.xtend.lib.macro.ValidationParticipant;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableExecutableDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CloseResourceProcessor
implements TransformationParticipant<MutableParameterDeclaration>,
ValidationParticipant<MutableParameterDeclaration> {
    public void doTransform(List<? extends MutableParameterDeclaration> annotatedTargetElements, @Extension TransformationContext context) {
        Functions.Function1 _function = it -> it.getDeclaringExecutable();
        Map grouped = IterableExtensions.groupBy(annotatedTargetElements, (Functions.Function1)_function);
        Set _entrySet = grouped.entrySet();
        for (Map.Entry annotationEntry : _entrySet) {
            new CloseResourceExecutableProcessor(context).tranform((MutableExecutableDeclaration)annotationEntry.getKey(), (List)annotationEntry.getValue());
        }
    }

    public void doValidate(List<? extends MutableParameterDeclaration> annotatedTargetElements, @Extension ValidationContext context) {
        TypeInfo info = new TypeInfo((TypeReferenceProvider)context);
        for (MutableParameterDeclaration mutableParameterDeclaration : annotatedTargetElements) {
            boolean _not;
            boolean _hasSuperType = info.hasSuperType(mutableParameterDeclaration.getType(), AutoCloseable.class);
            boolean bl = _not = !_hasSuperType;
            if (!_not) continue;
            context.addError((Element)mutableParameterDeclaration, "A resource for try-with-resources must implement AutoCloseable!");
        }
    }

    @FinalFieldsConstructor
    private static class CloseResourceExecutableProcessor {
        private MutableExecutableDeclaration oldExecutable;
        private List<MutableParameterDeclaration> annotatedParameters;
        private MutableExecutableDeclaration newExecutable;
        private boolean doesReturn;
        @Extension
        private final TransformationContext context;
        @Extension
        private TypeCopier typeCopier;

        public void tranform(MutableExecutableDeclaration executable, List<MutableParameterDeclaration> annotatedParameters) {
            this.annotatedParameters = annotatedParameters;
            MutableTypeDeclaration type = executable.getDeclaringType();
            boolean _matched = false;
            if (executable instanceof MutableMethodDeclaration) {
                _matched = true;
                boolean _isInferred = ((MutableMethodDeclaration)executable).getReturnType().isInferred();
                if (_isInferred) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("A method using @");
                    String _simpleName = CloseResource.class.getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" must declare its return type");
                    this.context.addError((Element)executable, _builder.toString());
                    return;
                }
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("_");
                String _simpleName_1 = ((MutableMethodDeclaration)executable).getSimpleName();
                _builder_1.append(_simpleName_1);
                _builder_1.append("_with_safe_resources");
                Procedures.Procedure1 _function = it -> {};
                MutableMethodDeclaration newMethod = type.addMethod(_builder_1.toString(), _function);
                this.withMethod(newMethod, (MutableMethodDeclaration)executable);
            }
            if (!_matched && executable instanceof MutableConstructorDeclaration) {
                _matched = true;
                Procedures.Procedure1 _function = it -> {};
                MutableConstructorDeclaration newConstructor = type.addConstructor(_function);
                this.withConstructor(newConstructor, (MutableConstructorDeclaration)executable);
            }
            if (!_matched) {
                throw new AssertionError((Object)"Unknown subclass of MutableExecutableDeclration");
            }
            this.transform();
        }

        public MutableExecutableDeclaration withMethod(MutableMethodDeclaration newMethod, MutableMethodDeclaration oldMethod) {
            boolean _not;
            TypeCopier _typeCopier;
            MutableMethodDeclaration _xblockexpression = null;
            this.typeCopier = _typeCopier = new TypeCopier(this.context);
            Procedures.Procedure1 _function = it -> {
                this.typeCopier.copyTypeParametersFrom((MutableMethodDeclaration)it, oldMethod);
                this.context.setPrimarySourceElement((MutableElement)it, (Element)oldMethod);
                it.setStatic(oldMethod.isStatic());
                it.setFinal(oldMethod.isFinal());
                it.setReturnType(this.typeCopier.replaceTypeParameters(oldMethod.getReturnType()));
            };
            ObjectExtensions.operator_doubleArrow((Object)newMethod, (Procedures.Procedure1)_function);
            boolean _isVoid = oldMethod.getReturnType().isVoid();
            this.doesReturn = _not = !_isVoid;
            this.newExecutable = newMethod;
            this.oldExecutable = oldMethod;
            _xblockexpression = this.oldExecutable;
            return _xblockexpression;
        }

        public boolean withConstructor(MutableConstructorDeclaration constructor, MutableConstructorDeclaration oldConstructor) {
            TypeCopier _typeCopier;
            boolean _xblockexpression = false;
            this.typeCopier = _typeCopier = new TypeCopier(this.context);
            Procedures.Procedure1 _function = it -> this.context.setPrimarySourceElement((MutableElement)it, (Element)oldConstructor);
            ObjectExtensions.operator_doubleArrow((Object)constructor, (Procedures.Procedure1)_function);
            this.newExecutable = constructor;
            this.oldExecutable = oldConstructor;
            this.doesReturn = false;
            _xblockexpression = false;
            return _xblockexpression;
        }

        public void transform() {
            TypeInfo info = new TypeInfo((TypeReferenceProvider)this.context);
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PRIVATE);
                it.setBody(this.oldExecutable.getBody());
                it.setDocComment(this.oldExecutable.getDocComment());
                it.setVarArgs(this.oldExecutable.isVarArgs());
                Functions.Function1 _function_1 = it_1 -> this.typeCopier.replaceTypeParameters((TypeReference)it_1);
                it.setExceptions((TypeReference[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)this.oldExecutable.getExceptions(), (Functions.Function1)_function_1), TypeReference.class));
            };
            ObjectExtensions.operator_doubleArrow((Object)this.newExecutable, (Procedures.Procedure1)_function);
            Consumer<MutableParameterDeclaration> _function_1 = it -> this.newExecutable.addParameter(it.getSimpleName(), this.typeCopier.replaceTypeParameters(it.getType()));
            this.oldExecutable.getParameters().forEach(_function_1);
            Functions.Function1 _function_2 = it -> info.withAllSuperTypes(it.getType());
            Functions.Function1 _function_3 = it -> {
                Functions.Function1 _function_4 = it_1 -> {
                    Functions.Function1 _function_5 = it_2 -> {
                        String _simpleSignature = it_2.getSimpleSignature();
                        return Objects.equal((Object)_simpleSignature, (Object)"close()");
                    };
                    return (ResolvedMethod)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)it_1.getDeclaredResolvedMethods(), ResolvedMethod.class), (Functions.Function1)_function_5);
                };
                Functions.Function1 _function_5 = it_1 -> it_1 != null;
                return (ResolvedMethod)IterableExtensions.findFirst((Iterable)IterableExtensions.map((Iterable)it, (Functions.Function1)_function_4), (Functions.Function1)_function_5);
            };
            Functions.Function1 _function_4 = it -> it != null;
            Functions.Function1 _function_5 = it -> it.getResolvedExceptionTypes();
            Iterable closeExceptions = Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)ListExtensions.map(this.annotatedParameters, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
            Iterable _exceptions = this.oldExecutable.getExceptions();
            this.oldExecutable.setExceptions((TypeReference[])Conversions.unwrapArray((Object)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_exceptions, (Iterable)closeExceptions)), TypeReference.class));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"try (");
                    boolean _hasElements = false;
                    for (MutableParameterDeclaration p : annotatedParameters) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)"; ", "");
                        }
                        TypeReference _type = p.getType();
                        _builder.append((Object)_type);
                        _builder.append((Object)" r_");
                        String _simpleName = p.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" = ");
                        String _simpleName_1 = p.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                    }
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    if (doesReturn) {
                        _builder.append((Object)"return ");
                    }
                    String _simpleName_2 = newExecutable.getSimpleName();
                    _builder.append((Object)_simpleName_2, "\t");
                    _builder.append((Object)"(");
                    Iterable _parameters = oldExecutable.getParameters();
                    boolean _hasElements_1 = false;
                    for (MutableParameterDeclaration p_1 : _parameters) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        boolean _isAnnotated = this.isAnnotated(p_1);
                        if (_isAnnotated) {
                            _builder.append((Object)"r_");
                        }
                        String _simpleName_3 = p_1.getSimpleName();
                        _builder.append((Object)_simpleName_3, "\t");
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}\t\t\t");
                    _builder.newLine();
                }
            };
            this.oldExecutable.setBody(_client);
            this.oldExecutable.setDocComment("");
        }

        public boolean isAnnotated(MutableParameterDeclaration parameter) {
            return this.annotatedParameters.contains(parameter);
        }

        public CloseResourceExecutableProcessor(TransformationContext context) {
            this.context = context;
        }
    }

    @FinalFieldsConstructor
    private static class TypeInfo {
        @Extension
        private final TypeReferenceProvider provider;

        private boolean hasSuperType(TypeReference typeReference, Class<?> superType) {
            return this.withAllSuperTypes(typeReference).contains(this.provider.newTypeReference(superType, new TypeReference[0]));
        }

        private Set<? extends TypeReference> withAllSuperTypes(TypeReference typeReference) {
            Functions.Function1 _function = it -> this.withAllSuperTypes((TypeReference)it);
            Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)typeReference.getDeclaredSuperTypes(), (Functions.Function1)_function));
            return IterableExtensions.toSet((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{typeReference})), (Iterable)_flatten));
        }

        public TypeInfo(TypeReferenceProvider provider) {
            this.provider = provider;
        }
    }
}

