/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.activextendannotations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.activextendannotations.StaticDelegate;
import edu.kit.ipd.sdq.activextendannotations.TypeCopier;
import edu.kit.ipd.sdq.activextendannotations.Visibility;
import edu.kit.ipd.sdq.activextendannotations.VisibilityExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTarget;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.NamedElement;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ExportStaticMethodsProcessor
implements TransformationParticipant<MutableTypeDeclaration> {
    public void doTransform(List<? extends MutableTypeDeclaration> annotatedTargetElements, @Extension TransformationContext context) {
        ContexedProcessor delegateProcessor = new ContexedProcessor(context);
        for (MutableTypeDeclaration mutableTypeDeclaration : annotatedTargetElements) {
            Iterable<? extends AnnotationReference> exportAnnotations = delegateProcessor.findAllAnnotations((AnnotationTarget)mutableTypeDeclaration, context.findTypeGlobally(StaticDelegate.class));
            ArrayList<AnnotationReference> validAnnotations = delegateProcessor.checkForSelfReference(delegateProcessor.checkForDuplicateTypes(exportAnnotations), mutableTypeDeclaration);
            for (AnnotationReference exportAnnotation : validAnnotations) {
                delegateProcessor.doTransform(mutableTypeDeclaration, exportAnnotation);
            }
        }
    }

    @FinalFieldsConstructor
    private static class ContexedProcessor {
        @Extension
        private final TransformationContext context;

        private void doTransform(MutableTypeDeclaration annotatedType, AnnotationReference annotation) {
            Visibility exportedVisiblity = Visibility.valueOf(annotation.getEnumValue("visibility").getSimpleName());
            Collection<TypeReference> _withoutDuplicateTypes = this.withoutDuplicateTypes(this.delegationTargets(annotation));
            for (TypeReference sourceType : _withoutDuplicateTypes) {
                Functions.Function1 _function = it -> it.getDeclaration().isStatic() && this.isAccessibleFrom(it.getDeclaration(), annotatedType);
                Iterable staticMethods = IterableExtensions.filter((Iterable)sourceType.getDeclaredResolvedMethods(), (Functions.Function1)_function);
                for (ResolvedMethod staticMethod : staticMethods) {
                    Procedures.Procedure1 _function_1 = it -> it.setVisibility(VisibilityExtension.toXtendVisibility(exportedVisiblity, staticMethod.getDeclaration().getVisibility()));
                    this.createDelegationTo(annotatedType, staticMethod, (Procedures.Procedure1<MutableMethodDeclaration>)_function_1);
                }
            }
        }

        private MutableMethodDeclaration createDelegationTo(MutableTypeDeclaration target, ResolvedMethod resolvedMethod, Procedures.Procedure1<MutableMethodDeclaration> furtherInitialiser) {
            MutableMethodDeclaration _xblockexpression = null;
            final MethodDeclaration method = resolvedMethod.getDeclaration();
            TypeCopier typeCopier = new TypeCopier(this.context);
            Procedures.Procedure1 _function = it -> {
                typeCopier.copyTypeParametersFrom((MutableMethodDeclaration)it, resolvedMethod);
                this.context.setPrimarySourceElement((MutableElement)it, (Element)method.getDeclaringType());
                it.setReturnType(typeCopier.replaceTypeParameters(resolvedMethod.getResolvedReturnType()));
                it.setVarArgs(method.isVarArgs());
                it.setDocComment(method.getDocComment());
                it.setStatic(true);
                it.setAbstract(false);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        boolean _not;
                        boolean _isVoid = method.getReturnType().isVoid();
                        boolean bl = _not = !_isVoid;
                        if (_not) {
                            _builder.append((Object)"return ");
                        }
                        TypeDeclaration _declaringType = method.getDeclaringType();
                        _builder.append((Object)_declaringType);
                        _builder.append((Object)".");
                        String _simpleName = method.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"(");
                        Functions.Function1 _function = it_1 -> it_1.getSimpleName();
                        String _join = IterableExtensions.join((Iterable)method.getParameters(), (CharSequence)", ", (Functions.Function1)_function);
                        _builder.append((Object)_join);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                };
                it.setBody(_client);
            };
            MutableMethodDeclaration copy = target.addMethod(method.getSimpleName(), _function);
            Consumer<AnnotationReference> _function_1 = it -> copy.addAnnotation(it);
            method.getAnnotations().forEach(_function_1);
            Consumer<ResolvedParameter> _function_2 = it -> copy.addParameter(it.getDeclaration().getSimpleName(), typeCopier.replaceTypeParameters(it.getResolvedType()));
            resolvedMethod.getResolvedParameters().forEach(_function_2);
            furtherInitialiser.apply((Object)copy);
            boolean _isAsVisibleAsAs = this.isAsVisibleAsAs(method, (MethodDeclaration)copy);
            if (_isAsVisibleAsAs) {
                int parametersLength = ((Object[])Conversions.unwrapArray((Object)method.getParameters(), Object.class)).length;
                Procedures.Procedure1 _function_3 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("$");
                    _builder.append((Object)(parametersLength + 1));
                    _builder.append(".");
                    String _simpleName = method.getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append("(");
                    IntegerRange _upTo = new IntegerRange(1, parametersLength);
                    boolean _hasElements = false;
                    for (Integer i : _upTo) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        _builder.append("$");
                        _builder.append((Object)i);
                    }
                    _builder.append(")");
                    it.setStringValue("value", new String[]{_builder.toString()});
                    it.setClassValue("imported", new TypeReference[]{this.context.newTypeReference((Type)method.getDeclaringType(), new TypeReference[0])});
                };
                copy.addAnnotation(this.context.newAnnotationReference(Inline.class, _function_3));
            }
            _xblockexpression = copy;
            return _xblockexpression;
        }

        private Collection<TypeReference> withoutDuplicateTypes(TypeReference[] references) {
            Collection<TypeReference> _xblockexpression = null;
            HashMap typeToRef = CollectionLiterals.newHashMap();
            Consumer<TypeReference> _function = it -> typeToRef.put(it.getType(), it);
            ((List)Conversions.doWrapArray((Object)references)).forEach(_function);
            _xblockexpression = typeToRef.values();
            return _xblockexpression;
        }

        private ArrayList<AnnotationReference> checkForDuplicateTypes(Iterable<? extends AnnotationReference> annotations) {
            ArrayList<AnnotationReference> _xblockexpression = null;
            int _length = ((Object[])Conversions.unwrapArray(annotations, Object.class)).length;
            ArrayList<AnnotationReference> validAnnotations = new ArrayList<AnnotationReference>(_length);
            HashMap usedTypes = new HashMap();
            for (AnnotationReference annotationReference : annotations) {
                boolean _equals;
                boolean _greaterThan;
                Functions.Function1 _function = it -> it.getType();
                HashSet<Type> containedDuplicates = ContexedProcessor.duplicates(ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.delegationTargets(annotationReference))), (Functions.Function1)_function));
                int _length_1 = ((Object[])Conversions.unwrapArray(containedDuplicates, Object.class)).length;
                boolean bl = _greaterThan = _length_1 > 0;
                if (_greaterThan) {
                    Consumer<Type> _function_1 = it -> {
                        Expression _delegationTargetsExpression = this.delegationTargetsExpression(annotation);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Type ");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(" is listet multiple times.");
                        this.context.addWarning((Element)_delegationTargetsExpression, _builder.toString());
                    };
                    containedDuplicates.forEach(_function_1);
                }
                Functions.Function1 _function_2 = it -> it.getType();
                List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.delegationTargets(annotationReference))), (Functions.Function1)_function_2);
                HashSet annotatedTypes = new HashSet(_map);
                HashSet duplicates = ContexedProcessor.intersect(usedTypes.keySet(), annotatedTypes);
                int _length_2 = ((Object[])Conversions.unwrapArray(duplicates, Object.class)).length;
                boolean bl2 = _equals = _length_2 == 0;
                if (_equals) {
                    validAnnotations.add(annotationReference);
                } else {
                    Consumer<Type> _function_3 = type -> {
                        Set _get = (Set)usedTypes.get(type);
                        Functions.Function1 _function_4 = it -> this.delegationTargetsExpression((AnnotationReference)it);
                        Consumer<Expression> _function_5 = it -> {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("The type ");
                            String _simpleName = type.getSimpleName();
                            _builder.append(_simpleName);
                            _builder.append(" is also used in another @");
                            String _simpleName_1 = StaticDelegate.class.getSimpleName();
                            _builder.append(_simpleName_1);
                            _builder.append(" annotation.");
                            this.context.addError((Element)it, _builder.toString());
                        };
                        IterableExtensions.map((Iterable)Iterables.concat((Iterable)_get, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AnnotationReference[]{annotation}))), (Functions.Function1)_function_4).forEach(_function_5);
                    };
                    duplicates.forEach(_function_3);
                }
                Consumer<Type> _function_4 = type -> {
                    BiFunction<Type, Set, Set> _function_5 = (k, set) -> {
                        Set _xblockexpression_1 = null;
                        set.add(annotation);
                        _xblockexpression_1 = set;
                        return _xblockexpression_1;
                    };
                    usedTypes.computeIfPresent(type, _function_5);
                    HashSet _hashSet = new HashSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AnnotationReference[]{annotation})));
                    usedTypes.putIfAbsent(type, _hashSet);
                };
                annotatedTypes.forEach(_function_4);
            }
            _xblockexpression = validAnnotations;
            return _xblockexpression;
        }

        private ArrayList<AnnotationReference> checkForSelfReference(Iterable<? extends AnnotationReference> annotations, MutableTypeDeclaration annotatedType) {
            ArrayList<AnnotationReference> _xblockexpression = null;
            int _length = ((Object[])Conversions.unwrapArray(annotations, Object.class)).length;
            ArrayList<AnnotationReference> validAnnotations = new ArrayList<AnnotationReference>(_length);
            for (AnnotationReference annotationReference : annotations) {
                Functions.Function1 _function = it -> it.getType();
                boolean _contains = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.delegationTargets(annotationReference))), (Functions.Function1)_function).contains(annotatedType);
                if (_contains) {
                    Expression _expression = annotationReference.getExpression("value");
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("A type cannot export its own methods. Remove the type ");
                    String _simpleName = annotatedType.getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" from the list.");
                    this.context.addError((Element)_expression, _builder.toString());
                    continue;
                }
                validAnnotations.add(annotationReference);
            }
            _xblockexpression = validAnnotations;
            return _xblockexpression;
        }

        private static <T> HashSet<T> duplicates(Iterable<T> iterable) {
            HashSet<T> _xblockexpression = null;
            int _length = ((Object[])Conversions.unwrapArray(iterable, Object.class)).length;
            HashSet<T> seen = new HashSet<T>(_length);
            HashSet<T> duplicates = new HashSet<T>();
            for (T value : iterable) {
                boolean _contains = seen.contains(value);
                if (_contains) {
                    duplicates.add(value);
                    continue;
                }
                seen.add(value);
            }
            _xblockexpression = duplicates;
            return _xblockexpression;
        }

        private static <T> HashSet<T> intersect(Set<T> a, Set<T> b) {
            HashSet<T> _xblockexpression = null;
            HashSet<T> copyOfA = new HashSet<T>(a);
            copyOfA.retainAll(b);
            _xblockexpression = copyOfA;
            return _xblockexpression;
        }

        private boolean isAccessibleFrom(MethodDeclaration method, MutableTypeDeclaration type) {
            return !(Objects.equal((Object)method.getVisibility(), (Object)org.eclipse.xtend.lib.macro.declaration.Visibility.PRIVATE) && !Objects.equal((Object)method.getDeclaringType(), (Object)type) || Objects.equal((Object)method.getVisibility(), (Object)org.eclipse.xtend.lib.macro.declaration.Visibility.DEFAULT) && !this.isInSamePackageAs((NamedElement)method, (NamedElement)type));
        }

        private boolean isInSamePackageAs(NamedElement thiz, NamedElement reference) {
            String _packageName = thiz.getCompilationUnit().getPackageName();
            String _packageName_1 = reference.getCompilationUnit().getPackageName();
            return Objects.equal((Object)_packageName, (Object)_packageName_1);
        }

        private Iterable<? extends AnnotationReference> findAllAnnotations(AnnotationTarget target, Type annotationType) {
            Functions.Function1 _function = it -> {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                return Objects.equal((Object)_annotationTypeDeclaration, (Object)annotationType);
            };
            return IterableExtensions.filter((Iterable)target.getAnnotations(), (Functions.Function1)_function);
        }

        private boolean isAsVisibleAsAs(MethodDeclaration thiz, MethodDeclaration reference) {
            return this.isAsVisibleAs(reference.getDeclaringType(), thiz.getDeclaringType()) && (this.isPublic((MemberDeclaration)reference) || this.isSamePackageVisible((MemberDeclaration)thiz, (MemberDeclaration)reference));
        }

        private boolean isAsVisibleAs(TypeDeclaration thiz, TypeDeclaration reference) {
            return this.isPublic((MemberDeclaration)reference) || this.isSamePackageVisible((MemberDeclaration)thiz, (MemberDeclaration)reference);
        }

        private boolean isPublic(MemberDeclaration declaration) {
            org.eclipse.xtend.lib.macro.declaration.Visibility _visibility = declaration.getVisibility();
            return Objects.equal((Object)_visibility, (Object)org.eclipse.xtend.lib.macro.declaration.Visibility.PUBLIC);
        }

        private boolean isSamePackageVisible(MemberDeclaration thiz, MemberDeclaration reference) {
            return Objects.equal((Object)reference.getVisibility(), (Object)org.eclipse.xtend.lib.macro.declaration.Visibility.DEFAULT) && Objects.equal((Object)thiz.getVisibility(), (Object)org.eclipse.xtend.lib.macro.declaration.Visibility.DEFAULT) && this.isInSamePackageAs((NamedElement)reference, (NamedElement)thiz);
        }

        private TypeReference[] delegationTargets(AnnotationReference annotation) {
            TypeReference[] _xblockexpression = null;
            TypeReference[] value = annotation.getClassArrayValue("value");
            TypeReference[] _xifexpression = null;
            int _length = value.length;
            boolean _greaterThan = _length > 0;
            _xifexpression = _greaterThan ? value : annotation.getClassArrayValue("delegationTargets");
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private Expression delegationTargetsExpression(AnnotationReference annotation) {
            Expression _xblockexpression = null;
            TypeReference[] value = annotation.getClassArrayValue("value");
            Expression _xifexpression = null;
            _xifexpression = value != null && value.length > 0 ? annotation.getExpression("value") : annotation.getExpression("delegationTargets");
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public ContexedProcessor(TransformationContext context) {
            this.context = context;
        }
    }
}

