/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util;

import edu.kit.ipd.sdq.activextendannotations.Utility;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

@Utility
public final class URIUtil {
    public static boolean existsResourceAtUri(URI uri) {
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            boolean _isPlatformPlugin = uri.isPlatformPlugin();
            if (_isPlatformPlugin) {
                throw new UnsupportedOperationException();
            }
            return URIUtil.getIFileForEMFUri(uri).exists();
        }
        boolean _isFile = uri.isFile();
        if (_isFile) {
            String _fileString = uri.toFileString();
            return new File(_fileString).exists();
        }
        throw new UnsupportedOperationException("Checking if a resource at an URI exists is currently only implemented for file and platform URIs.");
    }

    public static IFile getIFileForEMFUri(URI uri) {
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            IPath path = URIUtil.getIPathForEMFUri(uri);
            boolean _isPlatformPlugin = uri.isPlatformPlugin();
            if (_isPlatformPlugin) {
                throw new UnsupportedOperationException();
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        throw new UnsupportedOperationException("Getting the IFile is currently only implemented for platform URIs.");
    }

    public static IPath getIPathForEMFUri(URI uri) {
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            String _platformString = uri.toPlatformString(true);
            return new Path(_platformString);
        }
        boolean _isFile = uri.isFile();
        if (_isFile) {
            String _fileString = uri.toFileString();
            return new Path(_fileString);
        }
        throw new UnsupportedOperationException("Getting the path is currently only implemented for file and platform URIs.");
    }

    public static boolean isPathmap(URI uri) {
        return uri.toString().startsWith("pathmap");
    }

    public static URI createFileURI(File file) {
        return URI.createFileURI((String)file.getAbsolutePath());
    }

    public static URI createPlatformResourceURI(IResource iResource) {
        IPath _fullPath = iResource.getFullPath();
        String _string = null;
        if (_fullPath != null) {
            _string = _fullPath.toString();
        }
        return URI.createPlatformResourceURI((String)_string, (boolean)true);
    }

    private URIUtil() {
    }
}

