package edu.kit.ipd.sdq.commons.util.java.lang

import edu.kit.ipd.sdq.activextendannotations.Utility

/**
 * A utility class providing extension methods for Objects
 */
@Utility
class ObjectUtil {
    def static <T> T invokeDeclaredMethodWithoutParameters(Object object, String methodName, Class<T> returnType) {
    	val classWithMethod = object.getClass()
    	var T castedResult
    	try {
    		val declaredMethod = classWithMethod.getDeclaredMethod(methodName)
    		declaredMethod.setAccessible(true)
			val result = declaredMethod.invoke(object)
			castedResult = returnType.cast(result)
		} catch (Exception e) {
			// soften
			throw new RuntimeException("Could not invoke method '" + methodName + "' without parameters on '" + object + "'!", e)
		}
    	return castedResult
    }
}