/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.common.elements.ElementsFactory;
import tools.vitruv.dsls.reactions.builder.FluentBuilderContext;
import tools.vitruv.dsls.reactions.builder.FluentReactionsSegmentBuilder;
import tools.vitruv.dsls.reactions.builder.FluentReactionsSegmentChildBuilder;
import tools.vitruv.dsls.reactions.builder.FluentRoutineBuilder;
import tools.vitruv.dsls.reactions.builder.TypeProvider;
import tools.vitruv.dsls.reactions.language.ElementChangeType;
import tools.vitruv.dsls.reactions.language.ElementInsertionInListChangeType;
import tools.vitruv.dsls.reactions.language.ElementRemovalFromListChangeType;
import tools.vitruv.dsls.reactions.language.ElementReplacementChangeType;
import tools.vitruv.dsls.reactions.language.LanguageFactory;
import tools.vitruv.dsls.reactions.language.ModelAttributeInsertedChange;
import tools.vitruv.dsls.reactions.language.ModelAttributeRemovedChange;
import tools.vitruv.dsls.reactions.language.ModelAttributeReplacedChange;
import tools.vitruv.dsls.reactions.language.ModelElementChange;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.RoutineCall;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsFactory;
import tools.vitruv.dsls.reactions.language.toplevelelements.Trigger;

public class FluentReactionBuilder
extends FluentReactionsSegmentChildBuilder {
    private Reaction reaction;
    private int anonymousRoutineCounter = 0;
    private EClassifier valueType;
    private EClass affectedObjectType;

    FluentReactionBuilder(Reaction reaction, FluentBuilderContext context) {
        super(context);
        this.reaction = reaction;
    }

    FluentReactionBuilder(String reactionName, FluentBuilderContext context) {
        super(context);
        Reaction _doubleArrow;
        Reaction _createReaction = TopLevelElementsFactory.eINSTANCE.createReaction();
        Procedures.Procedure1 _function = it -> it.setName(reactionName);
        this.reaction = _doubleArrow = (Reaction)ObjectExtensions.operator_doubleArrow((Object)_createReaction, (Procedures.Procedure1)_function);
    }

    OverrideOrTriggerBuilder start() {
        return new OverrideOrTriggerBuilder(this);
    }

    @Override
    protected void attachmentPreparation() {
        super.attachmentPreparation();
        Trigger _trigger = this.reaction.getTrigger();
        boolean _tripleNotEquals = _trigger != null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("No trigger was set on the ");
        _builder.append((Object)this);
        _builder.append("!");
        Preconditions.checkState((boolean)_tripleNotEquals, (Object)_builder);
        RoutineCall _callRoutine = this.reaction.getCallRoutine();
        boolean _tripleNotEquals_1 = _callRoutine != null;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("No routine call was set on the ");
        _builder_1.append((Object)this);
        _builder_1.append("!");
        Preconditions.checkState((boolean)_tripleNotEquals_1, (Object)_builder_1);
    }

    Reaction getReaction() {
        return this.reaction;
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("reaction builder for \u201c");
        String _name = this.reaction.getName();
        _builder.append(_name);
        _builder.append("\u201d");
        return _builder.toString();
    }

    @Override
    protected String getCreatedElementName() {
        return this.reaction.getName();
    }

    @Override
    protected String getCreatedElementType() {
        return "reaction";
    }

    public FluentReactionBuilder call(FluentRoutineBuilder[] routineBuilders) {
        return new RoutineCallBuilder(this).call(routineBuilders);
    }

    public FluentReactionBuilder call(FluentRoutineBuilder routineBuilder, FluentRoutineBuilder.RoutineCallParameter ... parameters) {
        return new RoutineCallBuilder(this).call(routineBuilder, parameters);
    }

    public FluentReactionBuilder call(String routineName, Consumer<FluentRoutineBuilder.RoutineStartBuilder> routineInitializer) {
        return new RoutineCallBuilder(this).call(routineName, routineInitializer);
    }

    public FluentReactionBuilder call(Consumer<FluentRoutineBuilder.RoutineStartBuilder> routineInitializer) {
        return new RoutineCallBuilder(this).call(routineInitializer);
    }

    public static class OverrideOrTriggerBuilder
    extends TriggerBuilder {
        private OverrideOrTriggerBuilder(FluentReactionBuilder builder) {
            super(builder);
        }

        public TriggerBuilder overrideSegment(FluentReactionsSegmentBuilder segmentBuilder) {
            TriggerBuilder _xblockexpression = null;
            ReactionsSegment _segment = null;
            if (segmentBuilder != null) {
                _segment = segmentBuilder.getSegment();
            }
            this.builder.reaction.setOverriddenReactionsSegment(_segment);
            _xblockexpression = new TriggerBuilder(this.builder);
            return _xblockexpression;
        }
    }

    public static class RoutineCallBuilder {
        @Extension
        protected final FluentReactionBuilder builder;

        private RoutineCallBuilder(FluentReactionBuilder builder) {
            this.builder = builder;
        }

        public FluentReactionBuilder call(FluentRoutineBuilder[] routineBuilders) {
            Preconditions.checkNotNull((Object)routineBuilders);
            int _length = routineBuilders.length;
            boolean _greaterThan = _length > 0;
            Preconditions.checkArgument((boolean)_greaterThan, (Object)"Must provide at least one routineBuilder!");
            for (FluentRoutineBuilder routineBuilder : routineBuilders) {
                this.call(routineBuilder, new FluentRoutineBuilder.RoutineCallParameter[0]);
            }
            return this.builder;
        }

        public FluentReactionBuilder call(FluentRoutineBuilder routineBuilder, FluentRoutineBuilder.RoutineCallParameter ... parameters) {
            Preconditions.checkNotNull((Object)routineBuilder);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ");
            _builder.append((Object)routineBuilder);
            _builder.append(" is not sufficiently initialised to be set on the ");
            _builder.append((Object)this.builder);
            Preconditions.checkState((boolean)routineBuilder.readyToBeAttached, (Object)_builder);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The ");
            _builder_1.append((Object)routineBuilder);
            _builder_1.append(" requires a new value, but the ");
            _builder_1.append((Object)this.builder);
            _builder_1.append(" doesn\u2019t create one!");
            Preconditions.checkState((!routineBuilder.requireNewValue || this.builder.valueType != null ? 1 : 0) != 0, (Object)_builder_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("The ");
            _builder_2.append((Object)routineBuilder);
            _builder_2.append(" requires an old value, but the ");
            _builder_2.append((Object)this.builder);
            _builder_2.append(" doesn\u2019t create one!");
            Preconditions.checkState((!routineBuilder.requireOldValue || this.builder.valueType != null ? 1 : 0) != 0, (Object)_builder_2);
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("The ");
            _builder_3.append((Object)routineBuilder);
            _builder_3.append(" requires an affectedElement, but the ");
            _builder_3.append((Object)this.builder);
            _builder_3.append(" doesn\u2019t create one!");
            Preconditions.checkState((!routineBuilder.requireAffectedEObject || this.builder.affectedObjectType != null ? 1 : 0) != 0, (Object)_builder_3);
            if (this.builder.affectedObjectType != null && routineBuilder.requireAffectedEObject) {
                routineBuilder.setAffectedObjectType(this.builder.affectedObjectType);
            }
            if (this.builder.valueType != null && (routineBuilder.requireNewValue || routineBuilder.requireOldValue)) {
                routineBuilder.setValueType(this.builder.valueType);
            }
            this.builder.transferReactionsSegmentTo(this.builder, routineBuilder);
            this.addRoutineCall(routineBuilder, parameters);
            this.builder.readyToBeAttached = true;
            return this.builder;
        }

        private Boolean addRoutineCall(FluentRoutineBuilder routineBuilder, FluentRoutineBuilder.RoutineCallParameter ... parameters) {
            boolean _tripleEquals;
            boolean _xifexpression = false;
            RoutineCall _callRoutine = this.builder.reaction.getCallRoutine();
            boolean bl = _tripleEquals = _callRoutine == null;
            if (_tripleEquals) {
                RoutineCall _createRoutineCall = TopLevelElementsFactory.eINSTANCE.createRoutineCall();
                Procedures.Procedure1 _function = it -> it.setCode((XExpression)this.routineCall((RoutineCall)it, routineBuilder, parameters));
                RoutineCall _doubleArrow = (RoutineCall)ObjectExtensions.operator_doubleArrow((Object)_createRoutineCall, (Procedures.Procedure1)_function);
                this.builder.reaction.setCallRoutine(_doubleArrow);
            } else {
                boolean _xblockexpression = false;
                RoutineCall callRoutine = this.builder.reaction.getCallRoutine();
                XExpression callRoutineCode = callRoutine.getCode();
                boolean _xifexpression_1 = false;
                if (callRoutineCode instanceof XBlockExpression) {
                    EList _expressions = ((XBlockExpression)callRoutineCode).getExpressions();
                    XFeatureCall _routineCall = this.routineCall(callRoutine, routineBuilder, parameters);
                    _xifexpression_1 = _expressions.add((Object)_routineCall);
                } else {
                    RoutineCall _callRoutine_1 = this.builder.reaction.getCallRoutine();
                    XBlockExpression _createXBlockExpression = XbaseFactory.eINSTANCE.createXBlockExpression();
                    Procedures.Procedure1 _function_1 = it -> {
                        EList _expressions_1 = it.getExpressions();
                        _expressions_1.add((Object)callRoutineCode);
                        EList _expressions_2 = it.getExpressions();
                        XFeatureCall _routineCall_1 = this.routineCall(callRoutine, routineBuilder, parameters);
                        _expressions_2.add((Object)_routineCall_1);
                    };
                    XBlockExpression _doubleArrow_1 = (XBlockExpression)ObjectExtensions.operator_doubleArrow((Object)_createXBlockExpression, (Procedures.Procedure1)_function_1);
                    _callRoutine_1.setCode((XExpression)_doubleArrow_1);
                }
                _xifexpression = _xblockexpression = _xifexpression_1;
            }
            return _xifexpression;
        }

        public FluentReactionBuilder call(String routineName, Consumer<FluentRoutineBuilder.RoutineStartBuilder> routineInitializer) {
            FluentReactionBuilder _xblockexpression = null;
            FluentRoutineBuilder routineBuilder = new FluentRoutineBuilder(routineName, this.builder.context);
            routineInitializer.accept(routineBuilder.start());
            _xblockexpression = this.call(routineBuilder, new FluentRoutineBuilder.RoutineCallParameter[0]);
            return _xblockexpression;
        }

        public FluentReactionBuilder call(Consumer<FluentRoutineBuilder.RoutineStartBuilder> routineInitializer) {
            FluentReactionBuilder _xblockexpression = null;
            ++this.builder.anonymousRoutineCounter;
            StringConcatenation _builder = new StringConcatenation();
            String _firstLower = StringExtensions.toFirstLower((String)this.builder.reaction.getName());
            _builder.append(_firstLower);
            _builder.append("Repair");
            if (this.builder.anonymousRoutineCounter != 1) {
                _builder.append("anonymousRoutineCounter");
            }
            _xblockexpression = this.call(_builder.toString(), routineInitializer);
            return _xblockexpression;
        }

        private XFeatureCall routineCall(RoutineCall routineCall, FluentRoutineBuilder routineBuilder, FluentRoutineBuilder.RoutineCallParameter ... parameters) {
            XFeatureCall _createXFeatureCall = XbaseFactory.eINSTANCE.createXFeatureCall();
            Procedures.Procedure1 _function = it -> it.setExplicitOperationCall(true);
            Consumer<XFeatureCall> _function_1 = it -> {
                it.setFeature((JvmIdentifiableElement)routineBuilder.getJvmOperation());
                it.setImplicitReceiver((XExpression)this.builder.getJvmOperationRoutineFacade((XExpression)it));
                TypeProvider typeProvider = this.builder.getTypeProvider((XExpression)it);
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)parameters)));
                if (_isNullOrEmpty) {
                    EList _featureCallArguments = it.getFeatureCallArguments();
                    List<XExpression> _requiredArguments = this.requiredArguments(routineBuilder, typeProvider);
                    Iterables.addAll((Collection)_featureCallArguments, _requiredArguments);
                } else {
                    EList _featureCallArguments_1 = it.getFeatureCallArguments();
                    Functions.Function1 _function_2 = it_1 -> it_1.getExpression(typeProvider);
                    List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)parameters)), (Functions.Function1)_function_2);
                    Iterables.addAll((Collection)_featureCallArguments_1, (Iterable)_map);
                }
            };
            return this.builder.whenJvmTypes((XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createXFeatureCall, (Procedures.Procedure1)_function), _function_1);
        }

        private List<XExpression> requiredArguments(FluentRoutineBuilder routineBuilder, TypeProvider typeProvider) {
            ArrayList<XExpression> parameterList = new ArrayList<XExpression>(3);
            if (routineBuilder.requireAffectedEObject) {
                XFeatureCall _affectedEObject = typeProvider.affectedEObject();
                parameterList.add((XExpression)_affectedEObject);
            }
            if (routineBuilder.requireNewValue) {
                XFeatureCall _newValue = typeProvider.newValue();
                parameterList.add((XExpression)_newValue);
            }
            if (routineBuilder.requireOldValue) {
                XFeatureCall _oldValue = typeProvider.oldValue();
                parameterList.add((XExpression)_oldValue);
            }
            return parameterList;
        }
    }

    public static class PreconditionOrRoutineCallBuilder
    extends RoutineCallBuilder {
        private PreconditionOrRoutineCallBuilder(FluentReactionBuilder builder) {
            super(builder);
        }

        public RoutineCallBuilder with(Function<TypeProvider, XExpression> expressionProvider) {
            Trigger _trigger = this.builder.reaction.getTrigger();
            Consumer<XBlockExpression> _function = it -> {
                EList _expressions = it.getExpressions();
                List<XExpression> _extractExpressions = FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)expressionProvider.apply(this.builder.getTypeProvider((XExpression)it)));
                Iterables.addAll((Collection)_expressions, _extractExpressions);
            };
            _trigger.setPrecondition((XExpression)this.builder.whenJvmTypes(XbaseFactory.eINSTANCE.createXBlockExpression(), _function));
            return new RoutineCallBuilder(this.builder);
        }
    }

    public static class ChangeTypeBuilder {
        @Extension
        private final FluentReactionBuilder builder;
        private final ModelElementChange modelElementChange;
        private final EClass element;

        private ChangeTypeBuilder(FluentReactionBuilder builder, ModelElementChange modelElementChange, EClass element) {
            this.builder = builder;
            this.modelElementChange = modelElementChange;
            this.element = element;
        }

        public PreconditionOrRoutineCallBuilder created() {
            EClass _eObject;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eObject = EcorePackage.eINSTANCE.getEObject());
            this.builder.affectedObjectType = _elvis;
            _xblockexpression = this.continueWithChangeType(LanguageFactory.eINSTANCE.createElementCreationChangeType());
            return _xblockexpression;
        }

        public PreconditionOrRoutineCallBuilder deleted() {
            EClass _eObject;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eObject = EcorePackage.eINSTANCE.getEObject());
            this.builder.affectedObjectType = _elvis;
            _xblockexpression = this.continueWithChangeType(LanguageFactory.eINSTANCE.createElementDeletionChangeType());
            return _xblockexpression;
        }

        public PreconditionOrRoutineCallBuilder insertedAsRoot() {
            EClass _eObject;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eObject = EcorePackage.eINSTANCE.getEObject());
            this.builder.valueType = _elvis;
            _xblockexpression = this.continueWithChangeType(LanguageFactory.eINSTANCE.createElementInsertionAsRootChangeType());
            return _xblockexpression;
        }

        public PreconditionOrRoutineCallBuilder insertedIn(EReference reference) {
            return this.insertedIn(reference.getEContainingClass(), reference);
        }

        public PreconditionOrRoutineCallBuilder insertedIn(EClass eClass, EReference reference) {
            EClass _eReferenceType;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eReferenceType = reference.getEReferenceType());
            this.builder.valueType = _elvis;
            this.builder.affectedObjectType = eClass;
            ElementInsertionInListChangeType _createElementInsertionInListChangeType = LanguageFactory.eINSTANCE.createElementInsertionInListChangeType();
            Procedures.Procedure1 _function = it -> it.setFeature(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassEReferenceReference(), eClass, reference));
            ElementInsertionInListChangeType _doubleArrow = (ElementInsertionInListChangeType)ObjectExtensions.operator_doubleArrow((Object)_createElementInsertionInListChangeType, (Procedures.Procedure1)_function);
            _xblockexpression = this.continueWithChangeType(_doubleArrow);
            return _xblockexpression;
        }

        public PreconditionOrRoutineCallBuilder removedFrom(EReference reference) {
            return this.removedFrom(reference.getEContainingClass(), reference);
        }

        public PreconditionOrRoutineCallBuilder removedFrom(EClass eClass, EReference reference) {
            EClass _eReferenceType;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eReferenceType = reference.getEReferenceType());
            this.builder.valueType = _elvis;
            this.builder.affectedObjectType = eClass;
            ElementRemovalFromListChangeType _createElementRemovalFromListChangeType = LanguageFactory.eINSTANCE.createElementRemovalFromListChangeType();
            Procedures.Procedure1 _function = it -> it.setFeature(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassEReferenceReference(), eClass, reference));
            ElementRemovalFromListChangeType _doubleArrow = (ElementRemovalFromListChangeType)ObjectExtensions.operator_doubleArrow((Object)_createElementRemovalFromListChangeType, (Procedures.Procedure1)_function);
            _xblockexpression = this.continueWithChangeType(_doubleArrow);
            return _xblockexpression;
        }

        public PreconditionOrRoutineCallBuilder removedAsRoot() {
            EClass _eObject;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eObject = EcorePackage.eINSTANCE.getEObject());
            this.builder.valueType = _elvis;
            _xblockexpression = this.continueWithChangeType(LanguageFactory.eINSTANCE.createElementRemovalAsRootChangeType());
            return _xblockexpression;
        }

        public PreconditionOrRoutineCallBuilder replacedAt(EReference reference) {
            return this.replacedAt(reference.getEContainingClass(), reference);
        }

        public PreconditionOrRoutineCallBuilder replacedAt(EClass eClass, EReference reference) {
            EClass _eReferenceType;
            PreconditionOrRoutineCallBuilder _xblockexpression = null;
            EClass _elvis = null;
            _elvis = this.element != null ? this.element : (_eReferenceType = reference.getEReferenceType());
            this.builder.valueType = _elvis;
            this.builder.affectedObjectType = eClass;
            ElementReplacementChangeType _createElementReplacementChangeType = LanguageFactory.eINSTANCE.createElementReplacementChangeType();
            Procedures.Procedure1 _function = it -> it.setFeature(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassEReferenceReference(), eClass, reference));
            ElementReplacementChangeType _doubleArrow = (ElementReplacementChangeType)ObjectExtensions.operator_doubleArrow((Object)_createElementReplacementChangeType, (Procedures.Procedure1)_function);
            _xblockexpression = this.continueWithChangeType(_doubleArrow);
            return _xblockexpression;
        }

        private PreconditionOrRoutineCallBuilder continueWithChangeType(ElementChangeType changeType) {
            this.modelElementChange.setChangeType(changeType);
            return new PreconditionOrRoutineCallBuilder(this.builder);
        }
    }

    public static class TriggerBuilder {
        @Extension
        protected final FluentReactionBuilder builder;

        private TriggerBuilder(FluentReactionBuilder builder) {
            this.builder = builder;
        }

        public PreconditionOrRoutineCallBuilder afterAnyChange() {
            this.builder.reaction.setTrigger(LanguageFactory.eINSTANCE.createArbitraryModelChange());
            return new PreconditionOrRoutineCallBuilder(this.builder);
        }

        public ChangeTypeBuilder afterElement(EClass element) {
            ModelElementChange _createModelElementChange = LanguageFactory.eINSTANCE.createModelElementChange();
            Procedures.Procedure1 _function = it -> it.setElementType(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassReference(), element));
            ModelElementChange change = (ModelElementChange)ObjectExtensions.operator_doubleArrow((Object)_createModelElementChange, (Procedures.Procedure1)_function);
            this.builder.reaction.setTrigger(change);
            return new ChangeTypeBuilder(this.builder, change, element);
        }

        public ChangeTypeBuilder afterElement() {
            ModelElementChange change = LanguageFactory.eINSTANCE.createModelElementChange();
            this.builder.reaction.setTrigger(change);
            return new ChangeTypeBuilder(this.builder, change, null);
        }

        public PreconditionOrRoutineCallBuilder afterAttributeInsertIn(EAttribute attribute) {
            return this.afterAttributeInsertIn(attribute.getEContainingClass(), attribute);
        }

        public PreconditionOrRoutineCallBuilder afterAttributeInsertIn(EClass eClass, EAttribute attribute) {
            this.builder.valueType = attribute.getEType();
            this.builder.affectedObjectType = eClass;
            ModelAttributeInsertedChange _createModelAttributeInsertedChange = LanguageFactory.eINSTANCE.createModelAttributeInsertedChange();
            Procedures.Procedure1 _function = it -> it.setFeature(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassEAttributeReference(), eClass, attribute));
            ModelAttributeInsertedChange _doubleArrow = (ModelAttributeInsertedChange)ObjectExtensions.operator_doubleArrow((Object)_createModelAttributeInsertedChange, (Procedures.Procedure1)_function);
            this.builder.reaction.setTrigger(_doubleArrow);
            return new PreconditionOrRoutineCallBuilder(this.builder);
        }

        public PreconditionOrRoutineCallBuilder afterAttributeReplacedAt(EAttribute attribute) {
            return this.afterAttributeReplacedAt(attribute.getEContainingClass(), attribute);
        }

        public PreconditionOrRoutineCallBuilder afterAttributeReplacedAt(EClass eClass, EAttribute attribute) {
            this.builder.valueType = attribute.getEType();
            this.builder.affectedObjectType = eClass;
            ModelAttributeReplacedChange _createModelAttributeReplacedChange = LanguageFactory.eINSTANCE.createModelAttributeReplacedChange();
            Procedures.Procedure1 _function = it -> it.setFeature(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassEAttributeReference(), eClass, attribute));
            ModelAttributeReplacedChange _doubleArrow = (ModelAttributeReplacedChange)ObjectExtensions.operator_doubleArrow((Object)_createModelAttributeReplacedChange, (Procedures.Procedure1)_function);
            this.builder.reaction.setTrigger(_doubleArrow);
            return new PreconditionOrRoutineCallBuilder(this.builder);
        }

        public PreconditionOrRoutineCallBuilder afterAttributeRemoveFrom(EAttribute attribute) {
            return this.afterAttributeRemoveFrom(attribute.getEContainingClass(), attribute);
        }

        public PreconditionOrRoutineCallBuilder afterAttributeRemoveFrom(EClass eClass, EAttribute attribute) {
            this.builder.valueType = attribute.getEType();
            this.builder.affectedObjectType = eClass;
            ModelAttributeRemovedChange _createModelAttributeRemovedChange = LanguageFactory.eINSTANCE.createModelAttributeRemovedChange();
            Procedures.Procedure1 _function = it -> it.setFeature(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassEAttributeReference(), eClass, attribute));
            ModelAttributeRemovedChange _doubleArrow = (ModelAttributeRemovedChange)ObjectExtensions.operator_doubleArrow((Object)_createModelAttributeRemovedChange, (Procedures.Procedure1)_function);
            this.builder.reaction.setTrigger(_doubleArrow);
            return new PreconditionOrRoutineCallBuilder(this.builder);
        }
    }
}

