/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;
import tools.vitruv.dsls.common.elements.ElementsFactory;
import tools.vitruv.dsls.common.elements.MetaclassEAttributeReference;
import tools.vitruv.dsls.common.elements.MetaclassEReferenceReference;
import tools.vitruv.dsls.common.elements.MetaclassReference;
import tools.vitruv.dsls.common.elements.MetamodelImport;
import tools.vitruv.dsls.reactions.builder.FluentBuilderContext;
import tools.vitruv.dsls.reactions.language.toplevelelements.NamedJavaElementReference;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsFile;

abstract class FluentReactionElementBuilder {
    private final PatientList<Runnable> beforeAttached = new PatientList();
    private final PatientList<Runnable> afterJvmTypeCreation = new PatientList();
    protected final FluentBuilderContext context;
    protected boolean readyToBeAttached = false;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    protected boolean jvmTypesAvailable = false;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final PatientList<FluentReactionElementBuilder> childBuilders = new PatientList();
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private ReactionsFile attachedReactionsFile;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private Resource targetResource;

    protected FluentReactionElementBuilder(FluentBuilderContext context) {
        this.context = context;
    }

    public boolean willGenerateCode() {
        Functions.Function1 _function = it -> it.willGenerateCode();
        return IterableExtensions.exists(this.childBuilders, (Functions.Function1)_function);
    }

    void triggerBeforeAttached(ReactionsFile reactionsFile, Resource targetResource) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The ");
        _builder.append((Object)this);
        _builder.append(" was already attached to a reactions file!");
        Preconditions.checkState((this.attachedReactionsFile == null ? 1 : 0) != 0, (Object)_builder);
        Consumer<FluentReactionElementBuilder> _function = it -> it.triggerBeforeAttached(reactionsFile, targetResource);
        this.childBuilders.patientForEach(_function);
        this.attachedReactionsFile = reactionsFile;
        this.targetResource = targetResource;
        this.attachmentPreparation();
        Consumer<Runnable> _function_1 = it -> it.run();
        this.beforeAttached.patientForEach(_function_1);
        this.beforeAttached.discardAndClose();
    }

    void triggerAfterJvmTypeCreation() {
        Preconditions.checkState((this.attachedReactionsFile != null ? 1 : 0) != 0, (Object)"This builder was not yet attached to a reactions file!");
        this.jvmTypesAvailable = true;
        Consumer<FluentReactionElementBuilder> _function = it -> it.triggerAfterJvmTypeCreation();
        this.childBuilders.patientForEach(_function);
        this.childBuilders.discardAndClose();
        Consumer<Runnable> _function_1 = it -> it.run();
        this.afterJvmTypeCreation.patientForEach(_function_1);
        this.afterJvmTypeCreation.discardAndClose();
    }

    protected void checkNotYetAttached() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This operation is only allowed before the ");
        _builder.append((Object)this);
        _builder.append(" is attached to a resource!");
        Preconditions.checkState((this.attachedReactionsFile == null ? 1 : 0) != 0, (Object)_builder);
    }

    protected void attachmentPreparation() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The ");
        _builder.append((Object)this);
        _builder.append(" is not sufficiently initialised to be attached to a resource!");
        Preconditions.checkState((boolean)this.readyToBeAttached, (Object)_builder);
    }

    protected <T> T beforeAttached(T element, Consumer<? super T> initializer) {
        T _xblockexpression = null;
        Runnable _function = () -> initializer.accept((Object)element);
        this.beforeAttached.add(_function);
        _xblockexpression = element;
        return _xblockexpression;
    }

    protected <T> T whenJvmTypes(T element, Consumer<? super T> initializer) {
        T _xblockexpression = null;
        Runnable _function = () -> initializer.accept((Object)element);
        this.afterJvmTypeCreation.add(_function);
        _xblockexpression = element;
        return _xblockexpression;
    }

    protected IJvmTypeProvider delegateTypeProvider() {
        return this.context.getTypeProviderFactory().findOrCreateTypeProvider(this.attachedReactionsFile.eResource().getResourceSet());
    }

    protected JvmTypeReferenceBuilder referenceBuilderFactory() {
        return this.context.getReferenceBuilderFactory().create(this.attachedReactionsFile.eResource().getResourceSet());
    }

    private <T extends JvmDeclaredType> boolean equalImportTypes(T importedType, T type) {
        String _qualifiedName = importedType.getQualifiedName();
        String _qualifiedName_1 = type.getQualifiedName();
        return Objects.equals(_qualifiedName, _qualifiedName_1);
    }

    protected <T extends JvmDeclaredType> T imported(T type) {
        XImportDeclaration _createTypeImport;
        XImportDeclaration _elvis = null;
        Functions.Function1 _function = it -> this.equalImportTypes(it.getImportedType(), type);
        XImportDeclaration _findFirst = (XImportDeclaration)IterableExtensions.findFirst((Iterable)this.getXImportSection().getImportDeclarations(), (Functions.Function1)_function);
        _elvis = _findFirst != null ? _findFirst : (_createTypeImport = this.createTypeImport(type));
        return type;
    }

    protected <T extends JvmIdentifiableElement> T possiblyImported(T type) {
        boolean _matched = false;
        if (type instanceof JvmDeclaredType) {
            _matched = true;
            this.imported((JvmDeclaredType)type);
        }
        if (!_matched && type instanceof JvmMember) {
            _matched = true;
            this.imported(((JvmMember)type).getDeclaringType());
        }
        return type;
    }

    protected JvmDeclaredType staticExtensionAllImported(JvmDeclaredType declaredType) {
        XImportDeclaration _createTypeWildcardImport;
        XImportDeclaration _elvis = null;
        Functions.Function1 _function = it -> it.isWildcard() && this.equalImportTypes(it.getImportedType(), declaredType);
        XImportDeclaration _findFirst = (XImportDeclaration)IterableExtensions.findFirst((Iterable)this.getXImportSection().getImportDeclarations(), (Functions.Function1)_function);
        _elvis = _findFirst != null ? _findFirst : (_createTypeWildcardImport = this.createTypeWildcardImport(declaredType));
        Procedures.Procedure1 _function_1 = it -> it.setExtension(true);
        ObjectExtensions.operator_doubleArrow((Object)_elvis, (Procedures.Procedure1)_function_1);
        return declaredType;
    }

    protected JvmOperation staticExtensionImported(JvmOperation operation) {
        return this.staticImport(operation, true);
    }

    protected JvmOperation staticExtensionWildcardImported(JvmOperation operation) {
        this.staticExtensionAllImported(operation.getDeclaringType());
        return operation;
    }

    protected JvmOperation staticImported(JvmOperation operation) {
        return this.staticImport(operation, false);
    }

    private JvmOperation staticImport(JvmOperation operation, boolean asExtension) {
        Functions.Function1 _function = it -> it.isWildcard() && this.equalImportTypes(it.getImportedType(), operation.getDeclaringType());
        XImportDeclaration existingStarImport = (XImportDeclaration)IterableExtensions.findFirst((Iterable)this.getXImportSection().getImportDeclarations(), (Functions.Function1)_function);
        if (existingStarImport != null) {
            existingStarImport.setExtension(existingStarImport.isExtension() || asExtension);
        } else {
            XImportDeclaration _createStaticOperationImport;
            XImportDeclaration _elvis = null;
            Functions.Function1 _function_1 = it -> this.equalImportTypes(it.getImportedType(), operation.getDeclaringType()) && Objects.equals(it.getMemberName(), operation.getSimpleName()) && it.isStatic();
            XImportDeclaration _findFirst = (XImportDeclaration)IterableExtensions.findFirst((Iterable)this.getXImportSection().getImportDeclarations(), (Functions.Function1)_function_1);
            _elvis = _findFirst != null ? _findFirst : (_createStaticOperationImport = this.createStaticOperationImport(operation));
            Procedures.Procedure1 _function_2 = it -> it.setExtension(it.isExtension() || asExtension);
            ObjectExtensions.operator_doubleArrow((Object)_elvis, (Procedures.Procedure1)_function_2);
        }
        return operation;
    }

    private XImportDeclaration createStaticOperationImport(JvmOperation operation) {
        XImportDeclaration _createXImportDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        Procedures.Procedure1 _function = it -> {
            it.setImportedType(operation.getDeclaringType());
            it.setMemberName(operation.getSimpleName());
            it.setStatic(true);
            EList _importDeclarations = this.getXImportSection().getImportDeclarations();
            _importDeclarations.add(it);
        };
        return (XImportDeclaration)ObjectExtensions.operator_doubleArrow((Object)_createXImportDeclaration, (Procedures.Procedure1)_function);
    }

    private XImportDeclaration createTypeWildcardImport(JvmDeclaredType type) {
        XImportDeclaration _createXImportDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        Procedures.Procedure1 _function = it -> {
            it.setImportedType(type);
            it.setStatic(true);
            it.setWildcard(true);
        };
        XImportDeclaration newDeclaration = (XImportDeclaration)ObjectExtensions.operator_doubleArrow((Object)_createXImportDeclaration, (Procedures.Procedure1)_function);
        EList _importDeclarations = this.getXImportSection().getImportDeclarations();
        ArrayList oldImports = new ArrayList(_importDeclarations);
        this.getXImportSection().getImportDeclarations().clear();
        EList _importDeclarations_1 = this.getXImportSection().getImportDeclarations();
        Functions.Function1 _function_1 = it -> !it.isStatic() || !this.equalImportTypes(it.getImportedType(), type);
        Iterable _filter = IterableExtensions.filter(oldImports, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)_importDeclarations_1, (Iterable)_filter);
        EList _importDeclarations_2 = this.getXImportSection().getImportDeclarations();
        _importDeclarations_2.add((Object)newDeclaration);
        return newDeclaration;
    }

    private XImportDeclaration createTypeImport(JvmDeclaredType type) {
        XImportDeclaration _createXImportDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        Procedures.Procedure1 _function = it -> {
            it.setImportedType(type);
            EList _importDeclarations = this.getXImportSection().getImportDeclarations();
            _importDeclarations.add(it);
        };
        return (XImportDeclaration)ObjectExtensions.operator_doubleArrow((Object)_createXImportDeclaration, (Procedures.Procedure1)_function);
    }

    private XImportSection getXImportSection() {
        XImportSection _createXImportSection;
        XImportSection _elvis = null;
        XImportSection _namespaceImports = this.attachedReactionsFile.getNamespaceImports();
        _elvis = _namespaceImports != null ? _namespaceImports : (_createXImportSection = XtypeFactory.eINSTANCE.createXImportSection());
        Procedures.Procedure1 _function = it -> this.attachedReactionsFile.setNamespaceImports((XImportSection)it);
        return (XImportSection)ObjectExtensions.operator_doubleArrow((Object)_elvis, (Procedures.Procedure1)_function);
    }

    protected MetamodelImport metamodelImport(EPackage ePackage) {
        MetamodelImport _createMetamodelImport;
        MetamodelImport _xblockexpression = null;
        Preconditions.checkState((this.attachedReactionsFile != null && !this.jvmTypesAvailable ? 1 : 0) != 0, (Object)"Metamodel imports can only be created in the attachment preparation phase!");
        MetamodelImport _elvis = null;
        Functions.Function1 _function = it -> {
            EPackage _package = it.getPackage();
            return Objects.equals(_package, ePackage);
        };
        MetamodelImport _findFirst = (MetamodelImport)IterableExtensions.findFirst(this.attachedReactionsFile.getMetamodelImports(), (Functions.Function1)_function);
        _elvis = _findFirst != null ? _findFirst : (_createMetamodelImport = this.createMetamodelImport(ePackage));
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    protected MetamodelImport metamodelImport(EPackage ePackage, String pname) {
        MetamodelImport _xblockexpression = null;
        Preconditions.checkState((this.attachedReactionsFile != null && !this.jvmTypesAvailable ? 1 : 0) != 0, (Object)"Metamodel imports can only be created in the attachment preparation phase!");
        _xblockexpression = this.createMetamodelImport(ePackage, ePackage.getName());
        return _xblockexpression;
    }

    private MetamodelImport createMetamodelImport(EPackage ePackage) {
        return this.createMetamodelImport(ePackage, ePackage.getName());
    }

    private MetamodelImport createMetamodelImport(EPackage ePackage, String pname) {
        MetamodelImport _createMetamodelImport = ElementsFactory.eINSTANCE.createMetamodelImport();
        Procedures.Procedure1 _function = it -> {
            it.setPackage(ePackage);
            it.setName(pname);
        };
        MetamodelImport newImport = (MetamodelImport)ObjectExtensions.operator_doubleArrow((Object)_createMetamodelImport, (Procedures.Procedure1)_function);
        EList<MetamodelImport> _metamodelImports = this.attachedReactionsFile.getMetamodelImports();
        _metamodelImports.add((Object)newImport);
        return newImport;
    }

    protected <T extends MetaclassReference> T reference(T metaclassReference, EClass eClass) {
        Procedures.Procedure1 _function = it -> it.setMetaclass((EClassifier)eClass);
        Consumer<MetaclassReference> _function_1 = it -> it.setMetamodel(this.metamodelImport(eClass.getEPackage()));
        return (T)this.beforeAttached((MetaclassReference)ObjectExtensions.operator_doubleArrow(metaclassReference, (Procedures.Procedure1)_function), _function_1);
    }

    protected <T extends MetaclassEReferenceReference> T reference(T referenceReference, EClass eClass, EReference reference) {
        Procedures.Procedure1 _function = it -> {
            it.setFeature(reference);
            it.setMetaclass((EClassifier)eClass);
        };
        Consumer<MetaclassEReferenceReference> _function_1 = it -> it.setMetamodel(this.metamodelImport(eClass.getEPackage()));
        return (T)this.beforeAttached((MetaclassEReferenceReference)ObjectExtensions.operator_doubleArrow(referenceReference, (Procedures.Procedure1)_function), _function_1);
    }

    protected <T extends MetaclassEAttributeReference> T reference(T attributeReference, EClass eClass, EAttribute attribute) {
        Procedures.Procedure1 _function = it -> {
            it.setFeature(attribute);
            it.setMetaclass((EClassifier)eClass);
        };
        Consumer<MetaclassEAttributeReference> _function_1 = it -> it.setMetamodel(this.metamodelImport(eClass.getEPackage()));
        return (T)this.beforeAttached((MetaclassEAttributeReference)ObjectExtensions.operator_doubleArrow(attributeReference, (Procedures.Procedure1)_function), _function_1);
    }

    protected <T extends NamedJavaElementReference> T reference(T javaElementReference, Class<?> clazz) {
        Consumer<NamedJavaElementReference> _function = it -> it.setType(this.context.getTypeReferences().getTypeForName(clazz, (Notifier)this.targetResource, new JvmTypeReference[0]));
        return (T)this.beforeAttached(javaElementReference, _function);
    }

    @Pure
    protected boolean getJvmTypesAvailable() {
        return this.jvmTypesAvailable;
    }

    @Pure
    protected PatientList<FluentReactionElementBuilder> getChildBuilders() {
        return this.childBuilders;
    }

    @Pure
    protected ReactionsFile getAttachedReactionsFile() {
        return this.attachedReactionsFile;
    }

    @Pure
    protected Resource getTargetResource() {
        return this.targetResource;
    }

    static class PatientList<T>
    implements List<T> {
        @Delegate
        private List<T> delegate = new LinkedList<T>();

        PatientList() {
        }

        public void patientForEach(Consumer<T> consumer) {
            List<T> allList = this.delegate;
            while (this.delegate.size() > 0) {
                List<T> fromLastIteration = this.delegate;
                LinkedList<T> _linkedList = new LinkedList<T>();
                this.delegate = _linkedList;
                fromLastIteration.forEach(consumer);
                Iterables.addAll(allList, this.delegate);
            }
            this.delegate = allList;
        }

        public void discardAndClose() {
            this.delegate = Collections.emptyList();
        }

        @Override
        public boolean add(T arg0) {
            return this.delegate.add(arg0);
        }

        @Override
        public void add(int arg0, T arg1) {
            this.delegate.add(arg0, arg1);
        }

        @Override
        public boolean addAll(Collection<? extends T> arg0) {
            return this.delegate.addAll(arg0);
        }

        @Override
        public boolean addAll(int arg0, Collection<? extends T> arg1) {
            return this.delegate.addAll(arg0, arg1);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object arg0) {
            return this.delegate.contains(arg0);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.delegate.containsAll(arg0);
        }

        @Override
        public void forEach(Consumer<? super T> arg0) {
            this.delegate.forEach(arg0);
        }

        @Override
        public T get(int arg0) {
            return this.delegate.get(arg0);
        }

        @Override
        public int indexOf(Object arg0) {
            return this.delegate.indexOf(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public int lastIndexOf(Object arg0) {
            return this.delegate.lastIndexOf(arg0);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int arg0) {
            return this.delegate.listIterator(arg0);
        }

        @Override
        public Stream<T> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public boolean remove(Object arg0) {
            return this.delegate.remove(arg0);
        }

        @Override
        public T remove(int arg0) {
            return this.delegate.remove(arg0);
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return this.delegate.removeAll(arg0);
        }

        @Override
        public boolean removeIf(Predicate<? super T> arg0) {
            return this.delegate.removeIf(arg0);
        }

        @Override
        public void replaceAll(UnaryOperator<T> arg0) {
            this.delegate.replaceAll(arg0);
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return this.delegate.retainAll(arg0);
        }

        @Override
        public T set(int arg0, T arg1) {
            return this.delegate.set(arg0, arg1);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void sort(Comparator<? super T> arg0) {
            this.delegate.sort(arg0);
        }

        @Override
        public Spliterator<T> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public Stream<T> stream() {
            return this.delegate.stream();
        }

        @Override
        public List<T> subList(int arg0, int arg1) {
            return this.delegate.subList(arg0, arg1);
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> arg0) {
            return this.delegate.toArray(arg0);
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.delegate.toArray(arg0);
        }
    }
}

