/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.builder;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.dsls.common.elements.MetaclassReference;
import tools.vitruv.dsls.reactions.builder.FluentBuilderContext;
import tools.vitruv.dsls.reactions.builder.FluentReactionBuilder;
import tools.vitruv.dsls.reactions.builder.FluentReactionsFileBuilder;
import tools.vitruv.dsls.reactions.builder.FluentReactionsSegmentBuilder;
import tools.vitruv.dsls.reactions.builder.FluentRoutineBuilder;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsFactory;

@Singleton
public class FluentReactionsLanguageBuilder {
    @Inject
    private static FluentBuilderContext context;

    public FluentReactionsFileBuilder reactionsFile(String name) {
        return new FluentReactionsFileBuilder(name, context).start();
    }

    public FluentReactionsSegmentBuilder.ReactionsSegmentSourceBuilder reactionsSegment(String name) {
        return new FluentReactionsSegmentBuilder(name, context).start();
    }

    public FluentRoutineBuilder.RoutineStartBuilder routine(String name) {
        return new FluentRoutineBuilder(name, context).start();
    }

    public ExistingRoutineBuilder from(Routine routine, Consumer<FluentRoutineBuilder.InputBuilder> inputBuilder) {
        return new ExistingRoutineBuilder(routine, inputBuilder, context);
    }

    public ExistingRoutineBuilder from(Routine routine) {
        return new ExistingRoutineBuilder(routine, context);
    }

    public FluentReactionBuilder.OverrideOrTriggerBuilder reaction(String name) {
        return new FluentReactionBuilder(name, context).start();
    }

    public ExistingReactionBuilder from(Reaction reaction) {
        return new ExistingReactionBuilder(reaction, context);
    }

    public static class ExistingRoutineBuilder
    extends FluentRoutineBuilder {
        public ExistingRoutineBuilder(Routine routine, Consumer<FluentRoutineBuilder.InputBuilder> inputBuilder, FluentBuilderContext context) {
            super(null, context);
            this.routine = routine;
            this.routine.setInput(TopLevelElementsFactory.eINSTANCE.createRoutineInput());
            this.start().input(inputBuilder);
            this.init();
        }

        public ExistingRoutineBuilder(Routine routine, FluentBuilderContext context) {
            super(null, context);
            this.routine = routine;
            this.init();
        }

        private void init() {
            this.readyToBeAttached = true;
            TreeIterator contents = EcoreUtil.getAllContents(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{this.routine})));
            Functions.Function1 _function = it -> it instanceof MetaclassReference;
            Procedures.Procedure1 _function_1 = it -> {
                MetaclassReference ref = (MetaclassReference)it;
                EClassifier _metaclass = ref.getMetaclass();
                this.reference(ref, (EClass)_metaclass);
            };
            IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)contents, (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
        }
    }

    public static class ExistingReactionBuilder
    extends FluentReactionBuilder {
        public ExistingReactionBuilder(Reaction reaction, FluentBuilderContext context) {
            super(reaction, context);
            this.readyToBeAttached = true;
        }
    }
}

