/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import tools.vitruv.dsls.common.elements.MetamodelImport;
import tools.vitruv.dsls.reactions.builder.FluentBuilderContext;
import tools.vitruv.dsls.reactions.builder.FluentReactionBuilder;
import tools.vitruv.dsls.reactions.builder.FluentReactionElementBuilder;
import tools.vitruv.dsls.reactions.builder.FluentReactionsSegmentChildBuilder;
import tools.vitruv.dsls.reactions.builder.FluentRoutineBuilder;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsImport;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsFactory;

@Accessors(value={AccessorType.PACKAGE_GETTER})
public class FluentReactionsSegmentBuilder
extends FluentReactionElementBuilder {
    private final ReactionsSegment segment;

    FluentReactionsSegmentBuilder(String segmentName, FluentBuilderContext context) {
        super(context);
        ReactionsSegment _doubleArrow;
        ReactionsSegment _createReactionsSegment = TopLevelElementsFactory.eINSTANCE.createReactionsSegment();
        Procedures.Procedure1 _function = it -> it.setName(segmentName);
        this.segment = _doubleArrow = (ReactionsSegment)ObjectExtensions.operator_doubleArrow((Object)_createReactionsSegment, (Procedures.Procedure1)_function);
    }

    ReactionsSegmentSourceBuilder start() {
        return new ReactionsSegmentSourceBuilder(this);
    }

    @Override
    protected void attachmentPreparation() {
        super.attachmentPreparation();
        int _size = this.segment.getRoutines().size();
        int _size_1 = this.segment.getReactions().size();
        int _plus = _size + _size_1;
        int _size_2 = this.segment.getReactionsImports().size();
        int _plus_1 = _plus + _size_2;
        boolean _greaterThan = _plus_1 > 0;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Neither routines, nor reactions, nor imports were added to the reaction segment ");
        String _name = this.segment.getName();
        _builder.append(_name);
        _builder.append("!");
        Preconditions.checkState((boolean)_greaterThan, (Object)_builder);
    }

    public ReactionsSegmentImportBuilder importSegment(FluentReactionsSegmentBuilder reactionsSegmentBuilder) {
        return new ReactionsSegmentImportBuilder(this, reactionsSegmentBuilder);
    }

    public FluentReactionsSegmentBuilder operator_add(FluentReactionBuilder[] reactionBuilders) {
        FluentReactionsSegmentBuilder _xblockexpression = null;
        Consumer<FluentReactionBuilder> _function = it -> this.operator_add((FluentReactionBuilder)it);
        ((List)Conversions.doWrapArray((Object)reactionBuilders)).forEach(_function);
        _xblockexpression = this;
        return _xblockexpression;
    }

    public FluentReactionsSegmentBuilder operator_add(FluentRoutineBuilder[] routineBuilders) {
        FluentReactionsSegmentBuilder _xblockexpression = null;
        Consumer<FluentRoutineBuilder> _function = it -> this.operator_add((FluentRoutineBuilder)it);
        ((List)Conversions.doWrapArray((Object)routineBuilders)).forEach(_function);
        _xblockexpression = this;
        return _xblockexpression;
    }

    protected FluentReactionsSegmentBuilder _add(FluentReactionBuilder reactionBuilder) {
        return this.operator_add(reactionBuilder);
    }

    protected FluentReactionsSegmentBuilder _add(FluentRoutineBuilder routineBuilder) {
        return this.operator_add(routineBuilder);
    }

    public FluentReactionsSegmentBuilder operator_add(FluentReactionBuilder reactionBuilder) {
        boolean _tripleNotEquals;
        FluentReactionsSegmentBuilder _xblockexpression = null;
        this.checkNotYetAttached();
        FluentReactionsSegmentBuilder _segmentBuilder = reactionBuilder.getSegmentBuilder();
        boolean bl = _tripleNotEquals = _segmentBuilder != this;
        if (_tripleNotEquals) {
            FluentReactionsSegmentBuilder _segmentBuilder_1 = reactionBuilder.getSegmentBuilder();
            boolean _tripleEquals = _segmentBuilder_1 == null;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ");
            _builder.append((Object)reactionBuilder);
            _builder.append(" has already been added to the ");
            FluentReactionsSegmentBuilder _segmentBuilder_2 = reactionBuilder.getSegmentBuilder();
            _builder.append((Object)_segmentBuilder_2);
            Preconditions.checkArgument((boolean)_tripleEquals, (Object)_builder);
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                String _name_1 = reactionBuilder.getReaction().getName();
                return Objects.equals(_name, _name_1);
            };
            boolean _exists = IterableExtensions.exists(this.segment.getReactions(), (Functions.Function1)_function);
            boolean _not = !_exists;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The ");
            _builder_1.append((Object)this);
            _builder_1.append(" already contains a reaction with name '");
            String _name = reactionBuilder.getReaction().getName();
            _builder_1.append(_name);
            _builder_1.append("'!");
            Preconditions.checkArgument((boolean)_not, (Object)_builder_1);
            EList<Reaction> _reactions = this.segment.getReactions();
            Reaction _reaction = reactionBuilder.getReaction();
            _reactions.add((Object)_reaction);
            reactionBuilder.setSegmentBuilder(this);
            FluentReactionElementBuilder.PatientList<FluentReactionElementBuilder> _childBuilders = this.getChildBuilders();
            _childBuilders.add(reactionBuilder);
        }
        _xblockexpression = this;
        return _xblockexpression;
    }

    public FluentReactionsSegmentBuilder operator_add(FluentRoutineBuilder routineBuilder) {
        boolean _tripleNotEquals;
        FluentReactionsSegmentBuilder _xblockexpression = null;
        this.checkNotYetAttached();
        FluentReactionsSegmentBuilder _segmentBuilder = routineBuilder.getSegmentBuilder();
        boolean bl = _tripleNotEquals = _segmentBuilder != this;
        if (_tripleNotEquals) {
            FluentReactionsSegmentBuilder _segmentBuilder_1 = routineBuilder.getSegmentBuilder();
            boolean _tripleEquals = _segmentBuilder_1 == null;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ");
            _builder.append((Object)routineBuilder);
            _builder.append(" has already been added to the ");
            FluentReactionsSegmentBuilder _segmentBuilder_2 = routineBuilder.getSegmentBuilder();
            _builder.append((Object)_segmentBuilder_2);
            Preconditions.checkArgument((boolean)_tripleEquals, (Object)_builder);
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                String _name_1 = routineBuilder.routine.getName();
                return Objects.equals(_name, _name_1);
            };
            boolean _exists = IterableExtensions.exists(this.segment.getRoutines(), (Functions.Function1)_function);
            boolean _not = !_exists;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The ");
            _builder_1.append((Object)this);
            _builder_1.append(" already contains a routine with name '");
            String _name = routineBuilder.routine.getName();
            _builder_1.append(_name);
            _builder_1.append("'!");
            Preconditions.checkArgument((boolean)_not, (Object)_builder_1);
            EList<Routine> _routines = this.segment.getRoutines();
            _routines.add((Object)routineBuilder.routine);
            routineBuilder.setSegmentBuilder(this);
            FluentReactionElementBuilder.PatientList<FluentReactionElementBuilder> _childBuilders = this.getChildBuilders();
            _childBuilders.add(routineBuilder);
        }
        _xblockexpression = this;
        return _xblockexpression;
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("reaction segment builder for \u201c");
        String _name = this.segment.getName();
        _builder.append(_name);
        _builder.append("\u201d");
        return _builder.toString();
    }

    @XbaseGenerated
    public FluentReactionsSegmentBuilder add(FluentReactionsSegmentChildBuilder reactionBuilder) {
        if (reactionBuilder instanceof FluentReactionBuilder) {
            return this._add((FluentReactionBuilder)reactionBuilder);
        }
        if (reactionBuilder instanceof FluentRoutineBuilder) {
            return this._add((FluentRoutineBuilder)reactionBuilder);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(reactionBuilder).toString());
    }

    @Pure
    ReactionsSegment getSegment() {
        return this.segment;
    }

    public static class ReactionsSegmentSourceBuilder {
        @Extension
        private final FluentReactionsSegmentBuilder builder;

        private ReactionsSegmentSourceBuilder(FluentReactionsSegmentBuilder builder) {
            this.builder = builder;
        }

        public ReactionsSegmentTargetBuilder inReactionToChangesIn(EPackage sourceMetamodelRootPackage) {
            return this.inReactionToChangesIn(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EPackage[]{sourceMetamodelRootPackage})));
        }

        public ReactionsSegmentTargetBuilder inReactionToChangesIn(Set<EPackage> sourceMetamodelRootPackages) {
            ReactionsSegmentTargetBuilder _xblockexpression = null;
            Consumer<ReactionsSegmentSourceBuilder> _function = it -> {
                EList<MetamodelImport> _fromMetamodels = this.builder.segment.getFromMetamodels();
                Functions.Function1 _function_1 = it_1 -> this.builder.metamodelImport((EPackage)it_1);
                Iterable _map = IterableExtensions.map((Iterable)sourceMetamodelRootPackages, (Functions.Function1)_function_1);
                Iterables.addAll(_fromMetamodels, (Iterable)_map);
            };
            this.builder.beforeAttached(this, _function);
            _xblockexpression = new ReactionsSegmentTargetBuilder(this.builder);
            return _xblockexpression;
        }
    }

    public static class ReactionsSegmentImportBuilder {
        @Extension
        private final FluentReactionsSegmentBuilder builder;
        private final ReactionsImport reactionsImport;

        private ReactionsSegmentImportBuilder(FluentReactionsSegmentBuilder builder, FluentReactionsSegmentBuilder reactionsSegmentBuilder) {
            ReactionsImport _doubleArrow;
            this.builder = builder;
            ReactionsImport _createReactionsImport = TopLevelElementsFactory.eINSTANCE.createReactionsImport();
            Procedures.Procedure1 _function = it -> it.setImportedReactionsSegment(reactionsSegmentBuilder.segment);
            this.reactionsImport = _doubleArrow = (ReactionsImport)ObjectExtensions.operator_doubleArrow((Object)_createReactionsImport, (Procedures.Procedure1)_function);
            EList<ReactionsImport> _reactionsImports = builder.segment.getReactionsImports();
            _reactionsImports.add((Object)this.reactionsImport);
        }

        public ReactionsSegmentImportBuilder routinesOnly() {
            ReactionsSegmentImportBuilder _xblockexpression = null;
            this.reactionsImport.setRoutinesOnly(true);
            _xblockexpression = this;
            return _xblockexpression;
        }

        public FluentReactionsSegmentBuilder usingQualifiedRoutineNames() {
            FluentReactionsSegmentBuilder _xblockexpression = null;
            this.reactionsImport.setUseQualifiedNames(true);
            _xblockexpression = this.builder;
            return _xblockexpression;
        }

        public FluentReactionsSegmentBuilder usingSimpleRoutineNames() {
            FluentReactionsSegmentBuilder _xblockexpression = null;
            this.reactionsImport.setUseQualifiedNames(false);
            _xblockexpression = this.builder;
            return _xblockexpression;
        }
    }

    public static class ReactionsSegmentTargetBuilder {
        @Extension
        private final FluentReactionsSegmentBuilder builder;

        private ReactionsSegmentTargetBuilder(FluentReactionsSegmentBuilder builder) {
            this.builder = builder;
        }

        public FluentReactionsSegmentBuilder executeActionsIn(EPackage targetMetamodelRootPackage) {
            return this.executeActionsIn(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EPackage[]{targetMetamodelRootPackage})));
        }

        public FluentReactionsSegmentBuilder executeActionsIn(Set<EPackage> targetMetamodelRootPackages) {
            FluentReactionsSegmentBuilder _xblockexpression = null;
            Consumer<ReactionsSegmentTargetBuilder> _function = it -> {
                EList<MetamodelImport> _toMetamodels = this.builder.segment.getToMetamodels();
                Functions.Function1 _function_1 = it_1 -> this.builder.metamodelImport((EPackage)it_1);
                Iterable _map = IterableExtensions.map((Iterable)targetMetamodelRootPackages, (Functions.Function1)_function_1);
                Iterables.addAll(_toMetamodels, (Iterable)_map);
            };
            this.builder.beforeAttached(this, _function);
            this.builder.readyToBeAttached = true;
            _xblockexpression = this.builder;
            return _xblockexpression;
        }
    }
}

