/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import tools.vitruv.dsls.common.elements.ElementsFactory;
import tools.vitruv.dsls.common.elements.NamedMetaclassReference;
import tools.vitruv.dsls.reactions.builder.FluentBuilderContext;
import tools.vitruv.dsls.reactions.builder.FluentReactionsSegmentBuilder;
import tools.vitruv.dsls.reactions.builder.FluentReactionsSegmentChildBuilder;
import tools.vitruv.dsls.reactions.builder.TypeProvider;
import tools.vitruv.dsls.reactions.language.LanguageFactory;
import tools.vitruv.dsls.reactions.language.MatchCheckStatement;
import tools.vitruv.dsls.reactions.language.RequireAbscenceOfModelElement;
import tools.vitruv.dsls.reactions.language.RetrieveModelElement;
import tools.vitruv.dsls.reactions.language.RetrieveOneModelElement;
import tools.vitruv.dsls.reactions.language.RetrieveOrRequireAbscenceOfModelElement;
import tools.vitruv.dsls.reactions.language.toplevelelements.MatchBlock;
import tools.vitruv.dsls.reactions.language.toplevelelements.MatchStatement;
import tools.vitruv.dsls.reactions.language.toplevelelements.NamedJavaElementReference;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.RoutineOverrideImportPath;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsFactory;
import tools.vitruv.dsls.reactions.language.toplevelelements.UpdateBlock;
import tools.vitruv.dsls.reactions.runtime.routines.AbstractRoutine;

public class FluentRoutineBuilder
extends FluentReactionsSegmentChildBuilder {
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    protected Routine routine;
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    protected boolean requireOldValue = false;
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    protected boolean requireNewValue = false;
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    protected boolean requireAffectedEObject = false;
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    protected boolean requireAffectedValue = false;
    private EClassifier valueType;
    private EClass affectedObjectType;

    FluentRoutineBuilder(String routineName, FluentBuilderContext context) {
        super(context);
        Routine _doubleArrow;
        Routine _createRoutine = TopLevelElementsFactory.eINSTANCE.createRoutine();
        Procedures.Procedure1 _function = it -> {
            it.setName(routineName);
            it.setInput(TopLevelElementsFactory.eINSTANCE.createRoutineInput());
        };
        this.routine = _doubleArrow = (Routine)ObjectExtensions.operator_doubleArrow((Object)_createRoutine, (Procedures.Procedure1)_function);
    }

    @Override
    protected void attachmentPreparation() {
        super.attachmentPreparation();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Although required, there was no value type set on the ");
        _builder.append((Object)this);
        Preconditions.checkState((!this.requireOldValue && !this.requireNewValue && !this.requireAffectedValue || this.valueType != null ? 1 : 0) != 0, (Object)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Although required, there was no affected object type set on the ");
        _builder_1.append((Object)this);
        Preconditions.checkState((!this.requireAffectedEObject || this.affectedObjectType != null ? 1 : 0) != 0, (Object)_builder_1);
        if (this.requireAffectedEObject) {
            this.addInputElementIfNotExists((EClassifier)this.affectedObjectType, "affectedEObject");
        }
        if (this.requireOldValue) {
            this.addInputElementIfNotExists(this.valueType, "oldValue");
        }
        if (this.requireNewValue) {
            this.addInputElementIfNotExists(this.valueType, "newValue");
        }
    }

    RoutineStartBuilder start() {
        return new RoutineStartBuilder(this);
    }

    private void addInputElementIfNotExists(EClassifier type, String parameterName) {
        boolean _tripleNotEquals;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, parameterName);
        };
        NamedMetaclassReference _findFirst = (NamedMetaclassReference)IterableExtensions.findFirst(this.routine.getInput().getModelInputElements(), (Functions.Function1)_function);
        boolean bl = _tripleNotEquals = _findFirst != null;
        if (_tripleNotEquals) {
            return;
        }
        this.addInputElement(type, parameterName);
    }

    private void _addInputElement(EClass type, String parameterName) {
        EList<NamedMetaclassReference> _modelInputElements = this.routine.getInput().getModelInputElements();
        NamedMetaclassReference _createNamedMetaclassReference = ElementsFactory.eINSTANCE.createNamedMetaclassReference();
        Procedures.Procedure1 _function = it -> it.setName(parameterName);
        NamedMetaclassReference _reference = this.reference((NamedMetaclassReference)ObjectExtensions.operator_doubleArrow((Object)_createNamedMetaclassReference, (Procedures.Procedure1)_function), type);
        _modelInputElements.add((Object)_reference);
    }

    private void _addInputElement(EDataType type, String parameterName) {
        this.addInputElement(type.getInstanceClass(), parameterName);
    }

    private void _addInputElement(Class<?> type, String parameterName) {
        EList<NamedJavaElementReference> _javaInputElements = this.routine.getInput().getJavaInputElements();
        NamedJavaElementReference _createNamedJavaElementReference = TopLevelElementsFactory.eINSTANCE.createNamedJavaElementReference();
        Procedures.Procedure1 _function = it -> it.setName(parameterName);
        NamedJavaElementReference _reference = this.reference((NamedJavaElementReference)ObjectExtensions.operator_doubleArrow((Object)_createNamedJavaElementReference, (Procedures.Procedure1)_function), type);
        _javaInputElements.add((Object)_reference);
    }

    void setValueType(EClassifier type) {
        boolean _isAssignableFrom;
        boolean _not;
        if (this.valueType == null) {
            this.valueType = type;
        }
        boolean bl = _not = !(_isAssignableFrom = FluentRoutineBuilder.isAssignableFrom(this.valueType, type));
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ");
            _builder.append((Object)this);
            _builder.append(" already has the value type \u201c");
            String _name = this.valueType.getName();
            _builder.append(_name);
            _builder.append("\u201d set, which is not a super type of \u201c");
            String _name_1 = type.getName();
            _builder.append(_name_1);
            _builder.append("\u201d. The value type can thus not be set to \u201c");
            String _name_2 = type.getName();
            _builder.append(_name_2);
            _builder.append("\u201d!");
            throw new IllegalStateException(_builder.toString());
        }
    }

    void setAffectedObjectType(EClass type) {
        boolean _isAssignableFrom;
        boolean _not;
        if (this.affectedObjectType == null) {
            this.affectedObjectType = type;
        }
        boolean bl = _not = !(_isAssignableFrom = FluentRoutineBuilder.isAssignableFrom((EClassifier)this.affectedObjectType, (EClassifier)type));
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ");
            _builder.append((Object)this);
            _builder.append(" already has the affected object type \u201c");
            String _name = this.affectedObjectType.getName();
            _builder.append(_name);
            _builder.append("\u201d set, which is not a super type of \u201c");
            String _name_1 = type.getName();
            _builder.append(_name_1);
            _builder.append("\u201d. The affected element type can thus not be set to \u201c");
            String _name_2 = type.getName();
            _builder.append(_name_2);
            _builder.append("\u201d!");
            throw new IllegalStateException(_builder.toString());
        }
    }

    protected static boolean _isAssignableFrom(EDataType a, EClass b) {
        return false;
    }

    protected static boolean _isAssignableFrom(EClass a, EDataType b) {
        return false;
    }

    protected static boolean _isAssignableFrom(EClass a, EClass b) {
        return EcoreUtil2.isAssignableFrom((EClass)a, (EClass)b);
    }

    protected static boolean _isAssignableFrom(EDataType a, EDataType b) {
        return a.getInstanceClass().isAssignableFrom(b.getInstanceClass());
    }

    private XFeatureCall existingElement(String name) {
        Consumer<XFeatureCall> _function = it -> it.setFeature((JvmIdentifiableElement)this.correspondingMethodParameter((XExpression)it, name));
        return this.whenJvmTypes(XbaseFactory.eINSTANCE.createXFeatureCall(), _function);
    }

    private XBlockExpression existingElement(Function<TypeProvider, XExpression> expressionBuilder) {
        Consumer<XBlockExpression> _function = it -> {
            EList _expressions = it.getExpressions();
            List<XExpression> _extractExpressions = FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)expressionBuilder.apply(this.getTypeProvider((XExpression)it)));
            Iterables.addAll((Collection)_expressions, _extractExpressions);
        };
        return this.whenJvmTypes(XbaseFactory.eINSTANCE.createXBlockExpression(), _function);
    }

    private XFeatureCall correspondingElement(String name) {
        Consumer<XFeatureCall> _function = it -> it.setFeature((JvmIdentifiableElement)this.correspondingMethodParameter((XExpression)it, name));
        return this.whenJvmTypes(XbaseFactory.eINSTANCE.createXFeatureCall(), _function);
    }

    private XBlockExpression correspondingElement(Function<TypeProvider, XExpression> expressionBuilder) {
        Consumer<XBlockExpression> _function = it -> {
            EList _expressions = it.getExpressions();
            List<XExpression> _extractExpressions = FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)expressionBuilder.apply(this.getTypeProvider((XExpression)it)));
            Iterables.addAll((Collection)_expressions, _extractExpressions);
        };
        return this.whenJvmTypes(XbaseFactory.eINSTANCE.createXBlockExpression(), _function);
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("routine builder for ");
        String _name = this.routine.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public JvmOperation getJvmOperation() {
        EObject jvmMethod = this.context.getJvmModelAssociator().getPrimaryJvmElement((EObject)this.routine);
        if (jvmMethod instanceof JvmOperation) {
            return (JvmOperation)jvmMethod;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Could not find the routine facade method corresponding to the routine \u201c");
        String _name = this.routine.getName();
        _builder.append(_name);
        _builder.append("\u201d");
        throw new IllegalStateException(_builder.toString());
    }

    @Override
    protected String getCreatedElementName() {
        return this.routine.getName();
    }

    @Override
    protected String getCreatedElementType() {
        return "routine";
    }

    @XbaseGenerated
    private void addInputElement(Object type, String parameterName) {
        if (type instanceof EClass) {
            this._addInputElement((EClass)type, parameterName);
            return;
        }
        if (type instanceof EDataType) {
            this._addInputElement((EDataType)type, parameterName);
            return;
        }
        if (type instanceof Class) {
            this._addInputElement((Class)type, parameterName);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, parameterName).toString());
    }

    @XbaseGenerated
    public static boolean isAssignableFrom(EClassifier a, EClassifier b) {
        if (a instanceof EClass && b instanceof EClass) {
            return FluentRoutineBuilder._isAssignableFrom((EClass)a, (EClass)b);
        }
        if (a instanceof EClass && b instanceof EDataType) {
            return FluentRoutineBuilder._isAssignableFrom((EClass)a, (EDataType)b);
        }
        if (a instanceof EDataType && b instanceof EClass) {
            return FluentRoutineBuilder._isAssignableFrom((EDataType)a, (EClass)b);
        }
        if (a instanceof EDataType && b instanceof EDataType) {
            return FluentRoutineBuilder._isAssignableFrom((EDataType)a, (EDataType)b);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, b).toString());
    }

    @Pure
    Routine getRoutine() {
        return this.routine;
    }

    @Pure
    boolean getRequireOldValue() {
        return this.requireOldValue;
    }

    @Pure
    boolean getRequireNewValue() {
        return this.requireNewValue;
    }

    @Pure
    boolean isRequireAffectedEObject() {
        return this.requireAffectedEObject;
    }

    @Pure
    boolean getRequireAffectedValue() {
        return this.requireAffectedValue;
    }

    public static class RoutineStartBuilder
    extends InputOrMatchBlockOrCreatorOrUpdateBuilder {
        private RoutineStartBuilder(FluentRoutineBuilder builder) {
            super(builder);
        }

        public FluentRoutineBuilder retrieveRoutineBuilder() {
            return this.builder;
        }

        public RoutineStartBuilder alwaysRequireAffectedEObject() {
            RoutineStartBuilder _xblockexpression = null;
            this.builder.requireAffectedEObject = true;
            _xblockexpression = this;
            return _xblockexpression;
        }

        public RoutineStartBuilder alwaysRequireNewValue() {
            RoutineStartBuilder _xblockexpression = null;
            this.builder.requireNewValue = true;
            _xblockexpression = this;
            return _xblockexpression;
        }

        public InputOrMatchBlockOrCreatorOrUpdateBuilder overrideAlongImportPath(FluentReactionsSegmentBuilder ... importPathSegmentBuilders) {
            boolean _not;
            InputOrMatchBlockOrCreatorOrUpdateBuilder _xblockexpression = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)importPathSegmentBuilders)));
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                RoutineOverrideImportPath currentImportPath = null;
                for (FluentReactionsSegmentBuilder pathSegmentBuilder : importPathSegmentBuilders) {
                    RoutineOverrideImportPath nextPathSegment = TopLevelElementsFactory.eINSTANCE.createRoutineOverrideImportPath();
                    nextPathSegment.setReactionsSegment(pathSegmentBuilder.getSegment());
                    nextPathSegment.setParent(currentImportPath);
                    currentImportPath = nextPathSegment;
                }
                this.builder.routine.setOverrideImportPath(currentImportPath);
            }
            _xblockexpression = new InputOrMatchBlockOrCreatorOrUpdateBuilder(this.builder);
            return _xblockexpression;
        }
    }

    public static class TagWithBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final XFeatureCall correspondenceCreation;

        private TagWithBuilder(FluentRoutineBuilder builder, XFeatureCall correspondenceCreation) {
            this.builder = builder;
            this.correspondenceCreation = correspondenceCreation;
        }

        public void taggedWithAnything() {
            EList _featureCallArguments = this.correspondenceCreation.getFeatureCallArguments();
            XNullLiteral _createXNullLiteral = XbaseFactory.eINSTANCE.createXNullLiteral();
            _featureCallArguments.add((Object)_createXNullLiteral);
        }

        public void taggedWith(String tag) {
            EList _featureCallArguments = this.correspondenceCreation.getFeatureCallArguments();
            XStringLiteral _createXStringLiteral = XbaseFactory.eINSTANCE.createXStringLiteral();
            Procedures.Procedure1 _function = it -> it.setValue(tag);
            XStringLiteral _doubleArrow = (XStringLiteral)ObjectExtensions.operator_doubleArrow((Object)_createXStringLiteral, (Procedures.Procedure1)_function);
            _featureCallArguments.add((Object)_doubleArrow);
        }

        public void taggedWith(Function<TypeProvider, XExpression> tagExpressionBuilder) {
            EList _featureCallArguments = this.correspondenceCreation.getFeatureCallArguments();
            Consumer<XBlockExpression> _function = it -> {
                EList _expressions = it.getExpressions();
                List<XExpression> _extractExpressions = FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)tagExpressionBuilder.apply(this.builder.getTypeProvider((XExpression)it)));
                Iterables.addAll((Collection)_expressions, _extractExpressions);
            };
            XBlockExpression _whenJvmTypes = this.builder.whenJvmTypes(XbaseFactory.eINSTANCE.createXBlockExpression(), _function);
            _featureCallArguments.add((Object)_whenJvmTypes);
        }
    }

    public static class CorrespondenceTargetBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final XFeatureCall statement;

        private CorrespondenceTargetBuilder(FluentRoutineBuilder builder, XFeatureCall statement) {
            this.builder = builder;
            this.statement = statement;
        }

        public CorrespondenceElementBuilder<TagWithBuilder> and() {
            CorrespondenceElementBuilder<TagWithBuilder> _xblockexpression = null;
            TagWithBuilder tagBuilder = new TagWithBuilder(this.builder, this.statement);
            Consumer<XExpression> _function = it -> this.setSecondElement(this.statement, (XExpression)it);
            _xblockexpression = new CorrespondenceElementBuilder<TagWithBuilder>(this.builder, tagBuilder, _function);
            return _xblockexpression;
        }

        public TagWithBuilder and(String existingElement) {
            TagWithBuilder _xblockexpression = null;
            this.setSecondElement(this.statement, (XExpression)this.builder.existingElement(existingElement));
            _xblockexpression = new TagWithBuilder(this.builder, this.statement);
            return _xblockexpression;
        }

        public TagWithBuilder and(Function<TypeProvider, XExpression> expressionBuilder) {
            TagWithBuilder _xblockexpression = null;
            this.setSecondElement(this.statement, (XExpression)this.builder.existingElement(expressionBuilder));
            _xblockexpression = new TagWithBuilder(this.builder, this.statement);
            return _xblockexpression;
        }

        private XFeatureCall setSecondElement(XFeatureCall correspondenceStatement, XExpression existingElement) {
            Procedures.Procedure1 _function = it -> {
                EList _featureCallArguments = it.getFeatureCallArguments();
                _featureCallArguments.add((Object)existingElement);
            };
            return (XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)correspondenceStatement, (Procedures.Procedure1)_function);
        }
    }

    public static class CorrespondenceElementBuilder<NextType> {
        @Extension
        private final FluentRoutineBuilder builder;
        private final Consumer<XExpression> elementConsumer;
        private final NextType next;

        private CorrespondenceElementBuilder(FluentRoutineBuilder builder, NextType next, Consumer<XExpression> elementConsumer) {
            this.builder = builder;
            this.elementConsumer = elementConsumer;
            this.next = next;
        }

        public NextType oldValue() {
            NextType _xblockexpression = null;
            this.builder.requireOldValue = true;
            this.elementConsumer.accept((XExpression)this.builder.existingElement("oldValue"));
            _xblockexpression = this.next;
            return _xblockexpression;
        }

        public NextType newValue() {
            NextType _xblockexpression = null;
            this.builder.requireNewValue = true;
            this.elementConsumer.accept((XExpression)this.builder.existingElement("newValue"));
            _xblockexpression = this.next;
            return _xblockexpression;
        }

        public NextType affectedEObject() {
            NextType _xblockexpression = null;
            this.builder.requireAffectedEObject = true;
            this.elementConsumer.accept((XExpression)this.builder.existingElement("affectedEObject"));
            _xblockexpression = this.next;
            return _xblockexpression;
        }
    }

    public static class RoutineCallParameter {
        private Object argument;

        public RoutineCallParameter(String parameter) {
            this.argument = parameter;
        }

        public RoutineCallParameter(XExpression expression) {
            this.argument = expression;
        }

        public RoutineCallParameter(Function<TypeProvider, XExpression> expressionBuilder) {
            this.argument = expressionBuilder;
        }

        public boolean isParameterArgumentType() {
            return this.argument instanceof String;
        }

        public XExpression getExpression(TypeProvider typeProvider) {
            boolean _isParameterArgumentType = this.isParameterArgumentType();
            if (_isParameterArgumentType) {
                return typeProvider.variable((String)this.argument);
            }
            if (this.argument instanceof XExpression) {
                return (XExpression)this.argument;
            }
            Function expressionBuilder = (Function)this.argument;
            return (XExpression)expressionBuilder.apply(typeProvider);
        }
    }

    public static class UpdateStatementBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final XBlockExpression expressionBlock;

        private UpdateStatementBuilder(FluentRoutineBuilder builder) {
            this.builder = builder;
            this.expressionBlock = XbaseFactory.eINSTANCE.createXBlockExpression();
            UpdateBlock _updateBlock = this.builder.routine.getUpdateBlock();
            _updateBlock.setCode((XExpression)this.expressionBlock);
        }

        public boolean delete(String existingElement) {
            boolean _xblockexpression = false;
            XFeatureCall _createXFeatureCall = XbaseFactory.eINSTANCE.createXFeatureCall();
            Procedures.Procedure1 _function = it -> it.setExplicitOperationCall(true);
            Consumer<XFeatureCall> _function_1 = it -> {
                it.setFeature((JvmIdentifiableElement)this.builder.getTypeProvider((XExpression)it).findMethod(AbstractRoutine.Update.class, "removeObject"));
                EList _featureCallArguments = it.getFeatureCallArguments();
                XFeatureCall _existingElement = this.builder.existingElement(existingElement);
                _featureCallArguments.add((Object)_existingElement);
            };
            XFeatureCall statement = this.builder.whenJvmTypes((XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createXFeatureCall, (Procedures.Procedure1)_function), _function_1);
            EList _expressions = this.expressionBlock.getExpressions();
            _xblockexpression = _expressions.add((Object)statement);
            return _xblockexpression;
        }

        public CorrespondenceElementBuilder<CorrespondenceTargetBuilder> addCorrespondenceBetween() {
            CorrespondenceElementBuilder<CorrespondenceTargetBuilder> _xblockexpression = null;
            XFeatureCall statement = this.createCorrespondenceMethodCall();
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)statement);
            CorrespondenceTargetBuilder _correspondenceTargetBuilder = new CorrespondenceTargetBuilder(this.builder, statement);
            Consumer<XExpression> _function = it -> statement.getFeatureCallArguments().add(0, it);
            _xblockexpression = new CorrespondenceElementBuilder<CorrespondenceTargetBuilder>(this.builder, _correspondenceTargetBuilder, _function);
            return _xblockexpression;
        }

        public CorrespondenceTargetBuilder addCorrespondenceBetween(String existingElement) {
            CorrespondenceTargetBuilder _xblockexpression = null;
            XFeatureCall _createCorrespondenceMethodCall = this.createCorrespondenceMethodCall();
            Procedures.Procedure1 _function = it -> {
                EList _featureCallArguments = it.getFeatureCallArguments();
                XFeatureCall _existingElement = this.builder.existingElement(existingElement);
                _featureCallArguments.add((Object)_existingElement);
            };
            XFeatureCall statement = (XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createCorrespondenceMethodCall, (Procedures.Procedure1)_function);
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)statement);
            _xblockexpression = new CorrespondenceTargetBuilder(this.builder, statement);
            return _xblockexpression;
        }

        public CorrespondenceTargetBuilder addCorrespondenceBetween(Function<TypeProvider, XExpression> expressionBuilder) {
            CorrespondenceTargetBuilder _xblockexpression = null;
            XFeatureCall _createCorrespondenceMethodCall = this.createCorrespondenceMethodCall();
            Procedures.Procedure1 _function = it -> {
                EList _featureCallArguments = it.getFeatureCallArguments();
                XBlockExpression _existingElement = this.builder.existingElement(expressionBuilder);
                _featureCallArguments.add((Object)_existingElement);
            };
            XFeatureCall statement = (XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createCorrespondenceMethodCall, (Procedures.Procedure1)_function);
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)statement);
            _xblockexpression = new CorrespondenceTargetBuilder(this.builder, statement);
            return _xblockexpression;
        }

        private XFeatureCall createCorrespondenceMethodCall() {
            XFeatureCall _createXFeatureCall = XbaseFactory.eINSTANCE.createXFeatureCall();
            Procedures.Procedure1 _function = it -> it.setExplicitOperationCall(true);
            Consumer<XFeatureCall> _function_1 = it -> it.setFeature((JvmIdentifiableElement)this.builder.getTypeProvider((XExpression)it).findMethod(AbstractRoutine.Update.class, "addCorrespondenceBetween"));
            return this.builder.whenJvmTypes((XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createXFeatureCall, (Procedures.Procedure1)_function), _function_1);
        }

        public CorrespondenceElementBuilder<CorrespondenceTargetBuilder> removeCorrespondenceBetween() {
            CorrespondenceElementBuilder<CorrespondenceTargetBuilder> _xblockexpression = null;
            XFeatureCall statement = this.deleteCorrespondenceMethodCall();
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)statement);
            CorrespondenceTargetBuilder _correspondenceTargetBuilder = new CorrespondenceTargetBuilder(this.builder, statement);
            Consumer<XExpression> _function = it -> {
                EList _featureCallArguments = statement.getFeatureCallArguments();
                _featureCallArguments.add(it);
            };
            _xblockexpression = new CorrespondenceElementBuilder<CorrespondenceTargetBuilder>(this.builder, _correspondenceTargetBuilder, _function);
            return _xblockexpression;
        }

        public CorrespondenceTargetBuilder removeCorrespondenceBetween(String existingElement) {
            CorrespondenceTargetBuilder _xblockexpression = null;
            XFeatureCall _deleteCorrespondenceMethodCall = this.deleteCorrespondenceMethodCall();
            Procedures.Procedure1 _function = it -> {
                EList _featureCallArguments = it.getFeatureCallArguments();
                XFeatureCall _existingElement = this.builder.existingElement(existingElement);
                _featureCallArguments.add((Object)_existingElement);
            };
            XFeatureCall statement = (XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_deleteCorrespondenceMethodCall, (Procedures.Procedure1)_function);
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)statement);
            _xblockexpression = new CorrespondenceTargetBuilder(this.builder, statement);
            return _xblockexpression;
        }

        public CorrespondenceTargetBuilder removeCorrespondenceBetween(Function<TypeProvider, XExpression> expressionBuilder) {
            CorrespondenceTargetBuilder _xblockexpression = null;
            XFeatureCall _deleteCorrespondenceMethodCall = this.deleteCorrespondenceMethodCall();
            Procedures.Procedure1 _function = it -> {
                EList _featureCallArguments = it.getFeatureCallArguments();
                XBlockExpression _existingElement = this.builder.existingElement(expressionBuilder);
                _featureCallArguments.add((Object)_existingElement);
            };
            XFeatureCall statement = (XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_deleteCorrespondenceMethodCall, (Procedures.Procedure1)_function);
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)statement);
            _xblockexpression = new CorrespondenceTargetBuilder(this.builder, statement);
            return _xblockexpression;
        }

        private XFeatureCall deleteCorrespondenceMethodCall() {
            XFeatureCall _createXFeatureCall = XbaseFactory.eINSTANCE.createXFeatureCall();
            Procedures.Procedure1 _function = it -> it.setExplicitOperationCall(true);
            Consumer<XFeatureCall> _function_1 = it -> it.setFeature((JvmIdentifiableElement)this.builder.getTypeProvider((XExpression)it).findMethod(AbstractRoutine.Update.class, "removeCorrespondenceBetween"));
            return this.builder.whenJvmTypes((XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createXFeatureCall, (Procedures.Procedure1)_function), _function_1);
        }

        public XExpression execute(Function<TypeProvider, XExpression> expressionBuilder) {
            XBlockExpression placeholderExpression = XbaseFactory.eINSTANCE.createXBlockExpression();
            EList _expressions = this.expressionBlock.getExpressions();
            _expressions.add((Object)placeholderExpression);
            Consumer<XBlockExpression> _function = it -> {
                it.getExpressions().addAll(it.getExpressions().indexOf((Object)placeholderExpression), FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)expressionBuilder.apply(this.builder.getTypeProvider((XExpression)it))));
                EList _expressions_1 = it.getExpressions();
                _expressions_1.remove((Object)placeholderExpression);
            };
            this.builder.whenJvmTypes(this.expressionBlock, _function);
            return this.expressionBlock;
        }

        public XExpression call(Function<TypeProvider, XExpression> expressionBuilder) {
            this.execute(expressionBuilder);
            return this.expressionBlock;
        }

        public void call(FluentRoutineBuilder routineBuilder, RoutineCallParameter ... parameters) {
            RoutineCallParameter param;
            boolean _isParameterArgumentType;
            boolean _greaterThan;
            Preconditions.checkNotNull((Object)routineBuilder);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ");
            _builder.append((Object)routineBuilder);
            _builder.append(" is not sufficiently initialised to be set on the ");
            _builder.append((Object)this.builder);
            Preconditions.checkState((boolean)routineBuilder.readyToBeAttached, (Object)_builder);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The ");
            _builder_1.append((Object)routineBuilder);
            _builder_1.append(" requires a new value, and can thus only be called from reactions, not routines!");
            Preconditions.checkState((!routineBuilder.requireNewValue ? 1 : 0) != 0, (Object)_builder_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("The ");
            _builder_2.append((Object)routineBuilder);
            _builder_2.append(" requires an old value, and can thus only be called from reactions, not routines!");
            Preconditions.checkState((!routineBuilder.requireOldValue || this.builder.valueType != null ? 1 : 0) != 0, (Object)_builder_2);
            boolean hasFittingAffectedEObjectParameter = false;
            int _size = ((List)Conversions.doWrapArray((Object)parameters)).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan && (_isParameterArgumentType = (param = parameters[0]).isParameterArgumentType())) {
                hasFittingAffectedEObjectParameter = true;
            }
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("The ");
            _builder_3.append((Object)routineBuilder);
            _builder_3.append(" requires an affectedEObject, and can thus only be called from reactions, not");
            _builder_3.append(" routines!");
            Preconditions.checkState((!routineBuilder.requireAffectedEObject || routineBuilder.requireAffectedEObject && hasFittingAffectedEObjectParameter ? 1 : 0) != 0, (Object)_builder_3);
            this.builder.transferReactionsSegmentTo(this.builder, routineBuilder);
            this.addRoutineCall(routineBuilder, parameters);
        }

        private boolean addRoutineCall(FluentRoutineBuilder routineBuilder, RoutineCallParameter ... parameters) {
            EList _expressions = this.expressionBlock.getExpressions();
            XFeatureCall _routineCall = this.routineCall(routineBuilder, parameters);
            return _expressions.add((Object)_routineCall);
        }

        private XFeatureCall routineCall(FluentRoutineBuilder routineBuilder, RoutineCallParameter ... parameters) {
            XFeatureCall _createXFeatureCall = XbaseFactory.eINSTANCE.createXFeatureCall();
            Procedures.Procedure1 _function = it -> it.setExplicitOperationCall(true);
            Consumer<XFeatureCall> _function_1 = it -> {
                it.setFeature((JvmIdentifiableElement)routineBuilder.getJvmOperation());
                it.setImplicitReceiver((XExpression)this.builder.getJvmOperationRoutineFacade((XExpression)it));
                TypeProvider typeProvider = this.builder.getTypeProvider((XExpression)it);
                EList _featureCallArguments = it.getFeatureCallArguments();
                Functions.Function1 _function_2 = it_1 -> it_1.getExpression(typeProvider);
                List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)parameters)), (Functions.Function1)_function_2);
                Iterables.addAll((Collection)_featureCallArguments, (Iterable)_map);
            };
            return this.builder.whenJvmTypes((XFeatureCall)ObjectExtensions.operator_doubleArrow((Object)_createXFeatureCall, (Procedures.Procedure1)_function), _function_1);
        }
    }

    public static class UpdateBuilder {
        @Extension
        protected final FluentRoutineBuilder builder;

        private UpdateBuilder(FluentRoutineBuilder builder) {
            this.builder = builder;
        }

        public FluentRoutineBuilder withoutUpdate() {
            this.builder.readyToBeAttached = true;
            return this.builder;
        }

        public FluentRoutineBuilder update(Consumer<UpdateStatementBuilder> updates) {
            this.builder.routine.setUpdateBlock(TopLevelElementsFactory.eINSTANCE.createUpdateBlock());
            UpdateStatementBuilder statementBuilder = new UpdateStatementBuilder(this.builder);
            updates.accept(statementBuilder);
            this.builder.readyToBeAttached = true;
            return this.builder;
        }
    }

    public static class CreateStatementTypeBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final NamedMetaclassReference statement;

        private CreateStatementTypeBuilder(FluentRoutineBuilder builder, NamedMetaclassReference statement) {
            this.builder = builder;
            this.statement = statement;
        }

        public NamedMetaclassReference create(EClass element) {
            return this.builder.reference(this.statement, element);
        }
    }

    public static class CreateStatementBuilder {
        @Extension
        private final FluentRoutineBuilder builder;

        private CreateStatementBuilder(FluentRoutineBuilder builder) {
            this.builder = builder;
        }

        public CreateStatementTypeBuilder vall(String vallName) {
            CreateStatementTypeBuilder _xblockexpression = null;
            NamedMetaclassReference _createNamedMetaclassReference = ElementsFactory.eINSTANCE.createNamedMetaclassReference();
            Procedures.Procedure1 _function = it -> it.setName(vallName);
            NamedMetaclassReference statement = (NamedMetaclassReference)ObjectExtensions.operator_doubleArrow((Object)_createNamedMetaclassReference, (Procedures.Procedure1)_function);
            EList<NamedMetaclassReference> _createStatements = this.builder.routine.getCreateBlock().getCreateStatements();
            _createStatements.add((Object)statement);
            _xblockexpression = new CreateStatementTypeBuilder(this.builder, statement);
            return _xblockexpression;
        }
    }

    public static class RetrieveModelElementMatchBlockStatementTagBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final RetrieveOrRequireAbscenceOfModelElement statement;

        private RetrieveModelElementMatchBlockStatementTagBuilder(FluentRoutineBuilder builder, RetrieveOrRequireAbscenceOfModelElement statement) {
            this.builder = builder;
            this.statement = statement;
        }

        public void taggedWithAnything() {
            this.statement.setTag((XExpression)XbaseFactory.eINSTANCE.createXNullLiteral());
        }

        public void taggedWith(String tag) {
            XStringLiteral _createXStringLiteral = XbaseFactory.eINSTANCE.createXStringLiteral();
            Procedures.Procedure1 _function = it -> it.setValue(tag);
            XStringLiteral _doubleArrow = (XStringLiteral)ObjectExtensions.operator_doubleArrow((Object)_createXStringLiteral, (Procedures.Procedure1)_function);
            this.statement.setTag((XExpression)_doubleArrow);
        }

        public void taggedWith(Function<TypeProvider, XExpression> tagExpressionBuilder) {
            Consumer<XBlockExpression> _function = it -> {
                EList _expressions = it.getExpressions();
                List<XExpression> _extractExpressions = FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)tagExpressionBuilder.apply(this.builder.getTypeProvider((XExpression)it)));
                Iterables.addAll((Collection)_expressions, _extractExpressions);
            };
            this.statement.setTag((XExpression)this.builder.whenJvmTypes(XbaseFactory.eINSTANCE.createXBlockExpression(), _function));
        }
    }

    public static class UndecidedMatchStatementBuilder {
        @Extension
        private final FluentRoutineBuilder builder;

        private UndecidedMatchStatementBuilder(FluentRoutineBuilder builder) {
            this.builder = builder;
        }

        public RetrieveModelElementMatchBlockStatementBuilder vall(String valName) {
            RetrieveModelElementMatchBlockStatementBuilder _xblockexpression = null;
            RetrieveModelElement _createRetrieveModelElement = LanguageFactory.eINSTANCE.createRetrieveModelElement();
            Procedures.Procedure1 _function = it -> it.setName(valName);
            RetrieveModelElement statement = (RetrieveModelElement)ObjectExtensions.operator_doubleArrow((Object)_createRetrieveModelElement, (Procedures.Procedure1)_function);
            EList<MatchStatement> _matchStatements = this.builder.routine.getMatchBlock().getMatchStatements();
            _matchStatements.add((Object)statement);
            _xblockexpression = new RetrieveModelElementMatchBlockStatementBuilder(this.builder, statement);
            return _xblockexpression;
        }

        public RetrieveModelElementMatchBlockStatementCorrespondenceBuilder requireAbsenceOf(EClass absentMetaclass) {
            RequireAbscenceOfModelElement _createRequireAbscenceOfModelElement = LanguageFactory.eINSTANCE.createRequireAbscenceOfModelElement();
            Procedures.Procedure1 _function = it -> it.setElementType(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassReference(), absentMetaclass));
            RequireAbscenceOfModelElement statement = (RequireAbscenceOfModelElement)ObjectExtensions.operator_doubleArrow((Object)_createRequireAbscenceOfModelElement, (Procedures.Procedure1)_function);
            EList<MatchStatement> _matchStatements = this.builder.routine.getMatchBlock().getMatchStatements();
            _matchStatements.add((Object)statement);
            return new RetrieveModelElementMatchBlockStatementCorrespondenceBuilder(this.builder, statement);
        }

        public MatchCheckStatement check(Function<TypeProvider, XExpression> expressionBuilder) {
            MatchCheckStatement _createMatchCheckStatement = LanguageFactory.eINSTANCE.createMatchCheckStatement();
            Procedures.Procedure1 _function = it -> {
                Consumer<XBlockExpression> _function_1 = it_1 -> {
                    EList _expressions = it_1.getExpressions();
                    List<XExpression> _extractExpressions = FluentReactionsSegmentChildBuilder.extractExpressions((XExpression)expressionBuilder.apply(this.builder.getTypeProvider((XExpression)it_1)));
                    Iterables.addAll((Collection)_expressions, _extractExpressions);
                };
                it.setCondition((XExpression)this.builder.whenJvmTypes(XbaseFactory.eINSTANCE.createXBlockExpression(), _function_1));
            };
            MatchCheckStatement statement = (MatchCheckStatement)ObjectExtensions.operator_doubleArrow((Object)_createMatchCheckStatement, (Procedures.Procedure1)_function);
            EList<MatchStatement> _matchStatements = this.builder.routine.getMatchBlock().getMatchStatements();
            _matchStatements.add((Object)statement);
            return statement;
        }

        public void checkAsserted(Function<TypeProvider, XExpression> expressionBuilder) {
            MatchCheckStatement statement = this.check(expressionBuilder);
            statement.setAsserted(true);
        }
    }

    public static class RetrieveModelElementMatchBlockStatementCorrespondenceElementBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final RetrieveOrRequireAbscenceOfModelElement statement;

        private RetrieveModelElementMatchBlockStatementCorrespondenceElementBuilder(FluentRoutineBuilder builder, RetrieveOrRequireAbscenceOfModelElement statement) {
            this.builder = builder;
            this.statement = statement;
        }

        public RetrieveModelElementMatchBlockStatementTagBuilder affectedEObject() {
            RetrieveModelElementMatchBlockStatementTagBuilder _xblockexpression = null;
            this.builder.requireAffectedEObject = true;
            this.statement.setCorrespondenceSource((XExpression)this.builder.correspondingElement("affectedEObject"));
            _xblockexpression = new RetrieveModelElementMatchBlockStatementTagBuilder(this.builder, this.statement);
            return _xblockexpression;
        }

        public RetrieveModelElementMatchBlockStatementTagBuilder newValue() {
            RetrieveModelElementMatchBlockStatementTagBuilder _xblockexpression = null;
            this.builder.requireNewValue = true;
            this.statement.setCorrespondenceSource((XExpression)this.builder.correspondingElement("newValue"));
            _xblockexpression = new RetrieveModelElementMatchBlockStatementTagBuilder(this.builder, this.statement);
            return _xblockexpression;
        }

        public RetrieveModelElementMatchBlockStatementTagBuilder oldValue() {
            RetrieveModelElementMatchBlockStatementTagBuilder _xblockexpression = null;
            this.builder.requireOldValue = true;
            this.statement.setCorrespondenceSource((XExpression)this.builder.correspondingElement("oldValue"));
            _xblockexpression = new RetrieveModelElementMatchBlockStatementTagBuilder(this.builder, this.statement);
            return _xblockexpression;
        }
    }

    public static class RetrieveModelElementMatchBlockStatementCorrespondenceBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final RetrieveOrRequireAbscenceOfModelElement statement;

        private RetrieveModelElementMatchBlockStatementCorrespondenceBuilder(FluentRoutineBuilder builder, RetrieveOrRequireAbscenceOfModelElement statement) {
            this.builder = builder;
            this.statement = statement;
        }

        public RetrieveModelElementMatchBlockStatementCorrespondenceElementBuilder correspondingTo() {
            return new RetrieveModelElementMatchBlockStatementCorrespondenceElementBuilder(this.builder, this.statement);
        }

        public RetrieveModelElementMatchBlockStatementTagBuilder correspondingTo(String element) {
            RetrieveModelElementMatchBlockStatementTagBuilder _xblockexpression = null;
            this.statement.setCorrespondenceSource((XExpression)this.builder.correspondingElement(element));
            _xblockexpression = new RetrieveModelElementMatchBlockStatementTagBuilder(this.builder, this.statement);
            return _xblockexpression;
        }

        public RetrieveModelElementMatchBlockStatementTagBuilder correspondingTo(Function<TypeProvider, XExpression> expressionBuilder) {
            RetrieveModelElementMatchBlockStatementTagBuilder _xblockexpression = null;
            this.statement.setCorrespondenceSource((XExpression)this.builder.correspondingElement(expressionBuilder));
            _xblockexpression = new RetrieveModelElementMatchBlockStatementTagBuilder(this.builder, this.statement);
            return _xblockexpression;
        }
    }

    public static class RetrieveModelElementMatchBlockStatementBuilder {
        @Extension
        private final FluentRoutineBuilder builder;
        private final RetrieveModelElement statement;

        private RetrieveModelElementMatchBlockStatementBuilder(FluentRoutineBuilder builder, RetrieveModelElement statement) {
            this.builder = builder;
            this.statement = statement;
        }

        public RetrieveModelElementMatchBlockStatementCorrespondenceBuilder retrieve(EClass modelElement) {
            this.internalRetrieveOne(modelElement);
            return new RetrieveModelElementMatchBlockStatementCorrespondenceBuilder(this.builder, this.statement);
        }

        public RetrieveModelElementMatchBlockStatementCorrespondenceBuilder retrieveOptional(EClass modelElement) {
            RetrieveOneModelElement retrieveOneStatement = this.internalRetrieveOne(modelElement);
            retrieveOneStatement.setOptional(true);
            return new RetrieveModelElementMatchBlockStatementCorrespondenceBuilder(this.builder, this.statement);
        }

        public RetrieveModelElementMatchBlockStatementCorrespondenceBuilder retrieveAsserted(EClass modelElement) {
            RetrieveOneModelElement retrieveOneStatement = this.internalRetrieveOne(modelElement);
            retrieveOneStatement.setAsserted(true);
            return new RetrieveModelElementMatchBlockStatementCorrespondenceBuilder(this.builder, this.statement);
        }

        public RetrieveModelElementMatchBlockStatementCorrespondenceBuilder retrieveMany(EClass modelElement) {
            this.reference(modelElement);
            this.statement.setRetrievalType(LanguageFactory.eINSTANCE.createRetrieveManyModelElements());
            return new RetrieveModelElementMatchBlockStatementCorrespondenceBuilder(this.builder, this.statement);
        }

        private RetrieveOneModelElement internalRetrieveOne(EClass modelElement) {
            this.reference(modelElement);
            RetrieveOneModelElement retrieveOneElement = LanguageFactory.eINSTANCE.createRetrieveOneModelElement();
            this.statement.setRetrievalType(retrieveOneElement);
            return retrieveOneElement;
        }

        private void reference(EClass modelElement) {
            this.statement.setElementType(this.builder.reference(ElementsFactory.eINSTANCE.createMetaclassReference(), modelElement));
        }
    }

    public static interface WellKnownModelInput {
        public void apply(EClass var1);
    }

    public static class InputBuilder {
        @Extension
        private final FluentRoutineBuilder builder;

        private InputBuilder(FluentRoutineBuilder builder) {
            this.builder = builder;
        }

        public void model(EClass eClass, String parameterName) {
            this.detectWellKnownType(eClass, parameterName);
            this.builder.addInputElement(eClass, parameterName);
        }

        public void model(EClass eClass, WellKnownModelInput wellKnown) {
            wellKnown.apply(eClass);
        }

        private EClassifier detectWellKnownType(EClass eClass, String parameterName) {
            EClass _switchResult = null;
            if (parameterName != null) {
                switch (parameterName) {
                    case "oldValue": 
                    case "newValue": {
                        this.builder.valueType = eClass;
                        _switchResult = this.builder.valueType;
                        break;
                    }
                    case "affectedEObject": {
                        _switchResult = this.builder.affectedObjectType = eClass;
                    }
                }
            }
            return _switchResult;
        }

        public WellKnownModelInput newValue() {
            this.builder.requireNewValue = true;
            WellKnownModelInput _function = it -> {
                this.builder.valueType = it;
            };
            return _function;
        }

        public WellKnownModelInput oldValue() {
            this.builder.requireOldValue = true;
            WellKnownModelInput _function = it -> {
                this.builder.valueType = it;
            };
            return _function;
        }

        public WellKnownModelInput affectedEObject() {
            this.builder.requireAffectedEObject = true;
            WellKnownModelInput _function = it -> {
                this.builder.affectedObjectType = it;
            };
            return _function;
        }

        public void plain(Class<?> javaClass, String parameterName) {
            this.builder.addInputElement(javaClass, parameterName);
        }
    }

    public static class InputOrMatchBlockOrCreatorOrUpdateBuilder
    extends MatchBlockOrCreatorOrUpdateBuilder {
        private InputOrMatchBlockOrCreatorOrUpdateBuilder(FluentRoutineBuilder builder) {
            super(builder);
        }

        public MatchBlockOrCreatorOrUpdateBuilder input(Consumer<InputBuilder> inputs) {
            MatchBlockOrCreatorOrUpdateBuilder _xblockexpression = null;
            InputBuilder _inputBuilder = new InputBuilder(this.builder);
            inputs.accept(_inputBuilder);
            _xblockexpression = new MatchBlockOrCreatorOrUpdateBuilder(this.builder);
            return _xblockexpression;
        }
    }

    public static class MatchBlockOrCreatorOrUpdateBuilder
    extends CreatorOrUpdateBuilder {
        private MatchBlockOrCreatorOrUpdateBuilder(FluentRoutineBuilder builder) {
            super(builder);
        }

        public CreatorOrUpdateBuilder match(Consumer<UndecidedMatchStatementBuilder> matches) {
            boolean _equals;
            CreatorOrUpdateBuilder _xblockexpression = null;
            MatchBlock matchBlock = TopLevelElementsFactory.eINSTANCE.createMatchBlock();
            this.builder.routine.setMatchBlock(matchBlock);
            UndecidedMatchStatementBuilder statementsBuilder = new UndecidedMatchStatementBuilder(this.builder);
            matches.accept(statementsBuilder);
            int _size = this.builder.routine.getMatchBlock().getMatchStatements().size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                this.builder.routine.setMatchBlock(null);
            }
            _xblockexpression = new CreatorOrUpdateBuilder(this.builder);
            return _xblockexpression;
        }
    }

    public static class CreatorOrUpdateBuilder
    extends UpdateBuilder {
        private CreatorOrUpdateBuilder(FluentRoutineBuilder builder) {
            super(builder);
        }

        public UpdateBuilder create(Consumer<CreateStatementBuilder> creates) {
            UpdateBuilder _xblockexpression = null;
            this.builder.routine.setCreateBlock(TopLevelElementsFactory.eINSTANCE.createCreateBlock());
            CreateStatementBuilder statementBuilder = new CreateStatementBuilder(this.builder);
            creates.accept(statementBuilder);
            _xblockexpression = new UpdateBuilder(this.builder);
            return _xblockexpression;
        }
    }
}

