/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.classgenerators;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.dsls.reactions.codegen.changetyperepresentation.ChangeTypeRepresentation;
import tools.vitruv.dsls.reactions.codegen.changetyperepresentation.ChangeTypeRepresentationExtractor;
import tools.vitruv.dsls.reactions.codegen.classgenerators.ClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.steps.EmptyStepExecutionClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.steps.StepExecutionClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.steps.UpdateBlockClassGenerator;
import tools.vitruv.dsls.reactions.codegen.helper.AccessibleElement;
import tools.vitruv.dsls.reactions.codegen.helper.ClassNamesGenerators;
import tools.vitruv.dsls.reactions.codegen.typesbuilder.TypesBuilderExtensionProvider;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.RoutineCall;
import tools.vitruv.dsls.reactions.language.toplevelelements.Trigger;
import tools.vitruv.dsls.reactions.runtime.reactions.AbstractReaction;
import tools.vitruv.dsls.reactions.runtime.routines.RoutinesFacade;
import tools.vitruv.dsls.reactions.runtime.state.ReactionExecutionState;

public class ReactionClassGenerator
extends ClassGenerator {
    private static final String EXECUTION_STATE_VARIABLE = "executionState";
    private static final String ROUTINES_FACADE_VARIABLE = "routinesFacade";
    private static final String EXECUTE_REACTION_METHOD_NAME = "executeReaction";
    private static final String MATCH_CHANGE_METHOD_NAME = "isCurrentChangeMatchingTrigger";
    private static final String USER_DEFINED_PRECONDITION_METHOD_NAME = "isUserDefinedPreconditionFulfilled";
    private final Reaction reaction;
    private final ChangeTypeRepresentation changeType;
    private final String reactionClassQualifiedName;
    private final StepExecutionClassGenerator routineCallClassGenerator;
    private JvmGenericType generatedClass;

    public ReactionClassGenerator(Reaction reaction, TypesBuilderExtensionProvider typesBuilderExtensionProvider) {
        super(typesBuilderExtensionProvider);
        boolean _tripleNotEquals_1;
        Preconditions.checkArgument((reaction != null ? 1 : 0) != 0, (Object)"reaction must not be null");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)reaction.getName());
        boolean _not = !_isNullOrEmpty;
        Preconditions.checkArgument((boolean)_not, (Object)"reaction must have a name");
        Trigger _trigger = reaction.getTrigger();
        boolean _tripleNotEquals = _trigger != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"reaction must have a defined trigger");
        this.reaction = reaction;
        this.changeType = ChangeTypeRepresentationExtractor.extractChangeType(reaction.getTrigger());
        this.reactionClassQualifiedName = ClassNamesGenerators.getReactionClassNameGenerator(reaction).getQualifiedName();
        StepExecutionClassGenerator _xifexpression = null;
        RoutineCall _callRoutine = reaction.getCallRoutine();
        boolean bl = _tripleNotEquals_1 = _callRoutine != null;
        if (_tripleNotEquals_1) {
            UpdateBlockClassGenerator _xblockexpression = null;
            String routinesFacadeClassName = ClassNamesGenerators.getRoutinesFacadeClassNameGenerator(reaction.getReactionsSegment()).getQualifiedName();
            RoutineCall _callRoutine_1 = reaction.getCallRoutine();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(routinesFacadeClassName, new JvmTypeReference[0]);
            Iterable<AccessibleElement> _generatePropertiesParameterList = this.changeType.generatePropertiesParameterList();
            _xblockexpression = new UpdateBlockClassGenerator(typesBuilderExtensionProvider, this.reactionClassQualifiedName + ".Call", _callRoutine_1, _typeRef, _generatePropertiesParameterList);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = new EmptyStepExecutionClassGenerator(typesBuilderExtensionProvider);
        }
        this.routineCallClassGenerator = _xifexpression;
    }

    @Override
    public JvmGenericType generateEmptyClass() {
        JvmGenericType _xblockexpression = null;
        this.routineCallClassGenerator.generateEmptyClass();
        Procedures.Procedure1 _function = it -> it.setVisibility(JvmVisibility.PUBLIC);
        _xblockexpression = this.generatedClass = this._typesBuilder.toClass(this.reaction, this.reactionClassQualifiedName, _function);
        return _xblockexpression;
    }

    @Override
    public JvmGenericType generateBody() {
        Procedures.Procedure1 _function = it -> {
            this._typesBuilder.setDocumentation((JvmIdentifiableElement)it, this.getCommentWithoutMarkers(this.reaction.getDocumentation()));
            EList _superTypes = it.getSuperTypes();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(AbstractReaction.class, new JvmTypeReference[0]);
            this._typesBuilder.operator_add(_superTypes, _typeRef);
            EList _members = it.getMembers();
            JvmField _field = this._typesBuilder.toField(this.reaction, this.changeType.getName(), this.changeType.getAccessibleElement().generateTypeRef(this._typeReferenceBuilder));
            this._typesBuilder.operator_add(_members, _field);
            EList _members_1 = it.getMembers();
            JvmConstructor _generateConstructor = this.generateConstructor(this.reaction);
            this._typesBuilder.operator_add(_members_1, _generateConstructor);
            EList _members_2 = it.getMembers();
            JvmGenericType _generateBody = this.routineCallClassGenerator.generateBody();
            this._typesBuilder.operator_add(_members_2, _generateBody);
            EList _members_3 = it.getMembers();
            Iterable<JvmOperation> _generateMethodExecuteReactionAndDependentMethods = this.generateMethodExecuteReactionAndDependentMethods();
            this._typesBuilder.operator_add(_members_3, _generateMethodExecuteReactionAndDependentMethods);
        };
        return (JvmGenericType)ObjectExtensions.operator_doubleArrow((Object)this.generatedClass, (Procedures.Procedure1)_function);
    }

    private JvmConstructor generateConstructor(Reaction reaction) {
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PUBLIC);
            String _name = Function.class.getName();
            String _name_1 = ReactionExecutionState.class.getName();
            String _name_2 = RoutinesFacade.class.getName();
            AccessibleElement _accessibleElement = new AccessibleElement("routinesFacadeGenerator", _name, _name_1, _name_2);
            final JvmFormalParameter routinesFacadeParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement);
            EList _parameters = it.getParameters();
            this._typesBuilder.operator_add(_parameters, routinesFacadeParameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"super(");
                    String _name = routinesFacadeParameter.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._typesBuilder.setBody((JvmExecutable)it, _client);
        };
        return this._typesBuilder.toConstructor(reaction, _function);
    }

    private Iterable<JvmOperation> generateMethodExecuteReactionAndDependentMethods() {
        final JvmOperation matchChangeMethod = this.generateMatchChangeMethod();
        final JvmOperation userDefinedPreconditionMethod = this.generateUserDefinedPreconditionMethod();
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PUBLIC);
            AccessibleElement _accessibleElement = new AccessibleElement("change", EChange.class);
            final JvmFormalParameter changeParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement);
            AccessibleElement _accessibleElement_1 = new AccessibleElement(EXECUTION_STATE_VARIABLE, ReactionExecutionState.class);
            JvmFormalParameter reactionExecutionStateParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement_1);
            AccessibleElement _accessibleElement_2 = new AccessibleElement("routinesFacadeUntyped", RoutinesFacade.class);
            JvmFormalParameter routinesFacadeParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement_2);
            EList _parameters = it.getParameters();
            this._typesBuilder.operator_add(_parameters, changeParameter);
            EList _parameters_1 = it.getParameters();
            this._typesBuilder.operator_add(_parameters_1, reactionExecutionStateParameter);
            EList _parameters_2 = it.getParameters();
            this._typesBuilder.operator_add(_parameters_2, routinesFacadeParameter);
            final String facadeClassName = ClassNamesGenerators.getRoutinesFacadeClassNameGenerator(this.reaction.getReactionsSegment()).getQualifiedName();
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)facadeClassName);
                    _builder.append((Object)" ");
                    _builder.append((Object)ReactionClassGenerator.ROUTINES_FACADE_VARIABLE);
                    _builder.append((Object)" = (");
                    _builder.append((Object)facadeClassName);
                    _builder.append((Object)")");
                    _builder.append((Object)ReactionClassGenerator.ROUTINES_FACADE_VARIABLE);
                    _builder.append((Object)"Untyped;");
                    _builder.newLineIfNotEmpty();
                    StringConcatenationClient _generateMatchChangeMethodCallCode = ReactionClassGenerator.this.generateMatchChangeMethodCallCode(matchChangeMethod, changeParameter.getName());
                    _builder.append((Object)_generateMatchChangeMethodCallCode);
                    _builder.newLineIfNotEmpty();
                    StringConcatenationClient _generatePropertiesAssignmentCode = ReactionClassGenerator.this.changeType.generatePropertiesAssignmentCode();
                    _builder.append((Object)_generatePropertiesAssignmentCode);
                    _builder.newLineIfNotEmpty();
                    StringConcatenationClient _generateUserDefinedPreconditionMethodCall = ReactionClassGenerator.this.generateUserDefinedPreconditionMethodCall(userDefinedPreconditionMethod);
                    _builder.append((Object)_generateUserDefinedPreconditionMethodCall);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (getLogger().isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"getLogger().trace(\"Passed complete precondition check of Reaction \" + this.getClass().getName());");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    StringConcatenationClient _generateCallRoutineCode = ReactionClassGenerator.this.generateCallRoutineCode();
                    _builder.append((Object)_generateCallRoutineCode);
                    _builder.newLineIfNotEmpty();
                }
            };
            this._typesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation executeReactionMethod = this._typesBuilder.toMethod(this.reaction, EXECUTE_REACTION_METHOD_NAME, this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), _function);
        return IterableExtensions.filterNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new JvmOperation[]{matchChangeMethod, userDefinedPreconditionMethod, executeReactionMethod})));
    }

    private StringConcatenationClient generateCallRoutineCode() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            }
        };
        Functions.Function1 _function = it -> it.getName();
        Iterable _map = IterableExtensions.map(this.changeType.generatePropertiesParameterList(), (Functions.Function1)_function);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            }
        };
        return this.routineCallClassGenerator.generateStepExecutionCode(_client, EXECUTION_STATE_VARIABLE, ROUTINES_FACADE_VARIABLE, _map, _client_1);
    }

    private StringConcatenationClient generateMatchChangeMethodCallCode(final JvmOperation matchChangeMethod, final String changeParameterName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if (!");
                String _simpleName = matchChangeMethod.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)"(");
                _builder.append((Object)changeParameterName);
                _builder.append((Object)")) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private JvmOperation generateMatchChangeMethod() {
        Procedures.Procedure1 _function = it -> {
            AccessibleElement _accessibleElement = new AccessibleElement("change", EChange.class);
            JvmFormalParameter changeParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement);
            it.setVisibility(JvmVisibility.PUBLIC);
            EList _parameters = it.getParameters();
            this._typesBuilder.operator_add(_parameters, changeParameter);
            this._typesBuilder.setBody((JvmExecutable)it, this.changeType.generateCheckMethodBody(changeParameter.getName()));
        };
        return this._typesBuilder.toMethod(this.reaction.getTrigger(), MATCH_CHANGE_METHOD_NAME, this._typeReferenceBuilder.typeRef(Boolean.TYPE, new JvmTypeReference[0]), _function);
    }

    private StringConcatenationClient generateUserDefinedPreconditionMethodCall(final JvmOperation userDefinedPreconditionMethod) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _hasUserDefinedPrecondition = this.hasUserDefinedPrecondition();
        _xifexpression = _hasUserDefinedPrecondition ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if (getLogger().isTraceEnabled()) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"getLogger().trace(\"Passed change matching of Reaction \" + this.getClass().getName());");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (!");
                String _simpleName = userDefinedPreconditionMethod.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)"(");
                Functions.Function1 _function = it -> it.getName();
                Iterable _map = IterableExtensions.map(ReactionClassGenerator.this.changeType.generatePropertiesParameterList(), (Functions.Function1)_function);
                boolean _hasElements = false;
                for (String argument : _map) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append((Object)argument);
                }
                _builder.append((Object)")) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            }
        });
        return _xifexpression;
    }

    private JvmOperation generateUserDefinedPreconditionMethod() {
        boolean _not;
        boolean _hasUserDefinedPrecondition = this.hasUserDefinedPrecondition();
        boolean bl = _not = !_hasUserDefinedPrecondition;
        if (_not) {
            return null;
        }
        XExpression precondition = this.reaction.getTrigger().getPrecondition();
        String methodName = USER_DEFINED_PRECONDITION_METHOD_NAME;
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            EList _parameters = it.getParameters();
            Iterable<JvmFormalParameter> _generateAccessibleElementsParameters = this.generateAccessibleElementsParameters((EObject)it, this.changeType.generatePropertiesParameterList());
            this._typesBuilder.operator_add(_parameters, _generateAccessibleElementsParameters);
            this._typesBuilder.setBody((JvmExecutable)it, precondition);
        };
        return this._typesBuilder.toMethod(this.reaction.getTrigger(), USER_DEFINED_PRECONDITION_METHOD_NAME, this._typeReferenceBuilder.typeRef(Boolean.TYPE, new JvmTypeReference[0]), _function);
    }

    private boolean hasUserDefinedPrecondition() {
        Trigger _trigger = this.reaction.getTrigger();
        XExpression _precondition = null;
        if (_trigger != null) {
            _precondition = _trigger.getPrecondition();
        }
        return _precondition != null;
    }
}

