/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.classgenerators.steps;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.common.elements.NamedMetaclassReference;
import tools.vitruv.dsls.reactions.codegen.classgenerators.steps.StepExecutionClassGenerator;
import tools.vitruv.dsls.reactions.codegen.helper.AccessibleElement;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsLanguageHelper;
import tools.vitruv.dsls.reactions.codegen.typesbuilder.TypesBuilderExtensionProvider;
import tools.vitruv.dsls.reactions.language.toplevelelements.CreateBlock;
import tools.vitruv.dsls.reactions.runtime.routines.AbstractRoutine;
import tools.vitruv.dsls.reactions.runtime.state.ReactionExecutionState;

public class CreateBlockClassGenerator
extends StepExecutionClassGenerator {
    private static final String PREDEFINED_CREATE_OBJECT_METHOD_NAME = "createObject";
    private static final String MISSING_NAME = "/* Name missing */";
    private static final String MISSING_TYPE = "/* Type missing */";
    private static final String CREATED_ELEMENTS_SIMPLE_CLASS_NAME = "CreatedValues";
    private static final String CREATE_ELEMENTS_METHOD_NAME = "createElements";
    private final String qualifiedClassName;
    private final CreateBlock createBlock;
    private final JvmGenericType createdElementsClass;
    private JvmGenericType generatedClass;

    public CreateBlockClassGenerator(TypesBuilderExtensionProvider typesBuilderExtensionProvider, String qualifiedClassName, CreateBlock createBlock) {
        super(typesBuilderExtensionProvider);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)qualifiedClassName);
        boolean _not = !_isNullOrEmpty;
        Preconditions.checkArgument((boolean)_not, (Object)"class name must not be null or empty");
        this.qualifiedClassName = qualifiedClassName;
        this.createBlock = (CreateBlock)Preconditions.checkNotNull((Object)createBlock, (Object)"create block must not be null");
        this.createdElementsClass = this.generateNewlyAccessibleElementsContainerClass(this.getCreatedValuesClassQualifiedName());
    }

    private String getCreatedValuesClassQualifiedName() {
        return this.qualifiedClassName + ".CreatedValues";
    }

    @Override
    public Iterable<AccessibleElement> getNewlyAccessibleElementsAfterExecution() {
        Functions.Function1 _function = it -> {
            String _elvis = null;
            String _name = it.getName();
            _elvis = _name != null ? _name : MISSING_NAME;
            EClassifier _metaclass = it.getMetaclass();
            String _javaClassName = null;
            if (_metaclass != null) {
                _javaClassName = ReactionsLanguageHelper.getJavaClassName(_metaclass);
            }
            return new AccessibleElement(_elvis, _javaClassName);
        };
        return IterableUtil.mapFixed(this.createBlock.getCreateStatements(), (Functions.Function1)_function);
    }

    @Override
    public JvmGenericType getNewlyAccessibleElementsContainerType() {
        return this.createdElementsClass;
    }

    @Override
    public JvmGenericType generateEmptyClass() {
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
        };
        this.generatedClass = this._typesBuilder.toClass(this.createBlock, this.qualifiedClassName, _function);
        return this.generatedClass;
    }

    @Override
    public JvmGenericType generateBody() {
        Procedures.Procedure1 _function = it -> {
            EList _superTypes = it.getSuperTypes();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(AbstractRoutine.Create.class, new JvmTypeReference[0]);
            this._typesBuilder.operator_add(_superTypes, _typeRef);
            EList _members = it.getMembers();
            this._typesBuilder.operator_add(_members, this.createdElementsClass);
            EList _members_1 = it.getMembers();
            JvmConstructor _generateConstructor = this.generateConstructor();
            this._typesBuilder.operator_add(_members_1, _generateConstructor);
            EList _members_2 = it.getMembers();
            JvmOperation _generateMethodCreate = this.generateMethodCreate();
            this._typesBuilder.operator_add(_members_2, _generateMethodCreate);
        };
        return (JvmGenericType)ObjectExtensions.operator_doubleArrow((Object)this.generatedClass, (Procedures.Procedure1)_function);
    }

    private JvmConstructor generateConstructor() {
        Procedures.Procedure1 _function = it -> {
            AccessibleElement _accessibleElement = new AccessibleElement("reactionExecutionState", ReactionExecutionState.class);
            final JvmFormalParameter reactionExecutionStateParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement);
            EList _parameters = it.getParameters();
            this._typesBuilder.operator_add(_parameters, reactionExecutionStateParameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"super(");
                    String _name = reactionExecutionStateParameter.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)");");
                }
            };
            this._typesBuilder.setBody((JvmExecutable)it, _client);
        };
        return this._typesBuilder.toConstructor(this.createBlock, _function);
    }

    private JvmOperation generateMethodCreate() {
        Procedures.Procedure1 _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    EList<NamedMetaclassReference> _createStatements = CreateBlockClassGenerator.this.createBlock.getCreateStatements();
                    for (NamedMetaclassReference createStatement : _createStatements) {
                        StringConcatenationClient _elementCreationCode = CreateBlockClassGenerator.this.getElementCreationCode(createStatement);
                        _builder.append((Object)_elementCreationCode);
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"return new ");
                    JvmGenericType _newlyAccessibleElementsContainerType = CreateBlockClassGenerator.this.getNewlyAccessibleElementsContainerType();
                    _builder.append((Object)_newlyAccessibleElementsContainerType);
                    _builder.append((Object)"(");
                    Iterable<AccessibleElement> _newlyAccessibleElementsAfterExecution = CreateBlockClassGenerator.this.getNewlyAccessibleElementsAfterExecution();
                    boolean _hasElements = false;
                    for (AccessibleElement createdElement : _newlyAccessibleElementsAfterExecution) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _name = createdElement.getName();
                        _builder.append((Object)_name);
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._typesBuilder.setBody((JvmExecutable)it, _client);
        };
        return this._typesBuilder.toMethod(this.createBlock, CREATE_ELEMENTS_METHOD_NAME, this._typeReferenceBuilder.typeRef((JvmType)this.getNewlyAccessibleElementsContainerType(), new JvmTypeReference[0]), _function);
    }

    private StringConcatenationClient getElementCreationCode(final NamedMetaclassReference elementCreate) {
        final EClassifier affectedElementClass = elementCreate.getMetaclass();
        EPackage _ePackage = null;
        if (affectedElementClass != null) {
            _ePackage = affectedElementClass.getEPackage();
        }
        EFactory _eFactoryInstance = null;
        if (_ePackage != null) {
            _eFactoryInstance = _ePackage.getEFactoryInstance();
        }
        String _runtimeClassName = null;
        if (_eFactoryInstance != null) {
            _runtimeClassName = ReactionsLanguageHelper.getRuntimeClassName((EObject)_eFactoryInstance);
        }
        final String createdClassFactory = _runtimeClassName;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _javaClassName = ReactionsLanguageHelper.getJavaClassName(affectedElementClass);
                _builder.append((Object)_javaClassName);
                _builder.append((Object)" ");
                String _elvis = null;
                String _name = elementCreate.getName();
                _elvis = _name != null ? _name : CreateBlockClassGenerator.MISSING_NAME;
                _builder.append((Object)_elvis);
                _builder.append((Object)" = ");
                _builder.append((Object)CreateBlockClassGenerator.PREDEFINED_CREATE_OBJECT_METHOD_NAME);
                _builder.append((Object)"(() -> {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return ");
                String _elvis_1 = null;
                _elvis_1 = createdClassFactory != null ? createdClassFactory : CreateBlockClassGenerator.MISSING_TYPE;
                _builder.append((Object)_elvis_1, "\t");
                _builder.append((Object)".eINSTANCE.create");
                String _elvis_2 = null;
                String _name_1 = null;
                if (affectedElementClass != null) {
                    _name_1 = affectedElementClass.getName();
                }
                _elvis_2 = _name_1 != null ? _name_1 : CreateBlockClassGenerator.MISSING_TYPE;
                _builder.append((Object)_elvis_2, "\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"});");
                _builder.newLine();
            }
        };
        return _client;
    }

    @Override
    public StringConcatenationClient generateStepExecutionCode(final StringConcatenationClient prefix, final String executionStateAccessExpression, String routinesFacadeAccessExpression, Iterable<String> accessibleElementsAccessExpressions, final StringConcatenationClient suffix) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)prefix);
                _builder.append((Object)"new ");
                _builder.append((Object)CreateBlockClassGenerator.this.qualifiedClassName);
                _builder.append((Object)"(");
                _builder.append((Object)executionStateAccessExpression);
                _builder.append((Object)").");
                _builder.append((Object)CreateBlockClassGenerator.CREATE_ELEMENTS_METHOD_NAME);
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)suffix);
                _builder.newLineIfNotEmpty();
            }
        };
        return _client;
    }
}

