/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.classgenerators.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import tools.vitruv.dsls.common.elements.MetaclassReference;
import tools.vitruv.dsls.reactions.codegen.classgenerators.steps.StepExecutionClassGenerator;
import tools.vitruv.dsls.reactions.codegen.helper.AccessibleElement;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsLanguageHelper;
import tools.vitruv.dsls.reactions.codegen.typesbuilder.TypesBuilderExtensionProvider;
import tools.vitruv.dsls.reactions.language.MatchCheckStatement;
import tools.vitruv.dsls.reactions.language.RequireAbscenceOfModelElement;
import tools.vitruv.dsls.reactions.language.RetrieveManyModelElements;
import tools.vitruv.dsls.reactions.language.RetrieveModelElement;
import tools.vitruv.dsls.reactions.language.RetrieveModelElementType;
import tools.vitruv.dsls.reactions.language.RetrieveOneModelElement;
import tools.vitruv.dsls.reactions.language.RetrieveOrRequireAbscenceOfModelElement;
import tools.vitruv.dsls.reactions.language.toplevelelements.MatchBlock;
import tools.vitruv.dsls.reactions.language.toplevelelements.MatchStatement;
import tools.vitruv.dsls.reactions.runtime.routines.AbstractRoutine;
import tools.vitruv.dsls.reactions.runtime.state.ReactionExecutionState;

public class MatchBlockClassGenerator
extends StepExecutionClassGenerator {
    private static final String PREDEFINED_HAS_CORRESPONDING_ELEMENTS_METHOD_NAME = "hasCorrespondingElements";
    private static final String PREDEFINED_GET_CORRESPONDING_ELEMENT_METHOD_NAME = "getCorrespondingElement";
    private static final String PREDEFINED_GET_CORRESPONDING_ELEMENTS_METHOD_NAME = "getCorrespondingElements";
    private static final String MATCH_METHOD_NAME = "match";
    private static final String MISSING_TYPE = "/* Type missing */";
    private static final String RETRIEVED_ELEMENTS_SIMPLE_CLASS_NAME = "RetrievedValues";
    private final String qualifiedClassName;
    private final MatchBlock matchBlock;
    private final Iterable<AccessibleElement> inputElements;
    private final JvmGenericType retrievedElementsClass;
    private JvmGenericType generatedClass;
    private int counterGetRetrieveTagMethods = 1;
    private int counterCheckMatcherPreconditionMethods = 1;
    private int counterGetCorrespondenceSource = 1;

    public MatchBlockClassGenerator(TypesBuilderExtensionProvider typesBuilderExtensionProvider, String qualifiedClassName, MatchBlock matchBlock, Iterable<AccessibleElement> inputElements) {
        super(typesBuilderExtensionProvider);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)qualifiedClassName);
        boolean _not = !_isNullOrEmpty;
        Preconditions.checkArgument((boolean)_not, (Object)"class name must not be null or empty");
        this.qualifiedClassName = qualifiedClassName;
        this.matchBlock = (MatchBlock)Preconditions.checkNotNull((Object)matchBlock, (Object)"match block must not be null");
        this.inputElements = (Iterable)Preconditions.checkNotNull(inputElements, (Object)"input elements must not be null");
        this.retrievedElementsClass = this.generateNewlyAccessibleElementsContainerClass(this.getRetrievedValuesClassQualifiedName());
    }

    private String getRetrievedValuesClassQualifiedName() {
        return this.qualifiedClassName + ".RetrievedValues";
    }

    @Override
    public JvmGenericType generateEmptyClass() {
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
        };
        this.generatedClass = this._typesBuilder.toClass(this.matchBlock, this.qualifiedClassName, _function);
        return this.generatedClass;
    }

    @Override
    public JvmGenericType generateBody() {
        Procedures.Procedure1 _function = it -> {
            EList _superTypes = it.getSuperTypes();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(AbstractRoutine.Match.class, new JvmTypeReference[0]);
            this._typesBuilder.operator_add(_superTypes, _typeRef);
            EList _members = it.getMembers();
            this._typesBuilder.operator_add(_members, this.retrievedElementsClass);
            EList _members_1 = it.getMembers();
            JvmConstructor _generateConstructor = this.generateConstructor();
            this._typesBuilder.operator_add(_members_1, _generateConstructor);
            EList _members_2 = it.getMembers();
            JvmOperation _generateMatchMethod = this.generateMatchMethod();
            this._typesBuilder.operator_add(_members_2, _generateMatchMethod);
        };
        return (JvmGenericType)ObjectExtensions.operator_doubleArrow((Object)this.generatedClass, (Procedures.Procedure1)_function);
    }

    private JvmConstructor generateConstructor() {
        Procedures.Procedure1 _function = it -> {
            AccessibleElement _accessibleElement = new AccessibleElement("reactionExecutionState", ReactionExecutionState.class);
            final JvmFormalParameter executionStateParameter = this._parameterGenerator.generateParameter((EObject)it, _accessibleElement);
            EList _parameters = it.getParameters();
            this._typesBuilder.operator_add(_parameters, executionStateParameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"super(");
                    String _name = executionStateParameter.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)");");
                }
            };
            this._typesBuilder.setBody((JvmExecutable)it, _client);
        };
        return this._typesBuilder.toConstructor(this.matchBlock, _function);
    }

    private JvmOperation generateMatchMethod() {
        ArrayList currentlyAccessibleElements = CollectionLiterals.newArrayList((Object[])((AccessibleElement[])Conversions.unwrapArray(this.inputElements, AccessibleElement.class)));
        Functions.Function1 _function = it -> this.createStatements((MatchStatement)it, currentlyAccessibleElements);
        final List matcherStatements = IterableUtil.mapFixed(this.matchBlock.getMatchStatements(), (Functions.Function1)_function);
        Procedures.Procedure1 _function_1 = it -> {
            it.setVisibility(JvmVisibility.PUBLIC);
            EList _exceptions = it.getExceptions();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(IOException.class, new JvmTypeReference[0]);
            this._typesBuilder.operator_add(_exceptions, _typeRef);
            EList _parameters = it.getParameters();
            Iterable<JvmFormalParameter> _generateAccessibleElementsParameters = this.generateAccessibleElementsParameters((EObject)it, this.inputElements);
            this._typesBuilder.operator_add(_parameters, _generateAccessibleElementsParameters);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    for (StringConcatenationClient matcherStatement : matcherStatements) {
                        _builder.append((Object)matcherStatement);
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"return new ");
                    String _retrievedValuesClassQualifiedName = MatchBlockClassGenerator.this.getRetrievedValuesClassQualifiedName();
                    _builder.append((Object)_retrievedValuesClassQualifiedName);
                    _builder.append((Object)"(");
                    Iterable<AccessibleElement> _newlyAccessibleElementsAfterExecution = MatchBlockClassGenerator.this.getNewlyAccessibleElementsAfterExecution();
                    boolean _hasElements = false;
                    for (AccessibleElement retrievedElement : _newlyAccessibleElementsAfterExecution) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _name = retrievedElement.getName();
                        _builder.append((Object)_name);
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._typesBuilder.setBody((JvmExecutable)it, _client);
        };
        return this._typesBuilder.toMethod(this.matchBlock, MATCH_METHOD_NAME, this._typeReferenceBuilder.typeRef((JvmType)this.getNewlyAccessibleElementsContainerType(), new JvmTypeReference[0]), _function_1);
    }

    private StringConcatenationClient _createStatements(RequireAbscenceOfModelElement elementAbscence, List<AccessibleElement> currentlyAccessibleElements) {
        StringConcatenationClient _client;
        final StringConcatenationClient retrieveStatementArguments = this.getGeneralGetCorrespondingElementStatementArguments(elementAbscence, null, currentlyAccessibleElements);
        StringConcatenationClient statements = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if (");
                _builder.append((Object)MatchBlockClassGenerator.PREDEFINED_HAS_CORRESPONDING_ELEMENTS_METHOD_NAME);
                _builder.append((Object)"(");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)retrieveStatementArguments, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)")) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return null;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return statements;
    }

    private StringConcatenationClient _createStatements(RetrieveModelElement retrieveElement, List<AccessibleElement> currentlyAccessibleElements) {
        StringConcatenationClient retrieveStatementArguments = this.getGeneralGetCorrespondingElementStatementArguments(retrieveElement, retrieveElement.getName(), currentlyAccessibleElements);
        MetaclassReference _elementType = retrieveElement.getElementType();
        EClassifier _metaclass = null;
        if (_elementType != null) {
            _metaclass = _elementType.getMetaclass();
        }
        EClassifier affectedElementClass = _metaclass;
        RetrieveModelElementType _retrievalType = retrieveElement.getRetrievalType();
        String _name = retrieveElement.getName();
        String _javaClassName = null;
        if (affectedElementClass != null) {
            _javaClassName = ReactionsLanguageHelper.getJavaClassName(affectedElementClass);
        }
        StringConcatenationClient createdStatements = this.createStatements(_retrievalType, _name, _javaClassName, retrieveStatementArguments);
        AccessibleElement _accessibleElement = this.getAccessibleElement(retrieveElement);
        currentlyAccessibleElements.add(_accessibleElement);
        return createdStatements;
    }

    private StringConcatenationClient _createStatements(RetrieveManyModelElements retrieveElement, final String name, final String typeName, final StringConcatenationClient generalArguments) {
        StringConcatenationClient _client;
        StringConcatenationClient statement = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    _builder.append(Iterable.class);
                    _builder.append((Object)"<");
                    _builder.append((Object)typeName);
                    _builder.append((Object)"> ");
                    _builder.append((Object)name);
                    _builder.append((Object)" = ");
                }
                _builder.append((Object)MatchBlockClassGenerator.PREDEFINED_GET_CORRESPONDING_ELEMENTS_METHOD_NAME);
                _builder.append((Object)"(");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)generalArguments, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)");");
                _builder.newLine();
            }
        };
        return statement;
    }

    private StringConcatenationClient _createStatements(final RetrieveOneModelElement retrieveElement, final String name, final String typeName, StringConcatenationClient generalArguments) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(PREDEFINED_GET_CORRESPONDING_ELEMENT_METHOD_NAME);
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(generalArguments, "\t");
        _builder.append(", ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _isAsserted = retrieveElement.isAsserted();
        _builder.append((Object)_isAsserted, "\t");
        _builder.append(" // asserted");
        _builder.newLineIfNotEmpty();
        _builder.append(")");
        final String retrieveStatement = _builder.toString();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
        if (_isNullOrEmpty) {
            boolean _not;
            boolean _isOptional = retrieveElement.isOptional();
            boolean bl = _not = !_isOptional;
            if (_not) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append((Object)retrieveStatement);
                        _builder.append((Object)" == null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t\t\t");
                        _builder.append((Object)"return null;");
                        _builder.newLine();
                        _builder.append((Object)"\t\t\t\t");
                        _builder.append((Object)"}");
                    }
                };
                return _client;
            }
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _not;
                    boolean _isOptional = retrieveElement.isOptional();
                    if (_isOptional) {
                        _builder.append(Optional.class);
                        _builder.append((Object)"<");
                        _builder.append((Object)typeName);
                        _builder.append((Object)"> ");
                        _builder.append((Object)name);
                        _builder.append((Object)" = ");
                        _builder.append(Optional.class);
                        _builder.append((Object)".ofNullable(");
                        _builder.append((Object)retrieveStatement);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)");");
                        _builder.newLine();
                    } else {
                        _builder.append((Object)typeName);
                        _builder.append((Object)" ");
                        _builder.append((Object)name);
                        _builder.append((Object)" = ");
                        _builder.append((Object)retrieveStatement);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean _isOptional_1 = retrieveElement.isOptional();
                    boolean bl = _not = !_isOptional_1;
                    if (_not) {
                        _builder.append((Object)"if (");
                        _builder.append((Object)name);
                        _builder.append((Object)" == null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return null;");
                        _builder.newLine();
                        _builder.append((Object)"}");
                    }
                    _builder.newLineIfNotEmpty();
                }
            };
            return _client_1;
        }
        return null;
    }

    private StringConcatenationClient _createStatements(final MatchCheckStatement checkStatement, Iterable<AccessibleElement> currentlyAccessibleElements) {
        JvmOperation checkMethod = this.generateMethodMatcherPrecondition(checkStatement, currentlyAccessibleElements);
        String _userExecutionMethodCallString = null;
        if (checkMethod != null) {
            _userExecutionMethodCallString = this.getUserExecutionMethodCallString(checkMethod);
        }
        final String checkMethodCall = _userExecutionMethodCallString;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if (!");
                _builder.append((Object)checkMethodCall);
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                boolean _isAsserted = checkStatement.isAsserted();
                if (_isAsserted) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"throw new ");
                    _builder.append(IllegalStateException.class, "\t");
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return null;");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
            }
        };
        return _client;
    }

    private StringConcatenationClient getTagString(RetrieveOrRequireAbscenceOfModelElement retrieveElement, Iterable<AccessibleElement> currentlyAccessibleElements) {
        boolean _tripleNotEquals;
        XExpression _tag = retrieveElement.getTag();
        boolean bl = _tripleNotEquals = _tag != null;
        if (_tripleNotEquals) {
            final JvmOperation tagMethod = this.generateMethodGetRetrieveTag(retrieveElement, currentlyAccessibleElements);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _userExecutionMethodCallString = MatchBlockClassGenerator.this.getUserExecutionMethodCallString(tagMethod);
                    _builder.append((Object)_userExecutionMethodCallString);
                }
            };
            return _client;
        }
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"null");
            }
        };
        return _client_1;
    }

    private StringConcatenationClient getPreconditionChecker(RetrieveOrRequireAbscenceOfModelElement retrieveElement, String name, Iterable<AccessibleElement> currentlyAccessibleElements) {
        boolean _tripleEquals;
        MetaclassReference _elementType = retrieveElement.getElementType();
        String _javaClassName = null;
        if (_elementType != null) {
            _javaClassName = ReactionsLanguageHelper.getJavaClassName(_elementType);
        }
        final String affectedElementClass = _javaClassName;
        XExpression _precondition = retrieveElement.getPrecondition();
        boolean bl = _tripleEquals = _precondition == null;
        if (_tripleEquals) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"null");
                }
            };
            return _client;
        }
        final JvmOperation preconditionMethod = this.generateMethodCorrespondencePrecondition(retrieveElement, name, currentlyAccessibleElements);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(");
                _builder.append((Object)affectedElementClass);
                _builder.append((Object)" _element) -> ");
                String _simpleName = preconditionMethod.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)"(");
                Iterable _filterNull = IterableExtensions.filterNull((Iterable)preconditionMethod.getParameters());
                boolean _hasElements = false;
                for (JvmFormalParameter parameter : _filterNull) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    String _xifexpression = null;
                    String _name = parameter.getName();
                    boolean _equals = Objects.equals(_name, "it");
                    _xifexpression = _equals ? "_element" : parameter.getName();
                    _builder.append((Object)_xifexpression);
                }
                _builder.append((Object)")");
            }
        };
        return _client_1;
    }

    private StringConcatenationClient getGeneralGetCorrespondingElementStatementArguments(RetrieveOrRequireAbscenceOfModelElement retrieveElement, String name, Iterable<AccessibleElement> currentlyAccessibleElements) {
        MetaclassReference _elementType = retrieveElement.getElementType();
        String _javaClassName = null;
        if (_elementType != null) {
            _javaClassName = ReactionsLanguageHelper.getJavaClassName(_elementType);
        }
        final String affectedElementClass = _javaClassName;
        final StringConcatenationClient correspondingElementPreconditionChecker = this.getPreconditionChecker(retrieveElement, name, currentlyAccessibleElements);
        JvmOperation correspondenceSourceMethod = this.generateMethodGetCorrespondenceSource(retrieveElement, currentlyAccessibleElements);
        String _userExecutionMethodCallString = null;
        if (correspondenceSourceMethod != null) {
            _userExecutionMethodCallString = this.getUserExecutionMethodCallString(correspondenceSourceMethod);
        }
        final String correspondenceSourceMethodCall = _userExecutionMethodCallString;
        final StringConcatenationClient tagString = this.getTagString(retrieveElement, currentlyAccessibleElements);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)correspondenceSourceMethodCall);
                _builder.append((Object)", // correspondence source supplier");
                _builder.newLineIfNotEmpty();
                String _elvis = null;
                _elvis = affectedElementClass != null ? affectedElementClass : MatchBlockClassGenerator.MISSING_TYPE;
                _builder.append((Object)_elvis);
                _builder.append((Object)".class,");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)correspondingElementPreconditionChecker);
                _builder.append((Object)", // correspondence precondition checker");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)tagString);
            }
        };
        return _client;
    }

    private JvmOperation generateMethodGetRetrieveTag(RetrieveOrRequireAbscenceOfModelElement elementRetrieve, Iterable<AccessibleElement> currentlyAccessibleElements) {
        int _plusPlus = this.counterGetRetrieveTagMethods++;
        String methodName = "getRetrieveTag" + Integer.valueOf(_plusPlus);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            Iterable<JvmFormalParameter> _generateAccessibleElementsParameters = this.generateAccessibleElementsParameters((EObject)it, currentlyAccessibleElements);
            this._typesBuilder.operator_add(_parameters, _generateAccessibleElementsParameters);
            this._typesBuilder.setBody((JvmExecutable)it, elementRetrieve.getTag());
        };
        return this.generateAndAddMethod(elementRetrieve, methodName, this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]), (Procedures.Procedure1<? super JvmOperation>)_function);
    }

    private JvmOperation generateMethodCorrespondencePrecondition(RetrieveOrRequireAbscenceOfModelElement elementRetrieve, String name, Iterable<AccessibleElement> currentlyAccessibleElements) {
        Object _elvis = null;
        String _retrieveOrRequireAbscenceMethodSuffix = this.getRetrieveOrRequireAbscenceMethodSuffix(elementRetrieve);
        if (_retrieveOrRequireAbscenceMethodSuffix != null) {
            _elvis = _retrieveOrRequireAbscenceMethodSuffix;
        } else {
            int _plusPlus = this.counterGetCorrespondenceSource++;
            _elvis = _plusPlus;
        }
        String methodName = "getCorrespondingModelElementsPrecondition" + String.valueOf(_elvis);
        XExpression _precondition = elementRetrieve.getPrecondition();
        JvmOperation _generateAndAddMethod = null;
        if (_precondition != null) {
            Procedures.Procedure1 _function = it -> {
                String _javaClassName = ReactionsLanguageHelper.getJavaClassName(elementRetrieve.getElementType());
                AccessibleElement element = new AccessibleElement("it", _javaClassName);
                EList _parameters = it.getParameters();
                Iterable<JvmFormalParameter> _generateParameters = this._parameterGenerator.generateParameters((EObject)it, currentlyAccessibleElements);
                this._typesBuilder.operator_add(_parameters, _generateParameters);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _generateParameter = this._parameterGenerator.generateParameter((EObject)it, element);
                this._typesBuilder.operator_add(_parameters_1, _generateParameter);
                this._typesBuilder.setBody((JvmExecutable)it, elementRetrieve.getPrecondition());
            };
            _generateAndAddMethod = this.generateAndAddMethod((EObject)_precondition, methodName, this._typeReferenceBuilder.typeRef(Boolean.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1<? super JvmOperation>)_function);
        }
        return _generateAndAddMethod;
    }

    private JvmOperation generateMethodGetCorrespondenceSource(RetrieveOrRequireAbscenceOfModelElement elementRetrieve, Iterable<AccessibleElement> currentlyAccessibleElements) {
        Object _elvis = null;
        String _retrieveOrRequireAbscenceMethodSuffix = this.getRetrieveOrRequireAbscenceMethodSuffix(elementRetrieve);
        if (_retrieveOrRequireAbscenceMethodSuffix != null) {
            _elvis = _retrieveOrRequireAbscenceMethodSuffix;
        } else {
            int _plusPlus = this.counterGetCorrespondenceSource++;
            _elvis = _plusPlus;
        }
        String methodName = "getCorrepondenceSource" + String.valueOf(_elvis);
        JvmOperation _generateAndAddMethod = null;
        if (elementRetrieve != null) {
            Procedures.Procedure1 _function = it -> {
                EList _parameters = it.getParameters();
                Iterable<JvmFormalParameter> _generateAccessibleElementsParameters = this.generateAccessibleElementsParameters((EObject)it, currentlyAccessibleElements);
                this._typesBuilder.operator_add(_parameters, _generateAccessibleElementsParameters);
                this._typesBuilder.setBody((JvmExecutable)it, elementRetrieve.getCorrespondenceSource());
            };
            _generateAndAddMethod = this.generateAndAddMethod(elementRetrieve, methodName, this._typeReferenceBuilder.typeRef(EObject.class, new JvmTypeReference[0]), (Procedures.Procedure1<? super JvmOperation>)_function);
        }
        return _generateAndAddMethod;
    }

    private String getUserExecutionMethodCallString(JvmOperation method) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = method.getSimpleName();
        _builder.append(_simpleName);
        _builder.append("(");
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)method.getParameters());
        boolean _hasElements = false;
        for (JvmFormalParameter parameter : _filterNull) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name = parameter.getName();
            _builder.append(_name);
        }
        _builder.append(")");
        return _builder.toString();
    }

    private JvmOperation generateMethodMatcherPrecondition(MatchCheckStatement checkStatement, Iterable<AccessibleElement> currentlyAccessibleElements) {
        int _plusPlus = this.counterCheckMatcherPreconditionMethods++;
        String methodName = "checkMatcherPrecondition" + Integer.valueOf(_plusPlus);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            Iterable<JvmFormalParameter> _generateAccessibleElementsParameters = this.generateAccessibleElementsParameters((EObject)it, currentlyAccessibleElements);
            this._typesBuilder.operator_add(_parameters, _generateAccessibleElementsParameters);
            this._typesBuilder.setBody((JvmExecutable)it, checkStatement.getCondition());
        };
        return this.generateAndAddMethod(checkStatement, methodName, this._typeReferenceBuilder.typeRef(Boolean.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1<? super JvmOperation>)_function);
    }

    private String _getRetrieveOrRequireAbscenceMethodSuffix(RetrieveOrRequireAbscenceOfModelElement statement) {
        return null;
    }

    private String _getRetrieveOrRequireAbscenceMethodSuffix(RetrieveModelElement statement) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)statement.getName());
        if (_isNullOrEmpty) {
            return null;
        }
        return StringExtensions.toFirstUpper((String)statement.getName());
    }

    @Override
    public StringConcatenationClient generateStepExecutionCode(final StringConcatenationClient prefix, final String executionStateAccessExpression, String routinesFacadeAccessExpression, final Iterable<String> accessibleElementsAccessExpressions, final StringConcatenationClient suffix) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)prefix);
                _builder.append((Object)"new ");
                _builder.append((Object)MatchBlockClassGenerator.this.qualifiedClassName);
                _builder.append((Object)"(");
                _builder.append((Object)executionStateAccessExpression);
                _builder.append((Object)").");
                _builder.append((Object)MatchBlockClassGenerator.MATCH_METHOD_NAME);
                _builder.append((Object)"(");
                boolean _hasElements = false;
                for (String accessibleElement : accessibleElementsAccessExpressions) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append((Object)accessibleElement);
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)suffix);
                _builder.newLineIfNotEmpty();
            }
        };
        return _client;
    }

    @Override
    public Iterable<AccessibleElement> getNewlyAccessibleElementsAfterExecution() {
        Functions.Function1 _function = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName());
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_1 = it -> this.getAccessibleElement((RetrieveModelElement)it);
        return IterableUtil.mapFixed((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(this.matchBlock.getMatchStatements(), RetrieveModelElement.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    private AccessibleElement getAccessibleElement(RetrieveModelElement retrieveElement) {
        RetrieveModelElementType retrievalType = retrieveElement.getRetrievalType();
        MetaclassReference _elementType = retrieveElement.getElementType();
        EClassifier _metaclass = null;
        if (_elementType != null) {
            _metaclass = _elementType.getMetaclass();
        }
        String _javaClassName = null;
        if (_metaclass != null) {
            _javaClassName = ReactionsLanguageHelper.getJavaClassName(_metaclass);
        }
        String retrieveElementType = _javaClassName;
        boolean _matched = false;
        if (retrievalType instanceof RetrieveOneModelElement) {
            _matched = true;
            boolean _isOptional = ((RetrieveOneModelElement)retrievalType).isOptional();
            if (_isOptional) {
                String _name = retrieveElement.getName();
                String _name_1 = Optional.class.getName();
                return new AccessibleElement(_name, _name_1, retrieveElementType);
            }
            String _name_2 = retrieveElement.getName();
            return new AccessibleElement(_name_2, retrieveElementType);
        }
        if (!_matched && retrievalType instanceof RetrieveManyModelElements) {
            _matched = true;
            String _name = retrieveElement.getName();
            String _name_1 = Iterable.class.getName();
            return new AccessibleElement(_name, _name_1, retrieveElementType);
        }
        return null;
    }

    @Override
    public JvmGenericType getNewlyAccessibleElementsContainerType() {
        return this.retrievedElementsClass;
    }

    public JvmOperation generateAndAddMethod(EObject contextObject, String methodName, JvmTypeReference returnType, Procedures.Procedure1<? super JvmOperation> initializer) {
        JvmOperation generatedMethod = this._typesBuilder.toMethod(contextObject, methodName, returnType, initializer);
        EList _members = this.generatedClass.getMembers();
        this._typesBuilder.operator_add(_members, generatedMethod);
        return generatedMethod;
    }

    @XbaseGenerated
    private StringConcatenationClient createStatements(MatchStatement elementAbscence, Iterable<AccessibleElement> currentlyAccessibleElements) {
        if (elementAbscence instanceof RequireAbscenceOfModelElement && currentlyAccessibleElements instanceof List) {
            return this._createStatements((RequireAbscenceOfModelElement)elementAbscence, (List<AccessibleElement>)((List)currentlyAccessibleElements));
        }
        if (elementAbscence instanceof RetrieveModelElement && currentlyAccessibleElements instanceof List) {
            return this._createStatements((RetrieveModelElement)elementAbscence, (List<AccessibleElement>)((List)currentlyAccessibleElements));
        }
        if (elementAbscence instanceof MatchCheckStatement && currentlyAccessibleElements != null) {
            return this._createStatements((MatchCheckStatement)elementAbscence, currentlyAccessibleElements);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elementAbscence, currentlyAccessibleElements).toString());
    }

    @XbaseGenerated
    private StringConcatenationClient createStatements(RetrieveModelElementType retrieveElement, String name, String typeName, StringConcatenationClient generalArguments) {
        if (retrieveElement instanceof RetrieveManyModelElements) {
            return this._createStatements((RetrieveManyModelElements)retrieveElement, name, typeName, generalArguments);
        }
        if (retrieveElement instanceof RetrieveOneModelElement) {
            return this._createStatements((RetrieveOneModelElement)retrieveElement, name, typeName, generalArguments);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(retrieveElement, name, typeName, generalArguments).toString());
    }

    @XbaseGenerated
    private String getRetrieveOrRequireAbscenceMethodSuffix(RetrieveOrRequireAbscenceOfModelElement statement) {
        if (statement instanceof RetrieveModelElement) {
            return this._getRetrieveOrRequireAbscenceMethodSuffix((RetrieveModelElement)statement);
        }
        if (statement != null) {
            return this._getRetrieveOrRequireAbscenceMethodSuffix(statement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(statement).toString());
    }
}

