/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.helper;

import edu.kit.ipd.sdq.activextendannotations.Utility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.common.ClassNameGenerator;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsImportsHelper;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.runtime.structure.ReactionsImportPath;
import tools.vitruv.dsls.reactions.util.ReactionsLanguageUtil;

@Utility
public final class ClassNamesGenerators {
    private static final String BASIC_PACKAGE = "mir";
    private static final String REACTIONS_PACKAGE = "reactions";
    private static final String ROUTINES_PACKAGE = "routines";
    private static final String REACTIONS_EXECUTOR_CLASS_NAME = "ReactionsExecutor";
    private static final String ROUTINES_FACADE_CLASS_NAME = "RoutinesFacade";
    private static final String ROUTINES_FACADES_PROVIDER_CLASS_NAME = "RoutinesFacadesProvider";

    public static String getBasicMirPackageQualifiedName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(BASIC_PACKAGE);
        return _builder.toString();
    }

    public static String getBasicReactionsPackageQualifiedName() {
        StringConcatenation _builder = new StringConcatenation();
        String _basicMirPackageQualifiedName = ClassNamesGenerators.getBasicMirPackageQualifiedName();
        _builder.append(_basicMirPackageQualifiedName);
        _builder.append(".");
        _builder.append(REACTIONS_PACKAGE);
        return _builder.toString();
    }

    public static String getBasicRoutinesPackageQualifiedName() {
        StringConcatenation _builder = new StringConcatenation();
        String _basicMirPackageQualifiedName = ClassNamesGenerators.getBasicMirPackageQualifiedName();
        _builder.append(_basicMirPackageQualifiedName);
        _builder.append(".");
        _builder.append(ROUTINES_PACKAGE);
        return _builder.toString();
    }

    private static String getReactionsPackageQualifiedName(ReactionsSegment reactionSegment) {
        StringConcatenation _builder = new StringConcatenation();
        String _basicReactionsPackageQualifiedName = ClassNamesGenerators.getBasicReactionsPackageQualifiedName();
        _builder.append(_basicReactionsPackageQualifiedName);
        _builder.append(".");
        String _packageName = ClassNamesGenerators.getPackageName(reactionSegment);
        _builder.append(_packageName);
        return _builder.toString();
    }

    private static String getRoutinesPackageQualifiedName(ReactionsSegment reactionSegment) {
        StringConcatenation _builder = new StringConcatenation();
        String _basicRoutinesPackageQualifiedName = ClassNamesGenerators.getBasicRoutinesPackageQualifiedName();
        _builder.append(_basicRoutinesPackageQualifiedName);
        _builder.append(".");
        String _packageName = ClassNamesGenerators.getPackageName(reactionSegment);
        _builder.append(_packageName);
        return _builder.toString();
    }

    private static String getPackageName(ReactionsSegment reactionSegment) {
        StringConcatenation _builder = new StringConcatenation();
        String _reactionsSegmentPackageName = ClassNamesGenerators.getReactionsSegmentPackageName(reactionSegment.getName());
        _builder.append(_reactionsSegmentPackageName);
        return _builder.toString();
    }

    private static String getReactionsSegmentPackageName(String reactionSegmentName) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstLower = StringExtensions.toFirstLower((String)reactionSegmentName);
        _builder.append(_firstLower);
        return _builder.toString();
    }

    public static ClassNameGenerator getChangePropagationSpecificationClassNameGenerator(ReactionsSegment reactionSegment) {
        return new ChangePropagationSpecificationClassNameGenerator(reactionSegment);
    }

    public static ClassNameGenerator getExecutorClassNameGenerator(ReactionsSegment reactionSegment) {
        return new ExecutorClassNameGenerator(reactionSegment);
    }

    public static ClassNameGenerator getRoutinesFacadesProviderClassNameGenerator(ReactionsSegment reactionSegment) {
        return new RoutinesFacadesProviderClassNameGenerator(reactionSegment);
    }

    public static ClassNameGenerator getRoutinesFacadeClassNameGenerator(ReactionsSegment reactionSegment) {
        return new RoutinesFacadeClassNameGenerator(reactionSegment);
    }

    public static ClassNameGenerator getOverriddenRoutinesFacadeClassNameGenerator(ReactionsSegment reactionsSegment, ReactionsImportPath relativeImportPath) {
        return new OverriddenRoutinesFacadeClassNameGenerator(reactionsSegment, relativeImportPath);
    }

    public static ClassNameGenerator getReactionClassNameGenerator(Reaction reaction) {
        return new ReactionClassNameGenerator(reaction);
    }

    public static ClassNameGenerator getRoutineClassNameGenerator(Routine routine) {
        return new RoutineClassNameGenerator(routine);
    }

    private ClassNamesGenerators() {
    }

    private static class ChangePropagationSpecificationClassNameGenerator
    implements ClassNameGenerator {
        private final ReactionsSegment reactionsSegment;

        public ChangePropagationSpecificationClassNameGenerator(ReactionsSegment reactionsSegment) {
            this.reactionsSegment = reactionsSegment;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)this.reactionsSegment.getName());
            _builder.append(_firstUpper);
            _builder.append("ChangePropagationSpecification");
            return _builder.toString();
        }

        public String getPackageName() {
            StringConcatenation _builder = new StringConcatenation();
            String _reactionsPackageQualifiedName = ClassNamesGenerators.getReactionsPackageQualifiedName(this.reactionsSegment);
            _builder.append(_reactionsPackageQualifiedName);
            return _builder.toString();
        }
    }

    private static class ExecutorClassNameGenerator
    implements ClassNameGenerator {
        private final ReactionsSegment reactionsSegment;

        public ExecutorClassNameGenerator(ReactionsSegment reactionsSegment) {
            this.reactionsSegment = reactionsSegment;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(ClassNamesGenerators.REACTIONS_EXECUTOR_CLASS_NAME);
            return _builder.toString();
        }

        public String getPackageName() {
            StringConcatenation _builder = new StringConcatenation();
            String _reactionsPackageQualifiedName = ClassNamesGenerators.getReactionsPackageQualifiedName(this.reactionsSegment);
            _builder.append(_reactionsPackageQualifiedName);
            return _builder.toString();
        }
    }

    private static class RoutinesFacadesProviderClassNameGenerator
    implements ClassNameGenerator {
        private final ReactionsSegment reactionsSegment;

        public RoutinesFacadesProviderClassNameGenerator(ReactionsSegment reactionsSegment) {
            this.reactionsSegment = reactionsSegment;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)this.reactionsSegment.getName());
            _builder.append(_firstUpper);
            _builder.append(ClassNamesGenerators.ROUTINES_FACADES_PROVIDER_CLASS_NAME);
            return _builder.toString();
        }

        public String getPackageName() {
            StringConcatenation _builder = new StringConcatenation();
            String _basicRoutinesPackageQualifiedName = ClassNamesGenerators.getBasicRoutinesPackageQualifiedName();
            _builder.append(_basicRoutinesPackageQualifiedName);
            _builder.append(".");
            String _packageName = ClassNamesGenerators.getPackageName(this.reactionsSegment);
            _builder.append(_packageName);
            return _builder.toString();
        }
    }

    private static class RoutinesFacadeClassNameGenerator
    implements ClassNameGenerator {
        private final ReactionsSegment reactionsSegment;

        public RoutinesFacadeClassNameGenerator(ReactionsSegment reactionsSegment) {
            this.reactionsSegment = reactionsSegment;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)this.reactionsSegment.getName());
            _builder.append(_firstUpper);
            _builder.append(ClassNamesGenerators.ROUTINES_FACADE_CLASS_NAME);
            return _builder.toString();
        }

        public String getPackageName() {
            StringConcatenation _builder = new StringConcatenation();
            String _routinesPackageQualifiedName = ClassNamesGenerators.getRoutinesPackageQualifiedName(this.reactionsSegment);
            _builder.append(_routinesPackageQualifiedName);
            return _builder.toString();
        }
    }

    private static class OverriddenRoutinesFacadeClassNameGenerator
    implements ClassNameGenerator {
        private final ReactionsSegment reactionsSegment;
        private final ReactionsImportPath relativeImportPath;

        public OverriddenRoutinesFacadeClassNameGenerator(ReactionsSegment reactionsSegment, ReactionsImportPath relativeImportPath) {
            this.reactionsSegment = reactionsSegment;
            this.relativeImportPath = relativeImportPath;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)this.reactionsSegment.getName());
            _builder.append(_firstUpper);
            _builder.append(ClassNamesGenerators.ROUTINES_FACADE_CLASS_NAME);
            return _builder.toString();
        }

        public String getPackageName() {
            StringConcatenation _builder = new StringConcatenation();
            String _routinesPackageQualifiedName = ClassNamesGenerators.getRoutinesPackageQualifiedName(this.reactionsSegment);
            _builder.append(_routinesPackageQualifiedName);
            _builder.append(".");
            Functions.Function1 _function = it -> ClassNamesGenerators.getReactionsSegmentPackageName(it);
            String _join = IterableExtensions.join((Iterable)this.relativeImportPath.getSegments(), (CharSequence)".", (Functions.Function1)_function);
            _builder.append(_join);
            return _builder.toString();
        }
    }

    private static class ReactionClassNameGenerator
    implements ClassNameGenerator {
        private final Reaction reaction;

        public ReactionClassNameGenerator(Reaction reaction) {
            this.reaction = reaction;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)this.reaction.getName());
            _builder.append(_firstUpper);
            _builder.append("Reaction");
            return _builder.toString();
        }

        public String getPackageName() {
            Object packageName = ClassNamesGenerators.getReactionsPackageQualifiedName(this.reaction.getReactionsSegment());
            boolean _isOverride = ReactionsLanguageUtil.isOverride(this.reaction);
            if (_isOverride) {
                String _packageName = packageName;
                String _reactionsSegmentPackageName = ClassNamesGenerators.getReactionsSegmentPackageName(ReactionsImportsHelper.getParsedOverriddenReactionsSegmentName(this.reaction));
                String _plus = "." + _reactionsSegmentPackageName;
                packageName = _packageName + _plus;
            }
            return packageName;
        }
    }

    private static class RoutineClassNameGenerator
    implements ClassNameGenerator {
        private final Routine routine;

        public RoutineClassNameGenerator(Routine routine) {
            this.routine = routine;
        }

        public String getSimpleName() {
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)this.routine.getName());
            _builder.append(_firstUpper);
            _builder.append("Routine");
            return _builder.toString();
        }

        public String getPackageName() {
            Object packageName = ClassNamesGenerators.getRoutinesPackageQualifiedName(this.routine.getReactionsSegment());
            boolean _isOverride = ReactionsLanguageUtil.isOverride(this.routine);
            if (_isOverride) {
                String _packageName = packageName;
                Functions.Function1 _function = it -> ClassNamesGenerators.getReactionsSegmentPackageName(it);
                String _join = IterableExtensions.join((Iterable)ReactionsImportsHelper.getParsedOverrideImportPath(this.routine).getSegments(), (CharSequence)".", (Functions.Function1)_function);
                String _plus = "." + _join;
                packageName = _packageName + _plus;
            }
            return packageName;
        }
    }
}

