/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.helper;

import edu.kit.ipd.sdq.activextendannotations.Utility;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsImport;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.RoutineOverrideImportPath;
import tools.vitruv.dsls.reactions.util.ReactionsLanguageUtil;

@Utility
public final class ReactionsElementsCompletionChecker {
    public static boolean isReferenceable(ReactionsSegment reactionsSegment) {
        return reactionsSegment != null && !StringExtensions.isNullOrEmpty((String)reactionsSegment.getName()) && !reactionsSegment.getFromMetamodels().isEmpty() && !reactionsSegment.getToMetamodels().isEmpty();
    }

    public static boolean isReferenceable(ReactionsImport reactionsImport) {
        return reactionsImport != null && reactionsImport.getImportedReactionsSegment() != null;
    }

    public static boolean isReferenceable(Reaction reaction) {
        return reaction != null && !StringExtensions.isNullOrEmpty((String)reaction.getName());
    }

    public static boolean isReferenceable(Routine routine) {
        return routine != null && !StringExtensions.isNullOrEmpty((String)routine.getName());
    }

    public static boolean isComplete(RoutineOverrideImportPath routineOverrideImportPath) {
        return routineOverrideImportPath != null && !IterableExtensions.exists(ReactionsLanguageUtil.getFullPath(routineOverrideImportPath), it -> it.getReactionsSegment() == null || StringExtensions.isNullOrEmpty((String)it.getReactionsSegment().getName()));
    }

    private ReactionsElementsCompletionChecker() {
    }
}

