/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.helper;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.activextendannotations.Utility;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsElementsCompletionChecker;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsImport;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.RoutineOverrideImportPath;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsPackage;
import tools.vitruv.dsls.reactions.runtime.structure.ReactionsImportPath;
import tools.vitruv.dsls.reactions.util.ReactionsLanguageUtil;

@Utility
public final class ReactionsImportsHelper {
    public static String getParsedOverriddenReactionsSegmentName(Reaction reaction) {
        boolean _not;
        String parsed = ReactionsImportsHelper.getFeatureNodeText(reaction, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__OVERRIDDEN_REACTIONS_SEGMENT);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)parsed);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            return parsed;
        }
        ReactionsSegment _overriddenReactionsSegment = reaction.getOverriddenReactionsSegment();
        String _name = null;
        if (_overriddenReactionsSegment != null) {
            _name = _overriddenReactionsSegment.getName();
        }
        return _name;
    }

    public static ReactionsImportPath getParsedOverrideImportPath(Routine routine) {
        return ReactionsImportsHelper.getParsedOverrideImportPath(routine.getOverrideImportPath());
    }

    public static ReactionsImportPath getParsedOverrideImportPath(RoutineOverrideImportPath routineOverrideImportPath) {
        if (routineOverrideImportPath == null) {
            return null;
        }
        Functions.Function1 _function = it -> {
            boolean _not;
            String parsed = ReactionsImportsHelper.getFeatureNodeText(it, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE_OVERRIDE_IMPORT_PATH__REACTIONS_SEGMENT);
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)parsed);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                return parsed;
            }
            String _elvis = null;
            ReactionsSegment _reactionsSegment = it.getReactionsSegment();
            String _name = null;
            if (_reactionsSegment != null) {
                _name = _reactionsSegment.getName();
            }
            _elvis = _name != null ? _name : "";
            return _elvis;
        };
        List parsedSegments = ListExtensions.map(ReactionsLanguageUtil.getFullPath(routineOverrideImportPath), (Functions.Function1)_function);
        return ReactionsImportPath.create((Iterable)parsedSegments);
    }

    private static String getFeatureNodeText(EObject semanticObject, EStructuralFeature structuralFeature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)semanticObject, (EStructuralFeature)structuralFeature);
        boolean _isEmpty = nodes.isEmpty();
        if (_isEmpty) {
            return null;
        }
        return NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
    }

    public static Set<ReactionsImportPath> getParsedOverriddenRoutinesImportPaths(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
        Functions.Function1 _function_1 = it -> ReactionsImportsHelper.getParsedOverrideImportPath(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(ReactionsLanguageUtil.getOverrideRoutines(reactionsSegment), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public static boolean isAllImportsResolvable(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> {
            boolean _isResolvable = ReactionsImportsHelper.isResolvable(it);
            return !_isResolvable;
        };
        ReactionsImport _findFirst = (ReactionsImport)IterableExtensions.findFirst(reactionsSegment.getReactionsImports(), (Functions.Function1)_function);
        return _findFirst == null;
    }

    public static boolean isResolvable(ReactionsImport reactionsImport) {
        return reactionsImport != null && reactionsImport.getImportedReactionsSegment() != null && !reactionsImport.getImportedReactionsSegment().eIsProxy();
    }

    public static <R, D> R walkImportHierarchy(ReactionsSegment rootReactionsSegment, Supplier<D> dataInitializer, ImportHierarchyVisitor<D> earlyVisitor, ImportHierarchyVisitor<D> lateVisitor, Predicate<ReactionsImport> importFilter, Function<D, R> returnValueFunction) {
        Preconditions.checkNotNull((Object)rootReactionsSegment, (Object)"rootReactionsSegment is null");
        Preconditions.checkNotNull(returnValueFunction, (Object)"returnValueFunction is null");
        Object _get = null;
        if (dataInitializer != null) {
            _get = dataInitializer.get();
        }
        Object data = _get;
        ReactionsImportPath rootImportPath = ReactionsImportPath.create((String[])new String[]{rootReactionsSegment.getName()});
        Predicate<ReactionsImport> _elvis = null;
        if (importFilter != null) {
            _elvis = importFilter;
        } else {
            Predicate<ReactionsImport> _function = it -> true;
            _elvis = _function;
        }
        ReactionsImportsHelper._walkImportHierarchy(null, rootImportPath, rootReactionsSegment, data, earlyVisitor, lateVisitor, _elvis);
        return returnValueFunction.apply(data);
    }

    private static <D> void _walkImportHierarchy(ReactionsImport sourceImport, ReactionsImportPath currentImportPath, ReactionsSegment currentReactionsSegment, D data, ImportHierarchyVisitor<D> earlyVisitor, ImportHierarchyVisitor<D> lateVisitor, Predicate<ReactionsImport> importFilter) {
        if (earlyVisitor != null) {
            earlyVisitor.visit(sourceImport, currentImportPath, currentReactionsSegment, data);
        }
        Functions.Function1 _function = it -> ReactionsImportsHelper.isResolvable(it);
        Iterable _filter = IterableExtensions.filter(currentReactionsSegment.getReactionsImports(), (Functions.Function1)_function);
        for (ReactionsImport nextImport : _filter) {
            ReactionsSegment importedSegment = nextImport.getImportedReactionsSegment();
            if (currentImportPath.getSegments().contains(importedSegment.getName()) || !importFilter.test(nextImport)) continue;
            ReactionsImportPath importedSegmentImportPath = currentImportPath.append(new String[]{importedSegment.getName()});
            ReactionsImportsHelper._walkImportHierarchy(nextImport, importedSegmentImportPath, importedSegment, data, earlyVisitor, lateVisitor, importFilter);
        }
        if (lateVisitor != null) {
            lateVisitor.visit(sourceImport, currentImportPath, currentReactionsSegment, data);
        }
    }

    public static Map<ReactionsImportPath, ReactionsSegment> getRoutinesImportHierarchy(ReactionsSegment rootReactionsSegment) {
        Supplier<LinkedHashMap> _function = () -> new LinkedHashMap();
        ImportHierarchyVisitor<LinkedHashMap> _function_1 = (sourceImport, currentImportPath, currentReactionsSegment, data) -> {
            LinkedHashMap importHierarchy = data;
            importHierarchy.put(currentImportPath, currentReactionsSegment);
        };
        Predicate<ReactionsImport> _function_2 = it -> true;
        Function<LinkedHashMap, LinkedHashMap> _function_3 = it -> it;
        return ReactionsImportsHelper.walkImportHierarchy(rootReactionsSegment, _function, _function_1, null, _function_2, _function_3);
    }

    public static Map<ReactionsImportPath, ReactionsSegment> getReactionsImportHierarchy(ReactionsSegment rootReactionsSegment) {
        Supplier<LinkedHashMap> _function = () -> new LinkedHashMap();
        ImportHierarchyVisitor<LinkedHashMap> _function_1 = (sourceImport, currentImportPath, currentReactionsSegment, data) -> {
            boolean _not;
            LinkedHashMap importHierarchy = data;
            boolean _containsValue = importHierarchy.containsValue(currentReactionsSegment);
            boolean bl = _not = !_containsValue;
            if (_not) {
                importHierarchy.put(currentImportPath, currentReactionsSegment);
            }
        };
        Predicate<ReactionsImport> _function_2 = it -> {
            boolean _isRoutinesOnly = it.isRoutinesOnly();
            return !_isRoutinesOnly;
        };
        Function<LinkedHashMap, LinkedHashMap> _function_3 = it -> it;
        return ReactionsImportsHelper.walkImportHierarchy(rootReactionsSegment, _function, _function_1, null, _function_2, _function_3);
    }

    public static Map<Reaction, ReactionsImportPath> getIncludedReactions(ReactionsSegment rootReactionsSegment) {
        Supplier<org.eclipse.xtext.util.Pair> _function = () -> {
            LinkedHashMap _linkedHashMap = new LinkedHashMap();
            LinkedHashMap _linkedHashMap_1 = new LinkedHashMap();
            return Tuples.create(_linkedHashMap, _linkedHashMap_1);
        };
        ImportHierarchyVisitor<org.eclipse.xtext.util.Pair> _function_1 = (sourceImport, currentImportPath, currentReactionsSegment, data) -> {
            LinkedHashMap reactionsByQualifiedName = (LinkedHashMap)data.getFirst();
            LinkedHashMap reactionsToImportPath = (LinkedHashMap)data.getSecond();
            Functions.Function1 _function_2 = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
            Iterable _filter = IterableExtensions.filter(currentReactionsSegment.getReactions(), (Functions.Function1)_function_2);
            for (Reaction reaction : _filter) {
                String qualifiedName = ReactionsLanguageUtil.getQualifiedName(reaction);
                Reaction previousReaction = reactionsByQualifiedName.put(qualifiedName, reaction);
                if (previousReaction != null) {
                    reactionsToImportPath.remove(previousReaction);
                }
                reactionsToImportPath.put(reaction, currentImportPath);
            }
        };
        Predicate<ReactionsImport> _function_2 = it -> {
            boolean _isRoutinesOnly = it.isRoutinesOnly();
            return !_isRoutinesOnly;
        };
        Function<org.eclipse.xtext.util.Pair, LinkedHashMap> _function_3 = it -> (LinkedHashMap)it.getSecond();
        return ReactionsImportsHelper.walkImportHierarchy(rootReactionsSegment, _function, null, _function_1, _function_2, _function_3);
    }

    public static Map<Routine, ReactionsImportPath> getIncludedRoutines(ReactionsSegment rootReactionsSegment, boolean includeRootRoutines, boolean resolveOverrides) {
        Supplier<Triple> _function = () -> {
            LinkedHashMap _linkedHashMap = new LinkedHashMap();
            LinkedHashMap _linkedHashMap_1 = new LinkedHashMap();
            LinkedHashMap _linkedHashMap_2 = new LinkedHashMap();
            return Tuples.create(_linkedHashMap, _linkedHashMap_1, _linkedHashMap_2);
        };
        ImportHierarchyVisitor<Triple> _function_1 = (sourceImport, currentImportPath, currentReactionsSegment, data) -> {
            if (!includeRootRoutines && currentImportPath.getLength() == 1) {
                return;
            }
            LinkedHashMap routinesByName = (LinkedHashMap)data.getFirst();
            LinkedHashMap routinesByFullyQualifiedName = (LinkedHashMap)data.getSecond();
            LinkedHashMap routinesToImportPath = (LinkedHashMap)data.getThird();
            Functions.Function1 _function_2 = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
            Iterable _filter = IterableExtensions.filter(ReactionsLanguageUtil.getRegularRoutines(currentReactionsSegment), (Functions.Function1)_function_2);
            for (Routine routine : _filter) {
                Routine _putIfAbsent = routinesByName.putIfAbsent(ReactionsLanguageUtil.getFormattedName(routine), routine);
                boolean _tripleEquals = _putIfAbsent == null;
                if (!_tripleEquals) continue;
                String fullyQualifiedName = ReactionsLanguageUtil.getFullyQualifiedName(routine, currentImportPath);
                routinesByFullyQualifiedName.put(fullyQualifiedName, routine);
                routinesToImportPath.put(routine, currentImportPath);
            }
        };
        ImportHierarchyVisitor<Triple> _function_2 = (sourceImport, currentImportPath, currentReactionsSegment, data) -> {
            if (!resolveOverrides) {
                return;
            }
            LinkedHashMap routinesByName = (LinkedHashMap)data.getFirst();
            LinkedHashMap routinesByFullyQualifiedName = (LinkedHashMap)data.getSecond();
            LinkedHashMap routinesToImportPath = (LinkedHashMap)data.getThird();
            Functions.Function1 _function_3 = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
            Iterable _filter = IterableExtensions.filter(ReactionsLanguageUtil.getOverrideRoutines(currentReactionsSegment), (Functions.Function1)_function_3);
            for (Routine routine : _filter) {
                String fullyQualifiedName = ReactionsLanguageUtil.getFullyQualifiedName(routine, currentImportPath);
                Routine previousRoutine = routinesByFullyQualifiedName.replace(fullyQualifiedName, routine);
                if (previousRoutine == null) continue;
                routinesToImportPath.remove(previousRoutine);
                routinesToImportPath.put(routine, currentImportPath);
                routinesByName.put(ReactionsLanguageUtil.getFormattedName(routine), routine);
            }
        };
        Predicate<ReactionsImport> _function_3 = it -> {
            boolean _isUseQualifiedNames = it.isUseQualifiedNames();
            return !_isUseQualifiedNames;
        };
        Function<Triple, LinkedHashMap> _function_4 = it -> (LinkedHashMap)it.getThird();
        return ReactionsImportsHelper.walkImportHierarchy(rootReactionsSegment, _function, _function_1, _function_2, _function_3, _function_4);
    }

    public static Map<ReactionsSegment, ReactionsImportPath> getIncludedRoutinesFacades(ReactionsSegment rootReactionsSegment) {
        Supplier<org.eclipse.xtext.util.Pair> _function = () -> {
            LinkedHashMap _linkedHashMap = new LinkedHashMap();
            LinkedHashMap _linkedHashMap_1 = new LinkedHashMap();
            return Tuples.create(_linkedHashMap, _linkedHashMap_1);
        };
        ImportHierarchyVisitor<org.eclipse.xtext.util.Pair> _function_1 = (sourceImport, currentImportPath, currentReactionsSegment, data) -> {
            LinkedHashMap segmentsByName = (LinkedHashMap)data.getFirst();
            LinkedHashMap segmentsToImportPath = (LinkedHashMap)data.getSecond();
            Functions.Function1 _function_2 = it -> ReactionsElementsCompletionChecker.isReferenceable(it) && ReactionsImportsHelper.isResolvable(it) && it.isUseQualifiedNames();
            Iterable currentSegmentIncludedImports = IterableExtensions.filter(currentReactionsSegment.getReactionsImports(), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> it.getImportedReactionsSegment();
            Iterable currentSegmentIncludedSegments = IterableExtensions.map((Iterable)currentSegmentIncludedImports, (Functions.Function1)_function_3);
            for (ReactionsSegment includedSegment : currentSegmentIncludedSegments) {
                String includedSegmentFormattedName = ReactionsLanguageUtil.getFormattedName(includedSegment);
                ReactionsImportPath includedSegmentImportPath = currentImportPath.append(new String[]{includedSegment.getName()});
                ReactionsSegment _putIfAbsent = segmentsByName.putIfAbsent(includedSegmentFormattedName, includedSegment);
                boolean _tripleEquals = _putIfAbsent == null;
                if (!_tripleEquals) continue;
                segmentsToImportPath.put(includedSegment, includedSegmentImportPath);
            }
        };
        Predicate<ReactionsImport> _function_2 = it -> {
            boolean _isUseQualifiedNames = it.isUseQualifiedNames();
            return !_isUseQualifiedNames;
        };
        Function<org.eclipse.xtext.util.Pair, LinkedHashMap> _function_3 = it -> (LinkedHashMap)it.getSecond();
        return ReactionsImportsHelper.walkImportHierarchy(rootReactionsSegment, _function, _function_1, null, _function_2, _function_3);
    }

    public static <T> T walkImportPath(ReactionsSegment rootReactionsSegment, ReactionsImportPath relativeImportPath, ImportPathVisitor<T> visitor) {
        Preconditions.checkNotNull((Object)rootReactionsSegment, (Object)"rootReactionsSegment is null");
        Preconditions.checkNotNull((Object)relativeImportPath, (Object)"relativeImportPath is null");
        Preconditions.checkNotNull(visitor, (Object)"visitor is null");
        Set uniquePathSegments = IterableExtensions.toSet((Iterable)relativeImportPath.getSegments());
        if (uniquePathSegments.size() != relativeImportPath.getLength() || uniquePathSegments.contains(rootReactionsSegment.getName())) {
            return null;
        }
        ReactionsImportPath rootImportPath = ReactionsImportPath.create((String[])new String[]{rootReactionsSegment.getName()});
        return ReactionsImportsHelper._walkImportPath(null, rootImportPath, rootReactionsSegment, relativeImportPath, visitor);
    }

    private static <T> T _walkImportPath(ReactionsImport sourceImport, ReactionsImportPath currentImportPath, ReactionsSegment currentReactionsSegment, ReactionsImportPath remainingImportPath, ImportPathVisitor<T> visitor) {
        T returnValue = visitor.visit(sourceImport, currentImportPath, currentReactionsSegment, remainingImportPath);
        if (returnValue != null) {
            return returnValue;
        }
        boolean _isEmpty = remainingImportPath.isEmpty();
        if (_isEmpty) {
            return null;
        }
        String nextReactionsSegmentName = remainingImportPath.getFirstSegment();
        ReactionsImportPath nextImportPath = currentImportPath.append(new String[]{nextReactionsSegmentName});
        ReactionsImportPath nextRemainingImportPath = remainingImportPath.relativeToRoot();
        Functions.Function1 _function = it -> ReactionsImportsHelper.isResolvable(it);
        Functions.Function1 _function_1 = it -> nextReactionsSegmentName.equals(it.getImportedReactionsSegment().getName());
        ReactionsImport nextImport = (ReactionsImport)IterableExtensions.findFirst((Iterable)IterableExtensions.filter(currentReactionsSegment.getReactionsImports(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (nextImport == null) {
            return null;
        }
        ReactionsSegment nextReactionsSegment = nextImport.getImportedReactionsSegment();
        return ReactionsImportsHelper._walkImportPath(nextImport, nextImportPath, nextReactionsSegment, nextRemainingImportPath, visitor);
    }

    public static ReactionsSegment getReactionsSegment(ReactionsSegment rootReactionsSegment, ReactionsImportPath relativeImportPath) {
        ImportPathVisitor<ReactionsSegment> _function = (sourceImport, currentImportPath, currentReactionsSegment, remainingPath) -> {
            boolean _isEmpty = remainingPath.isEmpty();
            if (_isEmpty) {
                return currentReactionsSegment;
            }
            return null;
        };
        return ReactionsImportsHelper.walkImportPath(rootReactionsSegment, relativeImportPath, _function);
    }

    public static Pair<ReactionsImportPath, ReactionsSegment> getRoutinesOverrideRoot(ReactionsSegment rootReactionsSegment, ReactionsImportPath overriddenRoutineImportPath, boolean checkRootReactionsSegment) {
        ImportPathVisitor<Pair> _function = (sourceImport, currentImportPath, currentReactionsSegment, remainingPath) -> {
            boolean _isEmpty = remainingPath.isEmpty();
            if (_isEmpty) {
                return Pair.of((Object)currentImportPath, (Object)currentReactionsSegment);
            }
            if (checkRootReactionsSegment || currentImportPath.getLength() > 1) {
                boolean _tripleNotEquals;
                Functions.Function1 _function_2;
                Functions.Function1 _function_1 = it -> ReactionsLanguageUtil.toReactionsImportPath(it.getOverrideImportPath());
                Iterable overriddenRoutinesImportPaths = IterableExtensions.map(ReactionsLanguageUtil.getOverrideRoutines(currentReactionsSegment), (Functions.Function1)_function_1);
                ReactionsImportPath _findFirst = (ReactionsImportPath)IterableExtensions.findFirst((Iterable)overriddenRoutinesImportPaths, (Functions.Function1)(_function_2 = it -> it.equals((Object)remainingPath)));
                boolean bl = _tripleNotEquals = _findFirst != null;
                if (_tripleNotEquals) {
                    return Pair.of((Object)currentImportPath, (Object)currentReactionsSegment);
                }
            }
            return null;
        };
        return ReactionsImportsHelper.walkImportPath(rootReactionsSegment, overriddenRoutineImportPath, _function);
    }

    private ReactionsImportsHelper() {
    }

    public static interface ImportHierarchyVisitor<D> {
        public void visit(ReactionsImport var1, ReactionsImportPath var2, ReactionsSegment var3, D var4);
    }

    public static interface ImportPathVisitor<T> {
        public T visit(ReactionsImport var1, ReactionsImportPath var2, ReactionsSegment var3, ReactionsImportPath var4);
    }
}

