/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.codegen.typesbuilder;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import tools.vitruv.dsls.common.elements.NamedMetaclassReference;
import tools.vitruv.dsls.reactions.codegen.helper.AccessibleElement;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsLanguageHelper;
import tools.vitruv.dsls.reactions.codegen.typesbuilder.JvmTypesBuilderWithoutAssociations;
import tools.vitruv.dsls.reactions.language.inputTypes.InputTypesPackage;
import tools.vitruv.dsls.reactions.language.toplevelelements.NamedJavaElementReference;

public class ParameterGenerator {
    private static final String MISSING_PARAMETER_NAME = "/* Name missing */";
    @Extension
    protected final JvmTypeReferenceBuilder _typeReferenceBuilder;
    @Extension
    protected final JvmTypesBuilderWithoutAssociations _typesBuilder;

    public ParameterGenerator(JvmTypeReferenceBuilder typeReferenceBuilder, JvmTypesBuilderWithoutAssociations typesBuilder) {
        this._typeReferenceBuilder = typeReferenceBuilder;
        this._typesBuilder = typesBuilder;
    }

    public JvmFormalParameter generateParameter(EObject contextObject, AccessibleElement element) {
        return this._typesBuilder.toParameter(contextObject, element.getName(), element.generateTypeRef(this._typeReferenceBuilder));
    }

    public Iterable<JvmFormalParameter> generateParameters(EObject contextObject, Iterable<AccessibleElement> elements) {
        Functions.Function1 _function = it -> this._typesBuilder.toParameter(contextObject, it.getName(), it.generateTypeRef(this._typeReferenceBuilder));
        return IterableExtensions.map(elements, (Functions.Function1)_function);
    }

    public Iterable<AccessibleElement> getInputElements(Iterable<NamedMetaclassReference> metaclassReferences, Iterable<NamedJavaElementReference> javaElements) {
        Functions.Function1 _function = it -> {
            String _elvis = null;
            String _name = it.getName();
            _elvis = _name != null ? _name : MISSING_PARAMETER_NAME;
            EClassifier _metaclass = it.getMetaclass();
            String _mappedInstanceClassCanonicalName = null;
            if (_metaclass != null) {
                _mappedInstanceClassCanonicalName = this.getMappedInstanceClassCanonicalName(_metaclass);
            }
            return new AccessibleElement(_elvis, _mappedInstanceClassCanonicalName);
        };
        Iterable _map = IterableExtensions.map(metaclassReferences, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            String _elvis = null;
            String _name = it.getName();
            _elvis = _name != null ? _name : MISSING_PARAMETER_NAME;
            JvmTypeReference _type = it.getType();
            String _qualifiedName = null;
            if (_type != null) {
                _qualifiedName = _type.getQualifiedName();
            }
            return new AccessibleElement(_elvis, _qualifiedName);
        };
        Iterable _map_1 = IterableExtensions.map(javaElements, (Functions.Function1)_function_1);
        return Iterables.concat((Iterable)_map, (Iterable)_map_1);
    }

    private String _getMappedInstanceClassCanonicalName(EClass eClass) {
        String _switchResult = null;
        boolean _matched = false;
        if (Objects.equals(eClass, InputTypesPackage.Literals.STRING)) {
            _matched = true;
            _switchResult = String.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.INTEGER)) {
            _matched = true;
            _switchResult = Integer.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.LONG)) {
            _matched = true;
            _switchResult = Long.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.SHORT)) {
            _matched = true;
            _switchResult = Short.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.BOOLEAN)) {
            _matched = true;
            _switchResult = Boolean.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.CHARACTER)) {
            _matched = true;
            _switchResult = Character.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.BYTE)) {
            _matched = true;
            _switchResult = Byte.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.FLOAT)) {
            _matched = true;
            _switchResult = Float.class.getName();
        }
        if (!_matched && Objects.equals(eClass, InputTypesPackage.Literals.DOUBLE)) {
            _matched = true;
            _switchResult = Double.class.getName();
        }
        if (!_matched) {
            _switchResult = ReactionsLanguageHelper.getJavaClassName((EClassifier)eClass);
        }
        return _switchResult;
    }

    private String _getMappedInstanceClassCanonicalName(EEnum eEnum) {
        return ReactionsLanguageHelper.getJavaClassName((EClassifier)eEnum);
    }

    @XbaseGenerated
    private String getMappedInstanceClassCanonicalName(EClassifier eEnum) {
        if (eEnum instanceof EEnum) {
            return this._getMappedInstanceClassCanonicalName((EEnum)eEnum);
        }
        if (eEnum instanceof EClass) {
            return this._getMappedInstanceClassCanonicalName((EClass)eEnum);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(eEnum).toString());
    }
}

