/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import tools.vitruv.dsls.reactions.api.generator.IReactionsGenerator;
import tools.vitruv.dsls.reactions.builder.FluentReactionsFileBuilder;
import tools.vitruv.dsls.reactions.generator.InternalReactionsGenerator;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsFile;

public class ExternalReactionsGenerator
implements IReactionsGenerator {
    private static Logger logger = LogManager.getLogger(ExternalReactionsGenerator.class);
    @Inject
    private static Provider<InternalReactionsGenerator> internalGeneratorProvider;
    @Delegate
    private final InternalReactionsGenerator internalGenerator;

    @Inject
    ExternalReactionsGenerator(IGlobalServiceProvider globalServiceProvider) {
        if (internalGeneratorProvider == null) {
            logger.warn("The Reactions language has not been setup yet. Performing setup now.");
            globalServiceProvider.findService(URI.createFileURI((String)"dummy.reactions"), IReactionsGenerator.class);
            if (internalGeneratorProvider == null) {
                throw new IllegalStateException("Setup of the Reactions language has failed!");
            }
        }
        this.internalGenerator = (InternalReactionsGenerator)internalGeneratorProvider.get();
    }

    @Override
    public void addReaction(String sourceFileName, Iterable<? extends Reaction> reactions) {
        this.internalGenerator.addReaction(sourceFileName, reactions);
    }

    @Override
    public void addReaction(String sourceFileName, Reaction ... reactions) {
        this.internalGenerator.addReaction(sourceFileName, reactions);
    }

    @Override
    public void addReactionsFile(FluentReactionsFileBuilder reactionBuilder) {
        this.internalGenerator.addReactionsFile(reactionBuilder);
    }

    @Override
    public void addReactionsFile(String sourceFileName, ReactionsFile reactionsFile) {
        this.internalGenerator.addReactionsFile(sourceFileName, reactionsFile);
    }

    @Override
    public void addReactionsFiles(XtextResourceSet resourceSet) {
        this.internalGenerator.addReactionsFiles(resourceSet);
    }

    @Override
    public void generate(IFileSystemAccess2 fsa) {
        this.internalGenerator.generate(fsa);
    }

    @Override
    public void useResourceSet(ResourceSet resourceSet) {
        this.internalGenerator.useResourceSet(resourceSet);
    }

    @Override
    public void writeReactions(IFileSystemAccess2 fsa) throws IOException {
        this.internalGenerator.writeReactions(fsa);
    }

    @Override
    public void writeReactions(IFileSystemAccess2 fsa, String subPath) throws IOException {
        this.internalGenerator.writeReactions(fsa, subPath);
    }
}

