/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import edu.kit.ipd.sdq.activextendannotations.CloseResource;
import edu.kit.ipd.sdq.commons.util.java.lang.IterableUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.dsls.common.elements.MetamodelImport;
import tools.vitruv.dsls.reactions.api.generator.IReactionsGenerator;
import tools.vitruv.dsls.reactions.builder.FluentReactionsFileBuilder;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsLanguageHelper;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsFile;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsFactory;

public class InternalReactionsGenerator
implements IReactionsGenerator {
    private static final URI SYNTHETIC_RESOURCES = URI.createHierarchicalURI((String)"synthetic", null, null, (String[])new String[0], null, null);
    private boolean used = false;
    @Inject
    private IGenerator generator;
    @Inject
    private IResourceFactory resourceFactory;
    private ResourceSet artificialReactionsResourceSet;
    private final ArrayList<ResourceSet> reactionFileResourceSets = new ArrayList();
    private final ArrayList<Resource> resourcesToGenerate = new ArrayList();

    private boolean addReaction(String sourceFileName, Reaction reaction) {
        boolean _xblockexpression = false;
        Preconditions.checkNotNull((Object)reaction, (Object)"Reaction must not be null!");
        Preconditions.checkState((this.artificialReactionsResourceSet != null ? 1 : 0) != 0, (Object)"A resource set must be provided in order to add artificial reactions!");
        ReactionsSegment reactionsSegment = this.getCorrespondingReactionsSegmentInTempResource(sourceFileName, reaction.getReactionsSegment());
        EList<Reaction> _reactions = reactionsSegment.getReactions();
        _xblockexpression = _reactions.add((Object)reaction);
        return _xblockexpression;
    }

    private ReactionsSegment getCorrespondingReactionsSegmentInTempResource(String sourceFileName, ReactionsSegment reactionsSegment) {
        EList _resources = this.artificialReactionsResourceSet.getResources();
        for (Resource res : _resources) {
            boolean _equals = ((String)IterableExtensions.last((Iterable)res.getURI().segmentsList())).equals(sourceFileName + ".reactions");
            if (!_equals) continue;
            ReactionsFile reactionsFile = ReactionsLanguageHelper.getReactionsFile(res);
            ReactionsSegment foundSegment = null;
            EList<ReactionsSegment> _reactionsSegments = reactionsFile.getReactionsSegments();
            for (ReactionsSegment segment : _reactionsSegments) {
                if (!ListExtensions.map(segment.getFromMetamodels(), it -> it.getPackage()).equals(ListExtensions.map(reactionsSegment.getFromMetamodels(), it -> it.getPackage())) || !ListExtensions.map(segment.getToMetamodels(), it -> it.getPackage()).equals(ListExtensions.map(reactionsSegment.getToMetamodels(), it -> it.getPackage()))) continue;
                foundSegment = segment;
            }
            if (foundSegment == null) {
                foundSegment = this.addReactionsSegment(reactionsFile, reactionsSegment, sourceFileName);
            }
            return foundSegment;
        }
        ReactionsFile newFile = this.createSyntheticResourceWithReactionsFile(sourceFileName);
        return this.addReactionsSegment(newFile, reactionsSegment, sourceFileName);
    }

    private ReactionsSegment addReactionsSegment(ReactionsFile fileToAddTo, ReactionsSegment originalSegment, String segmentName) {
        ReactionsSegment _createReactionsSegment = TopLevelElementsFactory.eINSTANCE.createReactionsSegment();
        Procedures.Procedure1 _function = it -> {
            EList<MetamodelImport> _fromMetamodels = it.getFromMetamodels();
            EList<MetamodelImport> _fromMetamodels_1 = originalSegment.getFromMetamodels();
            Iterables.addAll(_fromMetamodels, _fromMetamodels_1);
            EList<MetamodelImport> _toMetamodels = it.getToMetamodels();
            EList<MetamodelImport> _toMetamodels_1 = originalSegment.getToMetamodels();
            Iterables.addAll(_toMetamodels, _toMetamodels_1);
            it.setName(segmentName);
        };
        ReactionsSegment newSegment = (ReactionsSegment)ObjectExtensions.operator_doubleArrow((Object)_createReactionsSegment, (Procedures.Procedure1)_function);
        EList<ReactionsSegment> _reactionsSegments = fileToAddTo.getReactionsSegments();
        _reactionsSegments.add((Object)newSegment);
        return newSegment;
    }

    @Override
    public void addReaction(String sourceFileName, Reaction ... reactions) {
        this.addReaction(sourceFileName, IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)reactions))));
    }

    @Override
    public void addReaction(String sourceFileName, Iterable<? extends Reaction> reactions) {
        Consumer<Reaction> _function = it -> this.addReaction(sourceFileName, (Reaction)it);
        reactions.forEach(_function);
    }

    @Override
    public void generate(IFileSystemAccess2 fsa) {
        Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"This generator was already used to generate reactions!");
        this.used = true;
        Consumer<Resource> _function = it -> this.generateReactions((Resource)it, (IFileSystemAccess)fsa);
        this.resourcesToGenerate.forEach(_function);
    }

    private Resource createSyntheticResource(String sourceFileName) {
        int uriAppendix = 1;
        URI resourceUri = SYNTHETIC_RESOURCES.appendSegment(sourceFileName).appendFileExtension("reactions");
        while (this.artificialReactionsResourceSet.getResource(resourceUri, false) != null) {
            resourceUri = SYNTHETIC_RESOURCES.appendSegment(sourceFileName + Integer.valueOf(uriAppendix)).appendFileExtension("reactions");
            ++uriAppendix;
        }
        Resource resource = this.resourceFactory.createResource(resourceUri);
        EList _resources = this.artificialReactionsResourceSet.getResources();
        _resources.add((Object)resource);
        this.resourcesToGenerate.add(resource);
        return resource;
    }

    private ReactionsFile createSyntheticResourceWithReactionsFile(String sourceFileName) {
        Resource singleReactionResource = this.createSyntheticResource(sourceFileName);
        ReactionsFile reactionsFile = TopLevelElementsFactory.eINSTANCE.createReactionsFile();
        singleReactionResource.getContents().add((Object)reactionsFile);
        return reactionsFile;
    }

    private void generateReactions(Resource reactionsResource, IFileSystemAccess fsa) {
        this.generator.doGenerate(reactionsResource, fsa);
    }

    @Override
    public void addReactionsFiles(XtextResourceSet resourceSet) {
        this.reactionFileResourceSets.add((ResourceSet)resourceSet);
        Functions.Function1 _function = it -> ReactionsLanguageHelper.containsReactionsFile(it);
        Iterable _filter = IterableExtensions.filter((Iterable)resourceSet.getResources(), (Functions.Function1)_function);
        Iterables.addAll(this.resourcesToGenerate, (Iterable)_filter);
    }

    @Override
    public void addReactionsFile(FluentReactionsFileBuilder reactionBuilder) {
        Preconditions.checkState((this.artificialReactionsResourceSet != null ? 1 : 0) != 0, (Object)"A resource set must be provided in order to add artificial reactions files!");
        Resource resource = this.createSyntheticResource(reactionBuilder.getFileName());
        reactionBuilder.attachTo(resource);
    }

    @Override
    public void addReactionsFile(String sourceFileName, ReactionsFile reactionsFile) {
        Preconditions.checkState((this.artificialReactionsResourceSet != null ? 1 : 0) != 0, (Object)"A resource set must be provided in order to add artificial reactions files!");
        Resource reactionsFileResource = this.createSyntheticResource(sourceFileName);
        reactionsFileResource.getContents().add((Object)reactionsFile);
        this.resourcesToGenerate.add(reactionsFileResource);
    }

    @Override
    public void writeReactions(IFileSystemAccess2 fsa) throws IOException {
        this.writeReactions(fsa, null);
    }

    @Override
    public void writeReactions(IFileSystemAccess2 fsa, String subPath) throws IOException {
        try {
            Object _xifexpression = null;
            if (subPath == null) {
                _xifexpression = "";
            } else {
                Object _xifexpression_1 = null;
                boolean _endsWith = subPath.endsWith("/");
                _xifexpression_1 = _endsWith ? subPath : subPath + "/";
                _xifexpression = _xifexpression_1;
            }
            String pathPrefix = _xifexpression;
            ThreadFactory _function = r -> new Thread(r, "Reactions Serializer");
            ExecutorService serializationExecutor = Executors.newCachedThreadPool(_function);
            try {
                Functions.Function1 _function_1 = resource -> {
                    try {
                        Pair _xblockexpression = null;
                        PipedOutputStream serializationInput = new PipedOutputStream();
                        PipedInputStream serializationOutput = new PipedInputStream(serializationInput, 102400);
                        Callable<Void> _function_2 = () -> InternalReactionsGenerator.writeTo(resource, serializationInput);
                        serializationExecutor.submit(_function_2);
                        _xblockexpression = Pair.of((Object)resource, (Object)serializationOutput);
                        return _xblockexpression;
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                Consumer<Pair> _function_2 = it -> {
                    try {
                        Resource resource = (Resource)it.getKey();
                        PipedInputStream output = (PipedInputStream)it.getValue();
                        String _lastSegment = resource.getURI().lastSegment();
                        String _plus = pathPrefix + _lastSegment;
                        InternalReactionsGenerator.writeTo(output, fsa, _plus);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                IterableUtil.mapFixed(this.resourcesToGenerate, (Functions.Function1)_function_1).forEach(_function_2);
                serializationExecutor.shutdown();
                serializationExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (Throwable _t) {
                if (_t instanceof RuntimeIOException) {
                    RuntimeIOException runtimeIoError = (RuntimeIOException)_t;
                    throw this.mapRuntimeIoException(runtimeIoError);
                }
                if (_t instanceof ExecutionException) {
                    ExecutionException writerError = (ExecutionException)_t;
                    throw this.mapWriteException(writerError.getCause());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                serializationExecutor.shutdownNow();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static Void writeTo(Resource resource, @CloseResource OutputStream outputStream) throws IOException {
        try (OutputStream r_outputStream = outputStream;){
            Void void_ = InternalReactionsGenerator._writeTo_with_safe_resources(resource, r_outputStream);
            return void_;
        }
    }

    private static Void writeTo(@CloseResource InputStream inputStream, IFileSystemAccess2 fsa, String path) throws RuntimeIOException, IOException {
        try (InputStream r_inputStream = inputStream;){
            Void void_ = InternalReactionsGenerator._writeTo_with_safe_resources(r_inputStream, fsa, path);
            return void_;
        }
    }

    private IOException mapWriteException(Throwable executionException) {
        try {
            IOException _switchResult = null;
            boolean _matched = false;
            if (executionException instanceof IOException) {
                _matched = true;
                throw (IOException)executionException;
            }
            if (!_matched && executionException instanceof RuntimeIOException) {
                _matched = true;
                _switchResult = this.mapRuntimeIoException((RuntimeIOException)executionException);
            }
            if (!_matched) {
                throw new IOException(executionException);
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private IOException mapRuntimeIoException(RuntimeIOException runtimeIOException) {
        try {
            Throwable realException = runtimeIOException.getCause();
            boolean _matched = false;
            if (realException instanceof IOException) {
                _matched = true;
                throw (IOException)realException;
            }
            throw new IOException(realException);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void useResourceSet(ResourceSet resourceSet) {
        Preconditions.checkNotNull((Object)resourceSet);
        this.artificialReactionsResourceSet = resourceSet;
        this.reactionFileResourceSets.add(resourceSet);
    }

    private static Void _writeTo_with_safe_resources(Resource resource, OutputStream outputStream) throws IOException {
        Object _xblockexpression = null;
        resource.save(outputStream, CollectionLiterals.emptyMap());
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static Void _writeTo_with_safe_resources(InputStream inputStream, IFileSystemAccess2 fsa, String path) throws RuntimeIOException {
        Object _xblockexpression = null;
        fsa.generateFile(path, inputStream);
        _xblockexpression = null;
        return _xblockexpression;
    }
}

