/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import tools.vitruv.dsls.reactions.codegen.classgenerators.ChangePropagationSpecificationClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.ClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.OverriddenRoutinesFacadeClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.ReactionClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.RoutineClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.RoutineFacadeClassGenerator;
import tools.vitruv.dsls.reactions.codegen.classgenerators.RoutinesFacadesProviderClassGenerator;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsElementsCompletionChecker;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsImportsHelper;
import tools.vitruv.dsls.reactions.codegen.typesbuilder.JvmTypesBuilderWithoutAssociations;
import tools.vitruv.dsls.reactions.codegen.typesbuilder.TypesBuilderExtensionProvider;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsFile;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.runtime.structure.ReactionsImportPath;

public class ReactionsLanguageJvmModelInferrer
extends AbstractModelInferrer {
    @Inject
    @Extension
    private JvmTypesBuilderWithoutAssociations _typesBuilder;
    @Inject
    private TypesBuilderExtensionProvider typesBuilderExtensionProvider;

    private void updateBuilders() {
        this.typesBuilderExtensionProvider.setBuilders(this._typesBuilder, this._typeReferenceBuilder, this._annotationTypesBuilder);
    }

    protected void _generate(Reaction reaction, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        ReactionClassGenerator _reactionClassGenerator = new ReactionClassGenerator(reaction, this.typesBuilderExtensionProvider);
        ReactionsLanguageJvmModelInferrer.accept(acceptor, _reactionClassGenerator, reaction.getReactionsSegment());
    }

    protected void _generate(Routine routine, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        RoutineClassGenerator _routineClassGenerator = new RoutineClassGenerator(routine, this.typesBuilderExtensionProvider);
        ReactionsLanguageJvmModelInferrer.accept(acceptor, _routineClassGenerator, routine.getReactionsSegment());
    }

    protected void _infer(ReactionsFile file, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        this.updateBuilders();
        Functions.Function1 _function = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
        Iterable _filter = IterableExtensions.filter(file.getReactionsSegments(), (Functions.Function1)_function);
        for (ReactionsSegment reactionsSegment : _filter) {
            RoutineFacadeClassGenerator _routineFacadeClassGenerator = new RoutineFacadeClassGenerator(reactionsSegment, this.typesBuilderExtensionProvider);
            ReactionsLanguageJvmModelInferrer.accept(acceptor, _routineFacadeClassGenerator, reactionsSegment);
            Set<ReactionsImportPath> _parsedOverriddenRoutinesImportPaths = ReactionsImportsHelper.getParsedOverriddenRoutinesImportPaths(reactionsSegment);
            for (ReactionsImportPath overriddenRoutinesImportPath : _parsedOverriddenRoutinesImportPaths) {
                OverriddenRoutinesFacadeClassGenerator _overriddenRoutinesFacadeClassGenerator = new OverriddenRoutinesFacadeClassGenerator(reactionsSegment, overriddenRoutinesImportPath, this.typesBuilderExtensionProvider);
                ReactionsLanguageJvmModelInferrer.accept(acceptor, _overriddenRoutinesFacadeClassGenerator, reactionsSegment);
            }
            RoutinesFacadesProviderClassGenerator _routinesFacadesProviderClassGenerator = new RoutinesFacadesProviderClassGenerator(reactionsSegment, this.typesBuilderExtensionProvider);
            ReactionsLanguageJvmModelInferrer.accept(acceptor, _routinesFacadesProviderClassGenerator, reactionsSegment);
            Functions.Function1 _function_1 = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
            Iterable _filter_1 = IterableExtensions.filter(reactionsSegment.getRoutines(), (Functions.Function1)_function_1);
            for (Routine effect : _filter_1) {
                this.generate(effect, acceptor, isPreIndexingPhase);
            }
            Functions.Function1 _function_2 = it -> ReactionsElementsCompletionChecker.isReferenceable(it);
            Iterable _filter_2 = IterableExtensions.filter(reactionsSegment.getReactions(), (Functions.Function1)_function_2);
            for (Reaction reaction : _filter_2) {
                this.generate(reaction, acceptor, isPreIndexingPhase);
            }
            ChangePropagationSpecificationClassGenerator _changePropagationSpecificationClassGenerator = new ChangePropagationSpecificationClassGenerator(reactionsSegment, this.typesBuilderExtensionProvider);
            ReactionsLanguageJvmModelInferrer.accept(acceptor, _changePropagationSpecificationClassGenerator, reactionsSegment);
        }
    }

    private static void accept(IJvmDeclaredTypeAcceptor acceptor, @Extension ClassGenerator generator, ReactionsSegment reactionsSegment) {
        Procedures.Procedure1 _function = it -> {
            boolean _isAllImportsResolvable = ReactionsImportsHelper.isAllImportsResolvable(reactionsSegment);
            if (_isAllImportsResolvable) {
                generator.generateBody();
            }
        };
        acceptor.accept((JvmDeclaredType)generator.generateEmptyClass(), _function);
    }

    @XbaseGenerated
    public void generate(EObject reaction, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (reaction instanceof Reaction) {
            this._generate((Reaction)reaction, acceptor, isPreIndexingPhase);
            return;
        }
        if (reaction instanceof Routine) {
            this._generate((Routine)reaction, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(reaction, acceptor, isPreIndexingPhase).toString());
    }

    @XbaseGenerated
    public void infer(EObject file, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (file instanceof ReactionsFile) {
            this._infer((ReactionsFile)file, acceptor, isPreIndexingPhase);
            return;
        }
        if (file != null) {
            this._infer(file, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(file, acceptor, isPreIndexingPhase).toString());
    }
}

