/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.linking;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ReactionsLinkingService
extends DefaultLinkingService {
    private static final Logger log = LogManager.getLogger(ReactionsLinkingService.class);
    @Inject
    private IValueConverterService valueConverterService;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        List _xblockexpression = null;
        boolean _equals = ref.getEType().equals(EcorePackage.Literals.EPACKAGE);
        if (_equals) {
            return this.getEPackage((ILeafNode)node);
        }
        _xblockexpression = super.getLinkedObjects(context, ref, node);
        return _xblockexpression;
    }

    public List<EObject> getEPackage(ILeafNode text) {
        String nsUri = this.getMetamodelNsURI(text);
        if (nsUri == null) {
            return Collections.emptyList();
        }
        EPackage _ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        EPackage resolvedEPackage = _ePackage;
        if (resolvedEPackage == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{resolvedEPackage}));
    }

    private String getMetamodelNsURI(ILeafNode text) {
        try {
            Object _value = this.valueConverterService.toValue(text.getText(), this.getLinkingHelper().getRuleNameFrom(text.getGrammarElement()), (INode)text);
            return (String)_value;
        }
        catch (Throwable _t) {
            if (_t instanceof ValueConverterException) {
                ValueConverterException e = (ValueConverterException)_t;
                String _text = text.getText();
                String _plus = "Exception on leaf '" + _text;
                String _plus_1 = _plus + "'";
                log.debug(_plus_1, (Throwable)e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

