/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.scoping;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsPackage;

@Singleton
public class ReactionsImportScopeHelper {
    @Inject
    private IResourceDescription.Manager descriptionManager;
    @Inject
    private IResourceDescriptionsProvider descriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;

    public Iterable<IEObjectDescription> getVisibleReactionsSegmentDescriptions(ReactionsSegment reactionsSegment) {
        if (reactionsSegment == null) {
            return Collections.emptyList();
        }
        Resource resource = reactionsSegment.eResource();
        if (resource == null) {
            return Collections.emptyList();
        }
        IResourceDescription resourceDesc = this.descriptionManager.getResourceDescription(resource);
        IResourceDescriptions resourceDescriptions = this.descriptionsProvider.getResourceDescriptions(resource.getResourceSet());
        List visibleContainers = this.containerManager.getVisibleContainers(resourceDesc, resourceDescriptions);
        Functions.Function1 _function = it -> it.getResourceDescriptions();
        Functions.Function1 _function_1 = it -> {
            String lastURISegment = it.getURI().lastSegment();
            return lastURISegment != null && lastURISegment.endsWith(".reactions");
        };
        Iterable visibleReactionsResources = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)visibleContainers, (Functions.Function1)_function)), (Functions.Function1)_function_1);
        URI reactionsSegmentURI = EcoreUtil.getURI((EObject)reactionsSegment);
        Functions.Function1 _function_2 = it -> it.getExportedObjectsByType(TopLevelElementsPackage.eINSTANCE.getReactionsSegment());
        Functions.Function1 _function_3 = it -> {
            boolean _equals = it.getEObjectURI().equals(reactionsSegmentURI);
            return !_equals;
        };
        Iterable visibleReactionsSegmentDescriptions = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)visibleReactionsResources, (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
        return visibleReactionsSegmentDescriptions;
    }
}

